# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/translate/v3/translation_service_pb"
require "google/cloud/translate/v3/translation_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Translate
      module V3
        module TranslationService
          module Rest
            ##
            # REST client for the TranslationService service.
            #
            # Provides natural language translation operations.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "translate.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :translation_service_stub

              ##
              # Configure the TranslationService Client class.
              #
              # See {::Google::Cloud::Translate::V3::TranslationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all TranslationService clients
              #   ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Translate", "V3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.translate_text.timeout = 600.0

                  default_config.rpcs.detect_language.timeout = 600.0

                  default_config.rpcs.get_supported_languages.timeout = 600.0
                  default_config.rpcs.get_supported_languages.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.translate_document.timeout = 600.0

                  default_config.rpcs.batch_translate_text.timeout = 600.0

                  default_config.rpcs.batch_translate_document.timeout = 600.0

                  default_config.rpcs.create_glossary.timeout = 600.0

                  default_config.rpcs.list_glossaries.timeout = 600.0
                  default_config.rpcs.list_glossaries.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_glossary.timeout = 600.0
                  default_config.rpcs.get_glossary.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_glossary.timeout = 600.0
                  default_config.rpcs.delete_glossary.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the TranslationService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Translate::V3::TranslationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @translation_service_stub.universe_domain
              end

              ##
              # Create a new TranslationService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the TranslationService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @translation_service_stub = ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @translation_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @translation_service_stub.endpoint
                  config.universe_domain = @translation_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @translation_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @translation_service_stub.endpoint
                  config.universe_domain = @translation_service_stub.universe_domain
                  config.logger = @translation_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Translate::V3::TranslationService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @translation_service_stub.logger
              end

              # Service calls

              ##
              # Translates input text and returns translated text.
              #
              # @overload translate_text(request, options = nil)
              #   Pass arguments to `translate_text` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::TranslateTextRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::TranslateTextRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload translate_text(contents: nil, mime_type: nil, source_language_code: nil, target_language_code: nil, parent: nil, model: nil, glossary_config: nil, transliteration_config: nil, labels: nil)
              #   Pass arguments to `translate_text` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param contents [::Array<::String>]
              #     Required. The content of the input in string format.
              #     We recommend the total content be less than 30,000 codepoints. The max
              #     length of this field is 1024. Use BatchTranslateText for larger text.
              #   @param mime_type [::String]
              #     Optional. The format of the source text, for example, "text/html",
              #      "text/plain". If left blank, the MIME type defaults to "text/html".
              #   @param source_language_code [::String]
              #     Optional. The ISO-639 language code of the input text if
              #     known, for example, "en-US" or "sr-Latn". Supported language codes are
              #     listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages). If the source
              #     language isn't specified, the API attempts to identify the source language
              #     automatically and returns the source language within the response.
              #   @param target_language_code [::String]
              #     Required. The ISO-639 language code to use for translation of the input
              #     text, set to one of the language codes listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages).
              #   @param parent [::String]
              #     Required. Project or location to make a call. Must refer to a caller's
              #     project.
              #
              #     Format: `projects/{project-number-or-id}` or
              #     `projects/{project-number-or-id}/locations/{location-id}`.
              #
              #     For global calls, use `projects/{project-number-or-id}/locations/global` or
              #     `projects/{project-number-or-id}`.
              #
              #     Non-global location is required for requests using AutoML models or
              #     custom glossaries.
              #
              #     Models and glossaries must be within the same region (have same
              #     location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
              #   @param model [::String]
              #     Optional. The `model` type requested for this translation.
              #
              #     The format depends on model type:
              #
              #     - AutoML Translation models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
              #
              #     - General (built-in) models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
              #
              #     - Translation LLM models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/translation-llm`,
              #
              #     For global (non-regionalized) requests, use `location-id` `global`.
              #     For example,
              #     `projects/{project-number-or-id}/locations/global/models/general/nmt`.
              #
              #     If not provided, the default Google model (NMT) will be used
              #   @param glossary_config [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig, ::Hash]
              #     Optional. Glossary to be applied. The glossary must be
              #     within the same region (have the same location-id) as the model, otherwise
              #     an INVALID_ARGUMENT (400) error is returned.
              #   @param transliteration_config [::Google::Cloud::Translate::V3::TransliterationConfig, ::Hash]
              #     Optional. Transliteration to be applied.
              #   @param labels [::Hash{::String => ::String}]
              #     Optional. The labels with user-defined metadata for the request.
              #
              #     Label keys and values can be no longer than 63 characters
              #     (Unicode codepoints), can only contain lowercase letters, numeric
              #     characters, underscores and dashes. International characters are allowed.
              #     Label values are optional. Label keys must start with a letter.
              #
              #     See https://cloud.google.com/translate/docs/advanced/labels for more
              #     information.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::TranslateTextResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::TranslateTextResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::TranslateTextRequest.new
              #
              #   # Call the translate_text method.
              #   result = client.translate_text request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::TranslateTextResponse.
              #   p result
              #
              def translate_text request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::TranslateTextRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.translate_text.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.translate_text.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.translate_text.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.translate_text request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Romanize input text written in non-Latin scripts to Latin text.
              #
              # @overload romanize_text(request, options = nil)
              #   Pass arguments to `romanize_text` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::RomanizeTextRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::RomanizeTextRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload romanize_text(parent: nil, contents: nil, source_language_code: nil)
              #   Pass arguments to `romanize_text` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Project or location to make a call. Must refer to a caller's
              #     project.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}` or
              #     `projects/{project-number-or-id}`.
              #
              #     For global calls, use `projects/{project-number-or-id}/locations/global` or
              #     `projects/{project-number-or-id}`.
              #   @param contents [::Array<::String>]
              #     Required. The content of the input in string format.
              #   @param source_language_code [::String]
              #     Optional. The ISO-639 language code of the input text if
              #     known, for example, "hi" or "zh". Supported language codes are
              #     listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages#roman). If the
              #     source language isn't specified, the API attempts to identify the source
              #     language automatically and returns the source language for each content in
              #     the response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::RomanizeTextResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::RomanizeTextResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::RomanizeTextRequest.new
              #
              #   # Call the romanize_text method.
              #   result = client.romanize_text request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::RomanizeTextResponse.
              #   p result
              #
              def romanize_text request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::RomanizeTextRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.romanize_text.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.romanize_text.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.romanize_text.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.romanize_text request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Detects the language of text within a request.
              #
              # @overload detect_language(request, options = nil)
              #   Pass arguments to `detect_language` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DetectLanguageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DetectLanguageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload detect_language(parent: nil, model: nil, content: nil, mime_type: nil, labels: nil)
              #   Pass arguments to `detect_language` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Project or location to make a call. Must refer to a caller's
              #     project.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}` or
              #     `projects/{project-number-or-id}`.
              #
              #     For global calls, use `projects/{project-number-or-id}/locations/global` or
              #     `projects/{project-number-or-id}`.
              #
              #     Only models within the same region (has same location-id) can be used.
              #     Otherwise an INVALID_ARGUMENT (400) error is returned.
              #   @param model [::String]
              #     Optional. The language detection model to be used.
              #
              #     Format:
              #     `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
              #
              #     Only one language detection model is currently supported:
              #     `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
              #
              #     If not specified, the default model is used.
              #   @param content [::String]
              #     The content of the input stored as a string.
              #   @param mime_type [::String]
              #     Optional. The format of the source text, for example, "text/html",
              #     "text/plain". If left blank, the MIME type defaults to "text/html".
              #   @param labels [::Hash{::String => ::String}]
              #     Optional. The labels with user-defined metadata for the request.
              #
              #     Label keys and values can be no longer than 63 characters
              #     (Unicode codepoints), can only contain lowercase letters, numeric
              #     characters, underscores and dashes. International characters are allowed.
              #     Label values are optional. Label keys must start with a letter.
              #
              #     See https://cloud.google.com/translate/docs/advanced/labels for more
              #     information.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::DetectLanguageResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::DetectLanguageResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DetectLanguageRequest.new
              #
              #   # Call the detect_language method.
              #   result = client.detect_language request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::DetectLanguageResponse.
              #   p result
              #
              def detect_language request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DetectLanguageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.detect_language.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.detect_language.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.detect_language.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.detect_language request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of supported languages for translation.
              #
              # @overload get_supported_languages(request, options = nil)
              #   Pass arguments to `get_supported_languages` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetSupportedLanguagesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetSupportedLanguagesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_supported_languages(parent: nil, display_language_code: nil, model: nil)
              #   Pass arguments to `get_supported_languages` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Project or location to make a call. Must refer to a caller's
              #     project.
              #
              #     Format: `projects/{project-number-or-id}` or
              #     `projects/{project-number-or-id}/locations/{location-id}`.
              #
              #     For global calls, use `projects/{project-number-or-id}/locations/global` or
              #     `projects/{project-number-or-id}`.
              #
              #     Non-global location is required for AutoML models.
              #
              #     Only models within the same region (have same location-id) can be used,
              #     otherwise an INVALID_ARGUMENT (400) error is returned.
              #   @param display_language_code [::String]
              #     Optional. The language to use to return localized, human readable names
              #     of supported languages. If missing, then display names are not returned
              #     in a response.
              #   @param model [::String]
              #     Optional. Get supported languages of this model.
              #
              #     The format depends on model type:
              #
              #     - AutoML Translation models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
              #
              #     - General (built-in) models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
              #
              #
              #     Returns languages supported by the specified model.
              #     If missing, we get supported languages of Google general NMT model.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::SupportedLanguages]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::SupportedLanguages]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetSupportedLanguagesRequest.new
              #
              #   # Call the get_supported_languages method.
              #   result = client.get_supported_languages request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::SupportedLanguages.
              #   p result
              #
              def get_supported_languages request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetSupportedLanguagesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_supported_languages.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_supported_languages.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_supported_languages.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_supported_languages request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Translates documents in synchronous mode.
              #
              # @overload translate_document(request, options = nil)
              #   Pass arguments to `translate_document` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::TranslateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::TranslateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload translate_document(parent: nil, source_language_code: nil, target_language_code: nil, document_input_config: nil, document_output_config: nil, model: nil, glossary_config: nil, labels: nil, customized_attribution: nil, is_translate_native_pdf_only: nil, enable_shadow_removal_native_pdf: nil, enable_rotation_correction: nil)
              #   Pass arguments to `translate_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Location to make a regional call.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
              #
              #     For global calls, use `projects/{project-number-or-id}/locations/global` or
              #     `projects/{project-number-or-id}`.
              #
              #     Non-global location is required for requests using AutoML models or custom
              #     glossaries.
              #
              #     Models and glossaries must be within the same region (have the same
              #     location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
              #   @param source_language_code [::String]
              #     Optional. The ISO-639 language code of the input document if known, for
              #     example, "en-US" or "sr-Latn". Supported language codes are listed in
              #     [Language Support](https://cloud.google.com/translate/docs/languages). If
              #     the source language isn't specified, the API attempts to identify the
              #     source language automatically and returns the source language within the
              #     response. Source language must be specified if the request contains a
              #     glossary or a custom model.
              #   @param target_language_code [::String]
              #     Required. The ISO-639 language code to use for translation of the input
              #     document, set to one of the language codes listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages).
              #   @param document_input_config [::Google::Cloud::Translate::V3::DocumentInputConfig, ::Hash]
              #     Required. Input configurations.
              #   @param document_output_config [::Google::Cloud::Translate::V3::DocumentOutputConfig, ::Hash]
              #     Optional. Output configurations.
              #     Defines if the output file should be stored within Cloud Storage as well
              #     as the desired output format. If not provided the translated file will
              #     only be returned through a byte-stream and its output mime type will be
              #     the same as the input file's mime type.
              #   @param model [::String]
              #     Optional. The `model` type requested for this translation.
              #
              #     The format depends on model type:
              #
              #     - AutoML Translation models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
              #
              #     - General (built-in) models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
              #
              #
              #     If not provided, the default Google model (NMT) will be used for
              #     translation.
              #   @param glossary_config [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig, ::Hash]
              #     Optional. Glossary to be applied. The glossary must be within the same
              #     region (have the same location-id) as the model, otherwise an
              #     INVALID_ARGUMENT (400) error is returned.
              #   @param labels [::Hash{::String => ::String}]
              #     Optional. The labels with user-defined metadata for the request.
              #
              #     Label keys and values can be no longer than 63 characters (Unicode
              #     codepoints), can only contain lowercase letters, numeric characters,
              #     underscores and dashes. International characters are allowed. Label values
              #     are optional. Label keys must start with a letter.
              #
              #     See https://cloud.google.com/translate/docs/advanced/labels for more
              #     information.
              #   @param customized_attribution [::String]
              #     Optional. This flag is to support user customized attribution.
              #     If not provided, the default is `Machine Translated by Google`.
              #     Customized attribution should follow rules in
              #     https://cloud.google.com/translate/attribution#attribution_and_logos
              #   @param is_translate_native_pdf_only [::Boolean]
              #     Optional. is_translate_native_pdf_only field for external customers.
              #     If true, the page limit of online native pdf translation is 300 and only
              #     native pdf pages will be translated.
              #   @param enable_shadow_removal_native_pdf [::Boolean]
              #     Optional. If true, use the text removal server to remove the shadow text on
              #     background image for native pdf translation.
              #     Shadow removal feature can only be enabled when
              #     is_translate_native_pdf_only: false && pdf_native_only: false
              #   @param enable_rotation_correction [::Boolean]
              #     Optional. If true, enable auto rotation correction in DVS.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::TranslateDocumentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::TranslateDocumentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::TranslateDocumentRequest.new
              #
              #   # Call the translate_document method.
              #   result = client.translate_document request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::TranslateDocumentResponse.
              #   p result
              #
              def translate_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::TranslateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.translate_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.translate_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.translate_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.translate_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Translates a large volume of text in asynchronous batch mode.
              # This function provides real-time output as the inputs are being processed.
              # If caller cancels a request, the partial results (for an input file, it's
              # all or nothing) may still be available on the specified output location.
              #
              # This call returns immediately and you can
              # use google.longrunning.Operation.name to poll the status of the call.
              #
              # @overload batch_translate_text(request, options = nil)
              #   Pass arguments to `batch_translate_text` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::BatchTranslateTextRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::BatchTranslateTextRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_translate_text(parent: nil, source_language_code: nil, target_language_codes: nil, models: nil, input_configs: nil, output_config: nil, glossaries: nil, labels: nil)
              #   Pass arguments to `batch_translate_text` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Location to make a call. Must refer to a caller's project.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
              #
              #     The `global` location is not supported for batch translation.
              #
              #     Only AutoML Translation models or glossaries within the same region (have
              #     the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
              #     error is returned.
              #   @param source_language_code [::String]
              #     Required. Source language code. Supported language codes are listed in
              #     [Language
              #     Support](https://cloud.google.com/translate/docs/languages).
              #   @param target_language_codes [::Array<::String>]
              #     Required. Specify up to 10 language codes here. Supported language codes
              #     are listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages).
              #   @param models [::Hash{::String => ::String}]
              #     Optional. The models to use for translation. Map's key is target language
              #     code. Map's value is model name. Value can be a built-in general model,
              #     or an AutoML Translation model.
              #
              #     The value format depends on model type:
              #
              #     - AutoML Translation models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
              #
              #     - General (built-in) models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
              #
              #
              #     If the map is empty or a specific model is
              #     not requested for a language pair, then default google model (nmt) is used.
              #   @param input_configs [::Array<::Google::Cloud::Translate::V3::InputConfig, ::Hash>]
              #     Required. Input configurations.
              #     The total number of files matched should be <= 100.
              #     The total content size should be <= 100M Unicode codepoints.
              #     The files must use UTF-8 encoding.
              #   @param output_config [::Google::Cloud::Translate::V3::OutputConfig, ::Hash]
              #     Required. Output configuration.
              #     If 2 input configs match to the same file (that is, same input path),
              #     we don't generate output for duplicate inputs.
              #   @param glossaries [::Hash{::String => ::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig, ::Hash}]
              #     Optional. Glossaries to be applied for translation.
              #     It's keyed by target language code.
              #   @param labels [::Hash{::String => ::String}]
              #     Optional. The labels with user-defined metadata for the request.
              #
              #     Label keys and values can be no longer than 63 characters
              #     (Unicode codepoints), can only contain lowercase letters, numeric
              #     characters, underscores and dashes. International characters are allowed.
              #     Label values are optional. Label keys must start with a letter.
              #
              #     See https://cloud.google.com/translate/docs/advanced/labels for more
              #     information.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::BatchTranslateTextRequest.new
              #
              #   # Call the batch_translate_text method.
              #   result = client.batch_translate_text request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_translate_text request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::BatchTranslateTextRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_translate_text.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_translate_text.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_translate_text.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.batch_translate_text request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Translates a large volume of document in asynchronous batch mode.
              # This function provides real-time output as the inputs are being processed.
              # If caller cancels a request, the partial results (for an input file, it's
              # all or nothing) may still be available on the specified output location.
              #
              # This call returns immediately and you can use
              # google.longrunning.Operation.name to poll the status of the call.
              #
              # @overload batch_translate_document(request, options = nil)
              #   Pass arguments to `batch_translate_document` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::BatchTranslateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::BatchTranslateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_translate_document(parent: nil, source_language_code: nil, target_language_codes: nil, input_configs: nil, output_config: nil, models: nil, glossaries: nil, format_conversions: nil, customized_attribution: nil, enable_shadow_removal_native_pdf: nil, enable_rotation_correction: nil)
              #   Pass arguments to `batch_translate_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Location to make a regional call.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
              #
              #     The `global` location is not supported for batch translation.
              #
              #     Only AutoML Translation models or glossaries within the same region (have
              #     the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
              #     error is returned.
              #   @param source_language_code [::String]
              #     Required. The ISO-639 language code of the input document if known, for
              #     example, "en-US" or "sr-Latn". Supported language codes are listed in
              #     [Language Support](https://cloud.google.com/translate/docs/languages).
              #   @param target_language_codes [::Array<::String>]
              #     Required. The ISO-639 language code to use for translation of the input
              #     document. Specify up to 10 language codes here. Supported language codes
              #     are listed in [Language
              #     Support](https://cloud.google.com/translate/docs/languages).
              #   @param input_configs [::Array<::Google::Cloud::Translate::V3::BatchDocumentInputConfig, ::Hash>]
              #     Required. Input configurations.
              #     The total number of files matched should be <= 100.
              #     The total content size to translate should be <= 100M Unicode codepoints.
              #     The files must use UTF-8 encoding.
              #   @param output_config [::Google::Cloud::Translate::V3::BatchDocumentOutputConfig, ::Hash]
              #     Required. Output configuration.
              #     If 2 input configs match to the same file (that is, same input path),
              #     we don't generate output for duplicate inputs.
              #   @param models [::Hash{::String => ::String}]
              #     Optional. The models to use for translation. Map's key is target language
              #     code. Map's value is the model name. Value can be a built-in general model,
              #     or an AutoML Translation model.
              #
              #     The value format depends on model type:
              #
              #     - AutoML Translation models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
              #
              #     - General (built-in) models:
              #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
              #
              #
              #     If the map is empty or a specific model is
              #     not requested for a language pair, then default google model (nmt) is used.
              #   @param glossaries [::Hash{::String => ::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig, ::Hash}]
              #     Optional. Glossaries to be applied. It's keyed by target language code.
              #   @param format_conversions [::Hash{::String => ::String}]
              #     Optional. The file format conversion map that is applied to all input
              #     files. The map key is the original mime_type. The map value is the target
              #     mime_type of translated documents.
              #
              #     Supported file format conversion includes:
              #     - `application/pdf` to
              #       `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
              #
              #     If nothing specified, output files will be in the same format as the
              #     original file.
              #   @param customized_attribution [::String]
              #     Optional. This flag is to support user customized attribution.
              #     If not provided, the default is `Machine Translated by Google`.
              #     Customized attribution should follow rules in
              #     https://cloud.google.com/translate/attribution#attribution_and_logos
              #   @param enable_shadow_removal_native_pdf [::Boolean]
              #     Optional. If true, use the text removal server to remove the shadow text on
              #     background image for native pdf translation.
              #     Shadow removal feature can only be enabled when
              #     is_translate_native_pdf_only: false && pdf_native_only: false
              #   @param enable_rotation_correction [::Boolean]
              #     Optional. If true, enable auto rotation correction in DVS.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::BatchTranslateDocumentRequest.new
              #
              #   # Call the batch_translate_document method.
              #   result = client.batch_translate_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_translate_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::BatchTranslateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_translate_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_translate_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_translate_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.batch_translate_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a glossary and returns the long-running operation. Returns
              # NOT_FOUND, if the project doesn't exist.
              #
              # @overload create_glossary(request, options = nil)
              #   Pass arguments to `create_glossary` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::CreateGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::CreateGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_glossary(parent: nil, glossary: nil)
              #   Pass arguments to `create_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project name.
              #   @param glossary [::Google::Cloud::Translate::V3::Glossary, ::Hash]
              #     Required. The glossary to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::CreateGlossaryRequest.new
              #
              #   # Call the create_glossary method.
              #   result = client.create_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::CreateGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.create_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a glossary. A LRO is used since the update can be async if the
              # glossary's entry file is updated.
              #
              # @overload update_glossary(request, options = nil)
              #   Pass arguments to `update_glossary` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::UpdateGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::UpdateGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_glossary(glossary: nil, update_mask: nil)
              #   Pass arguments to `update_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param glossary [::Google::Cloud::Translate::V3::Glossary, ::Hash]
              #     Required. The glossary entry to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. Currently only `display_name` and
              #     'input_config'
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::UpdateGlossaryRequest.new
              #
              #   # Call the update_glossary method.
              #   result = client.update_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::UpdateGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.update_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
              # exist.
              #
              # @overload list_glossaries(request, options = nil)
              #   Pass arguments to `list_glossaries` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListGlossariesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListGlossariesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_glossaries(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_glossaries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project from which to list all of the glossaries.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer glossaries than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Typically, this is the value of [ListGlossariesResponse.next_page_token]
              #     returned from the previous call to `ListGlossaries` method.
              #     The first page is returned if `page_token`is empty or missing.
              #   @param filter [::String]
              #     Optional. Filter specifying constraints of a list operation.
              #     Specify the constraint by the format of "key=value", where key must be
              #     "src" or "tgt", and the value must be a valid language code.
              #     For multiple restrictions, concatenate them by "AND" (uppercase only),
              #     such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used
              #     here, which means using 'en-US' and 'en' can lead to different results,
              #     which depends on the language code you used when you create the glossary.
              #     For the unidirectional glossaries, the "src" and "tgt" add restrictions
              #     on the source and target language code separately.
              #     For the equivalent term set glossaries, the "src" and/or "tgt" add
              #     restrictions on the term set.
              #     For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
              #     glossaries which exactly match the source language code as "en-US" and the
              #     target language code "zh-CN", but all equivalent term set glossaries which
              #     contain "en-US" and "zh-CN" in their language set will be picked.
              #     If missing, no filtering is performed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Glossary>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Glossary>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListGlossariesRequest.new
              #
              #   # Call the list_glossaries method.
              #   result = client.list_glossaries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::Glossary.
              #     p item
              #   end
              #
              def list_glossaries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListGlossariesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_glossaries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_glossaries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_glossaries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_glossaries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_glossaries, "glossaries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
              # exist.
              #
              # @overload get_glossary(request, options = nil)
              #   Pass arguments to `get_glossary` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_glossary(name: nil)
              #   Pass arguments to `get_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the glossary to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::Glossary]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::Glossary]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetGlossaryRequest.new
              #
              #   # Call the get_glossary method.
              #   result = client.get_glossary request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::Glossary.
              #   p result
              #
              def get_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_glossary request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a glossary, or cancels glossary construction
              # if the glossary isn't created yet.
              # Returns NOT_FOUND, if the glossary doesn't exist.
              #
              # @overload delete_glossary(request, options = nil)
              #   Pass arguments to `delete_glossary` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_glossary(name: nil)
              #   Pass arguments to `delete_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the glossary to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteGlossaryRequest.new
              #
              #   # Call the delete_glossary method.
              #   result = client.delete_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a single glossary entry by the given id.
              #
              # @overload get_glossary_entry(request, options = nil)
              #   Pass arguments to `get_glossary_entry` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetGlossaryEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetGlossaryEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_glossary_entry(name: nil)
              #   Pass arguments to `get_glossary_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the glossary entry to get
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::GlossaryEntry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::GlossaryEntry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetGlossaryEntryRequest.new
              #
              #   # Call the get_glossary_entry method.
              #   result = client.get_glossary_entry request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::GlossaryEntry.
              #   p result
              #
              def get_glossary_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetGlossaryEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_glossary_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_glossary_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_glossary_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_glossary_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the entries for the glossary.
              #
              # @overload list_glossary_entries(request, options = nil)
              #   Pass arguments to `list_glossary_entries` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListGlossaryEntriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListGlossaryEntriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_glossary_entries(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_glossary_entries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent glossary resource name for listing the glossary's
              #     entries.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer glossary entries
              #     than requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Typically, this is the value of
              #     [ListGlossaryEntriesResponse.next_page_token] returned from the previous
              #     call. The first page is returned if `page_token`is empty or missing.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::GlossaryEntry>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::GlossaryEntry>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListGlossaryEntriesRequest.new
              #
              #   # Call the list_glossary_entries method.
              #   result = client.list_glossary_entries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::GlossaryEntry.
              #     p item
              #   end
              #
              def list_glossary_entries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListGlossaryEntriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_glossary_entries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_glossary_entries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_glossary_entries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_glossary_entries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_glossary_entries, "glossary_entries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a glossary entry.
              #
              # @overload create_glossary_entry(request, options = nil)
              #   Pass arguments to `create_glossary_entry` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::CreateGlossaryEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::CreateGlossaryEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_glossary_entry(parent: nil, glossary_entry: nil)
              #   Pass arguments to `create_glossary_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the glossary to create the entry under.
              #   @param glossary_entry [::Google::Cloud::Translate::V3::GlossaryEntry, ::Hash]
              #     Required. The glossary entry to create
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::GlossaryEntry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::GlossaryEntry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::CreateGlossaryEntryRequest.new
              #
              #   # Call the create_glossary_entry method.
              #   result = client.create_glossary_entry request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::GlossaryEntry.
              #   p result
              #
              def create_glossary_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::CreateGlossaryEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_glossary_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_glossary_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_glossary_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.create_glossary_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a glossary entry.
              #
              # @overload update_glossary_entry(request, options = nil)
              #   Pass arguments to `update_glossary_entry` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_glossary_entry(glossary_entry: nil)
              #   Pass arguments to `update_glossary_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param glossary_entry [::Google::Cloud::Translate::V3::GlossaryEntry, ::Hash]
              #     Required. The glossary entry to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::GlossaryEntry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::GlossaryEntry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest.new
              #
              #   # Call the update_glossary_entry method.
              #   result = client.update_glossary_entry request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::GlossaryEntry.
              #   p result
              #
              def update_glossary_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_glossary_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_glossary_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_glossary_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.update_glossary_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single entry from the glossary
              #
              # @overload delete_glossary_entry(request, options = nil)
              #   Pass arguments to `delete_glossary_entry` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_glossary_entry(name: nil)
              #   Pass arguments to `delete_glossary_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the glossary entry to delete
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest.new
              #
              #   # Call the delete_glossary_entry method.
              #   result = client.delete_glossary_entry request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_glossary_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_glossary_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_glossary_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_glossary_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_glossary_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Dataset.
              #
              # @overload create_dataset(request, options = nil)
              #   Pass arguments to `create_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::CreateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::CreateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dataset(parent: nil, dataset: nil)
              #   Pass arguments to `create_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project name.
              #   @param dataset [::Google::Cloud::Translate::V3::Dataset, ::Hash]
              #     Required. The Dataset to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::CreateDatasetRequest.new
              #
              #   # Call the create_dataset method.
              #   result = client.create_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::CreateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.create_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Dataset.
              #
              # @overload get_dataset(request, options = nil)
              #   Pass arguments to `get_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dataset(name: nil)
              #   Pass arguments to `get_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataset to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::Dataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::Dataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetDatasetRequest.new
              #
              #   # Call the get_dataset method.
              #   result = client.get_dataset request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::Dataset.
              #   p result
              #
              def get_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists datasets.
              #
              # @overload list_datasets(request, options = nil)
              #   Pass arguments to `list_datasets` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListDatasetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListDatasetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_datasets(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_datasets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent project. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server can return fewer results than
              #     requested.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results for the server to return.
              #     Typically obtained from next_page_token field in the response of a
              #     ListDatasets call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Dataset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Dataset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListDatasetsRequest.new
              #
              #   # Call the list_datasets method.
              #   result = client.list_datasets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::Dataset.
              #     p item
              #   end
              #
              def list_datasets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListDatasetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_datasets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_datasets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_datasets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_datasets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_datasets, "datasets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a dataset and all of its contents.
              #
              # @overload delete_dataset(request, options = nil)
              #   Pass arguments to `delete_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dataset(name: nil)
              #   Pass arguments to `delete_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the dataset to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteDatasetRequest.new
              #
              #   # Call the delete_dataset method.
              #   result = client.delete_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an Adaptive MT dataset.
              #
              # @overload create_adaptive_mt_dataset(request, options = nil)
              #   Pass arguments to `create_adaptive_mt_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_adaptive_mt_dataset(parent: nil, adaptive_mt_dataset: nil)
              #   Pass arguments to `create_adaptive_mt_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent project. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}`
              #   @param adaptive_mt_dataset [::Google::Cloud::Translate::V3::AdaptiveMtDataset, ::Hash]
              #     Required. The AdaptiveMtDataset to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::AdaptiveMtDataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::AdaptiveMtDataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest.new
              #
              #   # Call the create_adaptive_mt_dataset method.
              #   result = client.create_adaptive_mt_dataset request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::AdaptiveMtDataset.
              #   p result
              #
              def create_adaptive_mt_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_adaptive_mt_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_adaptive_mt_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_adaptive_mt_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.create_adaptive_mt_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an Adaptive MT dataset, including all its entries and associated
              # metadata.
              #
              # @overload delete_adaptive_mt_dataset(request, options = nil)
              #   Pass arguments to `delete_adaptive_mt_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_adaptive_mt_dataset(name: nil)
              #   Pass arguments to `delete_adaptive_mt_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the dataset. In the form of
              #     `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest.new
              #
              #   # Call the delete_adaptive_mt_dataset method.
              #   result = client.delete_adaptive_mt_dataset request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_adaptive_mt_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_adaptive_mt_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_adaptive_mt_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_adaptive_mt_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_adaptive_mt_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the Adaptive MT dataset.
              #
              # @overload get_adaptive_mt_dataset(request, options = nil)
              #   Pass arguments to `get_adaptive_mt_dataset` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_adaptive_mt_dataset(name: nil)
              #   Pass arguments to `get_adaptive_mt_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the dataset. In the form of
              #     `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::AdaptiveMtDataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::AdaptiveMtDataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest.new
              #
              #   # Call the get_adaptive_mt_dataset method.
              #   result = client.get_adaptive_mt_dataset request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::AdaptiveMtDataset.
              #   p result
              #
              def get_adaptive_mt_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_adaptive_mt_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_adaptive_mt_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_adaptive_mt_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_adaptive_mt_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all Adaptive MT datasets for which the caller has read permission.
              #
              # @overload list_adaptive_mt_datasets(request, options = nil)
              #   Pass arguments to `list_adaptive_mt_datasets` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_adaptive_mt_datasets(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_adaptive_mt_datasets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project from which to list the Adaptive
              #     MT datasets. `projects/{project-number-or-id}/locations/{location-id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer results than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Typically, this is the value of
              #     ListAdaptiveMtDatasetsResponse.next_page_token returned from the
              #     previous call to `ListAdaptiveMtDatasets` method. The first page is
              #     returned if `page_token`is empty or missing.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #     Filter is not supported yet.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtDataset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtDataset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest.new
              #
              #   # Call the list_adaptive_mt_datasets method.
              #   result = client.list_adaptive_mt_datasets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::AdaptiveMtDataset.
              #     p item
              #   end
              #
              def list_adaptive_mt_datasets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_adaptive_mt_datasets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_adaptive_mt_datasets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_adaptive_mt_datasets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_adaptive_mt_datasets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_adaptive_mt_datasets, "adaptive_mt_datasets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Translate text using Adaptive MT.
              #
              # @overload adaptive_mt_translate(request, options = nil)
              #   Pass arguments to `adaptive_mt_translate` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload adaptive_mt_translate(parent: nil, dataset: nil, content: nil, reference_sentence_config: nil, glossary_config: nil)
              #   Pass arguments to `adaptive_mt_translate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Location to make a regional call.
              #
              #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
              #   @param dataset [::String]
              #     Required. The resource name for the dataset to use for adaptive MT.
              #     `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
              #   @param content [::Array<::String>]
              #     Required. The content of the input in string format.
              #   @param reference_sentence_config [::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest::ReferenceSentenceConfig, ::Hash]
              #     Configuration for caller provided reference sentences.
              #   @param glossary_config [::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest::GlossaryConfig, ::Hash]
              #     Optional. Glossary to be applied. The glossary must be
              #     within the same region (have the same location-id) as the model, otherwise
              #     an INVALID_ARGUMENT (400) error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::AdaptiveMtTranslateResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::AdaptiveMtTranslateResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest.new
              #
              #   # Call the adaptive_mt_translate method.
              #   result = client.adaptive_mt_translate request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::AdaptiveMtTranslateResponse.
              #   p result
              #
              def adaptive_mt_translate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.adaptive_mt_translate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.adaptive_mt_translate.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.adaptive_mt_translate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.adaptive_mt_translate request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets and AdaptiveMtFile
              #
              # @overload get_adaptive_mt_file(request, options = nil)
              #   Pass arguments to `get_adaptive_mt_file` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_adaptive_mt_file(name: nil)
              #   Pass arguments to `get_adaptive_mt_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the file, in form of
              #     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::AdaptiveMtFile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::AdaptiveMtFile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest.new
              #
              #   # Call the get_adaptive_mt_file method.
              #   result = client.get_adaptive_mt_file request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::AdaptiveMtFile.
              #   p result
              #
              def get_adaptive_mt_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_adaptive_mt_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_adaptive_mt_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_adaptive_mt_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_adaptive_mt_file request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an AdaptiveMtFile along with its sentences.
              #
              # @overload delete_adaptive_mt_file(request, options = nil)
              #   Pass arguments to `delete_adaptive_mt_file` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_adaptive_mt_file(name: nil)
              #   Pass arguments to `delete_adaptive_mt_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the file to delete, in form of
              #     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest.new
              #
              #   # Call the delete_adaptive_mt_file method.
              #   result = client.delete_adaptive_mt_file request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_adaptive_mt_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_adaptive_mt_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_adaptive_mt_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_adaptive_mt_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_adaptive_mt_file request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports an AdaptiveMtFile and adds all of its sentences into the
              # AdaptiveMtDataset.
              #
              # @overload import_adaptive_mt_file(request, options = nil)
              #   Pass arguments to `import_adaptive_mt_file` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_adaptive_mt_file(parent: nil, file_input_source: nil, gcs_input_source: nil)
              #   Pass arguments to `import_adaptive_mt_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the file, in form of
              #     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
              #   @param file_input_source [::Google::Cloud::Translate::V3::FileInputSource, ::Hash]
              #     Inline file source.
              #
              #     Note: The following parameters are mutually exclusive: `file_input_source`, `gcs_input_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gcs_input_source [::Google::Cloud::Translate::V3::GcsInputSource, ::Hash]
              #     Google Cloud Storage file source.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_input_source`, `file_input_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::ImportAdaptiveMtFileResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::ImportAdaptiveMtFileResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest.new
              #
              #   # Call the import_adaptive_mt_file method.
              #   result = client.import_adaptive_mt_file request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::ImportAdaptiveMtFileResponse.
              #   p result
              #
              def import_adaptive_mt_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_adaptive_mt_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_adaptive_mt_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_adaptive_mt_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.import_adaptive_mt_file request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
              #
              # @overload list_adaptive_mt_files(request, options = nil)
              #   Pass arguments to `list_adaptive_mt_files` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_adaptive_mt_files(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_adaptive_mt_files` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project from which to list the Adaptive
              #     MT files.
              #     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
              #   @param page_size [::Integer]
              #     Optional.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Typically, this is the value of
              #     ListAdaptiveMtFilesResponse.next_page_token returned from the
              #     previous call to `ListAdaptiveMtFiles` method. The first page is
              #     returned if `page_token`is empty or missing.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtFile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtFile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest.new
              #
              #   # Call the list_adaptive_mt_files method.
              #   result = client.list_adaptive_mt_files request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::AdaptiveMtFile.
              #     p item
              #   end
              #
              def list_adaptive_mt_files request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_adaptive_mt_files.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_adaptive_mt_files.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_adaptive_mt_files.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_adaptive_mt_files request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_adaptive_mt_files, "adaptive_mt_files", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all AdaptiveMtSentences under a given file/dataset.
              #
              # @overload list_adaptive_mt_sentences(request, options = nil)
              #   Pass arguments to `list_adaptive_mt_sentences` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_adaptive_mt_sentences(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_adaptive_mt_sentences` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project from which to list the Adaptive
              #     MT files. The following format lists all sentences under a file.
              #     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
              #     The following format lists all sentences within a dataset.
              #     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
              #   @param page_size [::Integer]
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #     Typically, this is the value of
              #     ListAdaptiveMtSentencesRequest.next_page_token returned from the
              #     previous call to `ListTranslationMemories` method. The first page is
              #     returned if `page_token` is empty or missing.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtSentence>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::AdaptiveMtSentence>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest.new
              #
              #   # Call the list_adaptive_mt_sentences method.
              #   result = client.list_adaptive_mt_sentences request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::AdaptiveMtSentence.
              #     p item
              #   end
              #
              def list_adaptive_mt_sentences request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_adaptive_mt_sentences.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_adaptive_mt_sentences.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_adaptive_mt_sentences.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_adaptive_mt_sentences request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_adaptive_mt_sentences, "adaptive_mt_sentences", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Import sentence pairs into translation Dataset.
              #
              # @overload import_data(request, options = nil)
              #   Pass arguments to `import_data` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ImportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ImportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_data(dataset: nil, input_config: nil)
              #   Pass arguments to `import_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. Name of the dataset. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
              #   @param input_config [::Google::Cloud::Translate::V3::DatasetInputConfig, ::Hash]
              #     Required. The config for the input content.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ImportDataRequest.new
              #
              #   # Call the import_data method.
              #   result = client.import_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ImportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.import_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports dataset's data to the provided output location.
              #
              # @overload export_data(request, options = nil)
              #   Pass arguments to `export_data` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ExportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ExportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_data(dataset: nil, output_config: nil)
              #   Pass arguments to `export_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. Name of the dataset. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
              #   @param output_config [::Google::Cloud::Translate::V3::DatasetOutputConfig, ::Hash]
              #     Required. The config for the output content.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ExportDataRequest.new
              #
              #   # Call the export_data method.
              #   result = client.export_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ExportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.export_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists sentence pairs in the dataset.
              #
              # @overload list_examples(request, options = nil)
              #   Pass arguments to `list_examples` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListExamplesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListExamplesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_examples(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_examples` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent dataset. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
              #   @param filter [::String]
              #     Optional. An expression for filtering the examples that will be returned.
              #     Example filter:
              #     * `usage=TRAIN`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server can return fewer results than
              #     requested.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results for the server to return.
              #     Typically obtained from next_page_token field in the response of a
              #     ListExamples call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Example>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Example>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListExamplesRequest.new
              #
              #   # Call the list_examples method.
              #   result = client.list_examples request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::Example.
              #     p item
              #   end
              #
              def list_examples request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListExamplesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_examples.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_examples.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_examples.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_examples request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_examples, "examples", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Model.
              #
              # @overload create_model(request, options = nil)
              #   Pass arguments to `create_model` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::CreateModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::CreateModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_model(parent: nil, model: nil)
              #   Pass arguments to `create_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project name, in form of
              #     `projects/{project}/locations/{location}`
              #   @param model [::Google::Cloud::Translate::V3::Model, ::Hash]
              #     Required. The Model to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::CreateModelRequest.new
              #
              #   # Call the create_model method.
              #   result = client.create_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::CreateModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.create_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists models.
              #
              # @overload list_models(request, options = nil)
              #   Pass arguments to `list_models` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::ListModelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::ListModelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_models(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_models` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent project. In form of
              #     `projects/{project-number-or-id}/locations/{location-id}`
              #   @param filter [::String]
              #     Optional. An expression for filtering the models that will be returned.
              #     Supported filter:
              #     `dataset_id=${dataset_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server can return fewer results than
              #     requested.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results for the server to return.
              #     Typically obtained from next_page_token field in the response of a
              #     ListModels call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Model>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Translate::V3::Model>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::ListModelsRequest.new
              #
              #   # Call the list_models method.
              #   result = client.list_models request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Translate::V3::Model.
              #     p item
              #   end
              #
              def list_models request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::ListModelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_models.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_models.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_models.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.list_models request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @translation_service_stub, :list_models, "models", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a model.
              #
              # @overload get_model(request, options = nil)
              #   Pass arguments to `get_model` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::GetModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::GetModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_model(name: nil)
              #   Pass arguments to `get_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the model to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Translate::V3::Model]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Translate::V3::Model]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::GetModelRequest.new
              #
              #   # Call the get_model method.
              #   result = client.get_model request
              #
              #   # The returned object is of type Google::Cloud::Translate::V3::Model.
              #   p result
              #
              def get_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::GetModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.get_model request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a model.
              #
              # @overload delete_model(request, options = nil)
              #   Pass arguments to `delete_model` via a request object, either of type
              #   {::Google::Cloud::Translate::V3::DeleteModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Translate::V3::DeleteModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_model(name: nil)
              #   Pass arguments to `delete_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the model to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/translate/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Translate::V3::TranslationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Translate::V3::DeleteModelRequest.new
              #
              #   # Call the delete_model method.
              #   result = client.delete_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Translate::V3::DeleteModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Translate::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @translation_service_stub.delete_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the TranslationService REST API.
              #
              # This class represents the configuration for TranslationService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Translate::V3::TranslationService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # translate_text to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.translate_text.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.translate_text.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "translate.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the TranslationService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `translate_text`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :translate_text
                  ##
                  # RPC-specific configuration for `romanize_text`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :romanize_text
                  ##
                  # RPC-specific configuration for `detect_language`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :detect_language
                  ##
                  # RPC-specific configuration for `get_supported_languages`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_supported_languages
                  ##
                  # RPC-specific configuration for `translate_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :translate_document
                  ##
                  # RPC-specific configuration for `batch_translate_text`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_translate_text
                  ##
                  # RPC-specific configuration for `batch_translate_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_translate_document
                  ##
                  # RPC-specific configuration for `create_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_glossary
                  ##
                  # RPC-specific configuration for `update_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_glossary
                  ##
                  # RPC-specific configuration for `list_glossaries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_glossaries
                  ##
                  # RPC-specific configuration for `get_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_glossary
                  ##
                  # RPC-specific configuration for `delete_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_glossary
                  ##
                  # RPC-specific configuration for `get_glossary_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_glossary_entry
                  ##
                  # RPC-specific configuration for `list_glossary_entries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_glossary_entries
                  ##
                  # RPC-specific configuration for `create_glossary_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_glossary_entry
                  ##
                  # RPC-specific configuration for `update_glossary_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_glossary_entry
                  ##
                  # RPC-specific configuration for `delete_glossary_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_glossary_entry
                  ##
                  # RPC-specific configuration for `create_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dataset
                  ##
                  # RPC-specific configuration for `get_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dataset
                  ##
                  # RPC-specific configuration for `list_datasets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_datasets
                  ##
                  # RPC-specific configuration for `delete_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dataset
                  ##
                  # RPC-specific configuration for `create_adaptive_mt_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_adaptive_mt_dataset
                  ##
                  # RPC-specific configuration for `delete_adaptive_mt_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_adaptive_mt_dataset
                  ##
                  # RPC-specific configuration for `get_adaptive_mt_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_adaptive_mt_dataset
                  ##
                  # RPC-specific configuration for `list_adaptive_mt_datasets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_adaptive_mt_datasets
                  ##
                  # RPC-specific configuration for `adaptive_mt_translate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :adaptive_mt_translate
                  ##
                  # RPC-specific configuration for `get_adaptive_mt_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_adaptive_mt_file
                  ##
                  # RPC-specific configuration for `delete_adaptive_mt_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_adaptive_mt_file
                  ##
                  # RPC-specific configuration for `import_adaptive_mt_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_adaptive_mt_file
                  ##
                  # RPC-specific configuration for `list_adaptive_mt_files`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_adaptive_mt_files
                  ##
                  # RPC-specific configuration for `list_adaptive_mt_sentences`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_adaptive_mt_sentences
                  ##
                  # RPC-specific configuration for `import_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_data
                  ##
                  # RPC-specific configuration for `export_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_data
                  ##
                  # RPC-specific configuration for `list_examples`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_examples
                  ##
                  # RPC-specific configuration for `create_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_model
                  ##
                  # RPC-specific configuration for `list_models`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_models
                  ##
                  # RPC-specific configuration for `get_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_model
                  ##
                  # RPC-specific configuration for `delete_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_model

                  # @private
                  def initialize parent_rpcs = nil
                    translate_text_config = parent_rpcs.translate_text if parent_rpcs.respond_to? :translate_text
                    @translate_text = ::Gapic::Config::Method.new translate_text_config
                    romanize_text_config = parent_rpcs.romanize_text if parent_rpcs.respond_to? :romanize_text
                    @romanize_text = ::Gapic::Config::Method.new romanize_text_config
                    detect_language_config = parent_rpcs.detect_language if parent_rpcs.respond_to? :detect_language
                    @detect_language = ::Gapic::Config::Method.new detect_language_config
                    get_supported_languages_config = parent_rpcs.get_supported_languages if parent_rpcs.respond_to? :get_supported_languages
                    @get_supported_languages = ::Gapic::Config::Method.new get_supported_languages_config
                    translate_document_config = parent_rpcs.translate_document if parent_rpcs.respond_to? :translate_document
                    @translate_document = ::Gapic::Config::Method.new translate_document_config
                    batch_translate_text_config = parent_rpcs.batch_translate_text if parent_rpcs.respond_to? :batch_translate_text
                    @batch_translate_text = ::Gapic::Config::Method.new batch_translate_text_config
                    batch_translate_document_config = parent_rpcs.batch_translate_document if parent_rpcs.respond_to? :batch_translate_document
                    @batch_translate_document = ::Gapic::Config::Method.new batch_translate_document_config
                    create_glossary_config = parent_rpcs.create_glossary if parent_rpcs.respond_to? :create_glossary
                    @create_glossary = ::Gapic::Config::Method.new create_glossary_config
                    update_glossary_config = parent_rpcs.update_glossary if parent_rpcs.respond_to? :update_glossary
                    @update_glossary = ::Gapic::Config::Method.new update_glossary_config
                    list_glossaries_config = parent_rpcs.list_glossaries if parent_rpcs.respond_to? :list_glossaries
                    @list_glossaries = ::Gapic::Config::Method.new list_glossaries_config
                    get_glossary_config = parent_rpcs.get_glossary if parent_rpcs.respond_to? :get_glossary
                    @get_glossary = ::Gapic::Config::Method.new get_glossary_config
                    delete_glossary_config = parent_rpcs.delete_glossary if parent_rpcs.respond_to? :delete_glossary
                    @delete_glossary = ::Gapic::Config::Method.new delete_glossary_config
                    get_glossary_entry_config = parent_rpcs.get_glossary_entry if parent_rpcs.respond_to? :get_glossary_entry
                    @get_glossary_entry = ::Gapic::Config::Method.new get_glossary_entry_config
                    list_glossary_entries_config = parent_rpcs.list_glossary_entries if parent_rpcs.respond_to? :list_glossary_entries
                    @list_glossary_entries = ::Gapic::Config::Method.new list_glossary_entries_config
                    create_glossary_entry_config = parent_rpcs.create_glossary_entry if parent_rpcs.respond_to? :create_glossary_entry
                    @create_glossary_entry = ::Gapic::Config::Method.new create_glossary_entry_config
                    update_glossary_entry_config = parent_rpcs.update_glossary_entry if parent_rpcs.respond_to? :update_glossary_entry
                    @update_glossary_entry = ::Gapic::Config::Method.new update_glossary_entry_config
                    delete_glossary_entry_config = parent_rpcs.delete_glossary_entry if parent_rpcs.respond_to? :delete_glossary_entry
                    @delete_glossary_entry = ::Gapic::Config::Method.new delete_glossary_entry_config
                    create_dataset_config = parent_rpcs.create_dataset if parent_rpcs.respond_to? :create_dataset
                    @create_dataset = ::Gapic::Config::Method.new create_dataset_config
                    get_dataset_config = parent_rpcs.get_dataset if parent_rpcs.respond_to? :get_dataset
                    @get_dataset = ::Gapic::Config::Method.new get_dataset_config
                    list_datasets_config = parent_rpcs.list_datasets if parent_rpcs.respond_to? :list_datasets
                    @list_datasets = ::Gapic::Config::Method.new list_datasets_config
                    delete_dataset_config = parent_rpcs.delete_dataset if parent_rpcs.respond_to? :delete_dataset
                    @delete_dataset = ::Gapic::Config::Method.new delete_dataset_config
                    create_adaptive_mt_dataset_config = parent_rpcs.create_adaptive_mt_dataset if parent_rpcs.respond_to? :create_adaptive_mt_dataset
                    @create_adaptive_mt_dataset = ::Gapic::Config::Method.new create_adaptive_mt_dataset_config
                    delete_adaptive_mt_dataset_config = parent_rpcs.delete_adaptive_mt_dataset if parent_rpcs.respond_to? :delete_adaptive_mt_dataset
                    @delete_adaptive_mt_dataset = ::Gapic::Config::Method.new delete_adaptive_mt_dataset_config
                    get_adaptive_mt_dataset_config = parent_rpcs.get_adaptive_mt_dataset if parent_rpcs.respond_to? :get_adaptive_mt_dataset
                    @get_adaptive_mt_dataset = ::Gapic::Config::Method.new get_adaptive_mt_dataset_config
                    list_adaptive_mt_datasets_config = parent_rpcs.list_adaptive_mt_datasets if parent_rpcs.respond_to? :list_adaptive_mt_datasets
                    @list_adaptive_mt_datasets = ::Gapic::Config::Method.new list_adaptive_mt_datasets_config
                    adaptive_mt_translate_config = parent_rpcs.adaptive_mt_translate if parent_rpcs.respond_to? :adaptive_mt_translate
                    @adaptive_mt_translate = ::Gapic::Config::Method.new adaptive_mt_translate_config
                    get_adaptive_mt_file_config = parent_rpcs.get_adaptive_mt_file if parent_rpcs.respond_to? :get_adaptive_mt_file
                    @get_adaptive_mt_file = ::Gapic::Config::Method.new get_adaptive_mt_file_config
                    delete_adaptive_mt_file_config = parent_rpcs.delete_adaptive_mt_file if parent_rpcs.respond_to? :delete_adaptive_mt_file
                    @delete_adaptive_mt_file = ::Gapic::Config::Method.new delete_adaptive_mt_file_config
                    import_adaptive_mt_file_config = parent_rpcs.import_adaptive_mt_file if parent_rpcs.respond_to? :import_adaptive_mt_file
                    @import_adaptive_mt_file = ::Gapic::Config::Method.new import_adaptive_mt_file_config
                    list_adaptive_mt_files_config = parent_rpcs.list_adaptive_mt_files if parent_rpcs.respond_to? :list_adaptive_mt_files
                    @list_adaptive_mt_files = ::Gapic::Config::Method.new list_adaptive_mt_files_config
                    list_adaptive_mt_sentences_config = parent_rpcs.list_adaptive_mt_sentences if parent_rpcs.respond_to? :list_adaptive_mt_sentences
                    @list_adaptive_mt_sentences = ::Gapic::Config::Method.new list_adaptive_mt_sentences_config
                    import_data_config = parent_rpcs.import_data if parent_rpcs.respond_to? :import_data
                    @import_data = ::Gapic::Config::Method.new import_data_config
                    export_data_config = parent_rpcs.export_data if parent_rpcs.respond_to? :export_data
                    @export_data = ::Gapic::Config::Method.new export_data_config
                    list_examples_config = parent_rpcs.list_examples if parent_rpcs.respond_to? :list_examples
                    @list_examples = ::Gapic::Config::Method.new list_examples_config
                    create_model_config = parent_rpcs.create_model if parent_rpcs.respond_to? :create_model
                    @create_model = ::Gapic::Config::Method.new create_model_config
                    list_models_config = parent_rpcs.list_models if parent_rpcs.respond_to? :list_models
                    @list_models = ::Gapic::Config::Method.new list_models_config
                    get_model_config = parent_rpcs.get_model if parent_rpcs.respond_to? :get_model
                    @get_model = ::Gapic::Config::Method.new get_model_config
                    delete_model_config = parent_rpcs.delete_model if parent_rpcs.respond_to? :delete_model
                    @delete_model = ::Gapic::Config::Method.new delete_model_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
