# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Translate
      module V3
        module TranslationService
          # Path helper methods for the TranslationService API.
          module Paths
            ##
            # Create a fully-qualified AdaptiveMtDataset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            #
            # @return [::String]
            def adaptive_mt_dataset_path project:, location:, dataset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/adaptiveMtDatasets/#{dataset}"
            end

            ##
            # Create a fully-qualified AdaptiveMtFile resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            # @param file [String]
            #
            # @return [::String]
            def adaptive_mt_file_path project:, location:, dataset:, file:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

              "projects/#{project}/locations/#{location}/adaptiveMtDatasets/#{dataset}/adaptiveMtFiles/#{file}"
            end

            ##
            # Create a fully-qualified Dataset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            #
            # @return [::String]
            def dataset_path project:, location:, dataset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}"
            end

            ##
            # Create a fully-qualified Glossary resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            #
            # @return [::String]
            def glossary_path project:, location:, glossary:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}"
            end

            ##
            # Create a fully-qualified GlossaryEntry resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}/glossaryEntries/{glossary_entry}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            # @param glossary_entry [String]
            #
            # @return [::String]
            def glossary_entry_path project:, location:, glossary:, glossary_entry:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "glossary cannot contain /" if glossary.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}/glossaryEntries/#{glossary_entry}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Model resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/models/{model}`
            #
            # @param project [String]
            # @param location [String]
            # @param model [String]
            #
            # @return [::String]
            def model_path project:, location:, model:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/models/#{model}"
            end

            extend self
          end
        end
      end
    end
  end
end
