# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/trace/v1/version"

require "google/cloud/trace/v1/trace_service/credentials"
require "google/cloud/trace/v1/trace_service/rest/client"

module Google
  module Cloud
    module Trace
      module V1
        ##
        # This file describes an API for collecting and viewing traces and spans
        # within a trace.  A Trace is a collection of spans corresponding to a single
        # operation or set of operations for an application. A span is an individual
        # timed event which forms a node of the trace tree. Spans for a single trace
        # may span multiple services.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/trace/v1/trace_service/rest"
        #     client = ::Google::Cloud::Trace::V1::TraceService::Rest::Client.new
        #
        module TraceService
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/trace/v1/trace_service/rest/helpers" if ::File.file? helper_path
