# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/telcoautomation/v1/telcoautomation_pb"
require "google/cloud/telco_automation/v1/telco_automation"

class ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_orchestration_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_orchestration_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_orchestration_clusters, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_orchestration_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_orchestration_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_orchestration_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_orchestration_clusters ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_orchestration_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_orchestration_clusters(::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_orchestration_clusters_client_stub.call_rpc_count
    end
  end

  def test_get_orchestration_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_orchestration_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_orchestration_cluster, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_orchestration_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_orchestration_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_orchestration_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_orchestration_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_orchestration_cluster_client_stub.call_rpc_count
    end
  end

  def test_create_orchestration_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    orchestration_cluster_id = "hello world"
    orchestration_cluster = {}
    request_id = "hello world"

    create_orchestration_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_orchestration_cluster, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["orchestration_cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster), request["orchestration_cluster"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_orchestration_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_orchestration_cluster({ parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_orchestration_cluster parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest.new(parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_orchestration_cluster({ parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest.new(parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_orchestration_cluster_client_stub.call_rpc_count
    end
  end

  def test_delete_orchestration_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_orchestration_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_orchestration_cluster, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_orchestration_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_orchestration_cluster({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_orchestration_cluster name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_orchestration_cluster({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_orchestration_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_edge_slms
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_edge_slms_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_edge_slms, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_edge_slms_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_edge_slms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_edge_slms parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_edge_slms ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_edge_slms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_edge_slms(::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_edge_slms_client_stub.call_rpc_count
    end
  end

  def test_get_edge_slm
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::EdgeSlm.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_edge_slm_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_edge_slm, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_edge_slm_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_edge_slm({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_edge_slm name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_edge_slm ::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_edge_slm({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_edge_slm(::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_edge_slm_client_stub.call_rpc_count
    end
  end

  def test_create_edge_slm
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    edge_slm_id = "hello world"
    edge_slm = {}
    request_id = "hello world"

    create_edge_slm_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_edge_slm, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["edge_slm_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::EdgeSlm), request["edge_slm"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_edge_slm_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_edge_slm({ parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_edge_slm parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_edge_slm ::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest.new(parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_edge_slm({ parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_edge_slm(::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest.new(parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_edge_slm_client_stub.call_rpc_count
    end
  end

  def test_delete_edge_slm
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_edge_slm_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_edge_slm, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_edge_slm_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_edge_slm({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_edge_slm name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_edge_slm ::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_edge_slm({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_edge_slm(::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_edge_slm_client_stub.call_rpc_count
    end
  end

  def test_create_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    blueprint_id = "hello world"
    blueprint = {}

    create_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["blueprint_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::Blueprint), request["blueprint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_blueprint({ parent: parent, blueprint_id: blueprint_id, blueprint: blueprint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_blueprint parent: parent, blueprint_id: blueprint_id, blueprint: blueprint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_blueprint ::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest.new(parent: parent, blueprint_id: blueprint_id, blueprint: blueprint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_blueprint({ parent: parent, blueprint_id: blueprint_id, blueprint: blueprint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_blueprint(::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest.new(parent: parent, blueprint_id: blueprint_id, blueprint: blueprint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_blueprint_client_stub.call_rpc_count
    end
  end

  def test_update_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    blueprint = {}
    update_mask = {}

    update_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::Blueprint), request["blueprint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_blueprint({ blueprint: blueprint, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_blueprint blueprint: blueprint, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_blueprint ::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest.new(blueprint: blueprint, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_blueprint({ blueprint: blueprint, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_blueprint(::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest.new(blueprint: blueprint, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_blueprint_client_stub.call_rpc_count
    end
  end

  def test_get_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BLUEPRINT_VIEW_UNSPECIFIED

    get_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :BLUEPRINT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_blueprint({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_blueprint name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_blueprint ::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_blueprint({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_blueprint(::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_blueprint_client_stub.call_rpc_count
    end
  end

  def test_delete_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_blueprint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_blueprint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_blueprint ::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_blueprint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_blueprint(::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_blueprint_client_stub.call_rpc_count
    end
  end

  def test_list_blueprints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_blueprints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_blueprints, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_blueprints_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_blueprints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_blueprints parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_blueprints ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_blueprints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_blueprints(::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_blueprints_client_stub.call_rpc_count
    end
  end

  def test_approve_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_blueprint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_blueprint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_blueprint ::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_blueprint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_blueprint(::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_blueprint_client_stub.call_rpc_count
    end
  end

  def test_propose_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    propose_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :propose_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, propose_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.propose_blueprint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.propose_blueprint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.propose_blueprint ::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.propose_blueprint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.propose_blueprint(::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, propose_blueprint_client_stub.call_rpc_count
    end
  end

  def test_reject_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reject_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reject_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reject_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reject_blueprint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reject_blueprint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reject_blueprint ::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reject_blueprint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reject_blueprint(::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reject_blueprint_client_stub.call_rpc_count
    end
  end

  def test_list_blueprint_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_blueprint_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_blueprint_revisions, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_blueprint_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_blueprint_revisions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_blueprint_revisions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_blueprint_revisions ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_blueprint_revisions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_blueprint_revisions(::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_blueprint_revisions_client_stub.call_rpc_count
    end
  end

  def test_search_blueprint_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_blueprint_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_blueprint_revisions, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_blueprint_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_blueprint_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_blueprint_revisions parent: parent, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_blueprint_revisions ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_blueprint_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_blueprint_revisions(::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_blueprint_revisions_client_stub.call_rpc_count
    end
  end

  def test_search_deployment_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_deployment_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_deployment_revisions, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_deployment_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_deployment_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_deployment_revisions parent: parent, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_deployment_revisions ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_deployment_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_deployment_revisions(::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_deployment_revisions_client_stub.call_rpc_count
    end
  end

  def test_discard_blueprint_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    discard_blueprint_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :discard_blueprint_changes, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, discard_blueprint_changes_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.discard_blueprint_changes({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.discard_blueprint_changes name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.discard_blueprint_changes ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.discard_blueprint_changes({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.discard_blueprint_changes(::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, discard_blueprint_changes_client_stub.call_rpc_count
    end
  end

  def test_list_public_blueprints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_public_blueprints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_public_blueprints, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_public_blueprints_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_public_blueprints({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_public_blueprints parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_public_blueprints ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_public_blueprints({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_public_blueprints(::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_public_blueprints_client_stub.call_rpc_count
    end
  end

  def test_get_public_blueprint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::PublicBlueprint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_public_blueprint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_public_blueprint, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_public_blueprint_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_public_blueprint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_public_blueprint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_public_blueprint ::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_public_blueprint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_public_blueprint(::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_public_blueprint_client_stub.call_rpc_count
    end
  end

  def test_create_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["deployment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::Deployment), request["deployment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_deployment ::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_deployment(::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_deployment_client_stub.call_rpc_count
    end
  end

  def test_update_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    deployment = {}
    update_mask = {}

    update_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::Deployment), request["deployment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_deployment({ deployment: deployment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_deployment deployment: deployment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_deployment ::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_deployment({ deployment: deployment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_deployment(::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_deployment_client_stub.call_rpc_count
    end
  end

  def test_get_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :DEPLOYMENT_VIEW_UNSPECIFIED

    get_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :DEPLOYMENT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_deployment({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_deployment name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_deployment ::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_deployment({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_deployment(::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_deployment_client_stub.call_rpc_count
    end
  end

  def test_remove_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    remove_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_deployment ::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_deployment(::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deployments, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deployments parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deployments ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deployments(::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deployments_client_stub.call_rpc_count
    end
  end

  def test_list_deployment_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployment_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deployment_revisions, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deployment_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deployment_revisions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deployment_revisions ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deployment_revisions(::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deployment_revisions_client_stub.call_rpc_count
    end
  end

  def test_discard_deployment_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    discard_deployment_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :discard_deployment_changes, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, discard_deployment_changes_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.discard_deployment_changes({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.discard_deployment_changes name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.discard_deployment_changes ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.discard_deployment_changes({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.discard_deployment_changes(::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, discard_deployment_changes_client_stub.call_rpc_count
    end
  end

  def test_apply_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    apply_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :apply_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, apply_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.apply_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.apply_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.apply_deployment ::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.apply_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.apply_deployment(::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, apply_deployment_client_stub.call_rpc_count
    end
  end

  def test_compute_deployment_status
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    compute_deployment_status_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :compute_deployment_status, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, compute_deployment_status_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.compute_deployment_status({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.compute_deployment_status name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.compute_deployment_status ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.compute_deployment_status({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.compute_deployment_status(::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, compute_deployment_status_client_stub.call_rpc_count
    end
  end

  def test_rollback_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_deployment({ name: name, revision_id: revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_deployment name: name, revision_id: revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_deployment ::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest.new(name: name, revision_id: revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_deployment({ name: name, revision_id: revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_deployment(::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest.new(name: name, revision_id: revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_deployment_client_stub.call_rpc_count
    end
  end

  def test_get_hydrated_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hydrated_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hydrated_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hydrated_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hydrated_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hydrated_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hydrated_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hydrated_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_hydrated_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hydrated_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hydrated_deployments, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hydrated_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hydrated_deployments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hydrated_deployments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hydrated_deployments ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hydrated_deployments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hydrated_deployments(::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hydrated_deployments_client_stub.call_rpc_count
    end
  end

  def test_update_hydrated_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    hydrated_deployment = {}
    update_mask = {}

    update_hydrated_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_hydrated_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment), request["hydrated_deployment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_hydrated_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_hydrated_deployment({ hydrated_deployment: hydrated_deployment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_hydrated_deployment hydrated_deployment: hydrated_deployment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest.new(hydrated_deployment: hydrated_deployment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_hydrated_deployment({ hydrated_deployment: hydrated_deployment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest.new(hydrated_deployment: hydrated_deployment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_hydrated_deployment_client_stub.call_rpc_count
    end
  end

  def test_apply_hydrated_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    apply_hydrated_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :apply_hydrated_deployment, name
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, apply_hydrated_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.apply_hydrated_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.apply_hydrated_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.apply_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.apply_hydrated_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.apply_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, apply_hydrated_deployment_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Operations, client.operations_client
  end
end
