# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/telcoautomation/v1/telcoautomation_pb"
require "google/cloud/telco_automation/v1/telco_automation/rest"


class ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_orchestration_clusters
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_orchestration_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_orchestration_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_orchestration_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_orchestration_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_orchestration_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_orchestration_clusters ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_orchestration_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_orchestration_clusters(::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_orchestration_clusters_client_stub.call_count
      end
    end
  end

  def test_get_orchestration_cluster
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_orchestration_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_orchestration_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_orchestration_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_orchestration_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_orchestration_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_orchestration_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_orchestration_cluster_client_stub.call_count
      end
    end
  end

  def test_create_orchestration_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    orchestration_cluster_id = "hello world"
    orchestration_cluster = {}
    request_id = "hello world"

    create_orchestration_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_create_orchestration_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_orchestration_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_orchestration_cluster({ parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_orchestration_cluster parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest.new(parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_orchestration_cluster({ parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest.new(parent: parent, orchestration_cluster_id: orchestration_cluster_id, orchestration_cluster: orchestration_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_orchestration_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_orchestration_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_orchestration_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_delete_orchestration_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_orchestration_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_orchestration_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_orchestration_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_orchestration_cluster ::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_orchestration_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_orchestration_cluster(::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_orchestration_cluster_client_stub.call_count
      end
    end
  end

  def test_list_edge_slms
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_edge_slms_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_edge_slms_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_edge_slms_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_edge_slms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_edge_slms parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_edge_slms ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_edge_slms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_edge_slms(::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_edge_slms_client_stub.call_count
      end
    end
  end

  def test_get_edge_slm
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::EdgeSlm.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_edge_slm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_edge_slm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_edge_slm_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_edge_slm({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_edge_slm name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_edge_slm ::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_edge_slm({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_edge_slm(::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_edge_slm_client_stub.call_count
      end
    end
  end

  def test_create_edge_slm
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    edge_slm_id = "hello world"
    edge_slm = {}
    request_id = "hello world"

    create_edge_slm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_create_edge_slm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_edge_slm_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_edge_slm({ parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_edge_slm parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_edge_slm ::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest.new(parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_edge_slm({ parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_edge_slm(::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest.new(parent: parent, edge_slm_id: edge_slm_id, edge_slm: edge_slm, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_edge_slm_client_stub.call_count
      end
    end
  end

  def test_delete_edge_slm
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_edge_slm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_delete_edge_slm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_edge_slm_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_edge_slm({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_edge_slm name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_edge_slm ::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_edge_slm({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_edge_slm(::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_edge_slm_client_stub.call_count
      end
    end
  end

  def test_create_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    blueprint_id = "hello world"
    blueprint = {}

    create_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_create_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_blueprint({ parent: parent, blueprint_id: blueprint_id, blueprint: blueprint }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_blueprint parent: parent, blueprint_id: blueprint_id, blueprint: blueprint do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_blueprint ::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest.new(parent: parent, blueprint_id: blueprint_id, blueprint: blueprint) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_blueprint({ parent: parent, blueprint_id: blueprint_id, blueprint: blueprint }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_blueprint(::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest.new(parent: parent, blueprint_id: blueprint_id, blueprint: blueprint), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_blueprint_client_stub.call_count
      end
    end
  end

  def test_update_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    blueprint = {}
    update_mask = {}

    update_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_update_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_blueprint({ blueprint: blueprint, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_blueprint blueprint: blueprint, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_blueprint ::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest.new(blueprint: blueprint, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_blueprint({ blueprint: blueprint, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_blueprint(::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest.new(blueprint: blueprint, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_blueprint_client_stub.call_count
      end
    end
  end

  def test_get_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BLUEPRINT_VIEW_UNSPECIFIED

    get_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_blueprint({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_blueprint name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_blueprint ::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_blueprint({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_blueprint(::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_blueprint_client_stub.call_count
      end
    end
  end

  def test_delete_blueprint
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_delete_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_blueprint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_blueprint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_blueprint ::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_blueprint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_blueprint(::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_blueprint_client_stub.call_count
      end
    end
  end

  def test_list_blueprints
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_blueprints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_blueprints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_blueprints_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_blueprints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_blueprints parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_blueprints ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_blueprints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_blueprints(::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_blueprints_client_stub.call_count
      end
    end
  end

  def test_approve_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_approve_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_blueprint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_blueprint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_blueprint ::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_blueprint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_blueprint(::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_blueprint_client_stub.call_count
      end
    end
  end

  def test_propose_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    propose_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_propose_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, propose_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.propose_blueprint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.propose_blueprint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.propose_blueprint ::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.propose_blueprint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.propose_blueprint(::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, propose_blueprint_client_stub.call_count
      end
    end
  end

  def test_reject_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Blueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reject_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_reject_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reject_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reject_blueprint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reject_blueprint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reject_blueprint ::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reject_blueprint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reject_blueprint(::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reject_blueprint_client_stub.call_count
      end
    end
  end

  def test_list_blueprint_revisions
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_blueprint_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_blueprint_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_blueprint_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_blueprint_revisions({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_blueprint_revisions name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_blueprint_revisions ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_blueprint_revisions({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_blueprint_revisions(::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_blueprint_revisions_client_stub.call_count
      end
    end
  end

  def test_search_blueprint_revisions
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_blueprint_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_search_blueprint_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_blueprint_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_blueprint_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_blueprint_revisions parent: parent, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_blueprint_revisions ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_blueprint_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_blueprint_revisions(::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_blueprint_revisions_client_stub.call_count
      end
    end
  end

  def test_search_deployment_revisions
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_deployment_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_search_deployment_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_deployment_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_deployment_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_deployment_revisions parent: parent, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_deployment_revisions ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_deployment_revisions({ parent: parent, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_deployment_revisions(::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_deployment_revisions_client_stub.call_count
      end
    end
  end

  def test_discard_blueprint_changes
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    discard_blueprint_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_discard_blueprint_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, discard_blueprint_changes_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.discard_blueprint_changes({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.discard_blueprint_changes name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.discard_blueprint_changes ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.discard_blueprint_changes({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.discard_blueprint_changes(::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, discard_blueprint_changes_client_stub.call_count
      end
    end
  end

  def test_list_public_blueprints
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_public_blueprints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_public_blueprints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_public_blueprints_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_public_blueprints({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_public_blueprints parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_public_blueprints ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_public_blueprints({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_public_blueprints(::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_public_blueprints_client_stub.call_count
      end
    end
  end

  def test_get_public_blueprint
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::PublicBlueprint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_public_blueprint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_public_blueprint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_public_blueprint_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_public_blueprint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_public_blueprint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_public_blueprint ::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_public_blueprint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_public_blueprint(::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_public_blueprint_client_stub.call_count
      end
    end
  end

  def test_create_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_create_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deployment ::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deployment(::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deployment_client_stub.call_count
      end
    end
  end

  def test_update_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    deployment = {}
    update_mask = {}

    update_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_update_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_deployment({ deployment: deployment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_deployment deployment: deployment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_deployment ::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_deployment({ deployment: deployment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_deployment(::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_deployment_client_stub.call_count
      end
    end
  end

  def test_get_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :DEPLOYMENT_VIEW_UNSPECIFIED

    get_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deployment({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deployment name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deployment ::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deployment({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deployment(::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deployment_client_stub.call_count
      end
    end
  end

  def test_remove_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    remove_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_remove_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_deployment ::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_deployment(::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_deployment_client_stub.call_count
      end
    end
  end

  def test_list_deployments
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployments parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployments ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployments(::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployments_client_stub.call_count
      end
    end
  end

  def test_list_deployment_revisions
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployment_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_deployment_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployment_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployment_revisions name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployment_revisions ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployment_revisions(::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployment_revisions_client_stub.call_count
      end
    end
  end

  def test_discard_deployment_changes
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    discard_deployment_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_discard_deployment_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, discard_deployment_changes_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.discard_deployment_changes({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.discard_deployment_changes name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.discard_deployment_changes ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.discard_deployment_changes({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.discard_deployment_changes(::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, discard_deployment_changes_client_stub.call_count
      end
    end
  end

  def test_apply_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    apply_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_apply_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, apply_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.apply_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.apply_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.apply_deployment ::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.apply_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.apply_deployment(::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, apply_deployment_client_stub.call_count
      end
    end
  end

  def test_compute_deployment_status
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    compute_deployment_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_compute_deployment_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, compute_deployment_status_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.compute_deployment_status({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.compute_deployment_status name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.compute_deployment_status ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.compute_deployment_status({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.compute_deployment_status(::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, compute_deployment_status_client_stub.call_count
      end
    end
  end

  def test_rollback_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_rollback_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_deployment({ name: name, revision_id: revision_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_deployment name: name, revision_id: revision_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_deployment ::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest.new(name: name, revision_id: revision_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_deployment({ name: name, revision_id: revision_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_deployment(::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest.new(name: name, revision_id: revision_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_deployment_client_stub.call_count
      end
    end
  end

  def test_get_hydrated_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hydrated_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_get_hydrated_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hydrated_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hydrated_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hydrated_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hydrated_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hydrated_deployment_client_stub.call_count
      end
    end
  end

  def test_list_hydrated_deployments
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hydrated_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_list_hydrated_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hydrated_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hydrated_deployments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hydrated_deployments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hydrated_deployments ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hydrated_deployments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hydrated_deployments(::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hydrated_deployments_client_stub.call_count
      end
    end
  end

  def test_update_hydrated_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    hydrated_deployment = {}
    update_mask = {}

    update_hydrated_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_update_hydrated_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_hydrated_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_hydrated_deployment({ hydrated_deployment: hydrated_deployment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_hydrated_deployment hydrated_deployment: hydrated_deployment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest.new(hydrated_deployment: hydrated_deployment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_hydrated_deployment({ hydrated_deployment: hydrated_deployment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest.new(hydrated_deployment: hydrated_deployment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_hydrated_deployment_client_stub.call_count
      end
    end
  end

  def test_apply_hydrated_deployment
    # Create test objects.
    client_result = ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    apply_hydrated_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::ServiceStub.stub :transcode_apply_hydrated_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, apply_hydrated_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.apply_hydrated_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.apply_hydrated_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.apply_hydrated_deployment ::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.apply_hydrated_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.apply_hydrated_deployment(::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, apply_hydrated_deployment_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Rest::Client::Configuration, config
  end
end
