# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module TelcoAutomation
      module V1
        # Orchestration cluster represents a GKE cluster with config controller and
        # TNA specific components installed on it.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the orchestration cluster. The name of orchestration cluster cannot
        #     be more than 24 characters.
        # @!attribute [rw] management_config
        #   @return [::Google::Cloud::TelcoAutomation::V1::ManagementConfig]
        #     Management configuration of the underlying GKE cluster.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [r] tna_version
        #   @return [::String]
        #     Output only. Provides the TNA version installed on the cluster.
        # @!attribute [r] state
        #   @return [::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster::State]
        #     Output only. State of the Orchestration Cluster.
        class OrchestrationCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states that the Orchestration Cluster can be in.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # OrchestrationCluster is being created.
            CREATING = 1

            # OrchestrationCluster has been created and is ready for use.
            ACTIVE = 2

            # OrchestrationCluster is being deleted.
            DELETING = 3

            # OrchestrationCluster encountered an error and is in an indeterministic
            # state. User can still initiate a delete operation on this state.
            FAILED = 4
          end
        end

        # EdgeSlm represents an SLM instance which manages the lifecycle of edge
        # components installed on Workload clusters managed by an Orchestration
        # Cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the EdgeSlm resource.
        # @!attribute [rw] orchestration_cluster
        #   @return [::String]
        #     Immutable. Reference to the orchestration cluster on which templates for
        #     this resources will be applied. This should be of format
        #     projects/\\{project}/locations/\\{location}/orchestrationClusters/\\{orchestration_cluster}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs. The key and value should contain
        #     characters which are UTF-8 compliant and less than 50 characters.
        # @!attribute [r] tna_version
        #   @return [::String]
        #     Output only. Provides the active TNA version for this resource.
        # @!attribute [r] state
        #   @return [::Google::Cloud::TelcoAutomation::V1::EdgeSlm::State]
        #     Output only. State of the EdgeSlm resource.
        # @!attribute [rw] workload_cluster_type
        #   @return [::Google::Cloud::TelcoAutomation::V1::EdgeSlm::WorkloadClusterType]
        #     Optional. Type of workload cluster for which an EdgeSLM resource is
        #     created.
        class EdgeSlm
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of the resource.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # EdgeSlm is being created.
            CREATING = 1

            # EdgeSlm has been created and is ready for use.
            ACTIVE = 2

            # EdgeSlm is being deleted.
            DELETING = 3

            # EdgeSlm encountered an error and is in an indeterministic
            # state. User can still initiate a delete operation on this state.
            FAILED = 4
          end

          # Workload clusters supported by TNA. New values will be added to the enum
          # list as TNA adds supports for new workload clusters in future.
          module WorkloadClusterType
            # Unspecified workload cluster.
            WORKLOAD_CLUSTER_TYPE_UNSPECIFIED = 0

            # Workload cluster is a GDCE cluster.
            GDCE = 1

            # Workload cluster is a GKE cluster.
            GKE = 2
          end
        end

        # A Blueprint contains a collection of kubernetes resources in the form of
        # YAML files. The file contents of a blueprint are collectively known as
        # package. A blueprint can be
        # a) imported from TNA's public catalog
        # b) modified as per a user's need
        # c) proposed and approved.
        # On approval, a revision of blueprint is created which can be used to
        # create a deployment on Orchestration or Workload Cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the blueprint. If unspecified, the name will be autogenerated
        #     from server side. Name of the blueprint must not contain `@` character.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. Immutable. The revision ID of the blueprint.
        #     A new revision is committed whenever a blueprint is approved.
        # @!attribute [rw] source_blueprint
        #   @return [::String]
        #     Required. Immutable. The public blueprint ID from which this blueprint was
        #     created.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the revision was created.
        # @!attribute [r] approval_state
        #   @return [::Google::Cloud::TelcoAutomation::V1::Blueprint::ApprovalState]
        #     Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human readable name of a Blueprint.
        # @!attribute [r] repository
        #   @return [::String]
        #     Output only. Name of the repository where the blueprint files are stored.
        # @!attribute [rw] files
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::File>]
        #     Optional. Files present in a blueprint.
        #     When invoking UpdateBlueprint API, only the modified files should be
        #     included in this. Files that are not included in the update of a blueprint
        #     will not be changed.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are key-value attributes that can be set on a blueprint
        #     resource by the user.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Blueprint creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the blueprint was updated.
        # @!attribute [r] source_provider
        #   @return [::String]
        #     Output only. Source provider is the author of a public blueprint, from
        #     which this blueprint is created.
        # @!attribute [r] deployment_level
        #   @return [::Google::Cloud::TelcoAutomation::V1::DeploymentLevel]
        #     Output only. DeploymentLevel of a blueprint signifies where the blueprint
        #     will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
        # @!attribute [r] rollback_support
        #   @return [::Boolean]
        #     Output only. Indicates if the deployment created from this blueprint can be
        #     rolled back.
        class Blueprint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Approval state indicates the state of a Blueprint in its approval
          # lifecycle.
          module ApprovalState
            # Unspecified state.
            APPROVAL_STATE_UNSPECIFIED = 0

            # A blueprint starts in DRAFT state once it is created. All edits are made
            # to the blueprint in DRAFT state.
            DRAFT = 1

            # When the edits are ready for review, blueprint can be proposed and moves
            # to PROPOSED state. Edits cannot be made to a blueprint in PROPOSED state.
            PROPOSED = 2

            # When a proposed blueprint is approved, it moves to APPROVED state. A new
            # revision is committed. The latest committed revision can be used to
            # create a deployment on Orchestration or Workload Cluster. Edits to an
            # APPROVED blueprint changes its state back to DRAFT. The last committed
            # revision of a blueprint represents its latest APPROVED state.
            APPROVED = 3
          end
        end

        # A Blueprint contains a collection of kubernetes resources in the form of
        # YAML files. The file contents of a blueprint are collectively known as
        # package.
        # Public blueprint is a TNA provided blueprint that in present in TNA's public
        # catalog. A user can copy the public blueprint to their private catalog for
        # further modifications.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the public blueprint.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the public blueprint.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the public blueprint.
        # @!attribute [rw] deployment_level
        #   @return [::Google::Cloud::TelcoAutomation::V1::DeploymentLevel]
        #     DeploymentLevel of a blueprint signifies where the blueprint will be
        #     applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
        # @!attribute [rw] source_provider
        #   @return [::String]
        #     Source provider is the author of a public blueprint. e.g. Google, vendors
        # @!attribute [r] rollback_support
        #   @return [::Boolean]
        #     Output only. Indicates if the deployment created from this blueprint can be
        #     rolled back.
        class PublicBlueprint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deployment contains a collection of YAML files (This collection is also known
        # as package) that can to applied on an orchestration cluster (GKE cluster with
        # TNA addons) or a workload cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the deployment.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. Immutable. The revision ID of the deployment.
        #     A new revision is committed whenever a change in deployment is applied.
        # @!attribute [rw] source_blueprint_revision
        #   @return [::String]
        #     Required. The blueprint revision from which this deployment was created.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the revision was created.
        # @!attribute [r] state
        #   @return [::Google::Cloud::TelcoAutomation::V1::Deployment::State]
        #     Output only. State of the deployment (DRAFT, APPLIED, DELETING).
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human readable name of a Deployment.
        # @!attribute [r] repository
        #   @return [::String]
        #     Output only. Name of the repository where the deployment package files are
        #     stored.
        # @!attribute [rw] files
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::File>]
        #     Optional. Files present in a deployment.
        #     When invoking UpdateDeployment API, only the modified files should be
        #     included in this. Files that are not included in the update of a deployment
        #     will not be changed.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are key-value attributes that can be set on a deployment
        #     resource by the user.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Deployment creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the deployment was updated.
        # @!attribute [r] source_provider
        #   @return [::String]
        #     Output only. Source provider is the author of a public blueprint, from
        #     which this deployment is created.
        # @!attribute [rw] workload_cluster
        #   @return [::String]
        #     Optional. Immutable. The WorkloadCluster on which to create the Deployment.
        #     This field should only be passed when the deployment_level of the source
        #     blueprint specifies deployments on workload clusters e.g.
        #     WORKLOAD_CLUSTER_DEPLOYMENT.
        # @!attribute [r] deployment_level
        #   @return [::Google::Cloud::TelcoAutomation::V1::DeploymentLevel]
        #     Output only. Attributes to where the deployment can inflict changes. The
        #     value can only be [SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT].
        # @!attribute [r] rollback_support
        #   @return [::Boolean]
        #     Output only. Indicates if the deployment can be rolled back, exported from
        #     public blueprint.
        class Deployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State defines which state the current deployment is in.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # A deployment starts in DRAFT state. All edits are made in DRAFT state. A
            # deployment opened for editing after applying will be in draft state,
            # while its prevision revision will be its current applied version.
            DRAFT = 1

            # This state means that the contents (YAML files containing kubernetes
            # resources) of the deployment have been applied to an Orchestration or
            # Workload Cluster. A revision is created when a deployment is applied.
            # This revision will represent the latest view of what is applied on the
            # cluster until the deployment is modified and applied again, which will
            # create a new revision.
            APPLIED = 2

            # A deployment in DELETING state has been marked for deletion. Its
            # deletion status can be queried using `ComputeDeploymentStatus` API. No
            # updates are allowed to a deployment in DELETING state.
            DELETING = 3
          end
        end

        # A collection of kubernetes yaml files which are deployed on a Workload
        # Cluster. Hydrated Deployments are created by TNA intent based automation.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the hydrated deployment.
        # @!attribute [r] state
        #   @return [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment::State]
        #     Output only. State of the hydrated deployment (DRAFT, APPLIED).
        # @!attribute [rw] files
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::File>]
        #     Optional. File contents of a hydrated deployment.
        #     When invoking UpdateHydratedBlueprint API, only the modified files should
        #     be included in this. Files that are not included in the update of a
        #     hydrated deployment will not be changed.
        # @!attribute [r] workload_cluster
        #   @return [::String]
        #     Output only. WorkloadCluster identifies which workload cluster will the
        #     hydrated deployment will be deployed on.
        class HydratedDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State defines which state the current hydrated deployment is in.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # A hydrated deployment starts in DRAFT state. All edits are made in DRAFT
            # state.
            DRAFT = 1

            # When the edit is applied, the hydrated deployment moves to APPLIED
            # state. No changes can be made once a hydrated deployment is applied.
            APPLIED = 2
          end
        end

        # Message for requesting list of OrchestrationClusters.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListOrchestrationClustersRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListOrchestrationClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing OrchestrationClusters.
        # @!attribute [rw] orchestration_clusters
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster>]
        #     The list of OrchestrationCluster
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListOrchestrationClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a OrchestrationCluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetOrchestrationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a OrchestrationCluster.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] orchestration_cluster_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     orchestration_cluster_id from the method_signature of Create RPC
        # @!attribute [rw] orchestration_cluster
        #   @return [::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateOrchestrationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a OrchestrationCluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteOrchestrationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of EdgeSlms
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListEdgeSlmsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListEdgeSlmsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing EdgeSlms.
        # @!attribute [rw] edge_slms
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::EdgeSlm>]
        #     The list of EdgeSlm
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListEdgeSlmsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a EdgeSlm.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetEdgeSlmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a EdgeSlm.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] edge_slm_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     edge_slm_id from the method_signature of Create RPC
        # @!attribute [rw] edge_slm
        #   @return [::Google::Cloud::TelcoAutomation::V1::EdgeSlm]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateEdgeSlmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a EdgeSlm.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteEdgeSlmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateBlueprint`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] blueprint_id
        #   @return [::String]
        #     Optional. The name of the blueprint.
        # @!attribute [rw] blueprint
        #   @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
        #     Required. The `Blueprint` to create.
        class CreateBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateBlueprint`.
        # @!attribute [rw] blueprint
        #   @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
        #     Required. The `blueprint` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Update mask is used to specify the fields to be overwritten in
        #     the `blueprint` resource by the update.
        class UpdateBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `GetBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint.
        #     Case 1: If the name provided in the request is
        #     \\{blueprint_id}@\\{revision_id}, then the revision with revision_id will be
        #     returned. Case 2: If the name provided in the request is \\{blueprint}, then
        #     the current state of the blueprint is returned.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::TelcoAutomation::V1::BlueprintView]
        #     Optional. Defines the type of view of the blueprint.
        #     When field is not present BLUEPRINT_VIEW_BASIC is considered as default.
        class GetBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `DeleteBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of blueprint to delete.
        #     Blueprint name should be in the format \\{blueprint_id}, if
        #     \\{blueprint_id}@\\{revision_id} is passed then the API throws invalid
        #     argument.
        class DeleteBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListBlueprints`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent orchestration cluster resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering only supports equality on blueprint state.
        #     It should be in the form: "state = DRAFT". `OR` operator can be used to
        #     get response for multiple states. e.g. "state = DRAFT OR state = PROPOSED".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of blueprints to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous ListBlueprints call.
        #     It can be provided to retrieve the subsequent page.
        class ListBlueprintsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListBlueprints`.
        # @!attribute [rw] blueprints
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
        #     The list of requested blueprints.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListBlueprintsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ApproveBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint to approve. The blueprint must be in
        #     Proposed state. A new revision is committed on approval.
        class ApproveBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ProposeBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint being proposed.
        class ProposeBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `RejectBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint being rejected.
        class RejectBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListBlueprintRevisions`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint to list revisions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token, received from a previous ListBlueprintRevisions call
        #     It can be provided to retrieve the subsequent page.
        class ListBlueprintRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListBlueprintRevisions`.
        # @!attribute [rw] blueprints
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
        #     The revisions of the blueprint.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListBlueprintRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `SearchBlueprintRevisions`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent orchestration cluster resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. Supported queries:
        #     1. ""                       : Lists all revisions across all blueprints.
        #     2. "latest=true"            : Lists latest revisions across all blueprints.
        #     3. "name=\\{name}"            : Lists all revisions of blueprint with name
        #     \\{name}.
        #     4. "name=\\{name} latest=true": Lists latest revision of blueprint with name
        #     \\{name}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of blueprints revisions to return per page.
        #     max page size = 100, default page size = 20.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous search call.
        #     It can be provided to retrieve the subsequent page.
        class SearchBlueprintRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `SearchBlueprintRevisions`.
        # @!attribute [rw] blueprints
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
        #     The list of requested blueprint revisions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class SearchBlueprintRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `DiscardBlueprintChanges`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the blueprint of which changes are being discarded.
        class DiscardBlueprintChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `DiscardBlueprintChanges`.
        class DiscardBlueprintChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListPublicBlueprints`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value of public blueprint.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListPublicBlueprintsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListPublicBlueprints`.
        # @!attribute [rw] public_blueprints
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::PublicBlueprint>]
        #     The list of public blueprints to return.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token identifying a page of results the server should
        #     return.
        class ListPublicBlueprintsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `GetPublicBlueprint`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the public blueprint.
        class GetPublicBlueprintRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateDeployment`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] deployment_id
        #   @return [::String]
        #     Optional. The name of the deployment.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
        #     Required. The `Deployment` to create.
        class CreateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateDeployment`.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
        #     Required. The `deployment` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Update mask is used to specify the fields to be overwritten in
        #     the `deployment` resource by the update.
        class UpdateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `GetDeployment`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment.
        #     Case 1: If the name provided in the request is
        #     \\{deployment_id}@\\{revision_id}, then the revision with revision_id will be
        #     returned.
        #     Case 2: If the name provided in the request is \\{deployment}, then
        #     the current state of the deployment is returned.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::TelcoAutomation::V1::DeploymentView]
        #     Optional. Defines the type of view of the deployment.
        #     When field is not present VIEW_BASIC is considered as default.
        class GetDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `RemoveDeployment`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of deployment to initiate delete.
        class RemoveDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListDeployments`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent orchestration cluster resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering only supports equality on deployment state.
        #     It should be in the form: "state = DRAFT". `OR` operator can be used to
        #     get response for multiple states. e.g. "state = DRAFT OR state = APPLIED".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of deployments to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous ListDeployments call.
        #     It can be provided to retrieve the subsequent page.
        class ListDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListDeployments`.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Deployment>]
        #     The list of requested deployments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for listing all revisions of a deployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to list revisions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of revisions to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous ListDeploymentRevisions
        #     call Provide this to retrieve the subsequent page.
        class ListDeploymentRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of deployment revisions for a given deployment.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Deployment>]
        #     The revisions of the deployment.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeploymentRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `SearchDeploymentRevisions`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of parent orchestration cluster resource.
        #     Format should be -
        #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. Supported queries:
        #     1. ""                       : Lists all revisions across all deployments.
        #     2. "latest=true"            : Lists latest revisions across all
        #     deployments.
        #     3. "name=\\{name}"            : Lists all revisions of deployment with name
        #     \\{name}.
        #     4. "name=\\{name} latest=true": Lists latest revision of deployment with name
        #     \\{name}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of deployment revisions to return per page.
        #     max page size = 100, default page size = 20.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous search call.
        #     It can be provided to retrieve the subsequent page.
        class SearchDeploymentRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `SearchDeploymentRevisions`.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::Deployment>]
        #     The list of requested deployment revisions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class SearchDeploymentRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `DiscardDeploymentChanges`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment of which changes are being discarded.
        class DiscardDeploymentChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `DiscardDeploymentChanges`.
        class DiscardDeploymentChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ApplyDeployment`. The resources in given deployment
        # gets applied to Orchestration Cluster. A new revision is created when a
        # deployment is applied.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to apply to orchestration cluster.
        class ApplyDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ComputeDeploymentStatus`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment without revisionID.
        class ComputeDeploymentStatusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ComputeDeploymentStatus`.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the deployment.
        # @!attribute [r] aggregated_status
        #   @return [::Google::Cloud::TelcoAutomation::V1::Status]
        #     Output only. Aggregated status of a deployment.
        # @!attribute [r] resource_statuses
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::ResourceStatus>]
        #     Output only. Resource level status details in deployments.
        class ComputeDeploymentStatusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `RollbackDeployment`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the deployment.
        # @!attribute [rw] revision_id
        #   @return [::String]
        #     Required. The revision id of deployment to roll back to.
        class RollbackDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `GetHydratedDeployment`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the hydrated deployment.
        class GetHydratedDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListHydratedDeployments`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The deployment managing the hydrated deployments.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of hydrated deployments to return. The service
        #     may return fewer than this value. If unspecified, at most 50 hydrated
        #     deployments will be returned. The maximum value is 1000. Values above 1000
        #     will be set to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token, received from a previous ListHydratedDeployments
        #     call. Provide this to retrieve the subsequent page.
        class ListHydratedDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListHydratedDeployments`.
        # @!attribute [rw] hydrated_deployments
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::HydratedDeployment>]
        #     The list of hydrated deployments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListHydratedDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateHydratedDeployment`.
        # @!attribute [rw] hydrated_deployment
        #   @return [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
        #     Required. The hydrated deployment to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update. Update mask supports a special
        #     value `*` which fully replaces (equivalent to PUT) the resource provided.
        class UpdateHydratedDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for applying a hydrated deployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hydrated deployment to apply.
        class ApplyHydratedDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of the cluster management
        # @!attribute [rw] standard_management_config
        #   @return [::Google::Cloud::TelcoAutomation::V1::StandardManagementConfig]
        #     Configuration of the standard (GKE) cluster management
        #
        #     Note: The following fields are mutually exclusive: `standard_management_config`, `full_management_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] full_management_config
        #   @return [::Google::Cloud::TelcoAutomation::V1::FullManagementConfig]
        #     Configuration of the full (Autopilot) cluster management. Full cluster
        #     management is a preview feature.
        #
        #     Note: The following fields are mutually exclusive: `full_management_config`, `standard_management_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ManagementConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of the standard (GKE) cluster management.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. Name of the VPC Network to put the GKE cluster and nodes in. The
        #     VPC will be created if it doesn't exist.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Optional. Specifies the subnet that the interface will be part of. Network
        #     key must be specified and the subnet must be a subnetwork of the specified
        #     network.
        # @!attribute [rw] master_ipv4_cidr_block
        #   @return [::String]
        #     Optional. The /28 network that the masters will use. It should be free
        #     within the network.
        # @!attribute [rw] cluster_cidr_block
        #   @return [::String]
        #     Optional. The IP address range for the cluster pod IPs. Set to blank to
        #     have a range chosen with the default size. Set to /netmask (e.g. /14) to
        #     have a range chosen with a specific netmask. Set to a CIDR notation
        #     (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
        #     172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
        # @!attribute [rw] services_cidr_block
        #   @return [::String]
        #     Optional. The IP address range for the cluster service IPs. Set to blank to
        #     have a range chosen with the default size. Set to /netmask (e.g. /14) to
        #     have a range chosen with a specific netmask. Set to a CIDR notation (e.g.
        #     10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
        #     172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
        # @!attribute [rw] cluster_named_range
        #   @return [::String]
        #     Optional. The name of the existing secondary range in the cluster's
        #     subnetwork to use for pod IP addresses. Alternatively, cluster_cidr_block
        #     can be used to automatically create a GKE-managed one.
        # @!attribute [rw] services_named_range
        #   @return [::String]
        #     Optional. The name of the existing secondary range in the cluster's
        #     subnetwork to use for service ClusterIPs. Alternatively,
        #     services_cidr_block can be used to automatically create a GKE-managed one.
        # @!attribute [rw] master_authorized_networks_config
        #   @return [::Google::Cloud::TelcoAutomation::V1::MasterAuthorizedNetworksConfig]
        #     Optional. Master Authorized Network that supports multiple CIDR blocks.
        #     Allows access to the k8s master from multiple blocks. It cannot be set at
        #     the same time with the field man_block.
        class StandardManagementConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of the full (Autopilot) cluster management
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. Name of the VPC Network to put the GKE cluster and nodes in. The
        #     VPC will be created if it doesn't exist.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Optional. Specifies the subnet that the interface will be part of. Network
        #     key must be specified and the subnet must be a subnetwork of the specified
        #     network.
        # @!attribute [rw] master_ipv4_cidr_block
        #   @return [::String]
        #     Optional. The /28 network that the masters will use.
        # @!attribute [rw] cluster_cidr_block
        #   @return [::String]
        #     Optional. The IP address range for the cluster pod IPs. Set to blank to
        #     have a range chosen with the default size. Set to /netmask (e.g. /14) to
        #     have a range chosen with a specific netmask. Set to a CIDR notation
        #     (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
        #     172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
        # @!attribute [rw] services_cidr_block
        #   @return [::String]
        #     Optional. The IP address range for the cluster service IPs. Set to blank to
        #     have a range chosen with the default size. Set to /netmask (e.g. /14) to
        #     have a range chosen with a specific netmask. Set to a CIDR notation (e.g.
        #     10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
        #     172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
        # @!attribute [rw] cluster_named_range
        #   @return [::String]
        #     Optional. The name of the existing secondary range in the cluster's
        #     subnetwork to use for pod IP addresses. Alternatively, cluster_cidr_block
        #     can be used to automatically create a GKE-managed one.
        # @!attribute [rw] services_named_range
        #   @return [::String]
        #     Optional. The name of the existing secondary range in the cluster's
        #     subnetwork to use for service ClusterIPs. Alternatively,
        #     services_cidr_block can be used to automatically create a GKE-managed one.
        # @!attribute [rw] master_authorized_networks_config
        #   @return [::Google::Cloud::TelcoAutomation::V1::MasterAuthorizedNetworksConfig]
        #     Optional. Master Authorized Network that supports multiple CIDR blocks.
        #     Allows access to the k8s master from multiple blocks. It cannot be set at
        #     the same time with the field man_block.
        class FullManagementConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of the Master Authorized Network that support multiple CIDRs
        # @!attribute [rw] cidr_blocks
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::MasterAuthorizedNetworksConfig::CidrBlock>]
        #     Optional. cidr_blocks define up to 50 external networks that could access
        #     Kubernetes master through HTTPS.
        class MasterAuthorizedNetworksConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # CidrBlock contains an optional name and one CIDR block.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Optional. display_name is an optional field for users to identify CIDR
          #     blocks.
          # @!attribute [rw] cidr_block
          #   @return [::String]
          #     Optional. cidr_block must be specified in CIDR notation when using
          #     master_authorized_networks_config. Currently, the user could still use
          #     the deprecated man_block field, so this field is currently optional, but
          #     will be required in the future.
          class CidrBlock
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # File represents a yaml file present in a blueprint's package.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. Path of the file in package.
        #     e.g. `gdce/v1/cluster.yaml`
        # @!attribute [rw] content
        #   @return [::String]
        #     Optional. The contents of a file in string format.
        # @!attribute [rw] deleted
        #   @return [::Boolean]
        #     Optional. Signifies whether a file is marked for deletion.
        # @!attribute [rw] editable
        #   @return [::Boolean]
        #     Optional. Indicates whether changes are allowed to a file. If the field is
        #     not set, the file cannot be edited.
        class File
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Status of a deployment resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [rw] resource_namespace
        #   @return [::String]
        #     Namespace of the resource.
        # @!attribute [rw] group
        #   @return [::String]
        #     Group to which the resource belongs to.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the resource.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Kind of the resource.
        # @!attribute [r] resource_type
        #   @return [::Google::Cloud::TelcoAutomation::V1::ResourceType]
        #     Output only. Resource type.
        # @!attribute [r] status
        #   @return [::Google::Cloud::TelcoAutomation::V1::Status]
        #     Output only. Status of the resource.
        # @!attribute [r] nf_deploy_status
        #   @return [::Google::Cloud::TelcoAutomation::V1::NFDeployStatus]
        #     Output only. Detailed status of NFDeploy.
        class ResourceStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deployment status of NFDeploy.
        # @!attribute [r] targeted_nfs
        #   @return [::Integer]
        #     Output only. Total number of NFs targeted by this deployment
        # @!attribute [r] ready_nfs
        #   @return [::Integer]
        #     Output only. Total number of NFs targeted by this deployment with a Ready
        #     Condition set.
        # @!attribute [r] sites
        #   @return [::Array<::Google::Cloud::TelcoAutomation::V1::NFDeploySiteStatus>]
        #     Output only. Per-Site Status.
        class NFDeployStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Per-Site Status.
        # @!attribute [r] site
        #   @return [::String]
        #     Output only. Site id.
        # @!attribute [r] pending_deletion
        #   @return [::Boolean]
        #     Output only. If true, the Site Deletion is in progress.
        # @!attribute [r] hydration
        #   @return [::Google::Cloud::TelcoAutomation::V1::HydrationStatus]
        #     Output only. Hydration status.
        # @!attribute [r] workload
        #   @return [::Google::Cloud::TelcoAutomation::V1::WorkloadStatus]
        #     Output only. Workload status.
        class NFDeploySiteStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Hydration status.
        # @!attribute [r] site_version
        #   @return [::Google::Cloud::TelcoAutomation::V1::SiteVersion]
        #     Output only. SiteVersion Hydration is targeting.
        # @!attribute [r] status
        #   @return [::String]
        #     Output only. Status.
        class HydrationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SiteVersion Hydration is targeting.
        # @!attribute [r] nf_vendor
        #   @return [::String]
        #     Output only. NF vendor.
        # @!attribute [r] nf_type
        #   @return [::String]
        #     Output only. NF vendor type.
        # @!attribute [r] nf_version
        #   @return [::String]
        #     Output only. NF version.
        class SiteVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Workload status.
        # @!attribute [r] site_version
        #   @return [::Google::Cloud::TelcoAutomation::V1::SiteVersion]
        #     Output only. SiteVersion running in the workload cluster.
        # @!attribute [r] status
        #   @return [::String]
        #     Output only. Status.
        class WorkloadStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BlueprintView defines the type of view of the blueprint.
        module BlueprintView
          # Unspecified enum value.
          BLUEPRINT_VIEW_UNSPECIFIED = 0

          # View which only contains metadata.
          BLUEPRINT_VIEW_BASIC = 1

          # View which contains metadata and files it encapsulates.
          BLUEPRINT_VIEW_FULL = 2
        end

        # DeploymentView defines the type of view of the deployment.
        module DeploymentView
          # Unspecified enum value.
          DEPLOYMENT_VIEW_UNSPECIFIED = 0

          # View which only contains metadata.
          DEPLOYMENT_VIEW_BASIC = 1

          # View which contains metadata and files it encapsulates.
          DEPLOYMENT_VIEW_FULL = 2
        end

        # Represent type of CR.
        module ResourceType
          # Unspecified resource type.
          RESOURCE_TYPE_UNSPECIFIED = 0

          # User specified NF Deploy CR.
          NF_DEPLOY_RESOURCE = 1

          # CRs that are part of a blueprint.
          DEPLOYMENT_RESOURCE = 2
        end

        # Status of an entity (resource, deployment).
        module Status
          # Unknown state.
          STATUS_UNSPECIFIED = 0

          # Under progress.
          STATUS_IN_PROGRESS = 1

          # Running and ready to serve traffic.
          STATUS_ACTIVE = 2

          # Failed or stalled.
          STATUS_FAILED = 3

          # Delete in progress.
          STATUS_DELETING = 4

          # Deleted deployment.
          STATUS_DELETED = 5

          # NFDeploy specific status. Peering in progress.
          STATUS_PEERING = 10

          # K8s objects such as NetworkAttachmentDefinition don't have a defined
          # status.
          STATUS_NOT_APPLICABLE = 11
        end

        # DeploymentLevel of a blueprint signifies where the blueprint will be
        # applied.
        module DeploymentLevel
          # Default unspecified deployment level.
          DEPLOYMENT_LEVEL_UNSPECIFIED = 0

          # Blueprints at HYDRATION level cannot be used to create a Deployment
          # (A user cannot manually initate deployment of these blueprints on
          # orchestration or workload cluster).
          # These blueprints stay in a user's private catalog and are configured and
          # deployed by TNA automation.
          HYDRATION = 1

          # Blueprints at SINGLE_DEPLOYMENT level can be
          # a) Modified in private catalog.
          # b) Used to create a deployment on orchestration cluster by the user, once
          # approved.
          SINGLE_DEPLOYMENT = 2

          # Blueprints at MULTI_DEPLOYMENT level can be
          # a) Modified in private catalog.
          # b) Used to create a deployment on orchestration cluster which will create
          # further hydrated deployments.
          MULTI_DEPLOYMENT = 3

          # Blueprints at WORKLOAD_CLUSTER_DEPLOYMENT level can be
          # a) Modified in private catalog.
          # b) Used to create a deployment on workload cluster by the user, once
          # approved.
          WORKLOAD_CLUSTER_DEPLOYMENT = 4
        end
      end
    end
  end
end
