# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/telcoautomation/v1/telcoautomation_pb"
require "google/cloud/location"

module Google
  module Cloud
    module TelcoAutomation
      module V1
        module TelcoAutomation
          ##
          # Client for the TelcoAutomation service.
          #
          # TelcoAutomation Service manages the control plane cluster a.k.a.
          # Orchestration Cluster (GKE cluster with config controller) of TNA. It also
          # exposes blueprint APIs which manages the lifecycle of blueprints that control
          # the infrastructure setup (e.g GDCE clusters) and deployment of network
          # functions.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "telcoautomation.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :telco_automation_stub

            ##
            # Configure the TelcoAutomation Client class.
            #
            # See {::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all TelcoAutomation clients
            #   ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "TelcoAutomation", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the TelcoAutomation Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @telco_automation_stub.universe_domain
            end

            ##
            # Create a new TelcoAutomation client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the TelcoAutomation client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/telcoautomation/v1/telcoautomation_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @telco_automation_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @telco_automation_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @telco_automation_stub.endpoint
                config.universe_domain = @telco_automation_stub.universe_domain
                config.logger = @telco_automation_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @telco_automation_stub.logger
            end

            # Service calls

            ##
            # Lists OrchestrationClusters in a given project and location.
            #
            # @overload list_orchestration_clusters(request, options = nil)
            #   Pass arguments to `list_orchestration_clusters` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_orchestration_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_orchestration_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListOrchestrationClustersRequest
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested.
            #     If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Filtering results.
            #   @param order_by [::String]
            #     Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest.new
            #
            #   # Call the list_orchestration_clusters method.
            #   result = client.list_orchestration_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster.
            #     p item
            #   end
            #
            def list_orchestration_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListOrchestrationClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_orchestration_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_orchestration_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_orchestration_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_orchestration_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_orchestration_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single OrchestrationCluster.
            #
            # @overload get_orchestration_cluster(request, options = nil)
            #   Pass arguments to `get_orchestration_cluster` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_orchestration_cluster(name: nil)
            #   Pass arguments to `get_orchestration_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest.new
            #
            #   # Call the get_orchestration_cluster method.
            #   result = client.get_orchestration_cluster request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::OrchestrationCluster.
            #   p result
            #
            def get_orchestration_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetOrchestrationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_orchestration_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_orchestration_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_orchestration_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_orchestration_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new OrchestrationCluster in a given project and location.
            #
            # @overload create_orchestration_cluster(request, options = nil)
            #   Pass arguments to `create_orchestration_cluster` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_orchestration_cluster(parent: nil, orchestration_cluster_id: nil, orchestration_cluster: nil, request_id: nil)
            #   Pass arguments to `create_orchestration_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param orchestration_cluster_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     orchestration_cluster_id from the method_signature of Create RPC
            #   @param orchestration_cluster [::Google::Cloud::TelcoAutomation::V1::OrchestrationCluster, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest.new
            #
            #   # Call the create_orchestration_cluster method.
            #   result = client.create_orchestration_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_orchestration_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::CreateOrchestrationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_orchestration_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_orchestration_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_orchestration_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :create_orchestration_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single OrchestrationCluster.
            #
            # @overload delete_orchestration_cluster(request, options = nil)
            #   Pass arguments to `delete_orchestration_cluster` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_orchestration_cluster(name: nil, request_id: nil)
            #   Pass arguments to `delete_orchestration_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest.new
            #
            #   # Call the delete_orchestration_cluster method.
            #   result = client.delete_orchestration_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_orchestration_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::DeleteOrchestrationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_orchestration_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_orchestration_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_orchestration_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :delete_orchestration_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists EdgeSlms in a given project and location.
            #
            # @overload list_edge_slms(request, options = nil)
            #   Pass arguments to `list_edge_slms` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_edge_slms(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_edge_slms` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListEdgeSlmsRequest
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested.
            #     If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Filtering results
            #   @param order_by [::String]
            #     Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::EdgeSlm>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::EdgeSlm>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest.new
            #
            #   # Call the list_edge_slms method.
            #   result = client.list_edge_slms request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::EdgeSlm.
            #     p item
            #   end
            #
            def list_edge_slms request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListEdgeSlmsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_edge_slms.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_edge_slms.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_edge_slms.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_edge_slms, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_edge_slms, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single EdgeSlm.
            #
            # @overload get_edge_slm(request, options = nil)
            #   Pass arguments to `get_edge_slm` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_edge_slm(name: nil)
            #   Pass arguments to `get_edge_slm` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::EdgeSlm]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::EdgeSlm]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest.new
            #
            #   # Call the get_edge_slm method.
            #   result = client.get_edge_slm request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::EdgeSlm.
            #   p result
            #
            def get_edge_slm request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetEdgeSlmRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_edge_slm.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_edge_slm.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_edge_slm.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_edge_slm, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new EdgeSlm in a given project and location.
            #
            # @overload create_edge_slm(request, options = nil)
            #   Pass arguments to `create_edge_slm` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_edge_slm(parent: nil, edge_slm_id: nil, edge_slm: nil, request_id: nil)
            #   Pass arguments to `create_edge_slm` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param edge_slm_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     edge_slm_id from the method_signature of Create RPC
            #   @param edge_slm [::Google::Cloud::TelcoAutomation::V1::EdgeSlm, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest.new
            #
            #   # Call the create_edge_slm method.
            #   result = client.create_edge_slm request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_edge_slm request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::CreateEdgeSlmRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_edge_slm.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_edge_slm.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_edge_slm.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :create_edge_slm, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single EdgeSlm.
            #
            # @overload delete_edge_slm(request, options = nil)
            #   Pass arguments to `delete_edge_slm` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_edge_slm(name: nil, request_id: nil)
            #   Pass arguments to `delete_edge_slm` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest.new
            #
            #   # Call the delete_edge_slm method.
            #   result = client.delete_edge_slm request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_edge_slm request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::DeleteEdgeSlmRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_edge_slm.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_edge_slm.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_edge_slm.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :delete_edge_slm, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a blueprint.
            #
            # @overload create_blueprint(request, options = nil)
            #   Pass arguments to `create_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_blueprint(parent: nil, blueprint_id: nil, blueprint: nil)
            #   Pass arguments to `create_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param blueprint_id [::String]
            #     Optional. The name of the blueprint.
            #   @param blueprint [::Google::Cloud::TelcoAutomation::V1::Blueprint, ::Hash]
            #     Required. The `Blueprint` to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest.new
            #
            #   # Call the create_blueprint method.
            #   result = client.create_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def create_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::CreateBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :create_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a blueprint.
            #
            # @overload update_blueprint(request, options = nil)
            #   Pass arguments to `update_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_blueprint(blueprint: nil, update_mask: nil)
            #   Pass arguments to `update_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param blueprint [::Google::Cloud::TelcoAutomation::V1::Blueprint, ::Hash]
            #     Required. The `blueprint` to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Update mask is used to specify the fields to be overwritten in
            #     the `blueprint` resource by the update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest.new
            #
            #   # Call the update_blueprint method.
            #   result = client.update_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def update_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::UpdateBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.blueprint&.name
                header_params["blueprint.name"] = request.blueprint.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :update_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested blueprint.
            #
            # @overload get_blueprint(request, options = nil)
            #   Pass arguments to `get_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_blueprint(name: nil, view: nil)
            #   Pass arguments to `get_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint.
            #     Case 1: If the name provided in the request is
            #     \\{blueprint_id}@\\{revision_id}, then the revision with revision_id will be
            #     returned. Case 2: If the name provided in the request is \\{blueprint}, then
            #     the current state of the blueprint is returned.
            #   @param view [::Google::Cloud::TelcoAutomation::V1::BlueprintView]
            #     Optional. Defines the type of view of the blueprint.
            #     When field is not present BLUEPRINT_VIEW_BASIC is considered as default.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest.new
            #
            #   # Call the get_blueprint method.
            #   result = client.get_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def get_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a blueprint and all its revisions.
            #
            # @overload delete_blueprint(request, options = nil)
            #   Pass arguments to `delete_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_blueprint(name: nil)
            #   Pass arguments to `delete_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of blueprint to delete.
            #     Blueprint name should be in the format \\{blueprint_id}, if
            #     \\{blueprint_id}@\\{revision_id} is passed then the API throws invalid
            #     argument.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest.new
            #
            #   # Call the delete_blueprint method.
            #   result = client.delete_blueprint request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::DeleteBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :delete_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List all blueprints.
            #
            # @overload list_blueprints(request, options = nil)
            #   Pass arguments to `list_blueprints` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_blueprints(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_blueprints` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent orchestration cluster resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param filter [::String]
            #     Optional. Filtering only supports equality on blueprint state.
            #     It should be in the form: "state = DRAFT". `OR` operator can be used to
            #     get response for multiple states. e.g. "state = DRAFT OR state = PROPOSED".
            #   @param page_size [::Integer]
            #     Optional. The maximum number of blueprints to return per page.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous ListBlueprints call.
            #     It can be provided to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest.new
            #
            #   # Call the list_blueprints method.
            #   result = client.list_blueprints request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Blueprint.
            #     p item
            #   end
            #
            def list_blueprints request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListBlueprintsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_blueprints.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_blueprints.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_blueprints.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_blueprints, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_blueprints, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Approves a blueprint and commits a new revision.
            #
            # @overload approve_blueprint(request, options = nil)
            #   Pass arguments to `approve_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload approve_blueprint(name: nil)
            #   Pass arguments to `approve_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint to approve. The blueprint must be in
            #     Proposed state. A new revision is committed on approval.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest.new
            #
            #   # Call the approve_blueprint method.
            #   result = client.approve_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def approve_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ApproveBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.approve_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.approve_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.approve_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :approve_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Proposes a blueprint for approval of changes.
            #
            # @overload propose_blueprint(request, options = nil)
            #   Pass arguments to `propose_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload propose_blueprint(name: nil)
            #   Pass arguments to `propose_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint being proposed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest.new
            #
            #   # Call the propose_blueprint method.
            #   result = client.propose_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def propose_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ProposeBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.propose_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.propose_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.propose_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :propose_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rejects a blueprint revision proposal and flips it back to Draft state.
            #
            # @overload reject_blueprint(request, options = nil)
            #   Pass arguments to `reject_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reject_blueprint(name: nil)
            #   Pass arguments to `reject_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint being rejected.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Blueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest.new
            #
            #   # Call the reject_blueprint method.
            #   result = client.reject_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Blueprint.
            #   p result
            #
            def reject_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::RejectBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reject_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reject_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reject_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :reject_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List blueprint revisions of a given blueprint.
            #
            # @overload list_blueprint_revisions(request, options = nil)
            #   Pass arguments to `list_blueprint_revisions` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_blueprint_revisions(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_blueprint_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint to list revisions for.
            #   @param page_size [::Integer]
            #     The maximum number of revisions to return per page.
            #   @param page_token [::String]
            #     The page token, received from a previous ListBlueprintRevisions call
            #     It can be provided to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest.new
            #
            #   # Call the list_blueprint_revisions method.
            #   result = client.list_blueprint_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Blueprint.
            #     p item
            #   end
            #
            def list_blueprint_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListBlueprintRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_blueprint_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_blueprint_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_blueprint_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_blueprint_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_blueprint_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches across blueprint revisions.
            #
            # @overload search_blueprint_revisions(request, options = nil)
            #   Pass arguments to `search_blueprint_revisions` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_blueprint_revisions(parent: nil, query: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_blueprint_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent orchestration cluster resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param query [::String]
            #     Required. Supported queries:
            #     1. ""                       : Lists all revisions across all blueprints.
            #     2. "latest=true"            : Lists latest revisions across all blueprints.
            #     3. "name=\\{name}"            : Lists all revisions of blueprint with name
            #     \\{name}.
            #     4. "name=\\{name} latest=true": Lists latest revision of blueprint with name
            #     \\{name}
            #   @param page_size [::Integer]
            #     Optional. The maximum number of blueprints revisions to return per page.
            #     max page size = 100, default page size = 20.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous search call.
            #     It can be provided to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Blueprint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest.new
            #
            #   # Call the search_blueprint_revisions method.
            #   result = client.search_blueprint_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Blueprint.
            #     p item
            #   end
            #
            def search_blueprint_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::SearchBlueprintRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_blueprint_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_blueprint_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_blueprint_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :search_blueprint_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :search_blueprint_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches across deployment revisions.
            #
            # @overload search_deployment_revisions(request, options = nil)
            #   Pass arguments to `search_deployment_revisions` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_deployment_revisions(parent: nil, query: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_deployment_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent orchestration cluster resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param query [::String]
            #     Required. Supported queries:
            #     1. ""                       : Lists all revisions across all deployments.
            #     2. "latest=true"            : Lists latest revisions across all
            #     deployments.
            #     3. "name=\\{name}"            : Lists all revisions of deployment with name
            #     \\{name}.
            #     4. "name=\\{name} latest=true": Lists latest revision of deployment with name
            #     \\{name}
            #   @param page_size [::Integer]
            #     Optional. The maximum number of deployment revisions to return per page.
            #     max page size = 100, default page size = 20.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous search call.
            #     It can be provided to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest.new
            #
            #   # Call the search_deployment_revisions method.
            #   result = client.search_deployment_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Deployment.
            #     p item
            #   end
            #
            def search_deployment_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::SearchDeploymentRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_deployment_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_deployment_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_deployment_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :search_deployment_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :search_deployment_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Discards the changes in a blueprint and reverts the blueprint to the last
            # approved blueprint revision. No changes take place if a blueprint does not
            # have revisions.
            #
            # @overload discard_blueprint_changes(request, options = nil)
            #   Pass arguments to `discard_blueprint_changes` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload discard_blueprint_changes(name: nil)
            #   Pass arguments to `discard_blueprint_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the blueprint of which changes are being discarded.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest.new
            #
            #   # Call the discard_blueprint_changes method.
            #   result = client.discard_blueprint_changes request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesResponse.
            #   p result
            #
            def discard_blueprint_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::DiscardBlueprintChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.discard_blueprint_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.discard_blueprint_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.discard_blueprint_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :discard_blueprint_changes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the blueprints in TNA's public catalog. Default page size = 20,
            # Max Page Size = 100.
            #
            # @overload list_public_blueprints(request, options = nil)
            #   Pass arguments to `list_public_blueprints` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_public_blueprints(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_public_blueprints` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value of public blueprint.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}".
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::PublicBlueprint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::PublicBlueprint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest.new
            #
            #   # Call the list_public_blueprints method.
            #   result = client.list_public_blueprints request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::PublicBlueprint.
            #     p item
            #   end
            #
            def list_public_blueprints request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListPublicBlueprintsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_public_blueprints.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_public_blueprints.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_public_blueprints.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_public_blueprints, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_public_blueprints, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested public blueprint.
            #
            # @overload get_public_blueprint(request, options = nil)
            #   Pass arguments to `get_public_blueprint` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_public_blueprint(name: nil)
            #   Pass arguments to `get_public_blueprint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the public blueprint.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::PublicBlueprint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::PublicBlueprint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest.new
            #
            #   # Call the get_public_blueprint method.
            #   result = client.get_public_blueprint request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::PublicBlueprint.
            #   p result
            #
            def get_public_blueprint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetPublicBlueprintRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_public_blueprint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_public_blueprint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_public_blueprint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_public_blueprint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a deployment.
            #
            # @overload create_deployment(request, options = nil)
            #   Pass arguments to `create_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_deployment(parent: nil, deployment_id: nil, deployment: nil)
            #   Pass arguments to `create_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param deployment_id [::String]
            #     Optional. The name of the deployment.
            #   @param deployment [::Google::Cloud::TelcoAutomation::V1::Deployment, ::Hash]
            #     Required. The `Deployment` to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest.new
            #
            #   # Call the create_deployment method.
            #   result = client.create_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Deployment.
            #   p result
            #
            def create_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::CreateDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :create_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a deployment.
            #
            # @overload update_deployment(request, options = nil)
            #   Pass arguments to `update_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_deployment(deployment: nil, update_mask: nil)
            #   Pass arguments to `update_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param deployment [::Google::Cloud::TelcoAutomation::V1::Deployment, ::Hash]
            #     Required. The `deployment` to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Update mask is used to specify the fields to be overwritten in
            #     the `deployment` resource by the update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest.new
            #
            #   # Call the update_deployment method.
            #   result = client.update_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Deployment.
            #   p result
            #
            def update_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::UpdateDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.deployment&.name
                header_params["deployment.name"] = request.deployment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :update_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested deployment.
            #
            # @overload get_deployment(request, options = nil)
            #   Pass arguments to `get_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_deployment(name: nil, view: nil)
            #   Pass arguments to `get_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment.
            #     Case 1: If the name provided in the request is
            #     \\{deployment_id}@\\{revision_id}, then the revision with revision_id will be
            #     returned.
            #     Case 2: If the name provided in the request is \\{deployment}, then
            #     the current state of the deployment is returned.
            #   @param view [::Google::Cloud::TelcoAutomation::V1::DeploymentView]
            #     Optional. Defines the type of view of the deployment.
            #     When field is not present VIEW_BASIC is considered as default.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest.new
            #
            #   # Call the get_deployment method.
            #   result = client.get_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Deployment.
            #   p result
            #
            def get_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes the deployment by marking it as DELETING. Post which deployment and
            # it's revisions gets deleted.
            #
            # @overload remove_deployment(request, options = nil)
            #   Pass arguments to `remove_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_deployment(name: nil)
            #   Pass arguments to `remove_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of deployment to initiate delete.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest.new
            #
            #   # Call the remove_deployment method.
            #   result = client.remove_deployment request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def remove_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::RemoveDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :remove_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List all deployments.
            #
            # @overload list_deployments(request, options = nil)
            #   Pass arguments to `list_deployments` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_deployments(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_deployments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of parent orchestration cluster resource.
            #     Format should be -
            #     "projects/\\{project_id}/locations/\\{location_name}/orchestrationClusters/\\{orchestration_cluster}".
            #   @param filter [::String]
            #     Optional. Filtering only supports equality on deployment state.
            #     It should be in the form: "state = DRAFT". `OR` operator can be used to
            #     get response for multiple states. e.g. "state = DRAFT OR state = APPLIED".
            #   @param page_size [::Integer]
            #     Optional. The maximum number of deployments to return per page.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous ListDeployments call.
            #     It can be provided to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest.new
            #
            #   # Call the list_deployments method.
            #   result = client.list_deployments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Deployment.
            #     p item
            #   end
            #
            def list_deployments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListDeploymentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_deployments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_deployments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_deployments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_deployments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_deployments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List deployment revisions of a given deployment.
            #
            # @overload list_deployment_revisions(request, options = nil)
            #   Pass arguments to `list_deployment_revisions` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_deployment_revisions(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_deployment_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment to list revisions for.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of revisions to return per page.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous ListDeploymentRevisions
            #     call Provide this to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::Deployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest.new
            #
            #   # Call the list_deployment_revisions method.
            #   result = client.list_deployment_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::Deployment.
            #     p item
            #   end
            #
            def list_deployment_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListDeploymentRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_deployment_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_deployment_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_deployment_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_deployment_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_deployment_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Discards the changes in a deployment and reverts the deployment to the last
            # approved deployment revision. No changes take place if a deployment does
            # not have revisions.
            #
            # @overload discard_deployment_changes(request, options = nil)
            #   Pass arguments to `discard_deployment_changes` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload discard_deployment_changes(name: nil)
            #   Pass arguments to `discard_deployment_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment of which changes are being discarded.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest.new
            #
            #   # Call the discard_deployment_changes method.
            #   result = client.discard_deployment_changes request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesResponse.
            #   p result
            #
            def discard_deployment_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::DiscardDeploymentChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.discard_deployment_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.discard_deployment_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.discard_deployment_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :discard_deployment_changes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies the deployment's YAML files to the parent orchestration cluster.
            #
            # @overload apply_deployment(request, options = nil)
            #   Pass arguments to `apply_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload apply_deployment(name: nil)
            #   Pass arguments to `apply_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment to apply to orchestration cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest.new
            #
            #   # Call the apply_deployment method.
            #   result = client.apply_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Deployment.
            #   p result
            #
            def apply_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ApplyDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.apply_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.apply_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.apply_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :apply_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested deployment status.
            #
            # @overload compute_deployment_status(request, options = nil)
            #   Pass arguments to `compute_deployment_status` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload compute_deployment_status(name: nil)
            #   Pass arguments to `compute_deployment_status` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment without revisionID.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest.new
            #
            #   # Call the compute_deployment_status method.
            #   result = client.compute_deployment_status request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusResponse.
            #   p result
            #
            def compute_deployment_status request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ComputeDeploymentStatusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.compute_deployment_status.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.compute_deployment_status.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.compute_deployment_status.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :compute_deployment_status, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rollback the active deployment to the given past approved deployment
            # revision.
            #
            # @overload rollback_deployment(request, options = nil)
            #   Pass arguments to `rollback_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback_deployment(name: nil, revision_id: nil)
            #   Pass arguments to `rollback_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the deployment.
            #   @param revision_id [::String]
            #     Required. The revision id of deployment to roll back to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest.new
            #
            #   # Call the rollback_deployment method.
            #   result = client.rollback_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::Deployment.
            #   p result
            #
            def rollback_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::RollbackDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :rollback_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested hydrated deployment.
            #
            # @overload get_hydrated_deployment(request, options = nil)
            #   Pass arguments to `get_hydrated_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_hydrated_deployment(name: nil)
            #   Pass arguments to `get_hydrated_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the hydrated deployment.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest.new
            #
            #   # Call the get_hydrated_deployment method.
            #   result = client.get_hydrated_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::HydratedDeployment.
            #   p result
            #
            def get_hydrated_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::GetHydratedDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_hydrated_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_hydrated_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_hydrated_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :get_hydrated_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List all hydrated deployments present under a deployment.
            #
            # @overload list_hydrated_deployments(request, options = nil)
            #   Pass arguments to `list_hydrated_deployments` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_hydrated_deployments(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_hydrated_deployments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The deployment managing the hydrated deployments.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of hydrated deployments to return. The service
            #     may return fewer than this value. If unspecified, at most 50 hydrated
            #     deployments will be returned. The maximum value is 1000. Values above 1000
            #     will be set to 1000.
            #   @param page_token [::String]
            #     Optional. The page token, received from a previous ListHydratedDeployments
            #     call. Provide this to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::HydratedDeployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::TelcoAutomation::V1::HydratedDeployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest.new
            #
            #   # Call the list_hydrated_deployments method.
            #   result = client.list_hydrated_deployments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::TelcoAutomation::V1::HydratedDeployment.
            #     p item
            #   end
            #
            def list_hydrated_deployments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ListHydratedDeploymentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_hydrated_deployments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_hydrated_deployments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_hydrated_deployments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :list_hydrated_deployments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @telco_automation_stub, :list_hydrated_deployments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a hydrated deployment.
            #
            # @overload update_hydrated_deployment(request, options = nil)
            #   Pass arguments to `update_hydrated_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_hydrated_deployment(hydrated_deployment: nil, update_mask: nil)
            #   Pass arguments to `update_hydrated_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param hydrated_deployment [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment, ::Hash]
            #     Required. The hydrated deployment to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The list of fields to update. Update mask supports a special
            #     value `*` which fully replaces (equivalent to PUT) the resource provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest.new
            #
            #   # Call the update_hydrated_deployment method.
            #   result = client.update_hydrated_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::HydratedDeployment.
            #   p result
            #
            def update_hydrated_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::UpdateHydratedDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_hydrated_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.hydrated_deployment&.name
                header_params["hydrated_deployment.name"] = request.hydrated_deployment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_hydrated_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_hydrated_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :update_hydrated_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies a hydrated deployment to a workload cluster.
            #
            # @overload apply_hydrated_deployment(request, options = nil)
            #   Pass arguments to `apply_hydrated_deployment` via a request object, either of type
            #   {::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload apply_hydrated_deployment(name: nil)
            #   Pass arguments to `apply_hydrated_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the hydrated deployment to apply.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::TelcoAutomation::V1::HydratedDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/telco_automation/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest.new
            #
            #   # Call the apply_hydrated_deployment method.
            #   result = client.apply_hydrated_deployment request
            #
            #   # The returned object is of type Google::Cloud::TelcoAutomation::V1::HydratedDeployment.
            #   p result
            #
            def apply_hydrated_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::TelcoAutomation::V1::ApplyHydratedDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.apply_hydrated_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::TelcoAutomation::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.apply_hydrated_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.apply_hydrated_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @telco_automation_stub.call_rpc :apply_hydrated_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the TelcoAutomation API.
            #
            # This class represents the configuration for TelcoAutomation,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_orchestration_clusters to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_orchestration_clusters.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_orchestration_clusters.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::TelcoAutomation::V1::TelcoAutomation::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "telcoautomation.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the TelcoAutomation API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_orchestration_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_orchestration_clusters
                ##
                # RPC-specific configuration for `get_orchestration_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_orchestration_cluster
                ##
                # RPC-specific configuration for `create_orchestration_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_orchestration_cluster
                ##
                # RPC-specific configuration for `delete_orchestration_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_orchestration_cluster
                ##
                # RPC-specific configuration for `list_edge_slms`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_edge_slms
                ##
                # RPC-specific configuration for `get_edge_slm`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_edge_slm
                ##
                # RPC-specific configuration for `create_edge_slm`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_edge_slm
                ##
                # RPC-specific configuration for `delete_edge_slm`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_edge_slm
                ##
                # RPC-specific configuration for `create_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_blueprint
                ##
                # RPC-specific configuration for `update_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_blueprint
                ##
                # RPC-specific configuration for `get_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_blueprint
                ##
                # RPC-specific configuration for `delete_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_blueprint
                ##
                # RPC-specific configuration for `list_blueprints`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_blueprints
                ##
                # RPC-specific configuration for `approve_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :approve_blueprint
                ##
                # RPC-specific configuration for `propose_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :propose_blueprint
                ##
                # RPC-specific configuration for `reject_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reject_blueprint
                ##
                # RPC-specific configuration for `list_blueprint_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_blueprint_revisions
                ##
                # RPC-specific configuration for `search_blueprint_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_blueprint_revisions
                ##
                # RPC-specific configuration for `search_deployment_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_deployment_revisions
                ##
                # RPC-specific configuration for `discard_blueprint_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :discard_blueprint_changes
                ##
                # RPC-specific configuration for `list_public_blueprints`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_public_blueprints
                ##
                # RPC-specific configuration for `get_public_blueprint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_public_blueprint
                ##
                # RPC-specific configuration for `create_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_deployment
                ##
                # RPC-specific configuration for `update_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_deployment
                ##
                # RPC-specific configuration for `get_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_deployment
                ##
                # RPC-specific configuration for `remove_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_deployment
                ##
                # RPC-specific configuration for `list_deployments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_deployments
                ##
                # RPC-specific configuration for `list_deployment_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_deployment_revisions
                ##
                # RPC-specific configuration for `discard_deployment_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :discard_deployment_changes
                ##
                # RPC-specific configuration for `apply_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :apply_deployment
                ##
                # RPC-specific configuration for `compute_deployment_status`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :compute_deployment_status
                ##
                # RPC-specific configuration for `rollback_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback_deployment
                ##
                # RPC-specific configuration for `get_hydrated_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_hydrated_deployment
                ##
                # RPC-specific configuration for `list_hydrated_deployments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_hydrated_deployments
                ##
                # RPC-specific configuration for `update_hydrated_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_hydrated_deployment
                ##
                # RPC-specific configuration for `apply_hydrated_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :apply_hydrated_deployment

                # @private
                def initialize parent_rpcs = nil
                  list_orchestration_clusters_config = parent_rpcs.list_orchestration_clusters if parent_rpcs.respond_to? :list_orchestration_clusters
                  @list_orchestration_clusters = ::Gapic::Config::Method.new list_orchestration_clusters_config
                  get_orchestration_cluster_config = parent_rpcs.get_orchestration_cluster if parent_rpcs.respond_to? :get_orchestration_cluster
                  @get_orchestration_cluster = ::Gapic::Config::Method.new get_orchestration_cluster_config
                  create_orchestration_cluster_config = parent_rpcs.create_orchestration_cluster if parent_rpcs.respond_to? :create_orchestration_cluster
                  @create_orchestration_cluster = ::Gapic::Config::Method.new create_orchestration_cluster_config
                  delete_orchestration_cluster_config = parent_rpcs.delete_orchestration_cluster if parent_rpcs.respond_to? :delete_orchestration_cluster
                  @delete_orchestration_cluster = ::Gapic::Config::Method.new delete_orchestration_cluster_config
                  list_edge_slms_config = parent_rpcs.list_edge_slms if parent_rpcs.respond_to? :list_edge_slms
                  @list_edge_slms = ::Gapic::Config::Method.new list_edge_slms_config
                  get_edge_slm_config = parent_rpcs.get_edge_slm if parent_rpcs.respond_to? :get_edge_slm
                  @get_edge_slm = ::Gapic::Config::Method.new get_edge_slm_config
                  create_edge_slm_config = parent_rpcs.create_edge_slm if parent_rpcs.respond_to? :create_edge_slm
                  @create_edge_slm = ::Gapic::Config::Method.new create_edge_slm_config
                  delete_edge_slm_config = parent_rpcs.delete_edge_slm if parent_rpcs.respond_to? :delete_edge_slm
                  @delete_edge_slm = ::Gapic::Config::Method.new delete_edge_slm_config
                  create_blueprint_config = parent_rpcs.create_blueprint if parent_rpcs.respond_to? :create_blueprint
                  @create_blueprint = ::Gapic::Config::Method.new create_blueprint_config
                  update_blueprint_config = parent_rpcs.update_blueprint if parent_rpcs.respond_to? :update_blueprint
                  @update_blueprint = ::Gapic::Config::Method.new update_blueprint_config
                  get_blueprint_config = parent_rpcs.get_blueprint if parent_rpcs.respond_to? :get_blueprint
                  @get_blueprint = ::Gapic::Config::Method.new get_blueprint_config
                  delete_blueprint_config = parent_rpcs.delete_blueprint if parent_rpcs.respond_to? :delete_blueprint
                  @delete_blueprint = ::Gapic::Config::Method.new delete_blueprint_config
                  list_blueprints_config = parent_rpcs.list_blueprints if parent_rpcs.respond_to? :list_blueprints
                  @list_blueprints = ::Gapic::Config::Method.new list_blueprints_config
                  approve_blueprint_config = parent_rpcs.approve_blueprint if parent_rpcs.respond_to? :approve_blueprint
                  @approve_blueprint = ::Gapic::Config::Method.new approve_blueprint_config
                  propose_blueprint_config = parent_rpcs.propose_blueprint if parent_rpcs.respond_to? :propose_blueprint
                  @propose_blueprint = ::Gapic::Config::Method.new propose_blueprint_config
                  reject_blueprint_config = parent_rpcs.reject_blueprint if parent_rpcs.respond_to? :reject_blueprint
                  @reject_blueprint = ::Gapic::Config::Method.new reject_blueprint_config
                  list_blueprint_revisions_config = parent_rpcs.list_blueprint_revisions if parent_rpcs.respond_to? :list_blueprint_revisions
                  @list_blueprint_revisions = ::Gapic::Config::Method.new list_blueprint_revisions_config
                  search_blueprint_revisions_config = parent_rpcs.search_blueprint_revisions if parent_rpcs.respond_to? :search_blueprint_revisions
                  @search_blueprint_revisions = ::Gapic::Config::Method.new search_blueprint_revisions_config
                  search_deployment_revisions_config = parent_rpcs.search_deployment_revisions if parent_rpcs.respond_to? :search_deployment_revisions
                  @search_deployment_revisions = ::Gapic::Config::Method.new search_deployment_revisions_config
                  discard_blueprint_changes_config = parent_rpcs.discard_blueprint_changes if parent_rpcs.respond_to? :discard_blueprint_changes
                  @discard_blueprint_changes = ::Gapic::Config::Method.new discard_blueprint_changes_config
                  list_public_blueprints_config = parent_rpcs.list_public_blueprints if parent_rpcs.respond_to? :list_public_blueprints
                  @list_public_blueprints = ::Gapic::Config::Method.new list_public_blueprints_config
                  get_public_blueprint_config = parent_rpcs.get_public_blueprint if parent_rpcs.respond_to? :get_public_blueprint
                  @get_public_blueprint = ::Gapic::Config::Method.new get_public_blueprint_config
                  create_deployment_config = parent_rpcs.create_deployment if parent_rpcs.respond_to? :create_deployment
                  @create_deployment = ::Gapic::Config::Method.new create_deployment_config
                  update_deployment_config = parent_rpcs.update_deployment if parent_rpcs.respond_to? :update_deployment
                  @update_deployment = ::Gapic::Config::Method.new update_deployment_config
                  get_deployment_config = parent_rpcs.get_deployment if parent_rpcs.respond_to? :get_deployment
                  @get_deployment = ::Gapic::Config::Method.new get_deployment_config
                  remove_deployment_config = parent_rpcs.remove_deployment if parent_rpcs.respond_to? :remove_deployment
                  @remove_deployment = ::Gapic::Config::Method.new remove_deployment_config
                  list_deployments_config = parent_rpcs.list_deployments if parent_rpcs.respond_to? :list_deployments
                  @list_deployments = ::Gapic::Config::Method.new list_deployments_config
                  list_deployment_revisions_config = parent_rpcs.list_deployment_revisions if parent_rpcs.respond_to? :list_deployment_revisions
                  @list_deployment_revisions = ::Gapic::Config::Method.new list_deployment_revisions_config
                  discard_deployment_changes_config = parent_rpcs.discard_deployment_changes if parent_rpcs.respond_to? :discard_deployment_changes
                  @discard_deployment_changes = ::Gapic::Config::Method.new discard_deployment_changes_config
                  apply_deployment_config = parent_rpcs.apply_deployment if parent_rpcs.respond_to? :apply_deployment
                  @apply_deployment = ::Gapic::Config::Method.new apply_deployment_config
                  compute_deployment_status_config = parent_rpcs.compute_deployment_status if parent_rpcs.respond_to? :compute_deployment_status
                  @compute_deployment_status = ::Gapic::Config::Method.new compute_deployment_status_config
                  rollback_deployment_config = parent_rpcs.rollback_deployment if parent_rpcs.respond_to? :rollback_deployment
                  @rollback_deployment = ::Gapic::Config::Method.new rollback_deployment_config
                  get_hydrated_deployment_config = parent_rpcs.get_hydrated_deployment if parent_rpcs.respond_to? :get_hydrated_deployment
                  @get_hydrated_deployment = ::Gapic::Config::Method.new get_hydrated_deployment_config
                  list_hydrated_deployments_config = parent_rpcs.list_hydrated_deployments if parent_rpcs.respond_to? :list_hydrated_deployments
                  @list_hydrated_deployments = ::Gapic::Config::Method.new list_hydrated_deployments_config
                  update_hydrated_deployment_config = parent_rpcs.update_hydrated_deployment if parent_rpcs.respond_to? :update_hydrated_deployment
                  @update_hydrated_deployment = ::Gapic::Config::Method.new update_hydrated_deployment_config
                  apply_hydrated_deployment_config = parent_rpcs.apply_hydrated_deployment if parent_rpcs.respond_to? :apply_hydrated_deployment
                  @apply_hydrated_deployment = ::Gapic::Config::Method.new apply_hydrated_deployment_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
