# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Tasks
      module V2beta3
        # Pull Message.
        #
        # This proto can only be used for tasks in a queue which has
        # {::Google::Cloud::Tasks::V2beta3::Queue#type PULL} type. It currently exists for
        # backwards compatibility with the App Engine Task Queue SDK. This message type
        # maybe returned with methods
        # [list][google.cloud.tasks.v2beta3.CloudTask.ListTasks] and
        # [get][google.cloud.tasks.v2beta3.CloudTask.ListTasks], when the response view
        # is [FULL][google.cloud.tasks.v2beta3.Task.View.Full].
        # @!attribute [rw] payload
        #   @return [::String]
        #     A data payload consumed by the worker to execute the task.
        # @!attribute [rw] tag
        #   @return [::String]
        #     The tasks's tag.
        #
        #     The tag is less than 500 characters.
        #
        #     SDK compatibility: Although the SDK allows tags to be either
        #     string or
        #     [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
        #     only UTF-8 encoded tags can be used in Cloud Tasks. If a tag isn't UTF-8
        #     encoded, the tag will be empty when the task is returned by Cloud Tasks.
        class PullMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PathOverride.
        #
        # Path message defines path override for HTTP targets.
        # @!attribute [rw] path
        #   @return [::String]
        #     The URI path (e.g., /users/1234). Default is an empty string.
        class PathOverride
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QueryOverride.
        #
        # Query message defines query override for HTTP targets.
        # @!attribute [rw] query_params
        #   @return [::String]
        #     The query parameters (e.g., qparam1=123&qparam2=456). Default is an empty
        #     string.
        class QueryOverride
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # URI Override.
        #
        # When specified, all the HTTP tasks inside the queue will be partially or
        # fully overridden depending on the configured values.
        # @!attribute [rw] scheme
        #   @return [::Google::Cloud::Tasks::V2beta3::UriOverride::Scheme]
        #     Scheme override.
        #
        #     When specified, the task URI scheme is replaced by the provided value (HTTP
        #     or HTTPS).
        # @!attribute [rw] host
        #   @return [::String]
        #     Host override.
        #
        #     When specified, replaces the host part of the task URL. For example,
        #     if the task URL is "https://www.google.com," and host value is set to
        #     "example.net", the overridden URI will be changed to "https://example.net."
        #     Host value cannot be an empty string (INVALID_ARGUMENT).
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port override.
        #
        #     When specified, replaces the port part of the task URI. For instance,
        #     for a URI http://www.google.com/foo and port=123, the overridden URI
        #     becomes http://www.google.com:123/foo. Note that the port value must be a
        #     positive integer. Setting the port to 0 (Zero) clears the URI port.
        # @!attribute [rw] path_override
        #   @return [::Google::Cloud::Tasks::V2beta3::PathOverride]
        #     URI path.
        #
        #     When specified, replaces the existing path of the task URL. Setting the
        #     path value to an empty string clears the URI path segment.
        # @!attribute [rw] query_override
        #   @return [::Google::Cloud::Tasks::V2beta3::QueryOverride]
        #     URI Query.
        #
        #     When specified, replaces the query part of the task URI. Setting the
        #     query value to an empty string clears the URI query segment.
        # @!attribute [rw] uri_override_enforce_mode
        #   @return [::Google::Cloud::Tasks::V2beta3::UriOverride::UriOverrideEnforceMode]
        #     URI Override Enforce Mode
        #
        #     When specified, determines the Target UriOverride mode. If not specified,
        #     it defaults to ALWAYS.
        class UriOverride
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Scheme for an HTTP request. By default, it is HTTPS.
          module Scheme
            # Scheme unspecified. Defaults to HTTPS.
            SCHEME_UNSPECIFIED = 0

            # Convert the scheme to HTTP, e.g., https://www.google.ca will change to
            # http://www.google.ca.
            HTTP = 1

            # Convert the scheme to HTTPS, e.g., http://www.google.ca will change to
            # https://www.google.ca.
            HTTPS = 2
          end

          # UriOverrideEnforceMode mode is to define enforcing mode for the override
          # modes.
          module UriOverrideEnforceMode
            # OverrideMode Unspecified. Defaults to ALWAYS.
            URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED = 0

            # In the IF_NOT_EXISTS mode, queue-level configuration is only
            # applied where task-level configuration does not exist.
            IF_NOT_EXISTS = 1

            # In the ALWAYS mode, queue-level configuration overrides all
            # task-level configuration
            ALWAYS = 2
          end
        end

        # HTTP target.
        #
        # When specified as a [Queue][target_type], all the tasks with [HttpRequest]
        # will be overridden according to the target.
        # @!attribute [rw] uri_override
        #   @return [::Google::Cloud::Tasks::V2beta3::UriOverride]
        #     URI override.
        #
        #     When specified, overrides the execution URI for all the tasks in the queue.
        # @!attribute [rw] http_method
        #   @return [::Google::Cloud::Tasks::V2beta3::HttpMethod]
        #     The HTTP method to use for the request.
        #
        #     When specified, it overrides
        #     {::Google::Cloud::Tasks::V2beta3::HttpTarget#http_method HttpRequest} for the
        #     task. Note that if the value is set to [HttpMethod][GET] the
        #     [HttpRequest][body] of the task will be ignored at execution time.
        # @!attribute [rw] header_overrides
        #   @return [::Array<::Google::Cloud::Tasks::V2beta3::HttpTarget::HeaderOverride>]
        #     HTTP target headers.
        #
        #     This map contains the header field names and values.
        #     Headers will be set when running the
        #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task CreateTask} and/or
        #     [BufferTask][google.cloud.tasks.v2beta3.CloudTasks.BufferTask].
        #
        #     These headers represent a subset of the headers that will be configured for
        #     the task's HTTP request. Some HTTP request headers will be ignored or
        #     replaced.
        #
        #     A partial list of headers that will be ignored or replaced is:
        #     * Several predefined headers, prefixed with "X-CloudTasks-", can
        #     be used to define properties of the task.
        #     * Host: This will be computed by Cloud Tasks and derived from
        #     [HttpRequest.url][google.cloud.tasks.v2beta3.Target.HttpRequest.url].
        #     * Content-Length: This will be computed by Cloud Tasks.
        #
        #     `Content-Type` won't be set by Cloud Tasks. You can explicitly set
        #     `Content-Type` to a media type when the
        #      {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task task is created}.
        #      For example,`Content-Type` can be set to `"application/octet-stream"` or
        #      `"application/json"`. The default value is set to `"application/json"`.
        #
        #     * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
        #
        #     Headers which can have multiple values (according to RFC2616) can be
        #     specified using comma-separated values.
        #
        #     The size of the headers must be less than 80KB.
        #     Queue-level headers to override headers of all the tasks in the queue.
        # @!attribute [rw] oauth_token
        #   @return [::Google::Cloud::Tasks::V2beta3::OAuthToken]
        #     If specified, an
        #     [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
        #     will be generated and attached as the `Authorization` header in the HTTP
        #     request.
        #
        #     This type of authorization should generally only be used when calling
        #     Google APIs hosted on *.googleapis.com.
        #
        #     Note: The following fields are mutually exclusive: `oauth_token`, `oidc_token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oidc_token
        #   @return [::Google::Cloud::Tasks::V2beta3::OidcToken]
        #     If specified, an
        #     [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
        #     token will be generated and attached as an `Authorization` header in the
        #     HTTP request.
        #
        #     This type of authorization can be used for many scenarios, including
        #     calling Cloud Run, or endpoints where you intend to validate the token
        #     yourself.
        #
        #     Note: The following fields are mutually exclusive: `oidc_token`, `oauth_token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class HttpTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines a header message. A header can have a key and a value.
          # @!attribute [rw] key
          #   @return [::String]
          #     The Key of the header.
          # @!attribute [rw] value
          #   @return [::String]
          #     The Value of the header.
          class Header
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Wraps the Header object.
          # @!attribute [rw] header
          #   @return [::Google::Cloud::Tasks::V2beta3::HttpTarget::Header]
          #     header embodying a key and a value.
          class HeaderOverride
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # HTTP request.
        #
        # The task will be pushed to the worker as an HTTP request. If the worker
        # or the redirected worker acknowledges the task by returning a successful HTTP
        # response code ([`200` - `299`]), the task will be removed from the queue. If
        # any other HTTP response code is returned or no response is received, the
        # task will be retried according to the following:
        #
        # * User-specified throttling: [retry
        # configuration][google.cloud.tasks.v2beta3.Queue.retry_config],
        #   {::Google::Cloud::Tasks::V2beta3::Queue#rate_limits rate limits}, and the
        #   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
        #
        # * System throttling: To prevent the worker from overloading, Cloud Tasks may
        #   temporarily reduce the queue's effective rate. User-specified settings
        #   will not be changed.
        #
        #  System throttling happens because:
        #
        #   * Cloud Tasks backs off on all errors. Normally the backoff specified in
        #     {::Google::Cloud::Tasks::V2beta3::Queue#rate_limits rate limits} will be used.
        #     But if the worker returns `429` (Too Many Requests), `503` (Service
        #     Unavailable), or the rate of errors is high, Cloud Tasks will use a
        #     higher backoff rate. The retry specified in the `Retry-After` HTTP
        #     response header is considered.
        #
        #   * To prevent traffic spikes and to smooth sudden increases in traffic,
        #     dispatches ramp up slowly when the queue is newly created or idle and
        #     if large numbers of tasks suddenly become available to dispatch (due to
        #     spikes in create task rates, the queue being unpaused, or many tasks
        #     that are scheduled at the same time).
        # @!attribute [rw] url
        #   @return [::String]
        #     Required. The full url path that the request will be sent to.
        #
        #     This string must begin with either "http://" or "https://". Some examples
        #     are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
        #     encode some characters for safety and compatibility. The maximum allowed
        #     URL length is 2083 characters after encoding.
        #
        #     The `Location` header response from a redirect response [`300` - `399`]
        #     may be followed. The redirect is not counted as a separate attempt.
        # @!attribute [rw] http_method
        #   @return [::Google::Cloud::Tasks::V2beta3::HttpMethod]
        #     The HTTP method to use for the request. The default is POST.
        # @!attribute [rw] headers
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     HTTP request headers.
        #
        #     This map contains the header field names and values.
        #     Headers can be set when the
        #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task task is created}.
        #
        #     These headers represent a subset of the headers that will accompany the
        #     task's HTTP request. Some HTTP request headers will be ignored or replaced.
        #
        #     A partial list of headers that will be ignored or replaced is:
        #
        #     * Any header that is prefixed with "X-CloudTasks-" will be treated
        #     as service header. Service headers define properties of the task and are
        #     predefined in CloudTask.
        #     * Host: This will be computed by Cloud Tasks and derived from
        #       {::Google::Cloud::Tasks::V2beta3::HttpRequest#url HttpRequest.url}.
        #     * Content-Length: This will be computed by Cloud Tasks.
        #     * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
        #     * `X-Google-*`: Google use only.
        #     * `X-AppEngine-*`: Google use only.
        #
        #     `Content-Type` won't be set by Cloud Tasks. You can explicitly set
        #     `Content-Type` to a media type when the
        #      {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task task is created}.
        #      For example, `Content-Type` can be set to `"application/octet-stream"` or
        #      `"application/json"`.
        #
        #     Headers which can have multiple values (according to RFC2616) can be
        #     specified using comma-separated values.
        #
        #     The size of the headers must be less than 80KB.
        # @!attribute [rw] body
        #   @return [::String]
        #     HTTP request body.
        #
        #     A request body is allowed only if the
        #     {::Google::Cloud::Tasks::V2beta3::HttpRequest#http_method HTTP method} is POST,
        #     PUT, or PATCH. It is an error to set body on a task with an incompatible
        #     {::Google::Cloud::Tasks::V2beta3::HttpMethod HttpMethod}.
        # @!attribute [rw] oauth_token
        #   @return [::Google::Cloud::Tasks::V2beta3::OAuthToken]
        #     If specified, an
        #     [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
        #     will be generated and attached as an `Authorization` header in the HTTP
        #     request.
        #
        #     This type of authorization should generally only be used when calling
        #     Google APIs hosted on *.googleapis.com.
        #
        #     Note: The following fields are mutually exclusive: `oauth_token`, `oidc_token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oidc_token
        #   @return [::Google::Cloud::Tasks::V2beta3::OidcToken]
        #     If specified, an
        #     [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
        #     token will be generated and attached as an `Authorization` header in the
        #     HTTP request.
        #
        #     This type of authorization can be used for many scenarios, including
        #     calling Cloud Run, or endpoints where you intend to validate the token
        #     yourself.
        #
        #     Note: The following fields are mutually exclusive: `oidc_token`, `oauth_token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class HttpRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class HeadersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # App Engine HTTP queue.
        #
        # The task will be delivered to the App Engine application hostname
        # specified by its
        # {::Google::Cloud::Tasks::V2beta3::AppEngineHttpQueue AppEngineHttpQueue} and
        # {::Google::Cloud::Tasks::V2beta3::AppEngineHttpRequest AppEngineHttpRequest}. The
        # documentation for
        # {::Google::Cloud::Tasks::V2beta3::AppEngineHttpRequest AppEngineHttpRequest}
        # explains how the task's host URL is constructed.
        #
        # Using {::Google::Cloud::Tasks::V2beta3::AppEngineHttpQueue AppEngineHttpQueue}
        # requires
        # [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
        # Google IAM permission for the project
        # and the following scope:
        #
        # `https://www.googleapis.com/auth/cloud-platform`
        # @!attribute [rw] app_engine_routing_override
        #   @return [::Google::Cloud::Tasks::V2beta3::AppEngineRouting]
        #     Overrides for the
        #     [task-level
        #     app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
        #
        #     If set, `app_engine_routing_override` is used for all tasks in
        #     the queue, no matter what the setting is for the
        #     [task-level
        #     app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
        class AppEngineHttpQueue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # App Engine HTTP request.
        #
        # The message defines the HTTP request that is sent to an App Engine app when
        # the task is dispatched.
        #
        # Using {::Google::Cloud::Tasks::V2beta3::AppEngineHttpRequest AppEngineHttpRequest}
        # requires
        # [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
        # Google IAM permission for the project
        # and the following scope:
        #
        # `https://www.googleapis.com/auth/cloud-platform`
        #
        # The task will be delivered to the App Engine app which belongs to the same
        # project as the queue. For more information, see
        # [How Requests are
        # Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
        # and how routing is affected by
        # [dispatch
        # files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
        # Traffic is encrypted during transport and never leaves Google datacenters.
        # Because this traffic is carried over a communication mechanism internal to
        # Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
        # The request to the handler, however, will appear to have used the HTTP
        # protocol.
        #
        # The {::Google::Cloud::Tasks::V2beta3::AppEngineRouting AppEngineRouting} used to
        # construct the URL that the task is delivered to can be set at the queue-level
        # or task-level:
        #
        # * If set,
        #   {::Google::Cloud::Tasks::V2beta3::AppEngineHttpQueue#app_engine_routing_override app_engine_routing_override}
        #   is used for all tasks in the queue, no matter what the setting
        #   is for the
        #   [task-level
        #   app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
        #
        #
        # The `url` that the task will be sent to is:
        #
        # * `url =` {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#host host} `+`
        #   {::Google::Cloud::Tasks::V2beta3::AppEngineHttpRequest#relative_uri relative_uri}
        #
        # Tasks can be dispatched to secure app handlers, unsecure app handlers, and
        # URIs restricted with
        # [`login:
        # admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
        # Because tasks are not run as any user, they cannot be dispatched to URIs
        # restricted with
        # [`login:
        # required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
        # Task dispatches also do not follow redirects.
        #
        # The task attempt has succeeded if the app's request handler returns an HTTP
        # response code in the range [`200` - `299`]. The task attempt has failed if
        # the app's handler returns a non-2xx response code or Cloud Tasks does
        # not receive response before the
        # {::Google::Cloud::Tasks::V2beta3::Task#dispatch_deadline deadline}. Failed tasks
        # will be retried according to the [retry
        # configuration][google.cloud.tasks.v2beta3.Queue.retry_config]. `503` (Service
        # Unavailable) is considered an App Engine system error instead of an
        # application error and will cause Cloud Tasks' traffic congestion control to
        # temporarily throttle the queue's dispatches. Unlike other types of task
        # targets, a `429` (Too Many Requests) response from an app handler does not
        # cause traffic congestion control to throttle the queue.
        # @!attribute [rw] http_method
        #   @return [::Google::Cloud::Tasks::V2beta3::HttpMethod]
        #     The HTTP method to use for the request. The default is POST.
        #
        #     The app's request handler for the task's target URL must be able to handle
        #     HTTP requests with this http_method, otherwise the task attempt fails with
        #     error code 405 (Method Not Allowed). See [Writing a push task request
        #     handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
        #     and the App Engine documentation for your runtime on [How Requests are
        #     Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
        # @!attribute [rw] app_engine_routing
        #   @return [::Google::Cloud::Tasks::V2beta3::AppEngineRouting]
        #     Task-level setting for App Engine routing.
        #
        #     If set,
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineHttpQueue#app_engine_routing_override app_engine_routing_override}
        #     is used for all tasks in the queue, no matter what the setting is for the
        #     [task-level
        #     app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
        # @!attribute [rw] relative_uri
        #   @return [::String]
        #     The relative URI.
        #
        #     The relative URI must begin with "/" and must be a valid HTTP relative URI.
        #     It can contain a path and query string arguments.
        #     If the relative URI is empty, then the root path "/" will be used.
        #     No spaces are allowed, and the maximum length allowed is 2083 characters.
        # @!attribute [rw] headers
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     HTTP request headers.
        #
        #     This map contains the header field names and values.
        #     Headers can be set when the
        #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task task is created}.
        #     Repeated headers are not supported but a header value can contain commas.
        #
        #     Cloud Tasks sets some headers to default values:
        #
        #     * `User-Agent`: By default, this header is
        #       `"AppEngine-Google; (+http://code.google.com/appengine)"`.
        #       This header can be modified, but Cloud Tasks will append
        #       `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
        #       modified `User-Agent`.
        #
        #     If the task has a
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineHttpRequest#body body}, Cloud Tasks
        #     sets the following headers:
        #
        #     * `Content-Type`: By default, the `Content-Type` header is set to
        #       `"application/octet-stream"`. The default can be overridden by explicitly
        #       setting `Content-Type` to a particular media type when the
        #       {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task task is created}.
        #       For example, `Content-Type` can be set to `"application/json"`.
        #     * `Content-Length`: This is computed by Cloud Tasks. This value is
        #       output only.   It cannot be changed.
        #
        #     The headers below cannot be set or overridden:
        #
        #     * `Host`
        #     * `X-Google-*`
        #     * `X-AppEngine-*`
        #
        #     In addition, Cloud Tasks sets some headers when the task is dispatched,
        #     such as headers containing information about the task; see
        #     [request
        #     headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
        #     These headers are set only when the task is dispatched, so they are not
        #     visible when the task is returned in a Cloud Tasks response.
        #
        #     Although there is no specific limit for the maximum number of headers or
        #     the size, there is a limit on the maximum size of the
        #     {::Google::Cloud::Tasks::V2beta3::Task Task}. For more information, see the
        #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Client#create_task CreateTask}
        #     documentation.
        # @!attribute [rw] body
        #   @return [::String]
        #     HTTP request body.
        #
        #     A request body is allowed only if the HTTP method is POST or PUT. It is
        #     an error to set a body on a task with an incompatible
        #     {::Google::Cloud::Tasks::V2beta3::HttpMethod HttpMethod}.
        class AppEngineHttpRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class HeadersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # App Engine Routing.
        #
        # Defines routing characteristics specific to App Engine - service, version,
        # and instance.
        #
        # For more information about services, versions, and instances see
        # [An Overview of App
        # Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
        # [Microservices Architecture on Google App
        # Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
        # [App Engine Standard request
        # routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
        # and [App Engine Flex request
        # routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
        # @!attribute [rw] service
        #   @return [::String]
        #     App service.
        #
        #     By default, the task is sent to the service which is the default
        #     service when the task is attempted.
        #
        #     For some queues or tasks which were created using the App Engine
        #     Task Queue API, {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#host host} is
        #     not parsable into
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#service service},
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#version version}, and
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#instance instance}. For
        #     example, some tasks which were created using the App Engine SDK use a
        #     custom domain name; custom domains are not parsed by Cloud Tasks. If
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#host host} is not parsable,
        #     then {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#service service},
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#version version}, and
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#instance instance} are the
        #     empty string.
        # @!attribute [rw] version
        #   @return [::String]
        #     App version.
        #
        #     By default, the task is sent to the version which is the default
        #     version when the task is attempted.
        #
        #     For some queues or tasks which were created using the App Engine
        #     Task Queue API, {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#host host} is
        #     not parsable into
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#service service},
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#version version}, and
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#instance instance}. For
        #     example, some tasks which were created using the App Engine SDK use a
        #     custom domain name; custom domains are not parsed by Cloud Tasks. If
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#host host} is not parsable,
        #     then {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#service service},
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#version version}, and
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#instance instance} are the
        #     empty string.
        # @!attribute [rw] instance
        #   @return [::String]
        #     App instance.
        #
        #     By default, the task is sent to an instance which is available when
        #     the task is attempted.
        #
        #     Requests can only be sent to a specific instance if
        #     [manual scaling is used in App Engine
        #     Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
        #     App Engine Flex does not support instances. For more information, see
        #     [App Engine Standard request
        #     routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
        #     and [App Engine Flex request
        #     routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
        # @!attribute [rw] host
        #   @return [::String]
        #     Output only. The host that the task is sent to.
        #
        #     The host is constructed from the domain name of the app associated with
        #     the queue's project ID (for example <app-id>.appspot.com), and the
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#service service},
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#version version}, and
        #     {::Google::Cloud::Tasks::V2beta3::AppEngineRouting#instance instance}. Tasks
        #     which were created using the App Engine SDK might have a custom domain
        #     name.
        #
        #     For more information, see
        #     [How Requests are
        #     Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
        class AppEngineRouting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains information needed for generating an
        # [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
        # This type of authorization should generally only be used when calling Google
        # APIs hosted on *.googleapis.com.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     [Service account email](https://cloud.google.com/iam/docs/service-accounts)
        #     to be used for generating OAuth token.
        #     The service account must be within the same project as the queue. The
        #     caller must have iam.serviceAccounts.actAs permission for the service
        #     account.
        # @!attribute [rw] scope
        #   @return [::String]
        #     OAuth scope to be used for generating OAuth access token.
        #     If not specified, "https://www.googleapis.com/auth/cloud-platform"
        #     will be used.
        class OAuthToken
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains information needed for generating an
        # [OpenID Connect
        # token](https://developers.google.com/identity/protocols/OpenIDConnect).
        # This type of authorization can be used for many scenarios, including
        # calling Cloud Run, or endpoints where you intend to validate the token
        # yourself.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     [Service account email](https://cloud.google.com/iam/docs/service-accounts)
        #     to be used for generating OIDC token.
        #     The service account must be within the same project as the queue. The
        #     caller must have iam.serviceAccounts.actAs permission for the service
        #     account.
        # @!attribute [rw] audience
        #   @return [::String]
        #     Audience to be used when generating OIDC token. If not specified, the URI
        #     specified in target will be used.
        class OidcToken
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The HTTP method used to execute the task.
        module HttpMethod
          # HTTP method unspecified
          HTTP_METHOD_UNSPECIFIED = 0

          # HTTP POST
          POST = 1

          # HTTP GET
          GET = 2

          # HTTP HEAD
          HEAD = 3

          # HTTP PUT
          PUT = 4

          # HTTP DELETE
          DELETE = 5

          # HTTP PATCH
          PATCH = 6

          # HTTP OPTIONS
          OPTIONS = 7
        end
      end
    end
  end
end
