# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/tasks/v2beta3/cloudtasks_pb"
require "google/cloud/tasks/v2beta3/cloud_tasks/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Tasks
      module V2beta3
        module CloudTasks
          module Rest
            ##
            # REST client for the CloudTasks service.
            #
            # Cloud Tasks allows developers to manage the execution of background
            # work in their applications.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudtasks.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_tasks_stub

              ##
              # Configure the CloudTasks Client class.
              #
              # See {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudTasks clients
              #   ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Tasks", "V2beta3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_queues.timeout = 20.0
                  default_config.rpcs.list_queues.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_queue.timeout = 20.0
                  default_config.rpcs.get_queue.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_queue.timeout = 20.0

                  default_config.rpcs.update_queue.timeout = 20.0

                  default_config.rpcs.delete_queue.timeout = 20.0
                  default_config.rpcs.delete_queue.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.purge_queue.timeout = 20.0

                  default_config.rpcs.pause_queue.timeout = 20.0

                  default_config.rpcs.resume_queue.timeout = 20.0

                  default_config.rpcs.get_iam_policy.timeout = 20.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 20.0

                  default_config.rpcs.test_iam_permissions.timeout = 20.0
                  default_config.rpcs.test_iam_permissions.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_tasks.timeout = 20.0
                  default_config.rpcs.list_tasks.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_task.timeout = 20.0
                  default_config.rpcs.get_task.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_task.timeout = 20.0

                  default_config.rpcs.delete_task.timeout = 20.0
                  default_config.rpcs.delete_task.retry_policy = {
                    initial_delay: 0.1, max_delay: 10.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.run_task.timeout = 20.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudTasks Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_tasks_stub.universe_domain
              end

              ##
              # Create a new CloudTasks REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudTasks client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @cloud_tasks_stub = ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_tasks_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_tasks_stub.endpoint
                  config.universe_domain = @cloud_tasks_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cloud_tasks_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_tasks_stub.logger
              end

              # Service calls

              ##
              # Lists queues.
              #
              # Queues are returned in lexicographical order.
              #
              # @overload list_queues(request, options = nil)
              #   Pass arguments to `list_queues` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::ListQueuesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::ListQueuesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_queues(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
              #   Pass arguments to `list_queues` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location name.
              #     For example: `projects/PROJECT_ID/locations/LOCATION_ID`
              #   @param filter [::String]
              #     `filter` can be used to specify a subset of queues. Any
              #     {::Google::Cloud::Tasks::V2beta3::Queue Queue} field can be used as a filter and
              #     several operators as supported. For example: `<=, <, >=, >, !=, =, :`. The
              #     filter syntax is the same as described in [Stackdriver's Advanced Logs
              #     Filters](https://cloud.google.com/logging/docs/view/advanced_filters).
              #
              #     Sample filter "state: PAUSED".
              #
              #     Note that using filters might cause fewer queues than the
              #     requested page_size to be returned.
              #   @param page_size [::Integer]
              #     Requested page size.
              #
              #     The maximum page size is 9800. If unspecified, the page size will
              #     be the maximum. Fewer queues than requested might be returned,
              #     even if more queues exist; use the
              #     {::Google::Cloud::Tasks::V2beta3::ListQueuesResponse#next_page_token next_page_token}
              #     in the response to determine if more queues exist.
              #   @param page_token [::String]
              #     A token identifying the page of results to return.
              #
              #     To request the first page results, page_token must be empty. To
              #     request the next page of results, page_token must be the value of
              #     {::Google::Cloud::Tasks::V2beta3::ListQueuesResponse#next_page_token next_page_token}
              #     returned from the previous call to
              #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#list_queues ListQueues} method. It
              #     is an error to switch the value of the
              #     {::Google::Cloud::Tasks::V2beta3::ListQueuesRequest#filter filter} while
              #     iterating through pages.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Read mask is used for a more granular control over what the API
              #     returns. If the mask is not present all fields will be returned except
              #     [Queue.stats]. [Queue.stats] will be returned only if it was  explicitly
              #     specified in the mask.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Tasks::V2beta3::Queue>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Tasks::V2beta3::Queue>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::ListQueuesRequest.new
              #
              #   # Call the list_queues method.
              #   result = client.list_queues request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Tasks::V2beta3::Queue.
              #     p item
              #   end
              #
              def list_queues request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::ListQueuesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_queues.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_queues.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_queues.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.list_queues request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_tasks_stub, :list_queues, "queues", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a queue.
              #
              # @overload get_queue(request, options = nil)
              #   Pass arguments to `get_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::GetQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::GetQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_queue(name: nil, read_mask: nil)
              #   Pass arguments to `get_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the queue. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Read mask is used for a more granular control over what the API
              #     returns. If the mask is not present all fields will be returned except
              #     [Queue.stats]. [Queue.stats] will be returned only if it was  explicitly
              #     specified in the mask.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::GetQueueRequest.new
              #
              #   # Call the get_queue method.
              #   result = client.get_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def get_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::GetQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.get_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a queue.
              #
              # Queues created with this method allow tasks to live for a maximum of 31
              # days. After a task is 31 days old, the task will be deleted regardless of
              # whether it was dispatched or not.
              #
              # WARNING: Using this method may have unintended side effects if you are
              # using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
              # Read
              # [Overview of Queue Management and
              # queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
              # this method.
              #
              # @overload create_queue(request, options = nil)
              #   Pass arguments to `create_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::CreateQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::CreateQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_queue(parent: nil, queue: nil)
              #   Pass arguments to `create_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location name in which the queue will be created.
              #     For example: `projects/PROJECT_ID/locations/LOCATION_ID`
              #
              #     The list of allowed locations can be obtained by calling Cloud
              #     Tasks' implementation of
              #     [ListLocations][google.cloud.location.Locations.ListLocations].
              #   @param queue [::Google::Cloud::Tasks::V2beta3::Queue, ::Hash]
              #     Required. The queue to create.
              #
              #     [Queue's name][google.cloud.tasks.v2beta3.Queue.name] cannot be the same as
              #     an existing queue.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::CreateQueueRequest.new
              #
              #   # Call the create_queue method.
              #   result = client.create_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def create_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::CreateQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.create_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a queue.
              #
              # This method creates the queue if it does not exist and updates
              # the queue if it does exist.
              #
              # Queues created with this method allow tasks to live for a maximum of 31
              # days. After a task is 31 days old, the task will be deleted regardless of
              # whether it was dispatched or not.
              #
              # WARNING: Using this method may have unintended side effects if you are
              # using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
              # Read
              # [Overview of Queue Management and
              # queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
              # this method.
              #
              # @overload update_queue(request, options = nil)
              #   Pass arguments to `update_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::UpdateQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::UpdateQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_queue(queue: nil, update_mask: nil)
              #   Pass arguments to `update_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param queue [::Google::Cloud::Tasks::V2beta3::Queue, ::Hash]
              #     Required. The queue to create or update.
              #
              #     The queue's {::Google::Cloud::Tasks::V2beta3::Queue#name name} must be
              #     specified.
              #
              #     Output only fields cannot be modified using UpdateQueue.
              #     Any value specified for an output only field will be ignored.
              #     The queue's {::Google::Cloud::Tasks::V2beta3::Queue#name name} cannot be
              #     changed.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     A mask used to specify which fields of the queue are being updated.
              #
              #     If empty, then all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::UpdateQueueRequest.new
              #
              #   # Call the update_queue method.
              #   result = client.update_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def update_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::UpdateQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.update_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a queue.
              #
              # This command will delete the queue even if it has tasks in it.
              #
              # Note: If you delete a queue, a queue with the same name can't be created
              # for 7 days.
              #
              # WARNING: Using this method may have unintended side effects if you are
              # using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
              # Read
              # [Overview of Queue Management and
              # queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
              # this method.
              #
              # @overload delete_queue(request, options = nil)
              #   Pass arguments to `delete_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::DeleteQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::DeleteQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_queue(name: nil)
              #   Pass arguments to `delete_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::DeleteQueueRequest.new
              #
              #   # Call the delete_queue method.
              #   result = client.delete_queue request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::DeleteQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.delete_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Purges a queue by deleting all of its tasks.
              #
              # All tasks created before this method is called are permanently deleted.
              #
              # Purge operations can take up to one minute to take effect. Tasks
              # might be dispatched before the purge takes effect. A purge is irreversible.
              #
              # @overload purge_queue(request, options = nil)
              #   Pass arguments to `purge_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::PurgeQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::PurgeQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload purge_queue(name: nil)
              #   Pass arguments to `purge_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::PurgeQueueRequest.new
              #
              #   # Call the purge_queue method.
              #   result = client.purge_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def purge_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::PurgeQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.purge_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.purge_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.purge_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.purge_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses the queue.
              #
              # If a queue is paused then the system will stop dispatching tasks
              # until the queue is resumed via
              # {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#resume_queue ResumeQueue}. Tasks can
              # still be added when the queue is paused. A queue is paused if its
              # {::Google::Cloud::Tasks::V2beta3::Queue#state state} is
              # {::Google::Cloud::Tasks::V2beta3::Queue::State::PAUSED PAUSED}.
              #
              # @overload pause_queue(request, options = nil)
              #   Pass arguments to `pause_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::PauseQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::PauseQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_queue(name: nil)
              #   Pass arguments to `pause_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::PauseQueueRequest.new
              #
              #   # Call the pause_queue method.
              #   result = client.pause_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def pause_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::PauseQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.pause_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resume a queue.
              #
              # This method resumes a queue after it has been
              # {::Google::Cloud::Tasks::V2beta3::Queue::State::PAUSED PAUSED} or
              # {::Google::Cloud::Tasks::V2beta3::Queue::State::DISABLED DISABLED}. The state of a
              # queue is stored in the queue's
              # {::Google::Cloud::Tasks::V2beta3::Queue#state state}; after calling this method
              # it will be set to
              # {::Google::Cloud::Tasks::V2beta3::Queue::State::RUNNING RUNNING}.
              #
              # WARNING: Resuming many high-QPS queues at the same time can
              # lead to target overloading. If you are resuming high-QPS
              # queues, follow the 500/50/5 pattern described in
              # [Managing Cloud Tasks Scaling
              # Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
              #
              # @overload resume_queue(request, options = nil)
              #   Pass arguments to `resume_queue` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::ResumeQueueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::ResumeQueueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_queue(name: nil)
              #   Pass arguments to `resume_queue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Queue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Queue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::ResumeQueueRequest.new
              #
              #   # Call the resume_queue method.
              #   result = client.resume_queue request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Queue.
              #   p result
              #
              def resume_queue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::ResumeQueueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_queue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_queue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_queue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.resume_queue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a
              # {::Google::Cloud::Tasks::V2beta3::Queue Queue}. Returns an empty policy if the
              # resource exists and does not have a policy set.
              #
              # Authorization requires the following
              # [Google IAM](https://cloud.google.com/iam) permission on the specified
              # resource parent:
              #
              # * `cloudtasks.queues.getIamPolicy`
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy for a
              # {::Google::Cloud::Tasks::V2beta3::Queue Queue}. Replaces any existing policy.
              #
              # Note: The Cloud Console does not check queue-level IAM permissions yet.
              # Project-level permissions are required to use the Cloud Console.
              #
              # Authorization requires the following
              # [Google IAM](https://cloud.google.com/iam) permission on the specified
              # resource parent:
              #
              # * `cloudtasks.queues.setIamPolicy`
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that a caller has on a
              # {::Google::Cloud::Tasks::V2beta3::Queue Queue}. If the resource does not exist,
              # this will return an empty set of permissions, not a
              # [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
              #
              # Note: This operation is designed to be used for building permission-aware
              # UIs and command-line tools, not for authorization checking. This operation
              # may "fail open" without warning.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the tasks in a queue.
              #
              # By default, only the {::Google::Cloud::Tasks::V2beta3::Task::View::BASIC BASIC}
              # view is retrieved due to performance considerations;
              # {::Google::Cloud::Tasks::V2beta3::ListTasksRequest#response_view response_view}
              # controls the subset of information which is returned.
              #
              # The tasks may be returned in any order. The ordering may change at any
              # time.
              #
              # @overload list_tasks(request, options = nil)
              #   Pass arguments to `list_tasks` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::ListTasksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::ListTasksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tasks(parent: nil, response_view: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_tasks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
              #   @param response_view [::Google::Cloud::Tasks::V2beta3::Task::View]
              #     The response_view specifies which subset of the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} will be returned.
              #
              #     By default response_view is
              #     {::Google::Cloud::Tasks::V2beta3::Task::View::BASIC BASIC}; not all information is
              #     retrieved by default because some data, such as payloads, might be
              #     desirable to return only when needed because of its large size or because
              #     of the sensitivity of data that it contains.
              #
              #     Authorization for {::Google::Cloud::Tasks::V2beta3::Task::View::FULL FULL}
              #     requires `cloudtasks.tasks.fullView` [Google
              #     IAM](https://cloud.google.com/iam/) permission on the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} resource.
              #   @param page_size [::Integer]
              #     Maximum page size.
              #
              #     Fewer tasks than requested might be returned, even if more tasks exist; use
              #     {::Google::Cloud::Tasks::V2beta3::ListTasksResponse#next_page_token next_page_token}
              #     in the response to determine if more tasks exist.
              #
              #     The maximum page size is 1000. If unspecified, the page size will be the
              #     maximum.
              #   @param page_token [::String]
              #     A token identifying the page of results to return.
              #
              #     To request the first page results, page_token must be empty. To
              #     request the next page of results, page_token must be the value of
              #     {::Google::Cloud::Tasks::V2beta3::ListTasksResponse#next_page_token next_page_token}
              #     returned from the previous call to
              #     {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#list_tasks ListTasks} method.
              #
              #     The page token is valid for only 2 hours.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Tasks::V2beta3::Task>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Tasks::V2beta3::Task>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::ListTasksRequest.new
              #
              #   # Call the list_tasks method.
              #   result = client.list_tasks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Tasks::V2beta3::Task.
              #     p item
              #   end
              #
              def list_tasks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::ListTasksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tasks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tasks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tasks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.list_tasks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_tasks_stub, :list_tasks, "tasks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a task.
              #
              # @overload get_task(request, options = nil)
              #   Pass arguments to `get_task` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::GetTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::GetTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_task(name: nil, response_view: nil)
              #   Pass arguments to `get_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The task name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
              #   @param response_view [::Google::Cloud::Tasks::V2beta3::Task::View]
              #     The response_view specifies which subset of the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} will be returned.
              #
              #     By default response_view is
              #     {::Google::Cloud::Tasks::V2beta3::Task::View::BASIC BASIC}; not all information is
              #     retrieved by default because some data, such as payloads, might be
              #     desirable to return only when needed because of its large size or because
              #     of the sensitivity of data that it contains.
              #
              #     Authorization for {::Google::Cloud::Tasks::V2beta3::Task::View::FULL FULL}
              #     requires `cloudtasks.tasks.fullView` [Google
              #     IAM](https://cloud.google.com/iam/) permission on the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Task]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Task]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::GetTaskRequest.new
              #
              #   # Call the get_task method.
              #   result = client.get_task request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Task.
              #   p result
              #
              def get_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::GetTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.get_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a task and adds it to a queue.
              #
              # Tasks cannot be updated after creation; there is no UpdateTask command.
              #
              # * The maximum task size is 100KB.
              #
              # @overload create_task(request, options = nil)
              #   Pass arguments to `create_task` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::CreateTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::CreateTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_task(parent: nil, task: nil, response_view: nil)
              #   Pass arguments to `create_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The queue name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
              #
              #     The queue must already exist.
              #   @param task [::Google::Cloud::Tasks::V2beta3::Task, ::Hash]
              #     Required. The task to add.
              #
              #     Task names have the following format:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
              #     The user can optionally specify a task
              #     {::Google::Cloud::Tasks::V2beta3::Task#name name}. If a name is not specified
              #     then the system will generate a random unique task id, which will be set in
              #     the task returned in the {::Google::Cloud::Tasks::V2beta3::Task#name response}.
              #
              #     If {::Google::Cloud::Tasks::V2beta3::Task#schedule_time schedule_time} is not
              #     set or is in the past then Cloud Tasks will set it to the current time.
              #
              #     Task De-duplication:
              #
              #     Explicitly specifying a task ID enables task de-duplication.  If
              #     a task's ID is identical to that of an existing task or a task
              #     that was deleted or executed recently then the call will fail
              #     with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
              #     If the task's queue was created using Cloud Tasks, then another task with
              #     the same name can't be created for ~1 hour after the original task was
              #     deleted or executed. If the task's queue was created using queue.yaml or
              #     queue.xml, then another task with the same name can't be created
              #     for ~9 days after the original task was deleted or executed.
              #
              #     Because there is an extra lookup cost to identify duplicate task
              #     names, these {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#create_task CreateTask}
              #     calls have significantly increased latency. Using hashed strings for the
              #     task id or for the prefix of the task id is recommended. Choosing task ids
              #     that are sequential or have sequential prefixes, for example using a
              #     timestamp, causes an increase in latency and error rates in all
              #     task commands. The infrastructure relies on an approximately
              #     uniform distribution of task ids to store and serve tasks
              #     efficiently.
              #   @param response_view [::Google::Cloud::Tasks::V2beta3::Task::View]
              #     The response_view specifies which subset of the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} will be returned.
              #
              #     By default response_view is
              #     {::Google::Cloud::Tasks::V2beta3::Task::View::BASIC BASIC}; not all information is
              #     retrieved by default because some data, such as payloads, might be
              #     desirable to return only when needed because of its large size or because
              #     of the sensitivity of data that it contains.
              #
              #     Authorization for {::Google::Cloud::Tasks::V2beta3::Task::View::FULL FULL}
              #     requires `cloudtasks.tasks.fullView` [Google
              #     IAM](https://cloud.google.com/iam/) permission on the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Task]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Task]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::CreateTaskRequest.new
              #
              #   # Call the create_task method.
              #   result = client.create_task request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Task.
              #   p result
              #
              def create_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::CreateTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.create_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a task.
              #
              # A task can be deleted if it is scheduled or dispatched. A task
              # cannot be deleted if it has executed successfully or permanently
              # failed.
              #
              # @overload delete_task(request, options = nil)
              #   Pass arguments to `delete_task` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::DeleteTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::DeleteTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_task(name: nil)
              #   Pass arguments to `delete_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The task name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::DeleteTaskRequest.new
              #
              #   # Call the delete_task method.
              #   result = client.delete_task request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::DeleteTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.delete_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Forces a task to run now.
              #
              # When this method is called, Cloud Tasks will dispatch the task, even if
              # the task is already running, the queue has reached its
              # {::Google::Cloud::Tasks::V2beta3::RateLimits RateLimits} or is
              # {::Google::Cloud::Tasks::V2beta3::Queue::State::PAUSED PAUSED}.
              #
              # This command is meant to be used for manual debugging. For
              # example, {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#run_task RunTask} can be
              # used to retry a failed task after a fix has been made or to manually force
              # a task to be dispatched now.
              #
              # The dispatched task is returned. That is, the task that is returned
              # contains the [status][Task.status] after the task is dispatched but
              # before the task is received by its target.
              #
              # If Cloud Tasks receives a successful response from the task's
              # target, then the task will be deleted; otherwise the task's
              # {::Google::Cloud::Tasks::V2beta3::Task#schedule_time schedule_time} will be
              # reset to the time that
              # {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#run_task RunTask} was called plus
              # the retry delay specified in the queue's
              # {::Google::Cloud::Tasks::V2beta3::RetryConfig RetryConfig}.
              #
              # {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client#run_task RunTask} returns
              # [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
              # task that has already succeeded or permanently failed.
              #
              # @overload run_task(request, options = nil)
              #   Pass arguments to `run_task` via a request object, either of type
              #   {::Google::Cloud::Tasks::V2beta3::RunTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Tasks::V2beta3::RunTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_task(name: nil, response_view: nil)
              #   Pass arguments to `run_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The task name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
              #   @param response_view [::Google::Cloud::Tasks::V2beta3::Task::View]
              #     The response_view specifies which subset of the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} will be returned.
              #
              #     By default response_view is
              #     {::Google::Cloud::Tasks::V2beta3::Task::View::BASIC BASIC}; not all information is
              #     retrieved by default because some data, such as payloads, might be
              #     desirable to return only when needed because of its large size or because
              #     of the sensitivity of data that it contains.
              #
              #     Authorization for {::Google::Cloud::Tasks::V2beta3::Task::View::FULL FULL}
              #     requires `cloudtasks.tasks.fullView` [Google
              #     IAM](https://cloud.google.com/iam/) permission on the
              #     {::Google::Cloud::Tasks::V2beta3::Task Task} resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Tasks::V2beta3::Task]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Tasks::V2beta3::Task]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/tasks/v2beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Tasks::V2beta3::RunTaskRequest.new
              #
              #   # Call the run_task method.
              #   result = client.run_task request
              #
              #   # The returned object is of type Google::Cloud::Tasks::V2beta3::Task.
              #   p result
              #
              def run_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Tasks::V2beta3::RunTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Tasks::V2beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_tasks_stub.run_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudTasks REST API.
              #
              # This class represents the configuration for CloudTasks REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_queues to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_queues.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Tasks::V2beta3::CloudTasks::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_queues.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudtasks.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudTasks API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_queues`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_queues
                  ##
                  # RPC-specific configuration for `get_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_queue
                  ##
                  # RPC-specific configuration for `create_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_queue
                  ##
                  # RPC-specific configuration for `update_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_queue
                  ##
                  # RPC-specific configuration for `delete_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_queue
                  ##
                  # RPC-specific configuration for `purge_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :purge_queue
                  ##
                  # RPC-specific configuration for `pause_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_queue
                  ##
                  # RPC-specific configuration for `resume_queue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_queue
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `list_tasks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tasks
                  ##
                  # RPC-specific configuration for `get_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_task
                  ##
                  # RPC-specific configuration for `create_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_task
                  ##
                  # RPC-specific configuration for `delete_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_task
                  ##
                  # RPC-specific configuration for `run_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_task

                  # @private
                  def initialize parent_rpcs = nil
                    list_queues_config = parent_rpcs.list_queues if parent_rpcs.respond_to? :list_queues
                    @list_queues = ::Gapic::Config::Method.new list_queues_config
                    get_queue_config = parent_rpcs.get_queue if parent_rpcs.respond_to? :get_queue
                    @get_queue = ::Gapic::Config::Method.new get_queue_config
                    create_queue_config = parent_rpcs.create_queue if parent_rpcs.respond_to? :create_queue
                    @create_queue = ::Gapic::Config::Method.new create_queue_config
                    update_queue_config = parent_rpcs.update_queue if parent_rpcs.respond_to? :update_queue
                    @update_queue = ::Gapic::Config::Method.new update_queue_config
                    delete_queue_config = parent_rpcs.delete_queue if parent_rpcs.respond_to? :delete_queue
                    @delete_queue = ::Gapic::Config::Method.new delete_queue_config
                    purge_queue_config = parent_rpcs.purge_queue if parent_rpcs.respond_to? :purge_queue
                    @purge_queue = ::Gapic::Config::Method.new purge_queue_config
                    pause_queue_config = parent_rpcs.pause_queue if parent_rpcs.respond_to? :pause_queue
                    @pause_queue = ::Gapic::Config::Method.new pause_queue_config
                    resume_queue_config = parent_rpcs.resume_queue if parent_rpcs.respond_to? :resume_queue
                    @resume_queue = ::Gapic::Config::Method.new resume_queue_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    list_tasks_config = parent_rpcs.list_tasks if parent_rpcs.respond_to? :list_tasks
                    @list_tasks = ::Gapic::Config::Method.new list_tasks_config
                    get_task_config = parent_rpcs.get_task if parent_rpcs.respond_to? :get_task
                    @get_task = ::Gapic::Config::Method.new get_task_config
                    create_task_config = parent_rpcs.create_task if parent_rpcs.respond_to? :create_task
                    @create_task = ::Gapic::Config::Method.new create_task_config
                    delete_task_config = parent_rpcs.delete_task if parent_rpcs.respond_to? :delete_task
                    @delete_task = ::Gapic::Config::Method.new delete_task_config
                    run_task_config = parent_rpcs.run_task if parent_rpcs.respond_to? :run_task
                    @run_task = ::Gapic::Config::Method.new run_task_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
