# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/talent/v4beta1/job_service_pb"

module Google
  module Cloud
    module Talent
      module V4beta1
        module JobService
          ##
          # Client for the JobService service.
          #
          # A service handles job management, including job CRUD, enumeration and search.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "jobs.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :job_service_stub

            ##
            # Configure the JobService Client class.
            #
            # See {::Google::Cloud::Talent::V4beta1::JobService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all JobService clients
            #   ::Google::Cloud::Talent::V4beta1::JobService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Talent", "V4beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_job.timeout = 30.0

                default_config.rpcs.batch_create_jobs.timeout = 30.0

                default_config.rpcs.get_job.timeout = 30.0
                default_config.rpcs.get_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_job.timeout = 30.0

                default_config.rpcs.batch_update_jobs.timeout = 30.0

                default_config.rpcs.delete_job.timeout = 30.0
                default_config.rpcs.delete_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.batch_delete_jobs.timeout = 30.0

                default_config.rpcs.list_jobs.timeout = 30.0
                default_config.rpcs.list_jobs.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.search_jobs.timeout = 30.0

                default_config.rpcs.search_jobs_for_alert.timeout = 30.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the JobService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Talent::V4beta1::JobService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @job_service_stub.universe_domain
            end

            ##
            # Create a new JobService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Talent::V4beta1::JobService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the JobService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/talent/v4beta1/job_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @job_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Talent::V4beta1::JobService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @job_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Talent::V4beta1::JobService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @job_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new job.
            #
            # Typically, the job becomes searchable within 10 seconds, but it may take
            # up to 5 minutes.
            #
            # @overload create_job(request, options = nil)
            #   Pass arguments to `create_job` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::CreateJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::CreateJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_job(parent: nil, job: nil)
            #   Pass arguments to `create_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant under which the job is created.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified a default tenant
            #     is created. For example, "projects/foo".
            #   @param job [::Google::Cloud::Talent::V4beta1::Job, ::Hash]
            #     Required. The Job to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Talent::V4beta1::Job]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Talent::V4beta1::Job]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::CreateJobRequest.new
            #
            #   # Call the create_job method.
            #   result = client.create_job request
            #
            #   # The returned object is of type Google::Cloud::Talent::V4beta1::Job.
            #   p result
            #
            def create_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::CreateJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Begins executing a batch create jobs operation.
            #
            # @overload batch_create_jobs(request, options = nil)
            #   Pass arguments to `batch_create_jobs` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::BatchCreateJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::BatchCreateJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_jobs(parent: nil, jobs: nil)
            #   Pass arguments to `batch_create_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant under which the job is created.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param jobs [::Array<::Google::Cloud::Talent::V4beta1::Job, ::Hash>]
            #     Required. The jobs to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::BatchCreateJobsRequest.new
            #
            #   # Call the batch_create_jobs method.
            #   result = client.batch_create_jobs request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_create_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::BatchCreateJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :batch_create_jobs, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves the specified job, whose status is OPEN or recently EXPIRED
            # within the last 90 days.
            #
            # @overload get_job(request, options = nil)
            #   Pass arguments to `get_job` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::GetJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::GetJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_job(name: nil)
            #   Pass arguments to `get_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the job to retrieve.
            #
            #     The format is
            #     "projects/\\{project_id}/tenants/\\{tenant_id}/jobs/\\{job_id}". For
            #     example, "projects/foo/tenants/bar/jobs/baz".
            #
            #     If tenant id is unspecified, the default tenant is used. For
            #     example, "projects/foo/jobs/bar".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Talent::V4beta1::Job]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Talent::V4beta1::Job]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::GetJobRequest.new
            #
            #   # Call the get_job method.
            #   result = client.get_job request
            #
            #   # The returned object is of type Google::Cloud::Talent::V4beta1::Job.
            #   p result
            #
            def get_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::GetJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates specified job.
            #
            # Typically, updated contents become visible in search results within 10
            # seconds, but it may take up to 5 minutes.
            #
            # @overload update_job(request, options = nil)
            #   Pass arguments to `update_job` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::UpdateJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::UpdateJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_job(job: nil, update_mask: nil)
            #   Pass arguments to `update_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param job [::Google::Cloud::Talent::V4beta1::Job, ::Hash]
            #     Required. The Job to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Strongly recommended for the best service experience.
            #
            #     If {::Google::Cloud::Talent::V4beta1::UpdateJobRequest#update_mask update_mask}
            #     is provided, only the specified fields in
            #     {::Google::Cloud::Talent::V4beta1::UpdateJobRequest#job job} are updated.
            #     Otherwise all the fields are updated.
            #
            #     A field mask to restrict the fields that are updated. Only
            #     top level fields of {::Google::Cloud::Talent::V4beta1::Job Job} are supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Talent::V4beta1::Job]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Talent::V4beta1::Job]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::UpdateJobRequest.new
            #
            #   # Call the update_job method.
            #   result = client.update_job request
            #
            #   # The returned object is of type Google::Cloud::Talent::V4beta1::Job.
            #   p result
            #
            def update_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::UpdateJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.job&.name
                header_params["job.name"] = request.job.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :update_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Begins executing a batch update jobs operation.
            #
            # @overload batch_update_jobs(request, options = nil)
            #   Pass arguments to `batch_update_jobs` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_update_jobs(parent: nil, jobs: nil, update_mask: nil)
            #   Pass arguments to `batch_update_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant under which the job is created.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param jobs [::Array<::Google::Cloud::Talent::V4beta1::Job, ::Hash>]
            #     Required. The jobs to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Strongly recommended for the best service experience. Be aware that it will
            #     also increase latency when checking the status of a batch operation.
            #
            #     If
            #     {::Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest#update_mask update_mask}
            #     is provided, only the specified fields in
            #     {::Google::Cloud::Talent::V4beta1::Job Job} are updated. Otherwise all the
            #     fields are updated.
            #
            #     A field mask to restrict the fields that are updated. Only
            #     top level fields of {::Google::Cloud::Talent::V4beta1::Job Job} are supported.
            #
            #     If
            #     {::Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest#update_mask update_mask}
            #     is provided, The {::Google::Cloud::Talent::V4beta1::Job Job} inside
            #     {::Google::Cloud::Talent::V4beta1::JobOperationResult::JobResult JobResult}
            #     will only contains fields that is updated, plus the Id of the Job.
            #     Otherwise,  {::Google::Cloud::Talent::V4beta1::Job Job} will include all fields,
            #     which can yield a very large response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest.new
            #
            #   # Call the batch_update_jobs method.
            #   result = client.batch_update_jobs request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_update_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::BatchUpdateJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_update_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_update_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_update_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :batch_update_jobs, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified job.
            #
            # Typically, the job becomes unsearchable within 10 seconds, but it may take
            # up to 5 minutes.
            #
            # @overload delete_job(request, options = nil)
            #   Pass arguments to `delete_job` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::DeleteJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::DeleteJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_job(name: nil)
            #   Pass arguments to `delete_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the job to be deleted.
            #
            #     The format is
            #     "projects/\\{project_id}/tenants/\\{tenant_id}/jobs/\\{job_id}". For
            #     example, "projects/foo/tenants/bar/jobs/baz".
            #
            #     If tenant id is unspecified, the default tenant is used. For
            #     example, "projects/foo/jobs/bar".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::DeleteJobRequest.new
            #
            #   # Call the delete_job method.
            #   result = client.delete_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::DeleteJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a list of {::Google::Cloud::Talent::V4beta1::Job Job}s by filter.
            #
            # @overload batch_delete_jobs(request, options = nil)
            #   Pass arguments to `batch_delete_jobs` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::BatchDeleteJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::BatchDeleteJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_delete_jobs(parent: nil, filter: nil)
            #   Pass arguments to `batch_delete_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant under which the job is created.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param filter [::String]
            #     Required. The filter string specifies the jobs to be deleted.
            #
            #     Supported operator: =, AND
            #
            #     The fields eligible for filtering are:
            #
            #     * `companyName` (Required)
            #     * `requisitionId` (Required)
            #
            #     Sample Query: companyName = "projects/foo/companies/bar" AND
            #     requisitionId = "req-1"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::BatchDeleteJobsRequest.new
            #
            #   # Call the batch_delete_jobs method.
            #   result = client.batch_delete_jobs request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def batch_delete_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::BatchDeleteJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_delete_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_delete_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_delete_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :batch_delete_jobs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists jobs by filter.
            #
            # @overload list_jobs(request, options = nil)
            #   Pass arguments to `list_jobs` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::ListJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::ListJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_jobs(parent: nil, filter: nil, page_token: nil, page_size: nil, job_view: nil)
            #   Pass arguments to `list_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant under which the job is created.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param filter [::String]
            #     Required. The filter string specifies the jobs to be enumerated.
            #
            #     Supported operator: =, AND
            #
            #     The fields eligible for filtering are:
            #
            #     * `companyName`
            #     * `requisitionId`
            #     * `status` Available values: OPEN, EXPIRED, ALL. Defaults to
            #     OPEN if no value is specified.
            #
            #     At least one of `companyName` and `requisitionId` must present or an
            #     INVALID_ARGUMENT error is thrown.
            #
            #     Sample Query:
            #
            #     * companyName = "projects/foo/tenants/bar/companies/baz"
            #     * companyName = "projects/foo/tenants/bar/companies/baz" AND
            #     requisitionId = "req-1"
            #     * companyName = "projects/foo/tenants/bar/companies/baz" AND
            #     status = "EXPIRED"
            #     * requisitionId = "req-1"
            #     * requisitionId = "req-1" AND status = "EXPIRED"
            #   @param page_token [::String]
            #     The starting point of a query result.
            #   @param page_size [::Integer]
            #     The maximum number of jobs to be returned per page of results.
            #
            #     If {::Google::Cloud::Talent::V4beta1::ListJobsRequest#job_view job_view} is set
            #     to
            #     {::Google::Cloud::Talent::V4beta1::JobView::JOB_VIEW_ID_ONLY JobView.JOB_VIEW_ID_ONLY},
            #     the maximum allowed page size is 1000. Otherwise, the maximum allowed page
            #     size is 100.
            #
            #     Default is 100 if empty or a number < 1 is specified.
            #   @param job_view [::Google::Cloud::Talent::V4beta1::JobView]
            #     The desired job attributes returned for jobs in the
            #     search response. Defaults to
            #     {::Google::Cloud::Talent::V4beta1::JobView::JOB_VIEW_FULL JobView.JOB_VIEW_FULL}
            #     if no value is specified.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Talent::V4beta1::Job>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Talent::V4beta1::Job>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::ListJobsRequest.new
            #
            #   # Call the list_jobs method.
            #   result = client.list_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Talent::V4beta1::Job.
            #     p item
            #   end
            #
            def list_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::ListJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches for jobs using the provided
            # {::Google::Cloud::Talent::V4beta1::SearchJobsRequest SearchJobsRequest}.
            #
            # This call constrains the
            # {::Google::Cloud::Talent::V4beta1::Job#visibility visibility} of jobs present in
            # the database, and only returns jobs that the caller has permission to
            # search against.
            #
            # @overload search_jobs(request, options = nil)
            #   Pass arguments to `search_jobs` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::SearchJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::SearchJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_jobs(parent: nil, search_mode: nil, request_metadata: nil, job_query: nil, enable_broadening: nil, require_precise_result_size: nil, histogram_queries: nil, job_view: nil, offset: nil, page_size: nil, page_token: nil, order_by: nil, diversification_level: nil, custom_ranking_info: nil, disable_keyword_match: nil, keyword_match_mode: nil, relevance_threshold: nil)
            #   Pass arguments to `search_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant to search within.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param search_mode [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::SearchMode]
            #     Mode of a search.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::SearchMode::JOB_SEARCH SearchMode.JOB_SEARCH}.
            #   @param request_metadata [::Google::Cloud::Talent::V4beta1::RequestMetadata, ::Hash]
            #     Required. The meta information collected about the job searcher, used to
            #     improve the search quality of the service. The identifiers (such as
            #     `user_id`) are provided by users, and must be unique and consistent.
            #   @param job_query [::Google::Cloud::Talent::V4beta1::JobQuery, ::Hash]
            #     Query used to search against jobs, such as keyword, location filters, etc.
            #   @param enable_broadening [::Boolean]
            #     Controls whether to broaden the search when it produces sparse results.
            #     Broadened queries append results to the end of the matching results
            #     list.
            #
            #     Defaults to false.
            #   @param require_precise_result_size [::Boolean]
            #     This field is deprecated.
            #   @param histogram_queries [::Array<::Google::Cloud::Talent::V4beta1::HistogramQuery, ::Hash>]
            #     An expression specifies a histogram request against matching jobs.
            #
            #     Expression syntax is an aggregation function call with histogram facets and
            #     other options.
            #
            #     Available aggregation function calls are:
            #     * `count(string_histogram_facet)`: Count the number of matching entities,
            #     for each distinct attribute value.
            #     * `count(numeric_histogram_facet, list of buckets)`: Count the number of
            #     matching entities within each bucket.
            #
            #     A maximum of 200 histogram buckets are supported.
            #
            #     Data types:
            #
            #     * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
            #     * String: string like "any string with backslash escape for quote(\")."
            #     * Number: whole number and floating point number like 10, -1 and -0.01.
            #     * List: list of elements with comma(,) separator surrounded by square
            #     brackets, for example, [1, 2, 3] and ["one", "two", "three"].
            #
            #     Built-in constants:
            #
            #     * MIN (minimum number similar to java Double.MIN_VALUE)
            #     * MAX (maximum number similar to java Double.MAX_VALUE)
            #
            #     Built-in functions:
            #
            #     * bucket(start, end[, label]): bucket built-in function creates a bucket
            #     with range of [start, end). Note that the end is exclusive, for example,
            #     bucket(1, MAX, "positive number") or bucket(1, 10).
            #
            #     Job histogram facets:
            #
            #     * company_display_name: histogram by
            #     {::Google::Cloud::Talent::V4beta1::Job#company_display_name Job.company_display_name}.
            #     * employment_type: histogram by
            #     {::Google::Cloud::Talent::V4beta1::Job#employment_types Job.employment_types},
            #     for example,
            #       "FULL_TIME", "PART_TIME".
            #     * company_size (DEPRECATED): histogram by
            #     {::Google::Cloud::Talent::V4beta1::CompanySize CompanySize}, for example,
            #     "SMALL", "MEDIUM", "BIG".
            #     * publish_time_in_day: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in days.
            #       Must specify list of numeric buckets in spec.
            #     * publish_time_in_month: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in months.
            #       Must specify list of numeric buckets in spec.
            #     * publish_time_in_year: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in years.
            #       Must specify list of numeric buckets in spec.
            #     * degree_types: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#degree_types Job.degree_types}, for
            #     example,
            #       "Bachelors", "Masters".
            #     * job_level: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#job_level Job.job_level}, for example,
            #     "Entry
            #       Level".
            #     * country: histogram by the country code of jobs, for example, "US", "FR".
            #     * admin1: histogram by the admin1 code of jobs, which is a global
            #       placeholder referring to the state, province, or the particular term a
            #       country uses to define the geographic structure below the country level,
            #       for example, "CA", "IL".
            #     * city: histogram by a combination of the "city name, admin1 code". For
            #       example,  "Mountain View, CA", "New York, NY".
            #     * admin1_country: histogram by a combination of the "admin1 code, country",
            #       for example, "CA, US", "IL, US".
            #     * city_coordinate: histogram by the city center's GPS coordinates (latitude
            #       and longitude), for example, 37.4038522,-122.0987765. Since the
            #       coordinates of a city center can change, customers may need to refresh
            #       them periodically.
            #     * locale: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#language_code Job.language_code}, for
            #     example, "en-US",
            #       "fr-FR".
            #     * language: histogram by the language subtag of the
            #     {::Google::Cloud::Talent::V4beta1::Job#language_code Job.language_code},
            #       for example, "en", "fr".
            #     * category: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::JobCategory JobCategory}, for example,
            #       "COMPUTER_AND_IT", "HEALTHCARE".
            #     * base_compensation_unit: histogram by the
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo::CompensationUnit CompensationInfo.CompensationUnit}
            #       of base salary, for example, "WEEKLY", "MONTHLY".
            #     * base_compensation: histogram by the base salary. Must specify list of
            #       numeric buckets to group results by.
            #     * annualized_base_compensation: histogram by the base annualized salary.
            #       Must specify list of numeric buckets to group results by.
            #     * annualized_total_compensation: histogram by the total annualized salary.
            #       Must specify list of numeric buckets to group results by.
            #     * string_custom_attribute: histogram by string
            #     {::Google::Cloud::Talent::V4beta1::Job#custom_attributes Job.custom_attributes}.
            #       Values can be accessed via square bracket notations like
            #       string_custom_attribute["key1"].
            #     * numeric_custom_attribute: histogram by numeric
            #     {::Google::Cloud::Talent::V4beta1::Job#custom_attributes Job.custom_attributes}.
            #       Values can be accessed via square bracket notations like
            #       numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
            #       group results by.
            #
            #     Example expressions:
            #
            #     * `count(admin1)`
            #     * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
            #     bucket(100000, MAX)])`
            #     * `count(string_custom_attribute["some-string-custom-attribute"])`
            #     * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
            #       [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
            #   @param job_view [::Google::Cloud::Talent::V4beta1::JobView]
            #     The desired job attributes returned for jobs in the search response.
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::JobView::JOB_VIEW_SMALL JobView.JOB_VIEW_SMALL}
            #     if no value is specified.
            #   @param offset [::Integer]
            #     An integer that specifies the current offset (that is, starting result
            #     location, amongst the jobs deemed by the API as relevant) in search
            #     results. This field is only considered if
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#page_token page_token} is
            #     unset.
            #
            #     The maximum allowed value is 5000. Otherwise an error is thrown.
            #
            #     For example, 0 means to  return results starting from the first matching
            #     job, and 10 means to return from the 11th job. This can be used for
            #     pagination, (for example, pageSize = 10 and offset = 10 means to return
            #     from the second page).
            #   @param page_size [::Integer]
            #     A limit on the number of jobs returned in the search results.
            #     Increasing this value above the default value of 10 can increase search
            #     response time. The value can be between 1 and 100.
            #   @param page_token [::String]
            #     The token specifying the current offset within
            #     search results. See
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsResponse#next_page_token SearchJobsResponse.next_page_token}
            #     for an explanation of how to obtain the next set of query results.
            #   @param order_by [::String]
            #     The criteria determining how search results are sorted. Default is
            #     `"relevance desc"`.
            #
            #     Supported options are:
            #
            #     * `"relevance desc"`: By relevance descending, as determined by the API
            #       algorithms. Relevance thresholding of query results is only available
            #       with this ordering.
            #     * `"posting_publish_time desc"`: By
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       descending.
            #     * `"posting_update_time desc"`: By
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_update_time Job.posting_update_time}
            #       descending.
            #     * `"title"`: By {::Google::Cloud::Talent::V4beta1::Job#title Job.title}
            #     ascending.
            #     * `"title desc"`: By {::Google::Cloud::Talent::V4beta1::Job#title Job.title}
            #     descending.
            #     * `"annualized_base_compensation"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_base_compensation_range CompensationInfo.annualized_base_compensation_range}
            #       ascending. Jobs whose annualized base compensation is unspecified are put
            #       at the end of search results.
            #     * `"annualized_base_compensation desc"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_base_compensation_range CompensationInfo.annualized_base_compensation_range}
            #       descending. Jobs whose annualized base compensation is unspecified are
            #       put at the end of search results.
            #     * `"annualized_total_compensation"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_total_compensation_range CompensationInfo.annualized_total_compensation_range}
            #       ascending. Jobs whose annualized base compensation is unspecified are put
            #       at the end of search results.
            #     * `"annualized_total_compensation desc"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_total_compensation_range CompensationInfo.annualized_total_compensation_range}
            #       descending. Jobs whose annualized base compensation is unspecified are
            #       put at the end of search results.
            #     * `"custom_ranking desc"`: By the relevance score adjusted to the
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo#ranking_expression SearchJobsRequest.CustomRankingInfo.ranking_expression}
            #       with weight factor assigned by
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo#importance_level SearchJobsRequest.CustomRankingInfo.importance_level}
            #       in descending order.
            #     * Location sorting: Use the special syntax to order jobs by distance:<br>
            #       `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
            #       `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
            #       `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
            #       multiple locations. See details below.<br>
            #       `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
            #       multiple locations. See details below.<br>
            #       The string can have a maximum of 256 characters. When multiple distance
            #       centers are provided, a job that is close to any of the distance centers
            #       would have a high rank. When a job has multiple locations, the job
            #       location closest to one of the distance centers will be used. Jobs that
            #       don't have locations will be ranked at the bottom. Distance is calculated
            #       with a precision of 11.3 meters (37.4 feet). Diversification strategy is
            #       still applied unless explicitly disabled in
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#diversification_level diversification_level}.
            #   @param diversification_level [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::DiversificationLevel]
            #     Controls whether highly similar jobs are returned next to each other in
            #     the search results. Jobs are identified as highly similar based on
            #     their titles, job categories, and locations. Highly similar results are
            #     clustered so that only one representative job of the cluster is
            #     displayed to the job seeker higher up in the results, with the other jobs
            #     being displayed lower down in the results.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::DiversificationLevel::SIMPLE DiversificationLevel.SIMPLE}
            #     if no value is specified.
            #   @param custom_ranking_info [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo, ::Hash]
            #     Controls over how job documents get ranked on top of existing relevance
            #     score (determined by API algorithm).
            #   @param disable_keyword_match [::Boolean]
            #     This field is deprecated. Please use
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#keyword_match_mode SearchJobsRequest.keyword_match_mode}
            #     going forward.
            #
            #     To migrate, disable_keyword_match set to false maps to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_ALL KeywordMatchMode.KEYWORD_MATCH_ALL},
            #     and disable_keyword_match set to true maps to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_DISABLED KeywordMatchMode.KEYWORD_MATCH_DISABLED}.
            #     If
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#keyword_match_mode SearchJobsRequest.keyword_match_mode}
            #     is set, this field is ignored.
            #
            #     Controls whether to disable exact keyword match on
            #     {::Google::Cloud::Talent::V4beta1::Job#title Job.title},
            #     {::Google::Cloud::Talent::V4beta1::Job#description Job.description},
            #     {::Google::Cloud::Talent::V4beta1::Job#company_display_name Job.company_display_name},
            #     {::Google::Cloud::Talent::V4beta1::Job#addresses Job.addresses},
            #     {::Google::Cloud::Talent::V4beta1::Job#qualifications Job.qualifications}. When
            #     disable keyword match is turned off, a keyword match returns jobs that do
            #     not match given category filters when there are matching keywords. For
            #     example, for the query "program manager," a result is returned even if the
            #     job posting has the title "software developer," which doesn't fall into
            #     "program manager" ontology, but does have "program manager" appearing in
            #     its description.
            #
            #     For queries like "cloud" that don't contain title or
            #     location specific ontology, jobs with "cloud" keyword matches are returned
            #     regardless of this flag's value.
            #
            #     Use
            #     {::Google::Cloud::Talent::V4beta1::Company#keyword_searchable_job_custom_attributes Company.keyword_searchable_job_custom_attributes}
            #     if company-specific globally matched custom field/attribute string values
            #     are needed. Enabling keyword match improves recall of subsequent search
            #     requests.
            #
            #     Defaults to false.
            #   @param keyword_match_mode [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode]
            #     Controls what keyword match options to use.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_ALL KeywordMatchMode.KEYWORD_MATCH_ALL}
            #     if no value is specified.
            #   @param relevance_threshold [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::RelevanceThreshold]
            #     Optional. The relevance threshold of the search results.
            #
            #     Default to Google defined threshold, leveraging a balance of
            #     precision and recall to deliver both highly accurate results and
            #     comprehensive coverage of relevant information.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Talent::V4beta1::SearchJobsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Talent::V4beta1::SearchJobsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::SearchJobsRequest.new
            #
            #   # Call the search_jobs method.
            #   result = client.search_jobs request
            #
            #   # The returned object is of type Google::Cloud::Talent::V4beta1::SearchJobsResponse.
            #   p result
            #
            def search_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::SearchJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :search_jobs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches for jobs using the provided
            # {::Google::Cloud::Talent::V4beta1::SearchJobsRequest SearchJobsRequest}.
            #
            # This API call is intended for the use case of targeting passive job
            # seekers (for example, job seekers who have signed up to receive email
            # alerts about potential job opportunities), and has different algorithmic
            # adjustments that are targeted to passive job seekers.
            #
            # This call constrains the
            # {::Google::Cloud::Talent::V4beta1::Job#visibility visibility} of jobs present in
            # the database, and only returns jobs the caller has permission to search
            # against.
            #
            # @overload search_jobs_for_alert(request, options = nil)
            #   Pass arguments to `search_jobs_for_alert` via a request object, either of type
            #   {::Google::Cloud::Talent::V4beta1::SearchJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Talent::V4beta1::SearchJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_jobs_for_alert(parent: nil, search_mode: nil, request_metadata: nil, job_query: nil, enable_broadening: nil, require_precise_result_size: nil, histogram_queries: nil, job_view: nil, offset: nil, page_size: nil, page_token: nil, order_by: nil, diversification_level: nil, custom_ranking_info: nil, disable_keyword_match: nil, keyword_match_mode: nil, relevance_threshold: nil)
            #   Pass arguments to `search_jobs_for_alert` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the tenant to search within.
            #
            #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}". For example,
            #     "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
            #     is created. For example, "projects/foo".
            #   @param search_mode [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::SearchMode]
            #     Mode of a search.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::SearchMode::JOB_SEARCH SearchMode.JOB_SEARCH}.
            #   @param request_metadata [::Google::Cloud::Talent::V4beta1::RequestMetadata, ::Hash]
            #     Required. The meta information collected about the job searcher, used to
            #     improve the search quality of the service. The identifiers (such as
            #     `user_id`) are provided by users, and must be unique and consistent.
            #   @param job_query [::Google::Cloud::Talent::V4beta1::JobQuery, ::Hash]
            #     Query used to search against jobs, such as keyword, location filters, etc.
            #   @param enable_broadening [::Boolean]
            #     Controls whether to broaden the search when it produces sparse results.
            #     Broadened queries append results to the end of the matching results
            #     list.
            #
            #     Defaults to false.
            #   @param require_precise_result_size [::Boolean]
            #     This field is deprecated.
            #   @param histogram_queries [::Array<::Google::Cloud::Talent::V4beta1::HistogramQuery, ::Hash>]
            #     An expression specifies a histogram request against matching jobs.
            #
            #     Expression syntax is an aggregation function call with histogram facets and
            #     other options.
            #
            #     Available aggregation function calls are:
            #     * `count(string_histogram_facet)`: Count the number of matching entities,
            #     for each distinct attribute value.
            #     * `count(numeric_histogram_facet, list of buckets)`: Count the number of
            #     matching entities within each bucket.
            #
            #     A maximum of 200 histogram buckets are supported.
            #
            #     Data types:
            #
            #     * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
            #     * String: string like "any string with backslash escape for quote(\")."
            #     * Number: whole number and floating point number like 10, -1 and -0.01.
            #     * List: list of elements with comma(,) separator surrounded by square
            #     brackets, for example, [1, 2, 3] and ["one", "two", "three"].
            #
            #     Built-in constants:
            #
            #     * MIN (minimum number similar to java Double.MIN_VALUE)
            #     * MAX (maximum number similar to java Double.MAX_VALUE)
            #
            #     Built-in functions:
            #
            #     * bucket(start, end[, label]): bucket built-in function creates a bucket
            #     with range of [start, end). Note that the end is exclusive, for example,
            #     bucket(1, MAX, "positive number") or bucket(1, 10).
            #
            #     Job histogram facets:
            #
            #     * company_display_name: histogram by
            #     {::Google::Cloud::Talent::V4beta1::Job#company_display_name Job.company_display_name}.
            #     * employment_type: histogram by
            #     {::Google::Cloud::Talent::V4beta1::Job#employment_types Job.employment_types},
            #     for example,
            #       "FULL_TIME", "PART_TIME".
            #     * company_size (DEPRECATED): histogram by
            #     {::Google::Cloud::Talent::V4beta1::CompanySize CompanySize}, for example,
            #     "SMALL", "MEDIUM", "BIG".
            #     * publish_time_in_day: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in days.
            #       Must specify list of numeric buckets in spec.
            #     * publish_time_in_month: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in months.
            #       Must specify list of numeric buckets in spec.
            #     * publish_time_in_year: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       in years.
            #       Must specify list of numeric buckets in spec.
            #     * degree_types: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#degree_types Job.degree_types}, for
            #     example,
            #       "Bachelors", "Masters".
            #     * job_level: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#job_level Job.job_level}, for example,
            #     "Entry
            #       Level".
            #     * country: histogram by the country code of jobs, for example, "US", "FR".
            #     * admin1: histogram by the admin1 code of jobs, which is a global
            #       placeholder referring to the state, province, or the particular term a
            #       country uses to define the geographic structure below the country level,
            #       for example, "CA", "IL".
            #     * city: histogram by a combination of the "city name, admin1 code". For
            #       example,  "Mountain View, CA", "New York, NY".
            #     * admin1_country: histogram by a combination of the "admin1 code, country",
            #       for example, "CA, US", "IL, US".
            #     * city_coordinate: histogram by the city center's GPS coordinates (latitude
            #       and longitude), for example, 37.4038522,-122.0987765. Since the
            #       coordinates of a city center can change, customers may need to refresh
            #       them periodically.
            #     * locale: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::Job#language_code Job.language_code}, for
            #     example, "en-US",
            #       "fr-FR".
            #     * language: histogram by the language subtag of the
            #     {::Google::Cloud::Talent::V4beta1::Job#language_code Job.language_code},
            #       for example, "en", "fr".
            #     * category: histogram by the
            #     {::Google::Cloud::Talent::V4beta1::JobCategory JobCategory}, for example,
            #       "COMPUTER_AND_IT", "HEALTHCARE".
            #     * base_compensation_unit: histogram by the
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo::CompensationUnit CompensationInfo.CompensationUnit}
            #       of base salary, for example, "WEEKLY", "MONTHLY".
            #     * base_compensation: histogram by the base salary. Must specify list of
            #       numeric buckets to group results by.
            #     * annualized_base_compensation: histogram by the base annualized salary.
            #       Must specify list of numeric buckets to group results by.
            #     * annualized_total_compensation: histogram by the total annualized salary.
            #       Must specify list of numeric buckets to group results by.
            #     * string_custom_attribute: histogram by string
            #     {::Google::Cloud::Talent::V4beta1::Job#custom_attributes Job.custom_attributes}.
            #       Values can be accessed via square bracket notations like
            #       string_custom_attribute["key1"].
            #     * numeric_custom_attribute: histogram by numeric
            #     {::Google::Cloud::Talent::V4beta1::Job#custom_attributes Job.custom_attributes}.
            #       Values can be accessed via square bracket notations like
            #       numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
            #       group results by.
            #
            #     Example expressions:
            #
            #     * `count(admin1)`
            #     * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
            #     bucket(100000, MAX)])`
            #     * `count(string_custom_attribute["some-string-custom-attribute"])`
            #     * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
            #       [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
            #   @param job_view [::Google::Cloud::Talent::V4beta1::JobView]
            #     The desired job attributes returned for jobs in the search response.
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::JobView::JOB_VIEW_SMALL JobView.JOB_VIEW_SMALL}
            #     if no value is specified.
            #   @param offset [::Integer]
            #     An integer that specifies the current offset (that is, starting result
            #     location, amongst the jobs deemed by the API as relevant) in search
            #     results. This field is only considered if
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#page_token page_token} is
            #     unset.
            #
            #     The maximum allowed value is 5000. Otherwise an error is thrown.
            #
            #     For example, 0 means to  return results starting from the first matching
            #     job, and 10 means to return from the 11th job. This can be used for
            #     pagination, (for example, pageSize = 10 and offset = 10 means to return
            #     from the second page).
            #   @param page_size [::Integer]
            #     A limit on the number of jobs returned in the search results.
            #     Increasing this value above the default value of 10 can increase search
            #     response time. The value can be between 1 and 100.
            #   @param page_token [::String]
            #     The token specifying the current offset within
            #     search results. See
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsResponse#next_page_token SearchJobsResponse.next_page_token}
            #     for an explanation of how to obtain the next set of query results.
            #   @param order_by [::String]
            #     The criteria determining how search results are sorted. Default is
            #     `"relevance desc"`.
            #
            #     Supported options are:
            #
            #     * `"relevance desc"`: By relevance descending, as determined by the API
            #       algorithms. Relevance thresholding of query results is only available
            #       with this ordering.
            #     * `"posting_publish_time desc"`: By
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_publish_time Job.posting_publish_time}
            #       descending.
            #     * `"posting_update_time desc"`: By
            #     {::Google::Cloud::Talent::V4beta1::Job#posting_update_time Job.posting_update_time}
            #       descending.
            #     * `"title"`: By {::Google::Cloud::Talent::V4beta1::Job#title Job.title}
            #     ascending.
            #     * `"title desc"`: By {::Google::Cloud::Talent::V4beta1::Job#title Job.title}
            #     descending.
            #     * `"annualized_base_compensation"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_base_compensation_range CompensationInfo.annualized_base_compensation_range}
            #       ascending. Jobs whose annualized base compensation is unspecified are put
            #       at the end of search results.
            #     * `"annualized_base_compensation desc"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_base_compensation_range CompensationInfo.annualized_base_compensation_range}
            #       descending. Jobs whose annualized base compensation is unspecified are
            #       put at the end of search results.
            #     * `"annualized_total_compensation"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_total_compensation_range CompensationInfo.annualized_total_compensation_range}
            #       ascending. Jobs whose annualized base compensation is unspecified are put
            #       at the end of search results.
            #     * `"annualized_total_compensation desc"`: By job's
            #       {::Google::Cloud::Talent::V4beta1::CompensationInfo#annualized_total_compensation_range CompensationInfo.annualized_total_compensation_range}
            #       descending. Jobs whose annualized base compensation is unspecified are
            #       put at the end of search results.
            #     * `"custom_ranking desc"`: By the relevance score adjusted to the
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo#ranking_expression SearchJobsRequest.CustomRankingInfo.ranking_expression}
            #       with weight factor assigned by
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo#importance_level SearchJobsRequest.CustomRankingInfo.importance_level}
            #       in descending order.
            #     * Location sorting: Use the special syntax to order jobs by distance:<br>
            #       `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
            #       `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
            #       `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
            #       multiple locations. See details below.<br>
            #       `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
            #       multiple locations. See details below.<br>
            #       The string can have a maximum of 256 characters. When multiple distance
            #       centers are provided, a job that is close to any of the distance centers
            #       would have a high rank. When a job has multiple locations, the job
            #       location closest to one of the distance centers will be used. Jobs that
            #       don't have locations will be ranked at the bottom. Distance is calculated
            #       with a precision of 11.3 meters (37.4 feet). Diversification strategy is
            #       still applied unless explicitly disabled in
            #       {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#diversification_level diversification_level}.
            #   @param diversification_level [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::DiversificationLevel]
            #     Controls whether highly similar jobs are returned next to each other in
            #     the search results. Jobs are identified as highly similar based on
            #     their titles, job categories, and locations. Highly similar results are
            #     clustered so that only one representative job of the cluster is
            #     displayed to the job seeker higher up in the results, with the other jobs
            #     being displayed lower down in the results.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::DiversificationLevel::SIMPLE DiversificationLevel.SIMPLE}
            #     if no value is specified.
            #   @param custom_ranking_info [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::CustomRankingInfo, ::Hash]
            #     Controls over how job documents get ranked on top of existing relevance
            #     score (determined by API algorithm).
            #   @param disable_keyword_match [::Boolean]
            #     This field is deprecated. Please use
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#keyword_match_mode SearchJobsRequest.keyword_match_mode}
            #     going forward.
            #
            #     To migrate, disable_keyword_match set to false maps to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_ALL KeywordMatchMode.KEYWORD_MATCH_ALL},
            #     and disable_keyword_match set to true maps to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_DISABLED KeywordMatchMode.KEYWORD_MATCH_DISABLED}.
            #     If
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest#keyword_match_mode SearchJobsRequest.keyword_match_mode}
            #     is set, this field is ignored.
            #
            #     Controls whether to disable exact keyword match on
            #     {::Google::Cloud::Talent::V4beta1::Job#title Job.title},
            #     {::Google::Cloud::Talent::V4beta1::Job#description Job.description},
            #     {::Google::Cloud::Talent::V4beta1::Job#company_display_name Job.company_display_name},
            #     {::Google::Cloud::Talent::V4beta1::Job#addresses Job.addresses},
            #     {::Google::Cloud::Talent::V4beta1::Job#qualifications Job.qualifications}. When
            #     disable keyword match is turned off, a keyword match returns jobs that do
            #     not match given category filters when there are matching keywords. For
            #     example, for the query "program manager," a result is returned even if the
            #     job posting has the title "software developer," which doesn't fall into
            #     "program manager" ontology, but does have "program manager" appearing in
            #     its description.
            #
            #     For queries like "cloud" that don't contain title or
            #     location specific ontology, jobs with "cloud" keyword matches are returned
            #     regardless of this flag's value.
            #
            #     Use
            #     {::Google::Cloud::Talent::V4beta1::Company#keyword_searchable_job_custom_attributes Company.keyword_searchable_job_custom_attributes}
            #     if company-specific globally matched custom field/attribute string values
            #     are needed. Enabling keyword match improves recall of subsequent search
            #     requests.
            #
            #     Defaults to false.
            #   @param keyword_match_mode [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode]
            #     Controls what keyword match options to use.
            #
            #     Defaults to
            #     {::Google::Cloud::Talent::V4beta1::SearchJobsRequest::KeywordMatchMode::KEYWORD_MATCH_ALL KeywordMatchMode.KEYWORD_MATCH_ALL}
            #     if no value is specified.
            #   @param relevance_threshold [::Google::Cloud::Talent::V4beta1::SearchJobsRequest::RelevanceThreshold]
            #     Optional. The relevance threshold of the search results.
            #
            #     Default to Google defined threshold, leveraging a balance of
            #     precision and recall to deliver both highly accurate results and
            #     comprehensive coverage of relevant information.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Talent::V4beta1::SearchJobsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Talent::V4beta1::SearchJobsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/talent/v4beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Talent::V4beta1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Talent::V4beta1::SearchJobsRequest.new
            #
            #   # Call the search_jobs_for_alert method.
            #   result = client.search_jobs_for_alert request
            #
            #   # The returned object is of type Google::Cloud::Talent::V4beta1::SearchJobsResponse.
            #   p result
            #
            def search_jobs_for_alert request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4beta1::SearchJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_jobs_for_alert.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Talent::V4beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_jobs_for_alert.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_jobs_for_alert.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :search_jobs_for_alert, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the JobService API.
            #
            # This class represents the configuration for JobService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Talent::V4beta1::JobService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_job to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Talent::V4beta1::JobService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_job.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Talent::V4beta1::JobService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_job.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Talent::V4beta1::JobService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "jobs.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the JobService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_job
                ##
                # RPC-specific configuration for `batch_create_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_jobs
                ##
                # RPC-specific configuration for `get_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_job
                ##
                # RPC-specific configuration for `update_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_job
                ##
                # RPC-specific configuration for `batch_update_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_update_jobs
                ##
                # RPC-specific configuration for `delete_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_job
                ##
                # RPC-specific configuration for `batch_delete_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_delete_jobs
                ##
                # RPC-specific configuration for `list_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_jobs
                ##
                # RPC-specific configuration for `search_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_jobs
                ##
                # RPC-specific configuration for `search_jobs_for_alert`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_jobs_for_alert

                # @private
                def initialize parent_rpcs = nil
                  create_job_config = parent_rpcs.create_job if parent_rpcs.respond_to? :create_job
                  @create_job = ::Gapic::Config::Method.new create_job_config
                  batch_create_jobs_config = parent_rpcs.batch_create_jobs if parent_rpcs.respond_to? :batch_create_jobs
                  @batch_create_jobs = ::Gapic::Config::Method.new batch_create_jobs_config
                  get_job_config = parent_rpcs.get_job if parent_rpcs.respond_to? :get_job
                  @get_job = ::Gapic::Config::Method.new get_job_config
                  update_job_config = parent_rpcs.update_job if parent_rpcs.respond_to? :update_job
                  @update_job = ::Gapic::Config::Method.new update_job_config
                  batch_update_jobs_config = parent_rpcs.batch_update_jobs if parent_rpcs.respond_to? :batch_update_jobs
                  @batch_update_jobs = ::Gapic::Config::Method.new batch_update_jobs_config
                  delete_job_config = parent_rpcs.delete_job if parent_rpcs.respond_to? :delete_job
                  @delete_job = ::Gapic::Config::Method.new delete_job_config
                  batch_delete_jobs_config = parent_rpcs.batch_delete_jobs if parent_rpcs.respond_to? :batch_delete_jobs
                  @batch_delete_jobs = ::Gapic::Config::Method.new batch_delete_jobs_config
                  list_jobs_config = parent_rpcs.list_jobs if parent_rpcs.respond_to? :list_jobs
                  @list_jobs = ::Gapic::Config::Method.new list_jobs_config
                  search_jobs_config = parent_rpcs.search_jobs if parent_rpcs.respond_to? :search_jobs
                  @search_jobs = ::Gapic::Config::Method.new search_jobs_config
                  search_jobs_for_alert_config = parent_rpcs.search_jobs_for_alert if parent_rpcs.respond_to? :search_jobs_for_alert
                  @search_jobs_for_alert = ::Gapic::Config::Method.new search_jobs_for_alert_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
