# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Talent
      module V4
        # A Job resource represents a job posting (also referred to as a "job listing"
        # or "job requisition"). A job belongs to a
        # {::Google::Cloud::Talent::V4::Company Company}, which is the hiring entity
        # responsible for the job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required during job update.
        #
        #     The resource name for the job. This is generated by the service when a
        #     job is created.
        #
        #     The format is
        #     "projects/\\{project_id}/tenants/\\{tenant_id}/jobs/\\{job_id}". For
        #     example, "projects/foo/tenants/bar/jobs/baz".
        #
        #     Use of this field in job queries and API calls is preferred over the use of
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id} since this
        #     value is unique.
        # @!attribute [rw] company
        #   @return [::String]
        #     Required. The resource name of the company listing the job.
        #
        #     The format is
        #     "projects/\\{project_id}/tenants/\\{tenant_id}/companies/\\{company_id}". For
        #     example, "projects/foo/tenants/bar/companies/baz".
        # @!attribute [rw] requisition_id
        #   @return [::String]
        #     Required. The requisition ID, also referred to as the posting ID, is
        #     assigned by the client to identify a job. This field is intended to be used
        #     by clients for client identification and tracking of postings. A job isn't
        #     allowed to be created if there is another job with the same
        #     {::Google::Cloud::Talent::V4::Job#name company},
        #     {::Google::Cloud::Talent::V4::Job#language_code language_code} and
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id}.
        #
        #     The maximum number of allowed characters is 255.
        # @!attribute [rw] title
        #   @return [::String]
        #     Required. The title of the job, such as "Software Engineer"
        #
        #     The maximum number of allowed characters is 500.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. The description of the job, which typically includes a
        #     multi-paragraph description of the company and related information.
        #     Separate fields are provided on the job object for
        #     {::Google::Cloud::Talent::V4::Job#responsibilities responsibilities},
        #     {::Google::Cloud::Talent::V4::Job#qualifications qualifications}, and other job
        #     characteristics. Use of these separate job fields is recommended.
        #
        #     This field accepts and sanitizes HTML input, and also accepts
        #     bold, italic, ordered list, and unordered list markup tags.
        #
        #     The maximum number of allowed characters is 100,000.
        # @!attribute [rw] addresses
        #   @return [::Array<::String>]
        #     Strongly recommended for the best service experience.
        #
        #     Location(s) where the employer is looking to hire for this job posting.
        #
        #     Specifying the full street address(es) of the hiring location enables
        #     better API results, especially job searches by commute time.
        #
        #     At most 50 locations are allowed for best search performance. If a job has
        #     more locations, it is suggested to split it into multiple jobs with unique
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id}s (e.g. 'ReqA'
        #     becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
        #     {::Google::Cloud::Talent::V4::Job#company company},
        #     {::Google::Cloud::Talent::V4::Job#language_code language_code} and
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id} are not
        #     allowed. If the original
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id} must be
        #     preserved, a custom field should be used for storage. It is also suggested
        #     to group the locations that close to each other in the same job for better
        #     search experience.
        #
        #     Jobs with multiple addresses must have their addresses with the same
        #     {::Google::Cloud::Talent::V4::Location::LocationType LocationType} to allow
        #     location filtering to work properly. (For example, a Job with addresses
        #     "1600 Amphitheatre Parkway, Mountain View, CA, USA" and "London, UK" may
        #     not have location filters applied correctly at search time since the first
        #     is a
        #     {::Google::Cloud::Talent::V4::Location::LocationType::STREET_ADDRESS LocationType.STREET_ADDRESS}
        #     and the second is a
        #     {::Google::Cloud::Talent::V4::Location::LocationType::LOCALITY LocationType.LOCALITY}.)
        #     If a job needs to have multiple addresses, it is suggested to split it into
        #     multiple jobs with same LocationTypes.
        #
        #     The maximum number of allowed characters is 500.
        # @!attribute [rw] application_info
        #   @return [::Google::Cloud::Talent::V4::Job::ApplicationInfo]
        #     Job application information.
        # @!attribute [rw] job_benefits
        #   @return [::Array<::Google::Cloud::Talent::V4::JobBenefit>]
        #     The benefits included with the job.
        # @!attribute [rw] compensation_info
        #   @return [::Google::Cloud::Talent::V4::CompensationInfo]
        #     Job compensation information (a.k.a. "pay rate") i.e., the compensation
        #     that will paid to the employee.
        # @!attribute [rw] custom_attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Talent::V4::CustomAttribute}]
        #     A map of fields to hold both filterable and non-filterable custom job
        #     attributes that are not covered by the provided structured fields.
        #
        #     The keys of the map are strings up to 64 bytes and must match the
        #     pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
        #     KEY_1_LIKE_THIS.
        #
        #     At most 100 filterable and at most 100 unfilterable keys are supported.
        #     For filterable `string_values`, across all keys at most 200 values are
        #     allowed, with each string no more than 255 characters. For unfilterable
        #     `string_values`, the maximum total size of `string_values` across all keys
        #     is 50KB.
        # @!attribute [rw] degree_types
        #   @return [::Array<::Google::Cloud::Talent::V4::DegreeType>]
        #     The desired education degrees for the job, such as Bachelors, Masters.
        # @!attribute [rw] department
        #   @return [::String]
        #     The department or functional area within the company with the open
        #     position.
        #
        #     The maximum number of allowed characters is 255.
        # @!attribute [rw] employment_types
        #   @return [::Array<::Google::Cloud::Talent::V4::EmploymentType>]
        #     The employment type(s) of a job, for example,
        #     {::Google::Cloud::Talent::V4::EmploymentType::FULL_TIME full time} or
        #     {::Google::Cloud::Talent::V4::EmploymentType::PART_TIME part time}.
        # @!attribute [rw] incentives
        #   @return [::String]
        #     A description of bonus, commission, and other compensation
        #     incentives associated with the job not including salary or pay.
        #
        #     The maximum number of allowed characters is 10,000.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The language of the posting. This field is distinct from
        #     any requirements for fluency that are associated with the job.
        #
        #     Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
        #     For more information, see
        #     [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
        #     class="external" target="_blank" }.
        #
        #     If this field is unspecified and
        #     {::Google::Cloud::Talent::V4::Job#description Job.description} is present,
        #     detected language code based on
        #     {::Google::Cloud::Talent::V4::Job#description Job.description} is assigned,
        #     otherwise defaults to 'en_US'.
        # @!attribute [rw] job_level
        #   @return [::Google::Cloud::Talent::V4::JobLevel]
        #     The experience level associated with the job, such as "Entry Level".
        # @!attribute [rw] promotion_value
        #   @return [::Integer]
        #     A promotion value of the job, as determined by the client.
        #     The value determines the sort order of the jobs returned when searching for
        #     jobs using the featured jobs search call, with higher promotional values
        #     being returned first and ties being resolved by relevance sort. Only the
        #     jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
        #
        #     Default value is 0, and negative values are treated as 0.
        # @!attribute [rw] qualifications
        #   @return [::String]
        #     A description of the qualifications required to perform the
        #     job. The use of this field is recommended
        #     as an alternative to using the more general
        #     {::Google::Cloud::Talent::V4::Job#description description} field.
        #
        #     This field accepts and sanitizes HTML input, and also accepts
        #     bold, italic, ordered list, and unordered list markup tags.
        #
        #     The maximum number of allowed characters is 10,000.
        # @!attribute [rw] responsibilities
        #   @return [::String]
        #     A description of job responsibilities. The use of this field is
        #     recommended as an alternative to using the more general
        #     {::Google::Cloud::Talent::V4::Job#description description} field.
        #
        #     This field accepts and sanitizes HTML input, and also accepts
        #     bold, italic, ordered list, and unordered list markup tags.
        #
        #     The maximum number of allowed characters is 10,000.
        # @!attribute [rw] posting_region
        #   @return [::Google::Cloud::Talent::V4::PostingRegion]
        #     The job {::Google::Cloud::Talent::V4::PostingRegion PostingRegion} (for example,
        #     state, country) throughout which the job is available. If this field is
        #     set, a {::Google::Cloud::Talent::V4::LocationFilter LocationFilter} in a search
        #     query within the job region finds this job posting if an exact location
        #     match isn't specified. If this field is set to
        #     {::Google::Cloud::Talent::V4::PostingRegion::NATION PostingRegion.NATION} or
        #     {::Google::Cloud::Talent::V4::PostingRegion::ADMINISTRATIVE_AREA PostingRegion.ADMINISTRATIVE_AREA},
        #     setting job {::Google::Cloud::Talent::V4::Job#addresses Job.addresses} to the
        #     same location level as this field is strongly recommended.
        # @!attribute [rw] visibility
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Talent::V4::Visibility]
        #     Deprecated. The job is only visible to the owner.
        #
        #     The visibility of the job.
        #
        #     Defaults to
        #     {::Google::Cloud::Talent::V4::Visibility::ACCOUNT_ONLY Visibility.ACCOUNT_ONLY}
        #     if not specified.
        # @!attribute [rw] job_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start timestamp of the job in UTC time zone. Typically this field
        #     is used for contracting engagements. Invalid timestamps are ignored.
        # @!attribute [rw] job_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end timestamp of the job. Typically this field is used for contracting
        #     engagements. Invalid timestamps are ignored.
        # @!attribute [rw] posting_publish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp this job posting was most recently published. The default
        #     value is the time the request arrives at the server. Invalid timestamps are
        #     ignored.
        # @!attribute [rw] posting_expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Strongly recommended for the best service experience.
        #
        #     The expiration timestamp of the job. After this timestamp, the
        #     job is marked as expired, and it no longer appears in search results. The
        #     expired job can't be listed by the
        #     {::Google::Cloud::Talent::V4::JobService::Client#list_jobs ListJobs} API, but it can be
        #     retrieved with the {::Google::Cloud::Talent::V4::JobService::Client#get_job GetJob} API
        #     or updated with the
        #     {::Google::Cloud::Talent::V4::JobService::Client#update_job UpdateJob} API or deleted
        #     with the {::Google::Cloud::Talent::V4::JobService::Client#delete_job DeleteJob} API. An
        #     expired job can be updated and opened again by using a future expiration
        #     timestamp. Updating an expired job fails if there is another existing open
        #     job with same {::Google::Cloud::Talent::V4::Job#company company},
        #     {::Google::Cloud::Talent::V4::Job#language_code language_code} and
        #     {::Google::Cloud::Talent::V4::Job#requisition_id requisition_id}.
        #
        #     The expired jobs are retained in our system for 90 days. However, the
        #     overall expired job count cannot exceed 3 times the maximum number of
        #     open jobs over previous 7 days. If this threshold is exceeded,
        #     expired jobs are cleaned out in order of earliest expire time.
        #     Expired jobs are no longer accessible after they are cleaned
        #     out.
        #
        #     Invalid timestamps are ignored, and treated as expire time not provided.
        #
        #     If the timestamp is before the instant request is made, the job
        #     is treated as expired immediately on creation. This kind of job can
        #     not be updated. And when creating a job with past timestamp, the
        #     {::Google::Cloud::Talent::V4::Job#posting_publish_time posting_publish_time}
        #     must be set before
        #     {::Google::Cloud::Talent::V4::Job#posting_expire_time posting_expire_time}. The
        #     purpose of this feature is to allow other objects, such as
        #     {::Google::Cloud::Talent::V4::Job::ApplicationInfo ApplicationInfo}, to refer a
        #     job that didn't exist in the system prior to becoming expired. If you want
        #     to modify a job that was expired on creation, delete it and create a new
        #     one.
        #
        #     If this value isn't provided at the time of job creation or is invalid,
        #     the job posting expires after 30 days from the job's creation time. For
        #     example, if the job was created on 2017/01/01 13:00AM UTC with an
        #     unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
        #
        #     If this value isn't provided on job update, it depends on the field masks
        #     set by
        #     {::Google::Cloud::Talent::V4::UpdateJobRequest#update_mask UpdateJobRequest.update_mask}.
        #     If the field masks include
        #     {::Google::Cloud::Talent::V4::Job#job_end_time job_end_time}, or the masks are
        #     empty meaning that every field is updated, the job posting expires after 30
        #     days from the job's last update time. Otherwise the expiration date isn't
        #     updated.
        # @!attribute [r] posting_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this job posting was created.
        # @!attribute [r] posting_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this job posting was last updated.
        # @!attribute [r] company_display_name
        #   @return [::String]
        #     Output only. Display name of the company listing the job.
        # @!attribute [r] derived_info
        #   @return [::Google::Cloud::Talent::V4::Job::DerivedInfo]
        #     Output only. Derived details about the job posting.
        # @!attribute [rw] processing_options
        #   @return [::Google::Cloud::Talent::V4::Job::ProcessingOptions]
        #     Options for job processing.
        class Job
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Application related details of a job posting.
          # @!attribute [rw] emails
          #   @return [::Array<::String>]
          #     Use this field to specify email address(es) to which resumes or
          #     applications can be sent.
          #
          #     The maximum number of allowed characters for each entry is 255.
          # @!attribute [rw] instruction
          #   @return [::String]
          #     Use this field to provide instructions, such as "Mail your application
          #     to ...", that a candidate can follow to apply for the job.
          #
          #     This field accepts and sanitizes HTML input, and also accepts
          #     bold, italic, ordered list, and unordered list markup tags.
          #
          #     The maximum number of allowed characters is 3,000.
          # @!attribute [rw] uris
          #   @return [::Array<::String>]
          #     Use this URI field to direct an applicant to a website, for example to
          #     link to an online application form.
          #
          #     The maximum number of allowed characters for each entry is 2,000.
          class ApplicationInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Derived details about the job posting.
          # @!attribute [rw] locations
          #   @return [::Array<::Google::Cloud::Talent::V4::Location>]
          #     Structured locations of the job, resolved from
          #     {::Google::Cloud::Talent::V4::Job#addresses Job.addresses}.
          #
          #     {::Google::Cloud::Talent::V4::Job::DerivedInfo#locations locations} are exactly
          #     matched to {::Google::Cloud::Talent::V4::Job#addresses Job.addresses} in the
          #     same order.
          # @!attribute [rw] job_categories
          #   @return [::Array<::Google::Cloud::Talent::V4::JobCategory>]
          #     Job categories derived from {::Google::Cloud::Talent::V4::Job#title Job.title}
          #     and {::Google::Cloud::Talent::V4::Job#description Job.description}.
          class DerivedInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Options for job processing.
          # @!attribute [rw] disable_street_address_resolution
          #   @return [::Boolean]
          #     If set to `true`, the service does not attempt to resolve a
          #     more precise address for the job.
          # @!attribute [rw] html_sanitization
          #   @return [::Google::Cloud::Talent::V4::HtmlSanitization]
          #     Option for job HTML content sanitization. Applied fields are:
          #
          #     * description
          #     * applicationInfo.instruction
          #     * incentives
          #     * qualifications
          #     * responsibilities
          #
          #     HTML tags in these fields may be stripped if sanitiazation isn't
          #     disabled.
          #
          #     Defaults to
          #     {::Google::Cloud::Talent::V4::HtmlSanitization::SIMPLE_FORMATTING_ONLY HtmlSanitization.SIMPLE_FORMATTING_ONLY}.
          class ProcessingOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Talent::V4::CustomAttribute]
          class CustomAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
