# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/talent/v4/company_service_pb"
require "google/cloud/talent/v4/company_service/rest/service_stub"

module Google
  module Cloud
    module Talent
      module V4
        module CompanyService
          module Rest
            ##
            # REST client for the CompanyService service.
            #
            # A service that handles company management, including CRUD and enumeration.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "jobs.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :company_service_stub

              ##
              # Configure the CompanyService Client class.
              #
              # See {::Google::Cloud::Talent::V4::CompanyService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CompanyService clients
              #   ::Google::Cloud::Talent::V4::CompanyService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Talent", "V4"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_company.timeout = 30.0

                  default_config.rpcs.get_company.timeout = 30.0
                  default_config.rpcs.get_company.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_company.timeout = 30.0

                  default_config.rpcs.delete_company.timeout = 30.0
                  default_config.rpcs.delete_company.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_companies.timeout = 30.0
                  default_config.rpcs.list_companies.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CompanyService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Talent::V4::CompanyService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @company_service_stub.universe_domain
              end

              ##
              # Create a new CompanyService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Talent::V4::CompanyService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CompanyService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @company_service_stub = ::Google::Cloud::Talent::V4::CompanyService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @company_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @company_service_stub.logger
              end

              # Service calls

              ##
              # Creates a new company entity.
              #
              # @overload create_company(request, options = nil)
              #   Pass arguments to `create_company` via a request object, either of type
              #   {::Google::Cloud::Talent::V4::CreateCompanyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Talent::V4::CreateCompanyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_company(parent: nil, company: nil)
              #   Pass arguments to `create_company` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the tenant under which the company is created.
              #
              #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}", for example,
              #     "projects/foo/tenants/bar".
              #   @param company [::Google::Cloud::Talent::V4::Company, ::Hash]
              #     Required. The company to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Talent::V4::Company]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Talent::V4::Company]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/talent/v4"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Talent::V4::CreateCompanyRequest.new
              #
              #   # Call the create_company method.
              #   result = client.create_company request
              #
              #   # The returned object is of type Google::Cloud::Talent::V4::Company.
              #   p result
              #
              def create_company request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4::CreateCompanyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_company.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Talent::V4::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_company.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_company.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @company_service_stub.create_company request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves specified company.
              #
              # @overload get_company(request, options = nil)
              #   Pass arguments to `get_company` via a request object, either of type
              #   {::Google::Cloud::Talent::V4::GetCompanyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Talent::V4::GetCompanyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_company(name: nil)
              #   Pass arguments to `get_company` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the company to be retrieved.
              #
              #     The format is
              #     "projects/\\{project_id}/tenants/\\{tenant_id}/companies/\\{company_id}", for
              #     example, "projects/api-test-project/tenants/foo/companies/bar".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Talent::V4::Company]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Talent::V4::Company]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/talent/v4"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Talent::V4::GetCompanyRequest.new
              #
              #   # Call the get_company method.
              #   result = client.get_company request
              #
              #   # The returned object is of type Google::Cloud::Talent::V4::Company.
              #   p result
              #
              def get_company request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4::GetCompanyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_company.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Talent::V4::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_company.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_company.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @company_service_stub.get_company request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates specified company.
              #
              # @overload update_company(request, options = nil)
              #   Pass arguments to `update_company` via a request object, either of type
              #   {::Google::Cloud::Talent::V4::UpdateCompanyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Talent::V4::UpdateCompanyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_company(company: nil, update_mask: nil)
              #   Pass arguments to `update_company` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param company [::Google::Cloud::Talent::V4::Company, ::Hash]
              #     Required. The company resource to replace the current resource in the
              #     system.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Strongly recommended for the best service experience.
              #
              #     If {::Google::Cloud::Talent::V4::UpdateCompanyRequest#update_mask update_mask}
              #     is provided, only the specified fields in
              #     {::Google::Cloud::Talent::V4::UpdateCompanyRequest#company company} are updated.
              #     Otherwise all the fields are updated.
              #
              #     A field mask to specify the company fields to be updated. Only
              #     top level fields of {::Google::Cloud::Talent::V4::Company Company} are
              #     supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Talent::V4::Company]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Talent::V4::Company]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/talent/v4"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Talent::V4::UpdateCompanyRequest.new
              #
              #   # Call the update_company method.
              #   result = client.update_company request
              #
              #   # The returned object is of type Google::Cloud::Talent::V4::Company.
              #   p result
              #
              def update_company request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4::UpdateCompanyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_company.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Talent::V4::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_company.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_company.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @company_service_stub.update_company request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes specified company.
              # Prerequisite: The company has no jobs associated with it.
              #
              # @overload delete_company(request, options = nil)
              #   Pass arguments to `delete_company` via a request object, either of type
              #   {::Google::Cloud::Talent::V4::DeleteCompanyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Talent::V4::DeleteCompanyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_company(name: nil)
              #   Pass arguments to `delete_company` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the company to be deleted.
              #
              #     The format is
              #     "projects/\\{project_id}/tenants/\\{tenant_id}/companies/\\{company_id}", for
              #     example, "projects/foo/tenants/bar/companies/baz".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/talent/v4"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Talent::V4::DeleteCompanyRequest.new
              #
              #   # Call the delete_company method.
              #   result = client.delete_company request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_company request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4::DeleteCompanyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_company.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Talent::V4::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_company.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_company.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @company_service_stub.delete_company request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all companies associated with the project.
              #
              # @overload list_companies(request, options = nil)
              #   Pass arguments to `list_companies` via a request object, either of type
              #   {::Google::Cloud::Talent::V4::ListCompaniesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Talent::V4::ListCompaniesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_companies(parent: nil, page_token: nil, page_size: nil, require_open_jobs: nil)
              #   Pass arguments to `list_companies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the tenant under which the company is created.
              #
              #     The format is "projects/\\{project_id}/tenants/\\{tenant_id}", for example,
              #     "projects/foo/tenants/bar".
              #   @param page_token [::String]
              #     The starting indicator from which to return results.
              #   @param page_size [::Integer]
              #     The maximum number of companies to be returned, at most 100.
              #     Default is 100 if a non-positive number is provided.
              #   @param require_open_jobs [::Boolean]
              #     Set to true if the companies requested must have open jobs.
              #
              #     Defaults to false.
              #
              #     If true, at most
              #     {::Google::Cloud::Talent::V4::ListCompaniesRequest#page_size page_size} of
              #     companies are fetched, among which only those with open jobs are returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Talent::V4::Company>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Talent::V4::Company>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/talent/v4"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Talent::V4::CompanyService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Talent::V4::ListCompaniesRequest.new
              #
              #   # Call the list_companies method.
              #   result = client.list_companies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Talent::V4::Company.
              #     p item
              #   end
              #
              def list_companies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Talent::V4::ListCompaniesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_companies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Talent::V4::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_companies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_companies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @company_service_stub.list_companies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @company_service_stub, :list_companies, "companies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CompanyService REST API.
              #
              # This class represents the configuration for CompanyService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Talent::V4::CompanyService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_company to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Talent::V4::CompanyService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_company.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Talent::V4::CompanyService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_company.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "jobs.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CompanyService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_company`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_company
                  ##
                  # RPC-specific configuration for `get_company`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_company
                  ##
                  # RPC-specific configuration for `update_company`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_company
                  ##
                  # RPC-specific configuration for `delete_company`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_company
                  ##
                  # RPC-specific configuration for `list_companies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_companies

                  # @private
                  def initialize parent_rpcs = nil
                    create_company_config = parent_rpcs.create_company if parent_rpcs.respond_to? :create_company
                    @create_company = ::Gapic::Config::Method.new create_company_config
                    get_company_config = parent_rpcs.get_company if parent_rpcs.respond_to? :get_company
                    @get_company = ::Gapic::Config::Method.new get_company_config
                    update_company_config = parent_rpcs.update_company if parent_rpcs.respond_to? :update_company
                    @update_company = ::Gapic::Config::Method.new update_company_config
                    delete_company_config = parent_rpcs.delete_company if parent_rpcs.respond_to? :delete_company
                    @delete_company = ::Gapic::Config::Method.new delete_company_config
                    list_companies_config = parent_rpcs.list_companies if parent_rpcs.respond_to? :list_companies
                    @list_companies = ::Gapic::Config::Method.new list_companies_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
