# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/support/v2beta/case_service_pb"
require "google/cloud/support/v2beta/case_service"

class ::Google::Cloud::Support::V2beta::CaseService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::Case.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_case, name
      assert_kind_of ::Google::Cloud::Support::V2beta::GetCaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_case_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_case({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_case name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_case ::Google::Cloud::Support::V2beta::GetCaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_case({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_case(::Google::Cloud::Support::V2beta::GetCaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_case_client_stub.call_rpc_count
    end
  end

  def test_list_cases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::ListCasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    product_line = :PRODUCT_LINE_UNSPECIFIED

    list_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_cases, name
      assert_kind_of ::Google::Cloud::Support::V2beta::ListCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :PRODUCT_LINE_UNSPECIFIED, request["product_line"]
      assert request.has_product_line?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_cases({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_cases parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_cases ::Google::Cloud::Support::V2beta::ListCasesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_cases({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_cases(::Google::Cloud::Support::V2beta::ListCasesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_cases_client_stub.call_rpc_count
    end
  end

  def test_search_cases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::SearchCasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_cases, name
      assert_kind_of ::Google::Cloud::Support::V2beta::SearchCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_cases({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_cases parent: parent, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_cases ::Google::Cloud::Support::V2beta::SearchCasesRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_cases({ parent: parent, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_cases(::Google::Cloud::Support::V2beta::SearchCasesRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_cases_client_stub.call_rpc_count
    end
  end

  def test_create_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::Case.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    case_param = {}

    create_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_case, name
      assert_kind_of ::Google::Cloud::Support::V2beta::CreateCaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Support::V2beta::Case), request["case"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_case_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_case({ parent: parent, case: case_param }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_case parent: parent, case: case_param do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_case ::Google::Cloud::Support::V2beta::CreateCaseRequest.new(parent: parent, case: case_param) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_case({ parent: parent, case: case_param }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_case(::Google::Cloud::Support::V2beta::CreateCaseRequest.new(parent: parent, case: case_param), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_case_client_stub.call_rpc_count
    end
  end

  def test_update_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::Case.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    case_param = {}
    update_mask = {}

    update_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_case, name
      assert_kind_of ::Google::Cloud::Support::V2beta::UpdateCaseRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Support::V2beta::Case), request["case"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_case_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_case({ case: case_param, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_case case: case_param, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_case ::Google::Cloud::Support::V2beta::UpdateCaseRequest.new(case: case_param, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_case({ case: case_param, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_case(::Google::Cloud::Support::V2beta::UpdateCaseRequest.new(case: case_param, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_case_client_stub.call_rpc_count
    end
  end

  def test_escalate_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::Case.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    escalation = {}

    escalate_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :escalate_case, name
      assert_kind_of ::Google::Cloud::Support::V2beta::EscalateCaseRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Support::V2beta::Escalation), request["escalation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, escalate_case_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.escalate_case({ name: name, escalation: escalation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.escalate_case name: name, escalation: escalation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.escalate_case ::Google::Cloud::Support::V2beta::EscalateCaseRequest.new(name: name, escalation: escalation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.escalate_case({ name: name, escalation: escalation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.escalate_case(::Google::Cloud::Support::V2beta::EscalateCaseRequest.new(name: name, escalation: escalation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, escalate_case_client_stub.call_rpc_count
    end
  end

  def test_close_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::Case.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    close_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :close_case, name
      assert_kind_of ::Google::Cloud::Support::V2beta::CloseCaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, close_case_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.close_case({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.close_case name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.close_case ::Google::Cloud::Support::V2beta::CloseCaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.close_case({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.close_case(::Google::Cloud::Support::V2beta::CloseCaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, close_case_client_stub.call_rpc_count
    end
  end

  def test_search_case_classifications
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Support::V2beta::SearchCaseClassificationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    product = {}

    search_case_classifications_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_case_classifications, name
      assert_kind_of ::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest, request
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Support::V2beta::Product), request["product"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_case_classifications_client_stub do
      # Create client
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_case_classifications({ query: query, page_size: page_size, page_token: page_token, product: product }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_case_classifications query: query, page_size: page_size, page_token: page_token, product: product do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_case_classifications ::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest.new(query: query, page_size: page_size, page_token: page_token, product: product) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_case_classifications({ query: query, page_size: page_size, page_token: page_token, product: product }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_case_classifications(::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest.new(query: query, page_size: page_size, page_token: page_token, product: product), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_case_classifications_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Support::V2beta::CaseService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Support::V2beta::CaseService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Support::V2beta::CaseService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
