# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/support/v2beta/case_service_pb"
require "google/cloud/support/v2beta/case_service/rest"


class ::Google::Cloud::Support::V2beta::CaseService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_case
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::Case.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_get_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_case_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_case({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_case name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_case ::Google::Cloud::Support::V2beta::GetCaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_case({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_case(::Google::Cloud::Support::V2beta::GetCaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_case_client_stub.call_count
      end
    end
  end

  def test_list_cases
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::ListCasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    product_line = :PRODUCT_LINE_UNSPECIFIED

    list_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_list_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_cases({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_cases parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_cases ::Google::Cloud::Support::V2beta::ListCasesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_cases({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_cases(::Google::Cloud::Support::V2beta::ListCasesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, product_line: product_line), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_cases_client_stub.call_count
      end
    end
  end

  def test_search_cases
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::SearchCasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_search_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_cases({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_cases parent: parent, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_cases ::Google::Cloud::Support::V2beta::SearchCasesRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_cases({ parent: parent, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_cases(::Google::Cloud::Support::V2beta::SearchCasesRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_cases_client_stub.call_count
      end
    end
  end

  def test_create_case
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::Case.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    case_param = {}

    create_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_create_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_case_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_case({ parent: parent, case: case_param }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_case parent: parent, case: case_param do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_case ::Google::Cloud::Support::V2beta::CreateCaseRequest.new(parent: parent, case: case_param) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_case({ parent: parent, case: case_param }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_case(::Google::Cloud::Support::V2beta::CreateCaseRequest.new(parent: parent, case: case_param), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_case_client_stub.call_count
      end
    end
  end

  def test_update_case
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::Case.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    case_param = {}
    update_mask = {}

    update_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_update_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_case_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_case({ case: case_param, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_case case: case_param, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_case ::Google::Cloud::Support::V2beta::UpdateCaseRequest.new(case: case_param, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_case({ case: case_param, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_case(::Google::Cloud::Support::V2beta::UpdateCaseRequest.new(case: case_param, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_case_client_stub.call_count
      end
    end
  end

  def test_escalate_case
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::Case.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    escalation = {}

    escalate_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_escalate_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, escalate_case_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.escalate_case({ name: name, escalation: escalation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.escalate_case name: name, escalation: escalation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.escalate_case ::Google::Cloud::Support::V2beta::EscalateCaseRequest.new(name: name, escalation: escalation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.escalate_case({ name: name, escalation: escalation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.escalate_case(::Google::Cloud::Support::V2beta::EscalateCaseRequest.new(name: name, escalation: escalation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, escalate_case_client_stub.call_count
      end
    end
  end

  def test_close_case
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::Case.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    close_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_close_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, close_case_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.close_case({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.close_case name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.close_case ::Google::Cloud::Support::V2beta::CloseCaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.close_case({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.close_case(::Google::Cloud::Support::V2beta::CloseCaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, close_case_client_stub.call_count
      end
    end
  end

  def test_search_case_classifications
    # Create test objects.
    client_result = ::Google::Cloud::Support::V2beta::SearchCaseClassificationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    product = {}

    search_case_classifications_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.stub :transcode_search_case_classifications_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_case_classifications_client_stub do
        # Create client
        client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_case_classifications({ query: query, page_size: page_size, page_token: page_token, product: product }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_case_classifications query: query, page_size: page_size, page_token: page_token, product: product do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_case_classifications ::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest.new(query: query, page_size: page_size, page_token: page_token, product: product) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_case_classifications({ query: query, page_size: page_size, page_token: page_token, product: product }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_case_classifications(::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest.new(query: query, page_size: page_size, page_token: page_token, product: product), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_case_classifications_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Support::V2beta::CaseService::Rest::Client::Configuration, config
  end
end
