# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2beta
        # The request message for the ShowFeed endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the case for which feed items should be
        #     listed.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to order feed items by, followed by `asc` or `desc`
        #     postfix. The only valid field is
        #     `creation_time`. This list is case-insensitive, default sorting order is
        #     ascending, and the redundant space characters are insignificant.
        #
        #     Example: `creation_time desc`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of feed items fetched with each request.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying the page of results to return. If
        #     unspecified, it retrieves the first page.
        class ShowFeedRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the ShowFeed endpoint.
        # @!attribute [rw] feed_items
        #   @return [::Array<::Google::Cloud::Support::V2beta::FeedItem>]
        #     The list of feed items associated with the given Case.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. This should be set in the
        #     `page_token` field of subsequent `ShowFeedRequests`.
        #     If unspecified, there are no more results to retrieve.
        class ShowFeedResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
