# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2beta
        # A feed item associated with a support case.
        # @!attribute [r] comment
        #   @return [::Google::Cloud::Support::V2beta::Comment]
        #     Output only. A comment added to the case.
        #
        #     Note: The following fields are mutually exclusive: `comment`, `attachment`, `email_message`, `deleted_attachment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] attachment
        #   @return [::Google::Cloud::Support::V2beta::Attachment]
        #     Output only. An attachment attached to the case.
        #
        #     Note: The following fields are mutually exclusive: `attachment`, `comment`, `email_message`, `deleted_attachment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] email_message
        #   @return [::Google::Cloud::Support::V2beta::EmailMessage]
        #     Output only. An email message received in reply to the case.
        #
        #     Note: The following fields are mutually exclusive: `email_message`, `comment`, `attachment`, `deleted_attachment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] deleted_attachment
        #   @return [::Google::Cloud::Support::V2beta::Attachment]
        #     Output only. A deleted attachment that used to be associated with the
        #     support case.
        #
        #     Note: The following fields are mutually exclusive: `deleted_attachment`, `comment`, `attachment`, `email_message`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time corresponding to the event of this item.
        class FeedItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
