# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2beta
        # A comment associated with a support case.
        #
        # Case comments are the primary way for Google Support to communicate with a
        # user who has opened a case. When a user responds to Google Support, the
        # user's responses also appear as comments.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the comment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the comment was created.
        # @!attribute [r] creator
        #   @return [::Google::Cloud::Support::V2beta::Actor]
        #     Output only. The user or Google Support agent who created the comment.
        # @!attribute [rw] body
        #   @return [::String]
        #     The full comment body.
        #
        #     Maximum of 12800 characters.
        # @!attribute [r] plain_text_body
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. DEPRECATED. DO NOT USE.
        #
        #     A duplicate of the `body` field.
        #
        #     This field is only present for legacy reasons.
        class Comment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
