# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2beta
        # The request message for the ListAttachments endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the case for which attachments should be listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of attachments fetched with each request.
        #
        #     If not provided, the default is 10. The maximum page size that will be
        #     returned is 100.
        #
        #     The size of each page can be smaller than the requested page size and can
        #     include zero. For example, you could request 100 attachments on one page,
        #     receive 0, and then on the next page, receive 90.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying the page of results to return. If unspecified, the
        #     first page is retrieved.
        class ListAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting an attachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attachment to get.
        class GetAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the ListAttachments endpoint.
        # @!attribute [rw] attachments
        #   @return [::Array<::Google::Cloud::Support::V2beta::Attachment>]
        #     The list of attachments associated with a case.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. Set this in the `page_token`
        #     field of subsequent `cases.attachments.list` requests. If unspecified,
        #     there are no more results to retrieve.
        class ListAttachmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
