# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2beta
        # An Attachment contains metadata about a file that was uploaded to a
        # case - it is NOT a file itself. That being said, the name of an Attachment
        # object can be used to download its accompanying file through the
        # `media.download` endpoint.
        #
        # While attachments can be uploaded in the console at the
        # same time as a comment, they're associated on a "case" level, not a
        # "comment" level.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the attachment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the attachment was created.
        # @!attribute [r] creator
        #   @return [::Google::Cloud::Support::V2beta::Actor]
        #     Output only. The user who uploaded the attachment. Note, the name and email
        #     will be obfuscated if the attachment was uploaded by Google support.
        # @!attribute [rw] filename
        #   @return [::String]
        #     The filename of the attachment (e.g. `"graph.jpg"`).
        # @!attribute [r] mime_type
        #   @return [::String]
        #     Output only. The MIME type of the attachment (e.g. text/plain).
        # @!attribute [r] size_bytes
        #   @return [::Integer]
        #     Output only. The size of the attachment in bytes.
        class Attachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
