# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/support/v2beta/case_service_pb"
require "google/cloud/support/v2beta/case_service/rest/service_stub"

module Google
  module Cloud
    module Support
      module V2beta
        module CaseService
          module Rest
            ##
            # REST client for the CaseService service.
            #
            # A service to manage Google Cloud support cases.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudsupport.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :case_service_stub

              ##
              # Configure the CaseService Client class.
              #
              # See {::Google::Cloud::Support::V2beta::CaseService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CaseService clients
              #   ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Support", "V2beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.get_case.timeout = 60.0
                  default_config.rpcs.get_case.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_cases.timeout = 60.0
                  default_config.rpcs.list_cases.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.search_cases.timeout = 60.0
                  default_config.rpcs.search_cases.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_case.timeout = 60.0

                  default_config.rpcs.update_case.timeout = 60.0

                  default_config.rpcs.escalate_case.timeout = 60.0

                  default_config.rpcs.close_case.timeout = 60.0

                  default_config.rpcs.search_case_classifications.timeout = 60.0
                  default_config.rpcs.search_case_classifications.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CaseService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Support::V2beta::CaseService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @case_service_stub.universe_domain
              end

              ##
              # Create a new CaseService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CaseService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @case_service_stub = ::Google::Cloud::Support::V2beta::CaseService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @case_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @case_service_stub.logger
              end

              # Service calls

              ##
              # Retrieve a case.
              #
              # @overload get_case(request, options = nil)
              #   Pass arguments to `get_case` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::GetCaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::GetCaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_case(name: nil)
              #   Pass arguments to `get_case` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full name of a case to be retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Support::V2beta::Case]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Support::V2beta::Case]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::GetCaseRequest.new
              #
              #   # Call the get_case method.
              #   result = client.get_case request
              #
              #   # The returned object is of type Google::Cloud::Support::V2beta::Case.
              #   p result
              #
              def get_case request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::GetCaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_case.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_case.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_case.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.get_case request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieve all cases under a parent, but not its children.
              #
              # For example, listing cases under an organization only returns the cases
              # that are directly parented by that organization. To retrieve cases
              # under an organization and its projects, use `cases.search`.
              #
              # @overload list_cases(request, options = nil)
              #   Pass arguments to `list_cases` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::ListCasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::ListCasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cases(parent: nil, filter: nil, page_size: nil, page_token: nil, product_line: nil)
              #   Pass arguments to `list_cases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of a parent to list cases under.
              #   @param filter [::String]
              #     An expression used to filter cases.
              #
              #     If it's an empty string, then no filtering happens. Otherwise, the endpoint
              #     returns the cases that match the filter.
              #
              #     Expressions use the following fields separated by `AND` and specified with
              #     `=`:
              #
              #     - `state`: Can be `OPEN` or `CLOSED`.
              #     - `priority`: Can be `P0`, `P1`, `P2`, `P3`, or `P4`. You
              #     can specify multiple values for priority using the `OR` operator. For
              #     example, `priority=P1 OR priority=P2`.
              #     - `creator.email`: The email address of the case creator.
              #
              #     EXAMPLES:
              #
              #     - `state=CLOSED`
              #     - `state=OPEN AND creator.email="tester@example.com"`
              #     - `state=OPEN AND (priority=P0 OR priority=P1)`
              #   @param page_size [::Integer]
              #     The maximum number of cases fetched with each request. Defaults to 10.
              #   @param page_token [::String]
              #     A token identifying the page of results to return. If unspecified, the
              #     first page is retrieved.
              #   @param product_line [::Google::Cloud::Support::V2beta::ProductLine]
              #     The product line to request cases for. If unspecified, only
              #     Google Cloud cases will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::Case>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::Case>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::ListCasesRequest.new
              #
              #   # Call the list_cases method.
              #   result = client.list_cases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Support::V2beta::Case.
              #     p item
              #   end
              #
              def list_cases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::ListCasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.list_cases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @case_service_stub, :list_cases, "cases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Search for cases using a query.
              #
              # @overload search_cases(request, options = nil)
              #   Pass arguments to `search_cases` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::SearchCasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::SearchCasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_cases(parent: nil, query: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_cases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The name of the parent resource to search for cases under.
              #   @param query [::String]
              #     An expression used to filter cases.
              #
              #     Expressions use the following fields separated by `AND` and specified with
              #     `=`:
              #
              #     - `organization`: An organization name in the form
              #     `organizations/<organization_id>`.
              #     - `project`: A project name in the form `projects/<project_id>`.
              #     - `state`: Can be `OPEN` or `CLOSED`.
              #     - `priority`: Can be `P0`, `P1`, `P2`, `P3`, or `P4`. You
              #     can specify multiple values for priority using the `OR` operator. For
              #     example, `priority=P1 OR priority=P2`.
              #     - `creator.email`: The email address of the case creator.
              #
              #     You must specify either `organization` or `project`.
              #
              #     To search across `displayName`, `description`, and comments, use a global
              #     restriction with no keyword or operator. For example, `"my search"`.
              #
              #     To search only cases updated after a certain date, use `update_time`
              #     restricted with that particular date, time, and timezone in ISO datetime
              #     format. For example, `update_time>"2020-01-01T00:00:00-05:00"`.
              #     `update_time` only supports the greater than operator (`>`).
              #
              #     Examples:
              #
              #     - `organization="organizations/123456789"`
              #     - `project="projects/my-project-id"`
              #     - `project="projects/123456789"`
              #     - `organization="organizations/123456789" AND state=CLOSED`
              #     - `project="projects/my-project-id" AND creator.email="tester@example.com"`
              #     - `project="projects/my-project-id" AND (priority=P0 OR priority=P1)`
              #   @param page_size [::Integer]
              #     The maximum number of cases fetched with each request. The default page
              #     size is 10.
              #   @param page_token [::String]
              #     A token identifying the page of results to return. If unspecified, the
              #     first page is retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::Case>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::Case>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::SearchCasesRequest.new
              #
              #   # Call the search_cases method.
              #   result = client.search_cases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Support::V2beta::Case.
              #     p item
              #   end
              #
              def search_cases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::SearchCasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_cases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_cases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_cases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.search_cases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @case_service_stub, :search_cases, "cases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a new case and associate it with a parent.
              #
              # It must have the following fields set: `display_name`, `description`,
              # `classification`, and `priority`. If you're just testing the API and don't
              # want to route your case to an agent, set `testCase=true`.
              #
              # @overload create_case(request, options = nil)
              #   Pass arguments to `create_case` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::CreateCaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::CreateCaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_case(parent: nil, case: nil)
              #   Pass arguments to `create_case` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent under which the case should be created.
              #   @param case [::Google::Cloud::Support::V2beta::Case, ::Hash]
              #     Required. The case to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Support::V2beta::Case]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Support::V2beta::Case]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::CreateCaseRequest.new
              #
              #   # Call the create_case method.
              #   result = client.create_case request
              #
              #   # The returned object is of type Google::Cloud::Support::V2beta::Case.
              #   p result
              #
              def create_case request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::CreateCaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_case.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_case.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_case.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.create_case request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a case. Only some fields can be updated.
              #
              # @overload update_case(request, options = nil)
              #   Pass arguments to `update_case` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::UpdateCaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::UpdateCaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_case(case: nil, update_mask: nil)
              #   Pass arguments to `update_case` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param case [::Google::Cloud::Support::V2beta::Case, ::Hash]
              #     Required. The case to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     A list of attributes of the case that should be updated. Supported values
              #     are `priority`, `display_name`, and `subscriber_email_addresses`. If no
              #     fields are specified, all supported fields are updated.
              #
              #     Be careful - if you do not provide a field mask, then you might
              #     accidentally clear some fields. For example, if you leave the field mask
              #     empty and do not provide a value for `subscriber_email_addresses`, then
              #     `subscriber_email_addresses` is updated to empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Support::V2beta::Case]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Support::V2beta::Case]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::UpdateCaseRequest.new
              #
              #   # Call the update_case method.
              #   result = client.update_case request
              #
              #   # The returned object is of type Google::Cloud::Support::V2beta::Case.
              #   p result
              #
              def update_case request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::UpdateCaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_case.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_case.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_case.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.update_case request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Escalate a case, starting the Google Cloud Support escalation management
              # process.
              #
              # This operation is only available for some support services. Go to
              # https://cloud.google.com/support and look for 'Technical support
              # escalations' in the feature list to find out which ones let you
              # do that.
              #
              # @overload escalate_case(request, options = nil)
              #   Pass arguments to `escalate_case` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::EscalateCaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::EscalateCaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload escalate_case(name: nil, escalation: nil)
              #   Pass arguments to `escalate_case` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the case to be escalated.
              #   @param escalation [::Google::Cloud::Support::V2beta::Escalation, ::Hash]
              #     The escalation information to be sent with the escalation request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Support::V2beta::Case]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Support::V2beta::Case]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::EscalateCaseRequest.new
              #
              #   # Call the escalate_case method.
              #   result = client.escalate_case request
              #
              #   # The returned object is of type Google::Cloud::Support::V2beta::Case.
              #   p result
              #
              def escalate_case request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::EscalateCaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.escalate_case.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.escalate_case.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.escalate_case.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.escalate_case request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Close a case.
              #
              # @overload close_case(request, options = nil)
              #   Pass arguments to `close_case` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::CloseCaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::CloseCaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload close_case(name: nil)
              #   Pass arguments to `close_case` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the case to close.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Support::V2beta::Case]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Support::V2beta::Case]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::CloseCaseRequest.new
              #
              #   # Call the close_case method.
              #   result = client.close_case request
              #
              #   # The returned object is of type Google::Cloud::Support::V2beta::Case.
              #   p result
              #
              def close_case request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::CloseCaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.close_case.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.close_case.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.close_case.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.close_case request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieve valid classifications to use when creating a support case.
              #
              # Classifications are hierarchical. Each classification is a string
              # containing all levels of the hierarchy separated by `" > "`. For example,
              # `"Technical Issue > Compute > Compute Engine"`.
              #
              # Classification IDs returned by this endpoint are valid for at least six
              # months. When a classification is deactivated, this endpoint immediately
              # stops returning it. After six months, `case.create` requests using the
              # classification will fail.
              #
              # @overload search_case_classifications(request, options = nil)
              #   Pass arguments to `search_case_classifications` via a request object, either of type
              #   {::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_case_classifications(query: nil, page_size: nil, page_token: nil, product: nil)
              #   Pass arguments to `search_case_classifications` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param query [::String]
              #     An expression used to filter case classifications.
              #
              #     If it's an empty string, then no filtering happens. Otherwise, case
              #     classifications will be returned that match the filter.
              #   @param page_size [::Integer]
              #     The maximum number of classifications fetched with each request.
              #   @param page_token [::String]
              #     A token identifying the page of results to return. If unspecified, the
              #     first page is retrieved.
              #   @param product [::Google::Cloud::Support::V2beta::Product, ::Hash]
              #     Optional. The product to return case classifications for.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::CaseClassification>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Support::V2beta::CaseClassification>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/support/v2beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Support::V2beta::CaseService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest.new
              #
              #   # Call the search_case_classifications method.
              #   result = client.search_case_classifications request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Support::V2beta::CaseClassification.
              #     p item
              #   end
              #
              def search_case_classifications request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Support::V2beta::SearchCaseClassificationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_case_classifications.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Support::V2beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_case_classifications.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_case_classifications.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @case_service_stub.search_case_classifications request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @case_service_stub, :search_case_classifications, "case_classifications", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CaseService REST API.
              #
              # This class represents the configuration for CaseService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Support::V2beta::CaseService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_case to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_case.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Support::V2beta::CaseService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_case.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudsupport.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CaseService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_case`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_case
                  ##
                  # RPC-specific configuration for `list_cases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cases
                  ##
                  # RPC-specific configuration for `search_cases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_cases
                  ##
                  # RPC-specific configuration for `create_case`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_case
                  ##
                  # RPC-specific configuration for `update_case`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_case
                  ##
                  # RPC-specific configuration for `escalate_case`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :escalate_case
                  ##
                  # RPC-specific configuration for `close_case`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :close_case
                  ##
                  # RPC-specific configuration for `search_case_classifications`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_case_classifications

                  # @private
                  def initialize parent_rpcs = nil
                    get_case_config = parent_rpcs.get_case if parent_rpcs.respond_to? :get_case
                    @get_case = ::Gapic::Config::Method.new get_case_config
                    list_cases_config = parent_rpcs.list_cases if parent_rpcs.respond_to? :list_cases
                    @list_cases = ::Gapic::Config::Method.new list_cases_config
                    search_cases_config = parent_rpcs.search_cases if parent_rpcs.respond_to? :search_cases
                    @search_cases = ::Gapic::Config::Method.new search_cases_config
                    create_case_config = parent_rpcs.create_case if parent_rpcs.respond_to? :create_case
                    @create_case = ::Gapic::Config::Method.new create_case_config
                    update_case_config = parent_rpcs.update_case if parent_rpcs.respond_to? :update_case
                    @update_case = ::Gapic::Config::Method.new update_case_config
                    escalate_case_config = parent_rpcs.escalate_case if parent_rpcs.respond_to? :escalate_case
                    @escalate_case = ::Gapic::Config::Method.new escalate_case_config
                    close_case_config = parent_rpcs.close_case if parent_rpcs.respond_to? :close_case
                    @close_case = ::Gapic::Config::Method.new close_case_config
                    search_case_classifications_config = parent_rpcs.search_case_classifications if parent_rpcs.respond_to? :search_case_classifications
                    @search_case_classifications = ::Gapic::Config::Method.new search_case_classifications_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
