# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2
        # An escalation of a support case.
        # @!attribute [rw] reason
        #   @return [::Google::Cloud::Support::V2::Escalation::Reason]
        #     Required. The reason why the Case is being escalated.
        # @!attribute [rw] justification
        #   @return [::String]
        #     Required. A free text description to accompany the `reason` field above.
        #     Provides additional context on why the case is being escalated.
        class Escalation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An enum detailing the possible reasons a case may be escalated.
          module Reason
            # The escalation reason is in an unknown state or has not been specified.
            REASON_UNSPECIFIED = 0

            # The case is taking too long to resolve.
            RESOLUTION_TIME = 1

            # The support agent does not have the expertise required to successfully
            # resolve the issue.
            TECHNICAL_EXPERTISE = 2

            # The issue is having a significant business impact.
            BUSINESS_IMPACT = 3
          end
        end
      end
    end
  end
end
