# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Support
      module V2
        # The request message for the GetCase endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full name of a case to be retrieved.
        class GetCaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the CreateCase endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent under which the case should be created.
        # @!attribute [rw] case
        #   @return [::Google::Cloud::Support::V2::Case]
        #     Required. The case to be created.
        class CreateCaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the ListCases endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of a parent to list cases under.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression used to filter cases.
        #
        #     If it's an empty string, then no filtering happens. Otherwise, the endpoint
        #     returns the cases that match the filter.
        #
        #     Expressions use the following fields separated by `AND` and specified with
        #     `=`:
        #
        #     - `state`: Can be `OPEN` or `CLOSED`.
        #     - `priority`: Can be `P0`, `P1`, `P2`, `P3`, or `P4`. You
        #     can specify multiple values for priority using the `OR` operator. For
        #     example, `priority=P1 OR priority=P2`.
        #     - `creator.email`: The email address of the case creator.
        #
        #     EXAMPLES:
        #
        #     - `state=CLOSED`
        #     - `state=OPEN AND creator.email="tester@example.com"`
        #     - `state=OPEN AND (priority=P0 OR priority=P1)`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of cases fetched with each request. Defaults to 10.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying the page of results to return. If unspecified, the
        #     first page is retrieved.
        class ListCasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the ListCases endpoint.
        # @!attribute [rw] cases
        #   @return [::Array<::Google::Cloud::Support::V2::Case>]
        #     The list of cases associated with the parent after any
        #     filters have been applied.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. Set this in the `page_token`
        #     field of subsequent `cases.list` requests. If unspecified, there are no
        #     more results to retrieve.
        class ListCasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the SearchCases endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The name of the parent resource to search for cases under.
        # @!attribute [rw] query
        #   @return [::String]
        #     An expression used to filter cases.
        #
        #     Expressions use the following fields separated by `AND` and specified with
        #     `=`:
        #
        #     - `organization`: An organization name in the form
        #     `organizations/<organization_id>`.
        #     - `project`: A project name in the form `projects/<project_id>`.
        #     - `state`: Can be `OPEN` or `CLOSED`.
        #     - `priority`: Can be `P0`, `P1`, `P2`, `P3`, or `P4`. You
        #     can specify multiple values for priority using the `OR` operator. For
        #     example, `priority=P1 OR priority=P2`.
        #     - `creator.email`: The email address of the case creator.
        #
        #     You must specify either `organization` or `project`.
        #
        #     To search across `displayName`, `description`, and comments, use a global
        #     restriction with no keyword or operator. For example, `"my search"`.
        #
        #     To search only cases updated after a certain date, use `update_time`
        #     restricted with that particular date, time, and timezone in ISO datetime
        #     format. For example, `update_time>"2020-01-01T00:00:00-05:00"`.
        #     `update_time` only supports the greater than operator (`>`).
        #
        #     Examples:
        #
        #     - `organization="organizations/123456789"`
        #     - `project="projects/my-project-id"`
        #     - `project="projects/123456789"`
        #     - `organization="organizations/123456789" AND state=CLOSED`
        #     - `project="projects/my-project-id" AND creator.email="tester@example.com"`
        #     - `project="projects/my-project-id" AND (priority=P0 OR priority=P1)`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of cases fetched with each request. The default page
        #     size is 10.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying the page of results to return. If unspecified, the
        #     first page is retrieved.
        class SearchCasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the SearchCases endpoint.
        # @!attribute [rw] cases
        #   @return [::Array<::Google::Cloud::Support::V2::Case>]
        #     The list of cases associated with the parent after any
        #     filters have been applied.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. Set this in the
        #     `page_token` field of subsequent `cases.search` requests. If unspecified,
        #     there are no more results to retrieve.
        class SearchCasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the EscalateCase endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the case to be escalated.
        # @!attribute [rw] escalation
        #   @return [::Google::Cloud::Support::V2::Escalation]
        #     The escalation information to be sent with the escalation request.
        class EscalateCaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the UpdateCase endpoint
        # @!attribute [rw] case
        #   @return [::Google::Cloud::Support::V2::Case]
        #     Required. The case to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A list of attributes of the case that should be updated. Supported values
        #     are `priority`, `display_name`, and `subscriber_email_addresses`. If no
        #     fields are specified, all supported fields are updated.
        #
        #     Be careful - if you do not provide a field mask, then you might
        #     accidentally clear some fields. For example, if you leave the field mask
        #     empty and do not provide a value for `subscriber_email_addresses`, then
        #     `subscriber_email_addresses` is updated to empty.
        class UpdateCaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the CloseCase endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the case to close.
        class CloseCaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the SearchCaseClassifications endpoint.
        # @!attribute [rw] query
        #   @return [::String]
        #     An expression used to filter case classifications.
        #
        #     If it's an empty string, then no filtering happens. Otherwise, case
        #     classifications will be returned that match the filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of classifications fetched with each request.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying the page of results to return. If unspecified, the
        #     first page is retrieved.
        class SearchCaseClassificationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for SearchCaseClassifications endpoint.
        # @!attribute [rw] case_classifications
        #   @return [::Array<::Google::Cloud::Support::V2::CaseClassification>]
        #     The classifications retrieved.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. Set this in the `page_token`
        #     field of subsequent `caseClassifications.list` requests. If unspecified,
        #     there are no more results to retrieve.
        class SearchCaseClassificationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
