# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/support/v2/case_service.proto for package 'Google.Cloud.Support.V2'
# Original file comments:
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/support/v2/case_service_pb'

module Google
  module Cloud
    module Support
      module V2
        module CaseService
          # A service to manage Google Cloud support cases.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.support.v2.CaseService'

            # Retrieve a case.
            rpc :GetCase, ::Google::Cloud::Support::V2::GetCaseRequest, ::Google::Cloud::Support::V2::Case
            # Retrieve all cases under a parent, but not its children.
            #
            # For example, listing cases under an organization only returns the cases
            # that are directly parented by that organization. To retrieve cases
            # under an organization and its projects, use `cases.search`.
            rpc :ListCases, ::Google::Cloud::Support::V2::ListCasesRequest, ::Google::Cloud::Support::V2::ListCasesResponse
            # Search for cases using a query.
            rpc :SearchCases, ::Google::Cloud::Support::V2::SearchCasesRequest, ::Google::Cloud::Support::V2::SearchCasesResponse
            # Create a new case and associate it with a parent.
            #
            # It must have the following fields set: `display_name`, `description`,
            # `classification`, and `priority`. If you're just testing the API and don't
            # want to route your case to an agent, set `testCase=true`.
            rpc :CreateCase, ::Google::Cloud::Support::V2::CreateCaseRequest, ::Google::Cloud::Support::V2::Case
            # Update a case. Only some fields can be updated.
            rpc :UpdateCase, ::Google::Cloud::Support::V2::UpdateCaseRequest, ::Google::Cloud::Support::V2::Case
            # Escalate a case, starting the Google Cloud Support escalation management
            # process.
            #
            # This operation is only available for some support services. Go to
            # https://cloud.google.com/support and look for 'Technical support
            # escalations' in the feature list to find out which ones let you
            # do that.
            rpc :EscalateCase, ::Google::Cloud::Support::V2::EscalateCaseRequest, ::Google::Cloud::Support::V2::Case
            # Close a case.
            rpc :CloseCase, ::Google::Cloud::Support::V2::CloseCaseRequest, ::Google::Cloud::Support::V2::Case
            # Retrieve valid classifications to use when creating a support case.
            #
            # Classifications are hierarchical. Each classification is a string
            # containing all levels of the hierarchy separated by `" > "`. For example,
            # `"Technical Issue > Compute > Compute Engine"`.
            #
            # Classification IDs returned by this endpoint are valid for at least six
            # months. When a classification is deactivated, this endpoint immediately
            # stops returning it. After six months, `case.create` requests using the
            # classification will fail.
            rpc :SearchCaseClassifications, ::Google::Cloud::Support::V2::SearchCaseClassificationsRequest, ::Google::Cloud::Support::V2::SearchCaseClassificationsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
