# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/storagetransfer/v1/transfer_pb"
require "google/cloud/storage_transfer/v1/storage_transfer_service"

class ::Google::Cloud::StorageTransfer::V1::StorageTransferService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_google_service_account
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::GoogleServiceAccount.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"

    get_google_service_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_google_service_account, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest, request
      assert_equal "hello world", request["project_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_google_service_account_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_google_service_account({ project_id: project_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_google_service_account project_id: project_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_google_service_account ::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest.new(project_id: project_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_google_service_account({ project_id: project_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_google_service_account(::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest.new(project_id: project_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_google_service_account_client_stub.call_rpc_count
    end
  end

  def test_create_transfer_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::TransferJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    transfer_job = {}

    create_transfer_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_transfer_job, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::StorageTransfer::V1::TransferJob), request["transfer_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_transfer_job_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_transfer_job({ transfer_job: transfer_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_transfer_job transfer_job: transfer_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_transfer_job ::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest.new(transfer_job: transfer_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_transfer_job({ transfer_job: transfer_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_transfer_job(::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest.new(transfer_job: transfer_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_transfer_job_client_stub.call_rpc_count
    end
  end

  def test_update_transfer_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::TransferJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    job_name = "hello world"
    project_id = "hello world"
    transfer_job = {}
    update_transfer_job_field_mask = {}

    update_transfer_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_transfer_job, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest, request
      assert_equal "hello world", request["job_name"]
      assert_equal "hello world", request["project_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::StorageTransfer::V1::TransferJob), request["transfer_job"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_transfer_job_field_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_transfer_job_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_transfer_job({ job_name: job_name, project_id: project_id, transfer_job: transfer_job, update_transfer_job_field_mask: update_transfer_job_field_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_transfer_job job_name: job_name, project_id: project_id, transfer_job: transfer_job, update_transfer_job_field_mask: update_transfer_job_field_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_transfer_job ::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest.new(job_name: job_name, project_id: project_id, transfer_job: transfer_job, update_transfer_job_field_mask: update_transfer_job_field_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_transfer_job({ job_name: job_name, project_id: project_id, transfer_job: transfer_job, update_transfer_job_field_mask: update_transfer_job_field_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_transfer_job(::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest.new(job_name: job_name, project_id: project_id, transfer_job: transfer_job, update_transfer_job_field_mask: update_transfer_job_field_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_transfer_job_client_stub.call_rpc_count
    end
  end

  def test_get_transfer_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::TransferJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    job_name = "hello world"
    project_id = "hello world"

    get_transfer_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_transfer_job, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest, request
      assert_equal "hello world", request["job_name"]
      assert_equal "hello world", request["project_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_transfer_job_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_transfer_job({ job_name: job_name, project_id: project_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_transfer_job job_name: job_name, project_id: project_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_transfer_job ::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest.new(job_name: job_name, project_id: project_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_transfer_job({ job_name: job_name, project_id: project_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_transfer_job(::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest.new(job_name: job_name, project_id: project_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_transfer_job_client_stub.call_rpc_count
    end
  end

  def test_list_transfer_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::ListTransferJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_transfer_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_transfer_jobs, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest, request
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_transfer_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_transfer_jobs({ filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_transfer_jobs filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_transfer_jobs ::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest.new(filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_transfer_jobs({ filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_transfer_jobs(::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest.new(filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_transfer_jobs_client_stub.call_rpc_count
    end
  end

  def test_pause_transfer_operation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_transfer_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pause_transfer_operation, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pause_transfer_operation_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pause_transfer_operation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pause_transfer_operation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pause_transfer_operation ::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pause_transfer_operation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pause_transfer_operation(::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pause_transfer_operation_client_stub.call_rpc_count
    end
  end

  def test_resume_transfer_operation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_transfer_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_transfer_operation, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_transfer_operation_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_transfer_operation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_transfer_operation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_transfer_operation ::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_transfer_operation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_transfer_operation(::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_transfer_operation_client_stub.call_rpc_count
    end
  end

  def test_run_transfer_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    job_name = "hello world"
    project_id = "hello world"

    run_transfer_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_transfer_job, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest, request
      assert_equal "hello world", request["job_name"]
      assert_equal "hello world", request["project_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_transfer_job_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_transfer_job({ job_name: job_name, project_id: project_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_transfer_job job_name: job_name, project_id: project_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_transfer_job ::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest.new(job_name: job_name, project_id: project_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_transfer_job({ job_name: job_name, project_id: project_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_transfer_job(::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest.new(job_name: job_name, project_id: project_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_transfer_job_client_stub.call_rpc_count
    end
  end

  def test_delete_transfer_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    job_name = "hello world"
    project_id = "hello world"

    delete_transfer_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_transfer_job, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest, request
      assert_equal "hello world", request["job_name"]
      assert_equal "hello world", request["project_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_transfer_job_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_transfer_job({ job_name: job_name, project_id: project_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_transfer_job job_name: job_name, project_id: project_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_transfer_job ::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest.new(job_name: job_name, project_id: project_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_transfer_job({ job_name: job_name, project_id: project_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_transfer_job(::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest.new(job_name: job_name, project_id: project_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_transfer_job_client_stub.call_rpc_count
    end
  end

  def test_create_agent_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::AgentPool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    agent_pool = {}
    agent_pool_id = "hello world"

    create_agent_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_agent_pool, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::StorageTransfer::V1::AgentPool), request["agent_pool"]
      assert_equal "hello world", request["agent_pool_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_agent_pool_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_agent_pool({ project_id: project_id, agent_pool: agent_pool, agent_pool_id: agent_pool_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_agent_pool project_id: project_id, agent_pool: agent_pool, agent_pool_id: agent_pool_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_agent_pool ::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest.new(project_id: project_id, agent_pool: agent_pool, agent_pool_id: agent_pool_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_agent_pool({ project_id: project_id, agent_pool: agent_pool, agent_pool_id: agent_pool_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_agent_pool(::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest.new(project_id: project_id, agent_pool: agent_pool, agent_pool_id: agent_pool_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_agent_pool_client_stub.call_rpc_count
    end
  end

  def test_update_agent_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::AgentPool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    agent_pool = {}
    update_mask = {}

    update_agent_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_agent_pool, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::StorageTransfer::V1::AgentPool), request["agent_pool"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_agent_pool_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_agent_pool({ agent_pool: agent_pool, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_agent_pool agent_pool: agent_pool, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_agent_pool ::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest.new(agent_pool: agent_pool, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_agent_pool({ agent_pool: agent_pool, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_agent_pool(::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest.new(agent_pool: agent_pool, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_agent_pool_client_stub.call_rpc_count
    end
  end

  def test_get_agent_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::AgentPool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_agent_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_agent_pool, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_agent_pool_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_agent_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_agent_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_agent_pool ::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_agent_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_agent_pool(::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_agent_pool_client_stub.call_rpc_count
    end
  end

  def test_list_agent_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_agent_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_agent_pools, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_agent_pools_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_agent_pools({ project_id: project_id, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_agent_pools project_id: project_id, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_agent_pools ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest.new(project_id: project_id, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_agent_pools({ project_id: project_id, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_agent_pools(::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest.new(project_id: project_id, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_agent_pools_client_stub.call_rpc_count
    end
  end

  def test_delete_agent_pool
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_agent_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_agent_pool, name
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_agent_pool_client_stub do
      # Create client
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_agent_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_agent_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_agent_pool ::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_agent_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_agent_pool(::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_agent_pool_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Operations, client.operations_client
  end
end
