# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/storagetransfer/v1/transfer_pb"
require "google/cloud/storage_transfer/v1/storage_transfer_service/rest/service_stub"

module Google
  module Cloud
    module StorageTransfer
      module V1
        module StorageTransferService
          module Rest
            ##
            # REST client for the StorageTransferService service.
            #
            # Storage Transfer Service and its protos.
            # Transfers data between between Google Cloud Storage buckets or from a data
            # source external to Google to a Cloud Storage bucket.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "storagetransfer.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :storage_transfer_service_stub

              ##
              # Configure the StorageTransferService Client class.
              #
              # See {::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all StorageTransferService clients
              #   ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "StorageTransfer", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14]
                  }

                  default_config.rpcs.create_transfer_job.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the StorageTransferService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @storage_transfer_service_stub.universe_domain
              end

              ##
              # Create a new StorageTransferService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the StorageTransferService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @storage_transfer_service_stub = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @storage_transfer_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @storage_transfer_service_stub.logger
              end

              # Service calls

              ##
              # Returns the Google service account that is used by Storage Transfer
              # Service to access buckets in the project where transfers
              # run or in other projects. Each Google service account is associated
              # with one Google Cloud project. Users
              # should add this service account to the Google Cloud Storage bucket
              # ACLs to grant access to Storage Transfer Service. This service
              # account is created and owned by Storage Transfer Service and can
              # only be used by Storage Transfer Service.
              #
              # @overload get_google_service_account(request, options = nil)
              #   Pass arguments to `get_google_service_account` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_google_service_account(project_id: nil)
              #   Pass arguments to `get_google_service_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that the Google service
              #     account is associated with.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::GoogleServiceAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::GoogleServiceAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest.new
              #
              #   # Call the get_google_service_account method.
              #   result = client.get_google_service_account request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::GoogleServiceAccount.
              #   p result
              #
              def get_google_service_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_google_service_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_google_service_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_google_service_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.get_google_service_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a transfer job that runs periodically.
              #
              # @overload create_transfer_job(request, options = nil)
              #   Pass arguments to `create_transfer_job` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_transfer_job(transfer_job: nil)
              #   Pass arguments to `create_transfer_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param transfer_job [::Google::Cloud::StorageTransfer::V1::TransferJob, ::Hash]
              #     Required. The job to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::TransferJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::TransferJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest.new
              #
              #   # Call the create_transfer_job method.
              #   result = client.create_transfer_job request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::TransferJob.
              #   p result
              #
              def create_transfer_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_transfer_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_transfer_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_transfer_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.create_transfer_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a transfer job. Updating a job's transfer spec does not affect
              # transfer operations that are running already.
              #
              # **Note:** The job's {::Google::Cloud::StorageTransfer::V1::TransferJob#status status}
              # field can be modified using this RPC (for example, to set a job's status to
              # {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DELETED DELETED},
              # {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DISABLED DISABLED}, or
              # {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::ENABLED ENABLED}).
              #
              # @overload update_transfer_job(request, options = nil)
              #   Pass arguments to `update_transfer_job` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_transfer_job(job_name: nil, project_id: nil, transfer_job: nil, update_transfer_job_field_mask: nil)
              #   Pass arguments to `update_transfer_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param job_name [::String]
              #     Required. The name of job to update.
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the
              #     job.
              #   @param transfer_job [::Google::Cloud::StorageTransfer::V1::TransferJob, ::Hash]
              #     Required. The job to update. `transferJob` is expected to specify one or
              #     more of five fields:
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#description description},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#transfer_spec transfer_spec},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#notification_config notification_config},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#logging_config logging_config}, and
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#status status}.  An
              #     `UpdateTransferJobRequest` that specifies other fields are rejected with
              #     the error {::Google::Rpc::Code::INVALID_ARGUMENT INVALID_ARGUMENT}. Updating a
              #     job status to
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DELETED DELETED} requires
              #     `storagetransfer.jobs.delete` permission.
              #   @param update_transfer_job_field_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The field mask of the fields in `transferJob` that are to be updated in
              #     this request.  Fields in `transferJob` that can be updated are:
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#description description},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#transfer_spec transfer_spec},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#notification_config notification_config},
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#logging_config logging_config}, and
              #     {::Google::Cloud::StorageTransfer::V1::TransferJob#status status}.  To update the
              #     `transfer_spec` of the job, a complete transfer specification must be
              #     provided. An incomplete specification missing any required fields is
              #     rejected with the error
              #     {::Google::Rpc::Code::INVALID_ARGUMENT INVALID_ARGUMENT}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::TransferJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::TransferJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest.new
              #
              #   # Call the update_transfer_job method.
              #   result = client.update_transfer_job request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::TransferJob.
              #   p result
              #
              def update_transfer_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_transfer_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_transfer_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_transfer_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.update_transfer_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a transfer job.
              #
              # @overload get_transfer_job(request, options = nil)
              #   Pass arguments to `get_transfer_job` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_transfer_job(job_name: nil, project_id: nil)
              #   Pass arguments to `get_transfer_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param job_name [::String]
              #     Required. The job to get.
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the
              #     job.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::TransferJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::TransferJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::GetTransferJobRequest.new
              #
              #   # Call the get_transfer_job method.
              #   result = client.get_transfer_job request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::TransferJob.
              #   p result
              #
              def get_transfer_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_transfer_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_transfer_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_transfer_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.get_transfer_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists transfer jobs.
              #
              # @overload list_transfer_jobs(request, options = nil)
              #   Pass arguments to `list_transfer_jobs` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_transfer_jobs(filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_transfer_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::String]
              #     Required. A list of query parameters specified as JSON text in the form of:
              #
              #     ```
              #     {
              #       "projectId":"my_project_id",
              #       "jobNames":["jobid1","jobid2",...],
              #       "jobStatuses":["status1","status2",...],
              #       "dataBackend":"QUERY_REPLICATION_CONFIGS",
              #       "sourceBucket":"source-bucket-name",
              #       "sinkBucket":"sink-bucket-name",
              #     }
              #     ```
              #
              #     The JSON formatting in the example is for display only; provide the
              #     query parameters without spaces or line breaks.
              #
              #     * `projectId` is required.
              #     * Since `jobNames` and `jobStatuses` support multiple values, their values
              #       must be specified with array notation. `jobNames` and `jobStatuses` are
              #       optional. Valid values are case-insensitive:
              #         * {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::ENABLED ENABLED}
              #         * {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DISABLED DISABLED}
              #         * {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DELETED DELETED}
              #     * Specify `"dataBackend":"QUERY_REPLICATION_CONFIGS"` to return a list of
              #       cross-bucket replication jobs.
              #     * Limit the results to jobs from a particular bucket with `sourceBucket`
              #       and/or to a particular bucket with `sinkBucket`.
              #   @param page_size [::Integer]
              #     The list page size. The max allowed value is 256.
              #   @param page_token [::String]
              #     The list page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::StorageTransfer::V1::TransferJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::StorageTransfer::V1::TransferJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest.new
              #
              #   # Call the list_transfer_jobs method.
              #   result = client.list_transfer_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::StorageTransfer::V1::TransferJob.
              #     p item
              #   end
              #
              def list_transfer_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_transfer_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_transfer_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_transfer_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.list_transfer_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @storage_transfer_service_stub, :list_transfer_jobs, "transfer_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses a transfer operation.
              #
              # @overload pause_transfer_operation(request, options = nil)
              #   Pass arguments to `pause_transfer_operation` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_transfer_operation(name: nil)
              #   Pass arguments to `pause_transfer_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the transfer operation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest.new
              #
              #   # Call the pause_transfer_operation method.
              #   result = client.pause_transfer_operation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def pause_transfer_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_transfer_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_transfer_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_transfer_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.pause_transfer_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes a transfer operation that is paused.
              #
              # @overload resume_transfer_operation(request, options = nil)
              #   Pass arguments to `resume_transfer_operation` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_transfer_operation(name: nil)
              #   Pass arguments to `resume_transfer_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the transfer operation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest.new
              #
              #   # Call the resume_transfer_operation method.
              #   result = client.resume_transfer_operation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def resume_transfer_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_transfer_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_transfer_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_transfer_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.resume_transfer_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a new operation for the specified transfer job.
              # A `TransferJob` has a maximum of one active `TransferOperation`. If this
              # method is called while a `TransferOperation` is active, an error is
              # returned.
              #
              # @overload run_transfer_job(request, options = nil)
              #   Pass arguments to `run_transfer_job` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_transfer_job(job_name: nil, project_id: nil)
              #   Pass arguments to `run_transfer_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param job_name [::String]
              #     Required. The name of the transfer job.
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the transfer
              #     job.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::RunTransferJobRequest.new
              #
              #   # Call the run_transfer_job method.
              #   result = client.run_transfer_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def run_transfer_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_transfer_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_transfer_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_transfer_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.run_transfer_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a transfer job. Deleting a transfer job sets its status to
              # {::Google::Cloud::StorageTransfer::V1::TransferJob::Status::DELETED DELETED}.
              #
              # @overload delete_transfer_job(request, options = nil)
              #   Pass arguments to `delete_transfer_job` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_transfer_job(job_name: nil, project_id: nil)
              #   Pass arguments to `delete_transfer_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param job_name [::String]
              #     Required. The job to delete.
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the
              #     job.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest.new
              #
              #   # Call the delete_transfer_job method.
              #   result = client.delete_transfer_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_transfer_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_transfer_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_transfer_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_transfer_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.delete_transfer_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an agent pool resource.
              #
              # @overload create_agent_pool(request, options = nil)
              #   Pass arguments to `create_agent_pool` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_agent_pool(project_id: nil, agent_pool: nil, agent_pool_id: nil)
              #   Pass arguments to `create_agent_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the
              #     agent pool.
              #   @param agent_pool [::Google::Cloud::StorageTransfer::V1::AgentPool, ::Hash]
              #     Required. The agent pool to create.
              #   @param agent_pool_id [::String]
              #     Required. The ID of the agent pool to create.
              #
              #     The `agent_pool_id` must meet the following requirements:
              #
              #     *   Length of 128 characters or less.
              #     *   Not start with the string `goog`.
              #     *   Start with a lowercase ASCII character, followed by:
              #         *   Zero or more: lowercase Latin alphabet characters, numerals,
              #             hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
              #         *   One or more numerals or lowercase ASCII characters.
              #
              #     As expressed by the regular expression:
              #     `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::AgentPool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::AgentPool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest.new
              #
              #   # Call the create_agent_pool method.
              #   result = client.create_agent_pool request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::AgentPool.
              #   p result
              #
              def create_agent_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_agent_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_agent_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_agent_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.create_agent_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing agent pool resource.
              #
              # @overload update_agent_pool(request, options = nil)
              #   Pass arguments to `update_agent_pool` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_agent_pool(agent_pool: nil, update_mask: nil)
              #   Pass arguments to `update_agent_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param agent_pool [::Google::Cloud::StorageTransfer::V1::AgentPool, ::Hash]
              #     Required. The agent pool to update. `agent_pool` is expected to specify
              #     following fields:
              #
              #     *  {::Google::Cloud::StorageTransfer::V1::AgentPool#name name}
              #
              #     *  {::Google::Cloud::StorageTransfer::V1::AgentPool#display_name display_name}
              #
              #     *  {::Google::Cloud::StorageTransfer::V1::AgentPool#bandwidth_limit bandwidth_limit}
              #     An `UpdateAgentPoolRequest` with any other fields is rejected
              #     with the error {::Google::Rpc::Code::INVALID_ARGUMENT INVALID_ARGUMENT}.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The [field mask]
              #     (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
              #     of the fields in `agentPool` to update in this request.
              #     The following `agentPool` fields can be updated:
              #
              #     *  {::Google::Cloud::StorageTransfer::V1::AgentPool#display_name display_name}
              #
              #     *  {::Google::Cloud::StorageTransfer::V1::AgentPool#bandwidth_limit bandwidth_limit}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::AgentPool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::AgentPool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest.new
              #
              #   # Call the update_agent_pool method.
              #   result = client.update_agent_pool request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::AgentPool.
              #   p result
              #
              def update_agent_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_agent_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_agent_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_agent_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.update_agent_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an agent pool.
              #
              # @overload get_agent_pool(request, options = nil)
              #   Pass arguments to `get_agent_pool` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_agent_pool(name: nil)
              #   Pass arguments to `get_agent_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the agent pool to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::StorageTransfer::V1::AgentPool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::StorageTransfer::V1::AgentPool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest.new
              #
              #   # Call the get_agent_pool method.
              #   result = client.get_agent_pool request
              #
              #   # The returned object is of type Google::Cloud::StorageTransfer::V1::AgentPool.
              #   p result
              #
              def get_agent_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_agent_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_agent_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_agent_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.get_agent_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists agent pools.
              #
              # @overload list_agent_pools(request, options = nil)
              #   Pass arguments to `list_agent_pools` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_agent_pools(project_id: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_agent_pools` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud project that owns the job.
              #   @param filter [::String]
              #     An optional list of query parameters specified as JSON text in the
              #     form of:
              #
              #     `{"agentPoolNames":["agentpool1","agentpool2",...]}`
              #
              #     Since `agentPoolNames` support multiple values, its values must be
              #     specified with array notation. When the filter is either empty or not
              #     provided, the list returns all agent pools for the project.
              #   @param page_size [::Integer]
              #     The list page size. The max allowed value is `256`.
              #   @param page_token [::String]
              #     The list page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::StorageTransfer::V1::AgentPool>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::StorageTransfer::V1::AgentPool>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest.new
              #
              #   # Call the list_agent_pools method.
              #   result = client.list_agent_pools request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::StorageTransfer::V1::AgentPool.
              #     p item
              #   end
              #
              def list_agent_pools request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_agent_pools.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_agent_pools.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_agent_pools.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.list_agent_pools request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @storage_transfer_service_stub, :list_agent_pools, "agent_pools", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an agent pool.
              #
              # @overload delete_agent_pool(request, options = nil)
              #   Pass arguments to `delete_agent_pool` via a request object, either of type
              #   {::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_agent_pool(name: nil)
              #   Pass arguments to `delete_agent_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the agent pool to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage_transfer/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest.new
              #
              #   # Call the delete_agent_pool method.
              #   result = client.delete_agent_pool request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_agent_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_agent_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::StorageTransfer::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_agent_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_agent_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_transfer_service_stub.delete_agent_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the StorageTransferService REST API.
              #
              # This class represents the configuration for StorageTransferService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_google_service_account to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_google_service_account.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::StorageTransfer::V1::StorageTransferService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_google_service_account.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "storagetransfer.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the StorageTransferService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_google_service_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_google_service_account
                  ##
                  # RPC-specific configuration for `create_transfer_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_transfer_job
                  ##
                  # RPC-specific configuration for `update_transfer_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_transfer_job
                  ##
                  # RPC-specific configuration for `get_transfer_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_transfer_job
                  ##
                  # RPC-specific configuration for `list_transfer_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_transfer_jobs
                  ##
                  # RPC-specific configuration for `pause_transfer_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_transfer_operation
                  ##
                  # RPC-specific configuration for `resume_transfer_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_transfer_operation
                  ##
                  # RPC-specific configuration for `run_transfer_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_transfer_job
                  ##
                  # RPC-specific configuration for `delete_transfer_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_transfer_job
                  ##
                  # RPC-specific configuration for `create_agent_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_agent_pool
                  ##
                  # RPC-specific configuration for `update_agent_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_agent_pool
                  ##
                  # RPC-specific configuration for `get_agent_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_agent_pool
                  ##
                  # RPC-specific configuration for `list_agent_pools`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_agent_pools
                  ##
                  # RPC-specific configuration for `delete_agent_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_agent_pool

                  # @private
                  def initialize parent_rpcs = nil
                    get_google_service_account_config = parent_rpcs.get_google_service_account if parent_rpcs.respond_to? :get_google_service_account
                    @get_google_service_account = ::Gapic::Config::Method.new get_google_service_account_config
                    create_transfer_job_config = parent_rpcs.create_transfer_job if parent_rpcs.respond_to? :create_transfer_job
                    @create_transfer_job = ::Gapic::Config::Method.new create_transfer_job_config
                    update_transfer_job_config = parent_rpcs.update_transfer_job if parent_rpcs.respond_to? :update_transfer_job
                    @update_transfer_job = ::Gapic::Config::Method.new update_transfer_job_config
                    get_transfer_job_config = parent_rpcs.get_transfer_job if parent_rpcs.respond_to? :get_transfer_job
                    @get_transfer_job = ::Gapic::Config::Method.new get_transfer_job_config
                    list_transfer_jobs_config = parent_rpcs.list_transfer_jobs if parent_rpcs.respond_to? :list_transfer_jobs
                    @list_transfer_jobs = ::Gapic::Config::Method.new list_transfer_jobs_config
                    pause_transfer_operation_config = parent_rpcs.pause_transfer_operation if parent_rpcs.respond_to? :pause_transfer_operation
                    @pause_transfer_operation = ::Gapic::Config::Method.new pause_transfer_operation_config
                    resume_transfer_operation_config = parent_rpcs.resume_transfer_operation if parent_rpcs.respond_to? :resume_transfer_operation
                    @resume_transfer_operation = ::Gapic::Config::Method.new resume_transfer_operation_config
                    run_transfer_job_config = parent_rpcs.run_transfer_job if parent_rpcs.respond_to? :run_transfer_job
                    @run_transfer_job = ::Gapic::Config::Method.new run_transfer_job_config
                    delete_transfer_job_config = parent_rpcs.delete_transfer_job if parent_rpcs.respond_to? :delete_transfer_job
                    @delete_transfer_job = ::Gapic::Config::Method.new delete_transfer_job_config
                    create_agent_pool_config = parent_rpcs.create_agent_pool if parent_rpcs.respond_to? :create_agent_pool
                    @create_agent_pool = ::Gapic::Config::Method.new create_agent_pool_config
                    update_agent_pool_config = parent_rpcs.update_agent_pool if parent_rpcs.respond_to? :update_agent_pool
                    @update_agent_pool = ::Gapic::Config::Method.new update_agent_pool_config
                    get_agent_pool_config = parent_rpcs.get_agent_pool if parent_rpcs.respond_to? :get_agent_pool
                    @get_agent_pool = ::Gapic::Config::Method.new get_agent_pool_config
                    list_agent_pools_config = parent_rpcs.list_agent_pools if parent_rpcs.respond_to? :list_agent_pools
                    @list_agent_pools = ::Gapic::Config::Method.new list_agent_pools_config
                    delete_agent_pool_config = parent_rpcs.delete_agent_pool if parent_rpcs.respond_to? :delete_agent_pool
                    @delete_agent_pool = ::Gapic::Config::Method.new delete_agent_pool_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
