# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/storageinsights/v1/storageinsights_pb"
require "google/cloud/storage_insights/v1/storage_insights/rest"


class ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_report_configs
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ListReportConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_report_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_list_report_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_report_configs_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_report_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_report_configs ::Google::Cloud::StorageInsights::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_report_configs(::Google::Cloud::StorageInsights::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_report_configs_client_stub.call_count
      end
    end
  end

  def test_get_report_config
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ReportConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_get_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_report_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_report_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_report_config ::Google::Cloud::StorageInsights::V1::GetReportConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_report_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_report_config(::Google::Cloud::StorageInsights::V1::GetReportConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_report_config_client_stub.call_count
      end
    end
  end

  def test_create_report_config
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ReportConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    report_config = {}
    request_id = "hello world"

    create_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_create_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_report_config({ parent: parent, report_config: report_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_report_config parent: parent, report_config: report_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_report_config ::Google::Cloud::StorageInsights::V1::CreateReportConfigRequest.new(parent: parent, report_config: report_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_report_config({ parent: parent, report_config: report_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_report_config(::Google::Cloud::StorageInsights::V1::CreateReportConfigRequest.new(parent: parent, report_config: report_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_report_config_client_stub.call_count
      end
    end
  end

  def test_update_report_config
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ReportConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    report_config = {}
    request_id = "hello world"

    update_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_update_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_report_config({ update_mask: update_mask, report_config: report_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_report_config update_mask: update_mask, report_config: report_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_report_config ::Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest.new(update_mask: update_mask, report_config: report_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_report_config({ update_mask: update_mask, report_config: report_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_report_config(::Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest.new(update_mask: update_mask, report_config: report_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_report_config_client_stub.call_count
      end
    end
  end

  def test_delete_report_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    request_id = "hello world"

    delete_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_delete_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_report_config({ name: name, force: force, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_report_config name: name, force: force, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_report_config ::Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest.new(name: name, force: force, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_report_config({ name: name, force: force, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_report_config(::Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest.new(name: name, force: force, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_report_config_client_stub.call_count
      end
    end
  end

  def test_list_report_details
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ListReportDetailsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_report_details_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_list_report_details_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_report_details_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_report_details({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_report_details parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_report_details ::Google::Cloud::StorageInsights::V1::ListReportDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_report_details({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_report_details(::Google::Cloud::StorageInsights::V1::ListReportDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_report_details_client_stub.call_count
      end
    end
  end

  def test_get_report_detail
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ReportDetail.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_report_detail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_get_report_detail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_report_detail_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_report_detail({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_report_detail name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_report_detail ::Google::Cloud::StorageInsights::V1::GetReportDetailRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_report_detail({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_report_detail(::Google::Cloud::StorageInsights::V1::GetReportDetailRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_report_detail_client_stub.call_count
      end
    end
  end

  def test_list_dataset_configs
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::ListDatasetConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_dataset_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_list_dataset_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_dataset_configs_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_dataset_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_dataset_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_dataset_configs ::Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_dataset_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_dataset_configs(::Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_dataset_configs_client_stub.call_count
      end
    end
  end

  def test_get_dataset_config
    # Create test objects.
    client_result = ::Google::Cloud::StorageInsights::V1::DatasetConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_get_dataset_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset_config ::Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset_config(::Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_config_client_stub.call_count
      end
    end
  end

  def test_create_dataset_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset_config_id = "hello world"
    dataset_config = {}
    request_id = "hello world"

    create_dataset_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_create_dataset_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset_config({ parent: parent, dataset_config_id: dataset_config_id, dataset_config: dataset_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset_config parent: parent, dataset_config_id: dataset_config_id, dataset_config: dataset_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset_config ::Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest.new(parent: parent, dataset_config_id: dataset_config_id, dataset_config: dataset_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset_config({ parent: parent, dataset_config_id: dataset_config_id, dataset_config: dataset_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset_config(::Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest.new(parent: parent, dataset_config_id: dataset_config_id, dataset_config: dataset_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_config_client_stub.call_count
      end
    end
  end

  def test_update_dataset_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    dataset_config = {}
    request_id = "hello world"

    update_dataset_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_update_dataset_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dataset_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dataset_config({ update_mask: update_mask, dataset_config: dataset_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dataset_config update_mask: update_mask, dataset_config: dataset_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dataset_config ::Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest.new(update_mask: update_mask, dataset_config: dataset_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dataset_config({ update_mask: update_mask, dataset_config: dataset_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dataset_config(::Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest.new(update_mask: update_mask, dataset_config: dataset_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dataset_config_client_stub.call_count
      end
    end
  end

  def test_delete_dataset_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_dataset_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_delete_dataset_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_config_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset_config({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset_config name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset_config ::Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset_config({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset_config(::Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_config_client_stub.call_count
      end
    end
  end

  def test_link_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    link_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_link_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, link_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.link_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.link_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.link_dataset ::Google::Cloud::StorageInsights::V1::LinkDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.link_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.link_dataset(::Google::Cloud::StorageInsights::V1::LinkDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, link_dataset_client_stub.call_count
      end
    end
  end

  def test_unlink_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    unlink_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::ServiceStub.stub :transcode_unlink_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unlink_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unlink_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unlink_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unlink_dataset ::Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unlink_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unlink_dataset(::Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unlink_dataset_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::StorageInsights::V1::StorageInsights::Rest::Client::Configuration, config
  end
end
