# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/storage_insights/v1/storage_insights"

class ::Google::Cloud::StorageInsights::V1::StorageInsights::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_dataset_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dataset_config_path project: "value0", location: "value1", dataset_config: "value2"
      assert_equal "projects/value0/locations/value1/datasetConfigs/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_report_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.report_config_path project: "value0", location: "value1", report_config: "value2"
      assert_equal "projects/value0/locations/value1/reportConfigs/value2", path
    end
  end

  def test_report_detail_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.report_detail_path project: "value0", location: "value1", report_config: "value2", report_detail: "value3"
      assert_equal "projects/value0/locations/value1/reportConfigs/value2/reportDetails/value3", path
    end
  end
end
