# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module StorageInsights
      module V1
        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#list_report_configs `ListReportConfigs`}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListReportConfigsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListReportConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing ReportConfigs
        # @!attribute [rw] report_configs
        #   @return [::Array<::Google::Cloud::StorageInsights::V1::ReportConfig>]
        #     The list of ReportConfig
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListReportConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a ReportConfig
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a ReportConfig
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] report_config
        #   @return [::Google::Cloud::StorageInsights::V1::ReportConfig]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a ReportConfig
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     ReportConfig resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] report_config
        #   @return [::Google::Cloud::StorageInsights::V1::ReportConfig]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a ReportConfig
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set, all ReportDetails for this ReportConfig will be deleted.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing ReportDetail object. ReportDetail represents metadata of
        # generated reports for a ReportConfig.
        # Next ID: 10
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of resource. It will be of form
        #     projects/<project>/locations/<location>/reportConfigs/<report-config-id>/reportDetails/<report-detail-id>.
        # @!attribute [rw] snapshot_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The snapshot time.
        #     All the report data is referenced at this point of time.
        # @!attribute [rw] report_path_prefix
        #   @return [::String]
        #     Prefix of the object name of each report's shard. This will have full
        #     prefix except the "extension" and "shard_id".
        #     For example, if the `destination_path` is
        #     `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
        #     `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
        #     and the value of `report_path_prefix` field would be
        #     `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
        # @!attribute [rw] shards_count
        #   @return [::Integer]
        #     Total shards generated for the report.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     Status of the ReportDetail.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [rw] target_datetime
        #   @return [::Google::Type::DateTime]
        #     The date for which report is generated. The time part of target_datetime
        #     will be zero till we support multiple reports per day.
        # @!attribute [rw] report_metrics
        #   @return [::Google::Cloud::StorageInsights::V1::ReportDetail::Metrics]
        #     Metrics of the report.
        class ReportDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Different metrics associated with the generated report.
          # @!attribute [rw] processed_records_count
          #   @return [::Integer]
          #     Count of Cloud Storage objects which are part of the report.
          class Metrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for requesting list of ReportDetails
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListReportDetailsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListReportDetailsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing ReportDetails
        # @!attribute [rw] report_details
        #   @return [::Array<::Google::Cloud::StorageInsights::V1::ReportDetail>]
        #     The list of ReportDetail
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListReportDetailsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a ReportDetail
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetReportDetailRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReportConfig Resource:
        #
        # Options to setup frequency of report generation.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::StorageInsights::V1::FrequencyOptions::Frequency]
        #     Frequency of report generation.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     The date from which report generation should start.
        #     UTC time zone.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     The date on which report generation should stop (Inclusive).
        #     UTC time zone.
        class FrequencyOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This ENUM specifies possible frequencies of report generation.
          module Frequency
            # Unspecified.
            FREQUENCY_UNSPECIFIED = 0

            # Report will be generated daily.
            DAILY = 1

            # Report will be generated weekly.
            WEEKLY = 2
          end
        end

        # Options to configure CSV formatted reports.
        # @!attribute [rw] record_separator
        #   @return [::String]
        #     Record separator characters in CSV.
        # @!attribute [rw] delimiter
        #   @return [::String]
        #     Delimiter characters in CSV.
        # @!attribute [rw] header_required
        #   @return [::Boolean]
        #     If set, will include a header row in the CSV report.
        class CSVOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure Parquet formatted reports.
        class ParquetOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to filter data on storage systems.
        # Next ID: 2
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Bucket for which the report will be generated.
        class CloudStorageFilters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to store reports in storage systems.
        # Next ID: 3
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Destination bucket.
        # @!attribute [rw] destination_path
        #   @return [::String]
        #     Destination path is the path in the bucket where the report should be
        #     generated.
        class CloudStorageDestinationOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Report specification for exporting object metadata.
        # Next ID: 4
        # @!attribute [rw] metadata_fields
        #   @return [::Array<::String>]
        #     Metadata fields to be included in the report.
        # @!attribute [rw] storage_filters
        #   @return [::Google::Cloud::StorageInsights::V1::CloudStorageFilters]
        #     Cloud Storage as the storage system.
        # @!attribute [rw] storage_destination_options
        #   @return [::Google::Cloud::StorageInsights::V1::CloudStorageDestinationOptions]
        #     Cloud Storage as the storage system.
        class ObjectMetadataReportOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing ReportConfig object. ReportConfig is the configuration to
        # generate reports.
        # See
        # https://cloud.google.com/storage/docs/insights/using-inventory-reports#create-config-rest
        # for more details on how to set various fields.
        # Next ID: 12
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource. It will be of form
        #     projects/<project>/locations/<location>/reportConfigs/<report-config-id>.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp
        # @!attribute [rw] frequency_options
        #   @return [::Google::Cloud::StorageInsights::V1::FrequencyOptions]
        #     The frequency of report generation.
        # @!attribute [rw] csv_options
        #   @return [::Google::Cloud::StorageInsights::V1::CSVOptions]
        #     Options for CSV formatted reports.
        #
        #     Note: The following fields are mutually exclusive: `csv_options`, `parquet_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parquet_options
        #   @return [::Google::Cloud::StorageInsights::V1::ParquetOptions]
        #     Options for Parquet formatted reports.
        #
        #     Note: The following fields are mutually exclusive: `parquet_options`, `csv_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] object_metadata_report_options
        #   @return [::Google::Cloud::StorageInsights::V1::ObjectMetadataReportOptions]
        #     Report for exporting object metadata.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User provided display name which can be empty and limited to 256 characters
        #     that is editable.
        class ReportConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Identity lets the user provide the type of identity to use, and outputs
        # the identity string that can be used for IAM policy changes.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the identity.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::StorageInsights::V1::Identity::IdentityType]
        #     Type of identity to use for the datasetConfig.
        class Identity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of service account to use for the dataset configuration.
          module IdentityType
            # Default is unspecified and should not be used.
            IDENTITY_TYPE_UNSPECIFIED = 0

            # Google managed service account per resource.
            IDENTITY_TYPE_PER_CONFIG = 1

            # Google managed service account per project.
            IDENTITY_TYPE_PER_PROJECT = 2
          end
        end

        # Message describing the dataset configuration properties. For more
        # information, see [Dataset configuration
        # properties](https://cloud.google.com/storage/docs/insights/datasets#dataset-config).
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. name of resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The UTC time at which the dataset configuration was created.
        #     This is auto-populated.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The UTC time at which the dataset configuration was last
        #     updated. This is auto-populated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated unique identifier for the resource.
        # @!attribute [rw] organization_number
        #   @return [::Integer]
        #     Optional. Organization resource ID that the source projects should belong
        #     to. Projects that do not belong to the provided organization are not
        #     considered when creating the dataset.
        # @!attribute [rw] source_projects
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::SourceProjects]
        #     Defines the options for providing source projects for the dataset.
        #
        #     Note: The following fields are mutually exclusive: `source_projects`, `source_folders`, `organization_scope`, `cloud_storage_object_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_folders
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::SourceFolders]
        #     Defines the options for providing source folders for the dataset.
        #
        #     Note: The following fields are mutually exclusive: `source_folders`, `source_projects`, `organization_scope`, `cloud_storage_object_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] organization_scope
        #   @return [::Boolean]
        #     Defines the options for providing a source organization for the dataset.
        #
        #     Note: The following fields are mutually exclusive: `organization_scope`, `source_projects`, `source_folders`, `cloud_storage_object_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_storage_object_path
        #   @return [::String]
        #     Input only. Cloud Storage object path containing a list of
        #     project or folder numbers to include in the dataset;
        #     it cannot contain a mix of project and folders.
        #
        #     The object must be a text file where each line has one of the following
        #     entries:
        #
        #     - Project number, formatted as `projects/{project_number}`, for example,
        #     `projects/1234567890`.
        #     - Folder identifier, formatted as `folders/{folder_number}`, for example,
        #     `folders/9876543210`.
        #     Path must be in the format `gs://{bucket_name}/{object_name}`.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_object_path`, `source_projects`, `source_folders`, `organization_scope`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] include_cloud_storage_locations
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::CloudStorageLocations]
        #     Note: The following fields are mutually exclusive: `include_cloud_storage_locations`, `exclude_cloud_storage_locations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclude_cloud_storage_locations
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::CloudStorageLocations]
        #     Note: The following fields are mutually exclusive: `exclude_cloud_storage_locations`, `include_cloud_storage_locations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] include_cloud_storage_buckets
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::CloudStorageBuckets]
        #     Note: The following fields are mutually exclusive: `include_cloud_storage_buckets`, `exclude_cloud_storage_buckets`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclude_cloud_storage_buckets
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::CloudStorageBuckets]
        #     Note: The following fields are mutually exclusive: `exclude_cloud_storage_buckets`, `include_cloud_storage_buckets`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] include_newly_created_buckets
        #   @return [::Boolean]
        #     If set to `true`, the request includes all the newly created buckets in the
        #     dataset that meet the inclusion and exclusion rules.
        # @!attribute [rw] skip_verification_and_ingest
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. If set to `false`, then all the permission checks must be
        #     successful before the system can start ingesting data. This field can only
        #     be updated before the system ingests data for the first time. Any attempt
        #     to modify the field after data ingestion starts results in an error.
        # @!attribute [rw] retention_period_days
        #   @return [::Integer]
        #     Number of days of history that must be retained.
        # @!attribute [rw] link
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::Link]
        #     Details of the linked dataset.
        # @!attribute [rw] identity
        #   @return [::Google::Cloud::StorageInsights::V1::Identity]
        #     Identity used by this `datasetConfig`.
        # @!attribute [r] status
        #   @return [::Google::Rpc::Status]
        #     Output only. Status of the `datasetConfig`.
        # @!attribute [r] dataset_config_state
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::ConfigState]
        #     Output only. State of the `datasetConfig`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A user-provided description for the dataset configuration.
        #
        #     Maximum length: 256 characters.
        class DatasetConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Collection of project numbers
          # @!attribute [rw] project_numbers
          #   @return [::Array<::Integer>]
          class SourceProjects
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies a set of folders to include in the dataset
          # @!attribute [rw] folder_numbers
          #   @return [::Array<::Integer>]
          #     Optional. The list of folder numbers to include in the dataset.
          class SourceFolders
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of Cloud Storage locations.
          # @!attribute [rw] locations
          #   @return [::Array<::String>]
          class CloudStorageLocations
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of Cloud Storage buckets.
          # @!attribute [rw] cloud_storage_buckets
          #   @return [::Array<::Google::Cloud::StorageInsights::V1::DatasetConfig::CloudStorageBuckets::CloudStorageBucket>]
          class CloudStorageBuckets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the bucket by its name or a regex pattern to match buckets.
            # @!attribute [rw] bucket_name
            #   @return [::String]
            #     Cloud Storage bucket name.
            #
            #     Note: The following fields are mutually exclusive: `bucket_name`, `bucket_prefix_regex`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] bucket_prefix_regex
            #   @return [::String]
            #     A regex pattern for bucket names matching the regex. Regex should
            #     follow the syntax specified in `google/re2` on GitHub.
            #
            #     Note: The following fields are mutually exclusive: `bucket_prefix_regex`, `bucket_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class CloudStorageBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Defines the details about the linked dataset.
          # @!attribute [r] dataset
          #   @return [::String]
          #     Output only. Dataset name for linked dataset.
          # @!attribute [r] linked
          #   @return [::Boolean]
          #     Output only. State of the linked dataset.
          class Link
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Provides a summary of the bucket level error statistics.
          # @!attribute [rw] validated_count
          #   @return [::Integer]
          #     Optional. Count of successfully validated buckets.
          # @!attribute [rw] permission_denied_count
          #   @return [::Integer]
          #     Optional. Count of buckets with permission denied errors.
          # @!attribute [rw] permission_denied_bucket_ids
          #   @return [::Array<::String>]
          #     Optional. Subset of bucket names that have permission denied.
          # @!attribute [rw] non_management_hub_entitled_count
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Integer]
          #     Optional. Count of buckets that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] internal_error_count
          #   @return [::Integer]
          #     Optional. Number of buckets that encountered internal errors during the
          #     validation process. These buckets are automatically retried in subsequent
          #     validation attempts.
          # @!attribute [rw] non_storage_intelligence_entitled_count
          #   @return [::Integer]
          #     Optional. Count of buckets that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] non_storage_intelligence_entitled_bucket_ids
          #   @return [::Array<::String>]
          #     Optional. Subset of bucket names that are not subscribed to Storage
          #     Intelligence.
          class BucketErrors
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Provides a summary of the project level error statistics.
          # @!attribute [rw] validated_count
          #   @return [::Integer]
          #     Optional. Count of successfully validated projects.
          # @!attribute [rw] outside_org_error_count
          #   @return [::Integer]
          #     Optional. Count of projects which are not in the same organization.
          # @!attribute [rw] outside_org_project_numbers
          #   @return [::Array<::Integer>]
          #     Optional. Subset of project numbers which are not in the same
          #     organization.
          # @!attribute [rw] non_management_hub_entitled_error_count
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Integer]
          #     Optional. Count of projects that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] non_management_hub_entitled_project_numbers
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Array<::Integer>]
          #     Optional. Subset of project numbers that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] non_storage_intelligence_entitled_error_count
          #   @return [::Integer]
          #     Optional. Count of projects that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] non_storage_intelligence_entitled_project_numbers
          #   @return [::Array<::Integer>]
          #     Optional. Subset of project numbers that are not subscribed to Storage
          #     Intelligence.
          # @!attribute [rw] internal_error_count
          #   @return [::Integer]
          #     Optional. Number of projects that encountered internal errors during
          #     validation and are automatically retried.
          # @!attribute [rw] destination_project_org_error
          #   @return [::Boolean]
          #     Optional. Indicates if the destination project resides within the same
          #     organization as the source project.
          #
          #     Note: The following fields are mutually exclusive: `destination_project_org_error`, `destination_project_check_has_internal_error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] destination_project_check_has_internal_error
          #   @return [::Boolean]
          #     Optional. Indicates whether the destination project check failed due to
          #     an internal error. If `true`, the system automatically retries the
          #     check.
          #
          #     Note: The following fields are mutually exclusive: `destination_project_check_has_internal_error`, `destination_project_org_error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ProjectErrors
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Summary of validation errors that occurred during the verification phase.
          # @!attribute [rw] bucket_errors
          #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::BucketErrors]
          #     Optional. Provides a summary of the bucket level error stats.
          # @!attribute [rw] project_errors
          #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig::ProjectErrors]
          #     Optional. Provides a summary of the project level error stats.
          class ValidationErrorsBeforeIngestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the configuration.
          module ConfigState
            # Unspecified state.
            CONFIG_STATE_UNSPECIFIED = 0

            # Active configuration indicates that the configuration is
            # actively ingesting data.
            CONFIG_STATE_ACTIVE = 1

            # In this state, the configuration is being verified for various
            # permissions.
            CONFIG_STATE_VERIFICATION_IN_PROGRESS = 2

            # Configuration is created and further processing needs to happen.
            CONFIG_STATE_CREATED = 3

            # Configuration is under processing
            CONFIG_STATE_PROCESSING = 4
          end
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#list_dataset_configs `ListDatasetConfigs`}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListDatasetConfigsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server might return fewer items than requested.
        #     If unspecified, server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListDatasetConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#list_dataset_configs `ListDatasetConfigs`}
        # @!attribute [rw] dataset_configs
        #   @return [::Array<::Google::Cloud::StorageInsights::V1::DatasetConfig>]
        #     The list of `DatasetConfigs`
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDatasetConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#get_dataset_config `GetDatasetConfig`}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetDatasetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#create_dataset_config `CreateDatasetConfig`}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] dataset_config_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        #     If auto-generating ID is enabled on the server-side, remove this field and
        #     `dataset_config_id` from the method_signature of Create RPC
        #     Note: The value should not contain any hyphens.
        # @!attribute [rw] dataset_config
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for your request.
        #     Specify the request ID if you need to retry the request.
        #     If you retry the request with the same ID within 60 minutes, the server
        #     ignores the request if it has already completed the original request.
        #
        #     For example, if your initial request times out and you retry the request
        #     using the same request ID, the server recognizes the original request and
        #     does not process the new request.
        #
        #     The request ID must be a valid UUID and cannot be a zero UUID
        #     (00000000-0000-0000-0000-000000000000).
        class CreateDatasetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#update_dataset_config `UpdateDatasetConfig`}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `DatasetConfig` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field is overwritten if it is in the mask. If the
        #     user does not provide a mask then it returns an "Invalid Argument" error.
        # @!attribute [rw] dataset_config
        #   @return [::Google::Cloud::StorageInsights::V1::DatasetConfig]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for your request.
        #     Specify the request ID if you need to retry the request.
        #     If you retry the request with the same ID within 60 minutes, the server
        #     ignores the request if it has already completed the original request.
        #
        #     For example, if your initial request times out and you retry the request
        #     using the same request ID, the server recognizes the original request and
        #     does not process the new request.
        #
        #     The request ID must be a valid UUID and cannot be a zero UUID
        #     (00000000-0000-0000-0000-000000000000).
        class UpdateDatasetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#delete_dataset_config `DeleteDatasetConfig`}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for your request.
        #     Specify the request ID if you need to retry the request.
        #     If you retry the request with the same ID within 60 minutes, the server
        #     ignores the request if it has already completed the original request.
        #
        #     For example, if your initial request times out and you retry the request
        #     using the same request ID, the server recognizes the original request and
        #     does not process the new request.
        #
        #     The request ID must be a valid UUID and cannot be a zero UUID
        #     (00000000-0000-0000-0000-000000000000).
        class DeleteDatasetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#link_dataset `LinkDataset`}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class LinkDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#link_dataset `LinkDataset`}
        class LinkDatasetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client#unlink_dataset `UnlinkDataset`}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class UnlinkDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata that helps discover which resources are available in a location.
        # @!attribute [rw] report_config_available
        #   @return [::Boolean]
        #     If true, `storageinsights.googleapis.com/ReportConfig` resource is
        #     available at the location.
        # @!attribute [rw] dataset_config_available
        #   @return [::Boolean]
        #     If true, `storageinsights.googleapis.com/DatasetConfig` resource is
        #     available at the location.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
