# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/storageinsights/v1/storageinsights_pb"
require "google/cloud/location"

module Google
  module Cloud
    module StorageInsights
      module V1
        module StorageInsights
          ##
          # Client for the StorageInsights service.
          #
          # Service describing handlers for resources
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "storageinsights.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :storage_insights_stub

            ##
            # Configure the StorageInsights Client class.
            #
            # See {::Google::Cloud::StorageInsights::V1::StorageInsights::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all StorageInsights clients
            #   ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "StorageInsights", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config.rpcs.list_report_configs.timeout = 60.0
                default_config.rpcs.list_report_configs.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_report_config.timeout = 60.0
                default_config.rpcs.get_report_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_report_details.timeout = 60.0
                default_config.rpcs.list_report_details.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_report_detail.timeout = 60.0
                default_config.rpcs.get_report_detail.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_dataset_configs.timeout = 60.0
                default_config.rpcs.list_dataset_configs.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_dataset_config.timeout = 60.0
                default_config.rpcs.create_dataset_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_dataset_config.timeout = 60.0
                default_config.rpcs.update_dataset_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_dataset_config.timeout = 60.0
                default_config.rpcs.delete_dataset_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.link_dataset.timeout = 60.0
                default_config.rpcs.link_dataset.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.unlink_dataset.timeout = 60.0
                default_config.rpcs.unlink_dataset.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the StorageInsights Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::StorageInsights::V1::StorageInsights::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @storage_insights_stub.universe_domain
            end

            ##
            # Create a new StorageInsights client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the StorageInsights client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/storageinsights/v1/storageinsights_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @storage_insights_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::StorageInsights::V1::StorageInsights::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @storage_insights_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @storage_insights_stub.endpoint
                config.universe_domain = @storage_insights_stub.universe_domain
                config.logger = @storage_insights_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::StorageInsights::V1::StorageInsights::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @storage_insights_stub.logger
            end

            # Service calls

            ##
            # Lists ReportConfigs in a given project and location.
            #
            # @overload list_report_configs(request, options = nil)
            #   Pass arguments to `list_report_configs` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::ListReportConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::ListReportConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_report_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_report_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListReportConfigsRequest
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested.
            #     If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Filtering results
            #   @param order_by [::String]
            #     Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::ReportConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::ReportConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::ListReportConfigsRequest.new
            #
            #   # Call the list_report_configs method.
            #   result = client.list_report_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::StorageInsights::V1::ReportConfig.
            #     p item
            #   end
            #
            def list_report_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::ListReportConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_report_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_report_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_report_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :list_report_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @storage_insights_stub, :list_report_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ReportConfig.
            #
            # @overload get_report_config(request, options = nil)
            #   Pass arguments to `get_report_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::GetReportConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::GetReportConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_report_config(name: nil)
            #   Pass arguments to `get_report_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::StorageInsights::V1::ReportConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::StorageInsights::V1::ReportConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::GetReportConfigRequest.new
            #
            #   # Call the get_report_config method.
            #   result = client.get_report_config request
            #
            #   # The returned object is of type Google::Cloud::StorageInsights::V1::ReportConfig.
            #   p result
            #
            def get_report_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::GetReportConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_report_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_report_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_report_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :get_report_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ReportConfig in a given project and location.
            #
            # @overload create_report_config(request, options = nil)
            #   Pass arguments to `create_report_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::CreateReportConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::CreateReportConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_report_config(parent: nil, report_config: nil, request_id: nil)
            #   Pass arguments to `create_report_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param report_config [::Google::Cloud::StorageInsights::V1::ReportConfig, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::StorageInsights::V1::ReportConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::StorageInsights::V1::ReportConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::CreateReportConfigRequest.new
            #
            #   # Call the create_report_config method.
            #   result = client.create_report_config request
            #
            #   # The returned object is of type Google::Cloud::StorageInsights::V1::ReportConfig.
            #   p result
            #
            def create_report_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::CreateReportConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_report_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_report_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_report_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :create_report_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ReportConfig.
            #
            # @overload update_report_config(request, options = nil)
            #   Pass arguments to `update_report_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_report_config(update_mask: nil, report_config: nil, request_id: nil)
            #   Pass arguments to `update_report_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     ReportConfig resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param report_config [::Google::Cloud::StorageInsights::V1::ReportConfig, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::StorageInsights::V1::ReportConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::StorageInsights::V1::ReportConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest.new
            #
            #   # Call the update_report_config method.
            #   result = client.update_report_config request
            #
            #   # The returned object is of type Google::Cloud::StorageInsights::V1::ReportConfig.
            #   p result
            #
            def update_report_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::UpdateReportConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_report_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.report_config&.name
                header_params["report_config.name"] = request.report_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_report_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_report_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :update_report_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ReportConfig.
            #
            # @overload delete_report_config(request, options = nil)
            #   Pass arguments to `delete_report_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_report_config(name: nil, force: nil, request_id: nil)
            #   Pass arguments to `delete_report_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param force [::Boolean]
            #     Optional. If set, all ReportDetails for this ReportConfig will be deleted.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest.new
            #
            #   # Call the delete_report_config method.
            #   result = client.delete_report_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_report_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::DeleteReportConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_report_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_report_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_report_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :delete_report_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ReportDetails in a given project and location.
            #
            # @overload list_report_details(request, options = nil)
            #   Pass arguments to `list_report_details` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::ListReportDetailsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::ListReportDetailsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_report_details(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_report_details` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListReportDetailsRequest
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested.
            #     If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Filtering results
            #   @param order_by [::String]
            #     Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::ReportDetail>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::ReportDetail>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::ListReportDetailsRequest.new
            #
            #   # Call the list_report_details method.
            #   result = client.list_report_details request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::StorageInsights::V1::ReportDetail.
            #     p item
            #   end
            #
            def list_report_details request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::ListReportDetailsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_report_details.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_report_details.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_report_details.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :list_report_details, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @storage_insights_stub, :list_report_details, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ReportDetail.
            #
            # @overload get_report_detail(request, options = nil)
            #   Pass arguments to `get_report_detail` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::GetReportDetailRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::GetReportDetailRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_report_detail(name: nil)
            #   Pass arguments to `get_report_detail` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::StorageInsights::V1::ReportDetail]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::StorageInsights::V1::ReportDetail]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::GetReportDetailRequest.new
            #
            #   # Call the get_report_detail method.
            #   result = client.get_report_detail request
            #
            #   # The returned object is of type Google::Cloud::StorageInsights::V1::ReportDetail.
            #   p result
            #
            def get_report_detail request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::GetReportDetailRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_report_detail.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_report_detail.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_report_detail.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :get_report_detail, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the dataset configurations in a given project for a given location.
            #
            # @overload list_dataset_configs(request, options = nil)
            #   Pass arguments to `list_dataset_configs` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_dataset_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_dataset_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListDatasetConfigsRequest
            #   @param page_size [::Integer]
            #     Requested page size. Server might return fewer items than requested.
            #     If unspecified, server picks an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Filtering results
            #   @param order_by [::String]
            #     Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::DatasetConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::StorageInsights::V1::DatasetConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest.new
            #
            #   # Call the list_dataset_configs method.
            #   result = client.list_dataset_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::StorageInsights::V1::DatasetConfig.
            #     p item
            #   end
            #
            def list_dataset_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::ListDatasetConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_dataset_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_dataset_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_dataset_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :list_dataset_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @storage_insights_stub, :list_dataset_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the dataset configuration in a given project for a given location.
            #
            # @overload get_dataset_config(request, options = nil)
            #   Pass arguments to `get_dataset_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dataset_config(name: nil)
            #   Pass arguments to `get_dataset_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::StorageInsights::V1::DatasetConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::StorageInsights::V1::DatasetConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest.new
            #
            #   # Call the get_dataset_config method.
            #   result = client.get_dataset_config request
            #
            #   # The returned object is of type Google::Cloud::StorageInsights::V1::DatasetConfig.
            #   p result
            #
            def get_dataset_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::GetDatasetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dataset_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dataset_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dataset_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :get_dataset_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a dataset configuration in a given project for a given location.
            #
            # @overload create_dataset_config(request, options = nil)
            #   Pass arguments to `create_dataset_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_dataset_config(parent: nil, dataset_config_id: nil, dataset_config: nil, request_id: nil)
            #   Pass arguments to `create_dataset_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param dataset_config_id [::String]
            #     Required. ID of the requesting object.
            #     If auto-generating ID is enabled on the server-side, remove this field and
            #     `dataset_config_id` from the method_signature of Create RPC
            #     Note: The value should not contain any hyphens.
            #   @param dataset_config [::Google::Cloud::StorageInsights::V1::DatasetConfig, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. A unique identifier for your request.
            #     Specify the request ID if you need to retry the request.
            #     If you retry the request with the same ID within 60 minutes, the server
            #     ignores the request if it has already completed the original request.
            #
            #     For example, if your initial request times out and you retry the request
            #     using the same request ID, the server recognizes the original request and
            #     does not process the new request.
            #
            #     The request ID must be a valid UUID and cannot be a zero UUID
            #     (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest.new
            #
            #   # Call the create_dataset_config method.
            #   result = client.create_dataset_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_dataset_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::CreateDatasetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_dataset_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_dataset_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_dataset_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :create_dataset_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a dataset configuration in a given project for a given location.
            #
            # @overload update_dataset_config(request, options = nil)
            #   Pass arguments to `update_dataset_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_dataset_config(update_mask: nil, dataset_config: nil, request_id: nil)
            #   Pass arguments to `update_dataset_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `DatasetConfig` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field is overwritten if it is in the mask. If the
            #     user does not provide a mask then it returns an "Invalid Argument" error.
            #   @param dataset_config [::Google::Cloud::StorageInsights::V1::DatasetConfig, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. A unique identifier for your request.
            #     Specify the request ID if you need to retry the request.
            #     If you retry the request with the same ID within 60 minutes, the server
            #     ignores the request if it has already completed the original request.
            #
            #     For example, if your initial request times out and you retry the request
            #     using the same request ID, the server recognizes the original request and
            #     does not process the new request.
            #
            #     The request ID must be a valid UUID and cannot be a zero UUID
            #     (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest.new
            #
            #   # Call the update_dataset_config method.
            #   result = client.update_dataset_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_dataset_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::UpdateDatasetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_dataset_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.dataset_config&.name
                header_params["dataset_config.name"] = request.dataset_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_dataset_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_dataset_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :update_dataset_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a dataset configuration in a given project for a given location.
            #
            # @overload delete_dataset_config(request, options = nil)
            #   Pass arguments to `delete_dataset_config` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_dataset_config(name: nil, request_id: nil)
            #   Pass arguments to `delete_dataset_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. A unique identifier for your request.
            #     Specify the request ID if you need to retry the request.
            #     If you retry the request with the same ID within 60 minutes, the server
            #     ignores the request if it has already completed the original request.
            #
            #     For example, if your initial request times out and you retry the request
            #     using the same request ID, the server recognizes the original request and
            #     does not process the new request.
            #
            #     The request ID must be a valid UUID and cannot be a zero UUID
            #     (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest.new
            #
            #   # Call the delete_dataset_config method.
            #   result = client.delete_dataset_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_dataset_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::DeleteDatasetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_dataset_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_dataset_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_dataset_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :delete_dataset_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Links a dataset to BigQuery in a given project for a given location.
            #
            # @overload link_dataset(request, options = nil)
            #   Pass arguments to `link_dataset` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::LinkDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::LinkDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload link_dataset(name: nil)
            #   Pass arguments to `link_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::LinkDatasetRequest.new
            #
            #   # Call the link_dataset method.
            #   result = client.link_dataset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def link_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::LinkDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.link_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.link_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.link_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :link_dataset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Unlinks a dataset from BigQuery in a given project
            # for a given location.
            #
            # @overload unlink_dataset(request, options = nil)
            #   Pass arguments to `unlink_dataset` via a request object, either of type
            #   {::Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload unlink_dataset(name: nil)
            #   Pass arguments to `unlink_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/storage_insights/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::StorageInsights::V1::StorageInsights::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest.new
            #
            #   # Call the unlink_dataset method.
            #   result = client.unlink_dataset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def unlink_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::StorageInsights::V1::UnlinkDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.unlink_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::StorageInsights::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.unlink_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.unlink_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @storage_insights_stub.call_rpc :unlink_dataset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the StorageInsights API.
            #
            # This class represents the configuration for StorageInsights,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::StorageInsights::V1::StorageInsights::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_report_configs to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_report_configs.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_report_configs.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::StorageInsights::V1::StorageInsights::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "storageinsights.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the StorageInsights API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_report_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_report_configs
                ##
                # RPC-specific configuration for `get_report_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_report_config
                ##
                # RPC-specific configuration for `create_report_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_report_config
                ##
                # RPC-specific configuration for `update_report_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_report_config
                ##
                # RPC-specific configuration for `delete_report_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_report_config
                ##
                # RPC-specific configuration for `list_report_details`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_report_details
                ##
                # RPC-specific configuration for `get_report_detail`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_report_detail
                ##
                # RPC-specific configuration for `list_dataset_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_dataset_configs
                ##
                # RPC-specific configuration for `get_dataset_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dataset_config
                ##
                # RPC-specific configuration for `create_dataset_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_dataset_config
                ##
                # RPC-specific configuration for `update_dataset_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_dataset_config
                ##
                # RPC-specific configuration for `delete_dataset_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_dataset_config
                ##
                # RPC-specific configuration for `link_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :link_dataset
                ##
                # RPC-specific configuration for `unlink_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :unlink_dataset

                # @private
                def initialize parent_rpcs = nil
                  list_report_configs_config = parent_rpcs.list_report_configs if parent_rpcs.respond_to? :list_report_configs
                  @list_report_configs = ::Gapic::Config::Method.new list_report_configs_config
                  get_report_config_config = parent_rpcs.get_report_config if parent_rpcs.respond_to? :get_report_config
                  @get_report_config = ::Gapic::Config::Method.new get_report_config_config
                  create_report_config_config = parent_rpcs.create_report_config if parent_rpcs.respond_to? :create_report_config
                  @create_report_config = ::Gapic::Config::Method.new create_report_config_config
                  update_report_config_config = parent_rpcs.update_report_config if parent_rpcs.respond_to? :update_report_config
                  @update_report_config = ::Gapic::Config::Method.new update_report_config_config
                  delete_report_config_config = parent_rpcs.delete_report_config if parent_rpcs.respond_to? :delete_report_config
                  @delete_report_config = ::Gapic::Config::Method.new delete_report_config_config
                  list_report_details_config = parent_rpcs.list_report_details if parent_rpcs.respond_to? :list_report_details
                  @list_report_details = ::Gapic::Config::Method.new list_report_details_config
                  get_report_detail_config = parent_rpcs.get_report_detail if parent_rpcs.respond_to? :get_report_detail
                  @get_report_detail = ::Gapic::Config::Method.new get_report_detail_config
                  list_dataset_configs_config = parent_rpcs.list_dataset_configs if parent_rpcs.respond_to? :list_dataset_configs
                  @list_dataset_configs = ::Gapic::Config::Method.new list_dataset_configs_config
                  get_dataset_config_config = parent_rpcs.get_dataset_config if parent_rpcs.respond_to? :get_dataset_config
                  @get_dataset_config = ::Gapic::Config::Method.new get_dataset_config_config
                  create_dataset_config_config = parent_rpcs.create_dataset_config if parent_rpcs.respond_to? :create_dataset_config
                  @create_dataset_config = ::Gapic::Config::Method.new create_dataset_config_config
                  update_dataset_config_config = parent_rpcs.update_dataset_config if parent_rpcs.respond_to? :update_dataset_config
                  @update_dataset_config = ::Gapic::Config::Method.new update_dataset_config_config
                  delete_dataset_config_config = parent_rpcs.delete_dataset_config if parent_rpcs.respond_to? :delete_dataset_config
                  @delete_dataset_config = ::Gapic::Config::Method.new delete_dataset_config_config
                  link_dataset_config = parent_rpcs.link_dataset if parent_rpcs.respond_to? :link_dataset
                  @link_dataset = ::Gapic::Config::Method.new link_dataset_config
                  unlink_dataset_config = parent_rpcs.unlink_dataset if parent_rpcs.respond_to? :unlink_dataset
                  @unlink_dataset = ::Gapic::Config::Method.new unlink_dataset_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
