# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module StorageBatchOperations
      module V1
        # The Storage Batch Operations Job description.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the Job. job_id is unique
        #     within the project, that is either set by the customer or
        #     defined by the service. Format:
        #     projects/\\{project}/locations/global/jobs/\\{job_id} .
        #     For example: "projects/123456/locations/global/jobs/job01".
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description provided by the user for the job. Its max length is
        #     1024 bytes when Unicode-encoded.
        # @!attribute [rw] bucket_list
        #   @return [::Google::Cloud::StorageBatchOperations::V1::BucketList]
        #     Specifies a list of buckets and their objects to be transformed.
        # @!attribute [rw] put_object_hold
        #   @return [::Google::Cloud::StorageBatchOperations::V1::PutObjectHold]
        #     Changes object hold status.
        #
        #     Note: The following fields are mutually exclusive: `put_object_hold`, `delete_object`, `put_metadata`, `rewrite_object`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete_object
        #   @return [::Google::Cloud::StorageBatchOperations::V1::DeleteObject]
        #     Delete objects.
        #
        #     Note: The following fields are mutually exclusive: `delete_object`, `put_object_hold`, `put_metadata`, `rewrite_object`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] put_metadata
        #   @return [::Google::Cloud::StorageBatchOperations::V1::PutMetadata]
        #     Updates object metadata. Allows updating fixed-key and custom metadata
        #     and fixed-key metadata i.e. Cache-Control, Content-Disposition,
        #     Content-Encoding, Content-Language, Content-Type, Custom-Time.
        #
        #     Note: The following fields are mutually exclusive: `put_metadata`, `put_object_hold`, `delete_object`, `rewrite_object`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rewrite_object
        #   @return [::Google::Cloud::StorageBatchOperations::V1::RewriteObject]
        #     Rewrite the object and updates metadata like KMS key.
        #
        #     Note: The following fields are mutually exclusive: `rewrite_object`, `put_object_hold`, `delete_object`, `put_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::StorageBatchOperations::V1::LoggingConfig]
        #     Optional. Logging configuration.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the job was created.
        # @!attribute [r] schedule_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the job was scheduled.
        # @!attribute [r] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the job was completed.
        # @!attribute [r] counters
        #   @return [::Google::Cloud::StorageBatchOperations::V1::Counters]
        #     Output only. Information about the progress of the job.
        # @!attribute [r] error_summaries
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::ErrorSummary>]
        #     Output only. Summarizes errors encountered with sample error log entries.
        # @!attribute [r] state
        #   @return [::Google::Cloud::StorageBatchOperations::V1::Job::State]
        #     Output only. State of the job.
        # @!attribute [rw] dry_run
        #   @return [::Boolean]
        #     Optional. If true, the job will run in dry run mode, returning the total
        #     object count and, if the object configuration is a prefix list, the bytes
        #     found from source. No transformations will be performed.
        class Job
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes state of a job.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # In progress.
            RUNNING = 1

            # Completed successfully.
            SUCCEEDED = 2

            # Cancelled by the user.
            CANCELED = 3

            # Terminated due to an unrecoverable failure.
            FAILED = 4
          end
        end

        # Describes list of buckets and their objects to be transformed.
        # @!attribute [rw] buckets
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::BucketList::Bucket>]
        #     Required. List of buckets and their objects to be transformed. Currently,
        #     only one bucket configuration is supported. If multiple buckets are
        #     specified, an error will be returned.
        class BucketList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes configuration of a single bucket and its objects to be
          # transformed.
          # @!attribute [rw] bucket
          #   @return [::String]
          #     Required. Bucket name for the objects to be transformed.
          # @!attribute [rw] prefix_list
          #   @return [::Google::Cloud::StorageBatchOperations::V1::PrefixList]
          #     Specifies objects matching a prefix set.
          #
          #     Note: The following fields are mutually exclusive: `prefix_list`, `manifest`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] manifest
          #   @return [::Google::Cloud::StorageBatchOperations::V1::Manifest]
          #     Specifies objects in a manifest file.
          #
          #     Note: The following fields are mutually exclusive: `manifest`, `prefix_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Bucket
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes list of objects to be transformed.
        # @!attribute [rw] manifest_location
        #   @return [::String]
        #     Required. `manifest_location` must contain the manifest source file that is
        #     a CSV file in a Google Cloud Storage bucket. Each row in the file must
        #     include the object details i.e. BucketId and Name. Generation may
        #     optionally be specified. When it is not specified the live object is acted
        #     upon. `manifest_location` should either be 1) An absolute path to the
        #     object in the format of `gs://bucket_name/path/file_name.csv`. 2) An
        #     absolute path with a single wildcard character in the file name, for
        #     example `gs://bucket_name/path/file_name*.csv`.
        #     If manifest location is specified with a wildcard, objects in all manifest
        #     files matching the pattern will be acted upon.
        class Manifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes prefixes of objects to be transformed.
        # @!attribute [rw] included_object_prefixes
        #   @return [::Array<::String>]
        #     Optional. Include prefixes of the objects to be transformed.
        #     * Supports full object name
        #     * Supports prefix of the object name
        #     * Wildcards are not supported
        #     * Supports empty string for all objects in a bucket.
        class PrefixList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes options to update object hold.
        # @!attribute [rw] temporary_hold
        #   @return [::Google::Cloud::StorageBatchOperations::V1::PutObjectHold::HoldStatus]
        #     Required. Updates object temporary holds state. When object temporary hold
        #     is set, object cannot be deleted or replaced.
        # @!attribute [rw] event_based_hold
        #   @return [::Google::Cloud::StorageBatchOperations::V1::PutObjectHold::HoldStatus]
        #     Required. Updates object event based holds state. When object event based
        #     hold is set, object cannot be deleted or replaced. Resets object's time in
        #     the bucket for the purposes of the retention period.
        class PutObjectHold
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the status of the hold.
          module HoldStatus
            # Default value, Object hold status will not be changed.
            HOLD_STATUS_UNSPECIFIED = 0

            # Places the hold.
            SET = 1

            # Releases the hold.
            UNSET = 2
          end
        end

        # Describes options to delete an object.
        # @!attribute [rw] permanent_object_deletion_enabled
        #   @return [::Boolean]
        #     Required. Controls deletion behavior when versioning is enabled for the
        #     object's bucket. If true both live and noncurrent objects will be
        #     permanently deleted. Otherwise live objects in versioned buckets will
        #     become noncurrent and objects that were already noncurrent will be skipped.
        #     This setting doesn't have any impact on the Soft Delete feature. All
        #     objects deleted by this service can be be restored for the duration of the
        #     Soft Delete retention duration if enabled. If enabled and the manifest
        #     doesn't specify an object's generation, a GetObjectMetadata call (a Class B
        #     operation) will be made to determine the live object generation.
        class DeleteObject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes options for object rewrite.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Required. Resource name of the Cloud KMS key that will be used to encrypt
        #     the object. The Cloud KMS key must be located in same location as the
        #     object. Refer to
        #     https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys#add-object-key
        #     for additional documentation. Format:
        #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyring}/cryptoKeys/\\{key}
        #     For example:
        #     "projects/123456/locations/us-central1/keyRings/my-keyring/cryptoKeys/my-key".
        #     The object will be rewritten and set with the specified KMS key.
        class RewriteObject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes options for object retention update.
        # @!attribute [rw] retain_until_time
        #   @return [::String]
        #     Required. The time when the object will be retained until. UNSET will clear
        #     the retention. Must be specified in RFC 3339 format e.g.
        #     YYYY-MM-DD'T'HH:MM:SS.SS'Z' or YYYY-MM-DD'T'HH:MM:SS'Z'.
        # @!attribute [rw] retention_mode
        #   @return [::Google::Cloud::StorageBatchOperations::V1::ObjectRetention::RetentionMode]
        #     Required. The retention mode of the object.
        class ObjectRetention
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the retention mode.
          module RetentionMode
            # If set and retain_until_time is empty, clears the retention.
            RETENTION_MODE_UNSPECIFIED = 0

            # Sets the retention mode to locked.
            LOCKED = 1

            # Sets the retention mode to unlocked.
            UNLOCKED = 2
          end
        end

        # Describes options for object metadata update.
        # @!attribute [rw] content_disposition
        #   @return [::String]
        #     Optional. Updates objects Content-Disposition fixed metadata. Unset values
        #     will be ignored. Set empty values to clear the metadata. Refer
        #     https://cloud.google.com/storage/docs/metadata#content-disposition for
        #     additional documentation.
        # @!attribute [rw] content_encoding
        #   @return [::String]
        #     Optional. Updates objects Content-Encoding fixed metadata. Unset values
        #     will be ignored. Set empty values to clear the metadata. Refer to
        #     documentation in
        #     https://cloud.google.com/storage/docs/metadata#content-encoding.
        # @!attribute [rw] content_language
        #   @return [::String]
        #     Optional. Updates objects Content-Language fixed metadata. Refer to ISO
        #     639-1 language codes for typical values of this metadata. Max length 100
        #     characters. Unset values will be ignored. Set empty values to clear the
        #     metadata. Refer to documentation in
        #     https://cloud.google.com/storage/docs/metadata#content-language.
        # @!attribute [rw] content_type
        #   @return [::String]
        #     Optional. Updates objects Content-Type fixed metadata. Unset values will be
        #     ignored. Set empty values to clear the metadata. Refer to documentation in
        #     https://cloud.google.com/storage/docs/metadata#content-type
        # @!attribute [rw] cache_control
        #   @return [::String]
        #     Optional. Updates objects Cache-Control fixed metadata. Unset values will
        #     be ignored. Set empty values to clear the metadata. Additionally, the value
        #     for Custom-Time cannot decrease. Refer to documentation in
        #     https://cloud.google.com/storage/docs/metadata#caching_data.
        # @!attribute [rw] custom_time
        #   @return [::String]
        #     Optional. Updates objects Custom-Time fixed metadata. Unset values will be
        #     ignored. Set empty values to clear the metadata. Refer to documentation in
        #     https://cloud.google.com/storage/docs/metadata#custom-time.
        # @!attribute [rw] custom_metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Updates objects custom metadata. Adds or sets individual custom
        #     metadata key value pairs on objects. Keys that are set with empty custom
        #     metadata values will have its value cleared. Existing custom metadata not
        #     specified with this flag is not changed. Refer to documentation in
        #     https://cloud.google.com/storage/docs/metadata#custom-metadata
        # @!attribute [rw] object_retention
        #   @return [::Google::Cloud::StorageBatchOperations::V1::ObjectRetention]
        #     Optional. Updates objects retention lock configuration. Unset values will
        #     be ignored. Set empty values to clear the retention for the object with
        #     existing `Unlocked` retention mode. Object with existing `Locked` retention
        #     mode cannot be cleared or reduce retain_until_time. Refer to documentation
        #     in https://cloud.google.com/storage/docs/object-lock
        class PutMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class CustomMetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A summary of errors by error code, plus a count and sample error log
        # entries.
        # @!attribute [rw] error_code
        #   @return [::Google::Rpc::Code]
        #     Required. The canonical error code.
        # @!attribute [rw] error_count
        #   @return [::Integer]
        #     Required. Number of errors encountered per `error_code`.
        # @!attribute [rw] error_log_entries
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::ErrorLogEntry>]
        #     Required. Sample error logs.
        class ErrorSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entry describing an error that has occurred.
        # @!attribute [r] object_uri
        #   @return [::String]
        #     Required. Output only. Object URL. e.g. gs://my_bucket/object.txt
        # @!attribute [r] error_details
        #   @return [::Array<::String>]
        #     Optional. Output only. At most 5 error log entries are recorded for a given
        #     error code for a job.
        class ErrorLogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes details about the progress of the job.
        # @!attribute [r] total_object_count
        #   @return [::Integer]
        #     Output only. Number of objects listed.
        # @!attribute [r] succeeded_object_count
        #   @return [::Integer]
        #     Output only. Number of objects completed.
        # @!attribute [r] failed_object_count
        #   @return [::Integer]
        #     Output only. Number of objects failed.
        # @!attribute [r] total_bytes_found
        #   @return [::Integer]
        #     Output only. Number of bytes found from source. This field is only
        #     populated for jobs with a prefix list object configuration.
        class Counters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies the Cloud Logging behavior.
        # @!attribute [rw] log_actions
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::LoggingConfig::LoggableAction>]
        #     Required. Specifies the actions to be logged.
        # @!attribute [rw] log_action_states
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::LoggingConfig::LoggableActionState>]
        #     Required. States in which Action are logged.If empty, no logs are
        #     generated.
        class LoggingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Loggable actions types.
          module LoggableAction
            # Illegal value, to avoid allowing a default.
            LOGGABLE_ACTION_UNSPECIFIED = 0

            # The corresponding transform action in this job.
            TRANSFORM = 6
          end

          # Loggable action states filter.
          module LoggableActionState
            # Illegal value, to avoid allowing a default.
            LOGGABLE_ACTION_STATE_UNSPECIFIED = 0

            # `LoggableAction` completed successfully. `SUCCEEDED` actions are
            # logged as [INFO][google.logging.type.LogSeverity.INFO].
            SUCCEEDED = 1

            # `LoggableAction` terminated in an error state. `FAILED` actions
            # are logged as [ERROR][google.logging.type.LogSeverity.ERROR].
            FAILED = 2
          end
        end
      end
    end
  end
end
