# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module StorageBatchOperations
      module V1
        # Message for request to list Jobs
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: projects/\\{project_id}/locations/global.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filters results as defined by https://google.aip.dev/160.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The list page size. default page size is 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The list page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Supported fields are name, create_time.
        class ListJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Jobs
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::StorageBatchOperations::V1::Job>]
        #     A list of storage batch jobs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Job
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. `name` of the job to retrieve.
        #     Format: projects/\\{project_id}/locations/global/jobs/\\{job_id} .
        class GetJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Job
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     Required. The optional `job_id` for this Job . If not
        #     specified, an id is generated. `job_id` should be no more than 128
        #     characters and must include only characters available in DNS names, as
        #     defined by RFC-1123.
        # @!attribute [rw] job
        #   @return [::Google::Cloud::StorageBatchOperations::V1::Job]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID in case you need to retry your request. Requests with same
        #     `request_id` will be ignored for at least 60 minutes since the first
        #     request. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class CreateJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for Job to Cancel
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The `name` of the job to cancel.
        #     Format: projects/\\{project_id}/locations/global/jobs/\\{job_id}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID in case you need to retry your request. Requests with same
        #     `request_id` will be ignored for at least 60 minutes since the first
        #     request. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class CancelJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Job
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The `name` of the job to delete.
        #     Format: projects/\\{project_id}/locations/global/jobs/\\{job_id} .
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID in case you need to retry your request. Requests with same
        #     `request_id` will be ignored for at least 60 minutes since the first
        #     request. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class DeleteJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to cancel Job.
        class CancelJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] operation
        #   @return [::String]
        #     Output only. The unique operation resource name.
        #     Format: projects/\\{project}/locations/global/operations/\\{operation}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to
        #     `[Code.CANCELLED][google.rpc.Code.CANCELLED]`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        # @!attribute [r] job
        #   @return [::Google::Cloud::StorageBatchOperations::V1::Job]
        #     Output only. The Job associated with the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
