# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/storage_batch_operations/v1/version"
require "google/cloud/storage_batch_operations/v1/bindings_override"

require "google/cloud/storage_batch_operations/v1/storage_batch_operations/credentials"
require "google/cloud/storage_batch_operations/v1/storage_batch_operations/paths"
require "google/cloud/storage_batch_operations/v1/storage_batch_operations/rest/operations"
require "google/cloud/storage_batch_operations/v1/storage_batch_operations/rest/client"

module Google
  module Cloud
    module StorageBatchOperations
      module V1
        ##
        # Storage Batch Operations offers a managed experience to perform batch
        # operations on millions of Cloud Storage objects in a serverless fashion. With
        # this service, you can automate and simplify large scale API operations
        # performed on Cloud Storage objects.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/storage_batch_operations/v1/storage_batch_operations/rest"
        #     client = ::Google::Cloud::StorageBatchOperations::V1::StorageBatchOperations::Rest::Client.new
        #
        module StorageBatchOperations
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/storage_batch_operations/v1/storage_batch_operations/rest/helpers" if ::File.file? helper_path
