# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/storage/control/v2/storage_control_pb"
require "google/cloud/storage/control/v2/storage_control"

class ::Google::Cloud::Storage::Control::V2::StorageControl::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_folder
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::Folder.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    folder = {}
    folder_id = "hello world"
    recursive = true
    request_id = "hello world"

    create_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::CreateFolderRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::Folder), request["folder"]
      assert_equal "hello world", request["folder_id"]
      assert_equal true, request["recursive"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_folder({ parent: parent, folder: folder, folder_id: folder_id, recursive: recursive, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_folder parent: parent, folder: folder, folder_id: folder_id, recursive: recursive, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_folder ::Google::Cloud::Storage::Control::V2::CreateFolderRequest.new(parent: parent, folder: folder, folder_id: folder_id, recursive: recursive, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_folder({ parent: parent, folder: folder, folder_id: folder_id, recursive: recursive, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_folder(::Google::Cloud::Storage::Control::V2::CreateFolderRequest.new(parent: parent, folder: folder, folder_id: folder_id, recursive: recursive, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_folder_client_stub.call_rpc_count
    end
  end

  def test_delete_folder
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    if_metageneration_match = 42
    if_metageneration_not_match = 42
    request_id = "hello world"

    delete_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::DeleteFolderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["if_metageneration_match"]
      assert request.has_if_metageneration_match?
      assert_equal 42, request["if_metageneration_not_match"]
      assert request.has_if_metageneration_not_match?
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_folder name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_folder ::Google::Cloud::Storage::Control::V2::DeleteFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_folder(::Google::Cloud::Storage::Control::V2::DeleteFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_folder_client_stub.call_rpc_count
    end
  end

  def test_get_folder
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::Folder.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    if_metageneration_match = 42
    if_metageneration_not_match = 42
    request_id = "hello world"

    get_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetFolderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["if_metageneration_match"]
      assert request.has_if_metageneration_match?
      assert_equal 42, request["if_metageneration_not_match"]
      assert request.has_if_metageneration_not_match?
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_folder name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_folder ::Google::Cloud::Storage::Control::V2::GetFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_folder(::Google::Cloud::Storage::Control::V2::GetFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_folder_client_stub.call_rpc_count
    end
  end

  def test_list_folders
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::ListFoldersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    prefix = "hello world"
    delimiter = "hello world"
    lexicographic_start = "hello world"
    lexicographic_end = "hello world"
    request_id = "hello world"

    list_folders_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_folders, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::ListFoldersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["prefix"]
      assert_equal "hello world", request["delimiter"]
      assert_equal "hello world", request["lexicographic_start"]
      assert_equal "hello world", request["lexicographic_end"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_folders_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_folders({ parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, delimiter: delimiter, lexicographic_start: lexicographic_start, lexicographic_end: lexicographic_end, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_folders parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, delimiter: delimiter, lexicographic_start: lexicographic_start, lexicographic_end: lexicographic_end, request_id: request_id do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_folders ::Google::Cloud::Storage::Control::V2::ListFoldersRequest.new(parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, delimiter: delimiter, lexicographic_start: lexicographic_start, lexicographic_end: lexicographic_end, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_folders({ parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, delimiter: delimiter, lexicographic_start: lexicographic_start, lexicographic_end: lexicographic_end, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_folders(::Google::Cloud::Storage::Control::V2::ListFoldersRequest.new(parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, delimiter: delimiter, lexicographic_start: lexicographic_start, lexicographic_end: lexicographic_end, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_folders_client_stub.call_rpc_count
    end
  end

  def test_rename_folder
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    destination_folder_id = "hello world"
    if_metageneration_match = 42
    if_metageneration_not_match = 42
    request_id = "hello world"

    rename_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rename_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::RenameFolderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["destination_folder_id"]
      assert_equal 42, request["if_metageneration_match"]
      assert request.has_if_metageneration_match?
      assert_equal 42, request["if_metageneration_not_match"]
      assert request.has_if_metageneration_not_match?
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rename_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rename_folder({ name: name, destination_folder_id: destination_folder_id, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rename_folder name: name, destination_folder_id: destination_folder_id, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rename_folder ::Google::Cloud::Storage::Control::V2::RenameFolderRequest.new(name: name, destination_folder_id: destination_folder_id, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rename_folder({ name: name, destination_folder_id: destination_folder_id, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rename_folder(::Google::Cloud::Storage::Control::V2::RenameFolderRequest.new(name: name, destination_folder_id: destination_folder_id, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rename_folder_client_stub.call_rpc_count
    end
  end

  def test_get_storage_layout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::StorageLayout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    prefix = "hello world"
    request_id = "hello world"

    get_storage_layout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_storage_layout, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["prefix"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_storage_layout_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_storage_layout({ name: name, prefix: prefix, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_storage_layout name: name, prefix: prefix, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_storage_layout ::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest.new(name: name, prefix: prefix, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_storage_layout({ name: name, prefix: prefix, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_storage_layout(::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest.new(name: name, prefix: prefix, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_storage_layout_client_stub.call_rpc_count
    end
  end

  def test_create_managed_folder
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::ManagedFolder.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    managed_folder = {}
    managed_folder_id = "hello world"
    request_id = "hello world"

    create_managed_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_managed_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::ManagedFolder), request["managed_folder"]
      assert_equal "hello world", request["managed_folder_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_managed_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_managed_folder({ parent: parent, managed_folder: managed_folder, managed_folder_id: managed_folder_id, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_managed_folder parent: parent, managed_folder: managed_folder, managed_folder_id: managed_folder_id, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_managed_folder ::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest.new(parent: parent, managed_folder: managed_folder, managed_folder_id: managed_folder_id, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_managed_folder({ parent: parent, managed_folder: managed_folder, managed_folder_id: managed_folder_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_managed_folder(::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest.new(parent: parent, managed_folder: managed_folder, managed_folder_id: managed_folder_id, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_managed_folder_client_stub.call_rpc_count
    end
  end

  def test_delete_managed_folder
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    if_metageneration_match = 42
    if_metageneration_not_match = 42
    allow_non_empty = true
    request_id = "hello world"

    delete_managed_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_managed_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["if_metageneration_match"]
      assert request.has_if_metageneration_match?
      assert_equal 42, request["if_metageneration_not_match"]
      assert request.has_if_metageneration_not_match?
      assert_equal true, request["allow_non_empty"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_managed_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_managed_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, allow_non_empty: allow_non_empty, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_managed_folder name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, allow_non_empty: allow_non_empty, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_managed_folder ::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, allow_non_empty: allow_non_empty, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_managed_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, allow_non_empty: allow_non_empty, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_managed_folder(::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, allow_non_empty: allow_non_empty, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_managed_folder_client_stub.call_rpc_count
    end
  end

  def test_get_managed_folder
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::ManagedFolder.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    if_metageneration_match = 42
    if_metageneration_not_match = 42
    request_id = "hello world"

    get_managed_folder_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_managed_folder, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["if_metageneration_match"]
      assert request.has_if_metageneration_match?
      assert_equal 42, request["if_metageneration_not_match"]
      assert request.has_if_metageneration_not_match?
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_managed_folder_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_managed_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_managed_folder name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_managed_folder ::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_managed_folder({ name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_managed_folder(::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest.new(name: name, if_metageneration_match: if_metageneration_match, if_metageneration_not_match: if_metageneration_not_match, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_managed_folder_client_stub.call_rpc_count
    end
  end

  def test_list_managed_folders
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::ListManagedFoldersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    prefix = "hello world"
    request_id = "hello world"

    list_managed_folders_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_managed_folders, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["prefix"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_managed_folders_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_managed_folders({ parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_managed_folders parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, request_id: request_id do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_managed_folders ::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest.new(parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_managed_folders({ parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_managed_folders(::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest.new(parent: parent, page_size: page_size, page_token: page_token, prefix: prefix, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_managed_folders_client_stub.call_rpc_count
    end
  end

  def test_create_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    anywhere_cache = {}
    request_id = "hello world"

    create_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::AnywhereCache), request["anywhere_cache"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_anywhere_cache({ parent: parent, anywhere_cache: anywhere_cache, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_anywhere_cache parent: parent, anywhere_cache: anywhere_cache, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_anywhere_cache ::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest.new(parent: parent, anywhere_cache: anywhere_cache, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_anywhere_cache({ parent: parent, anywhere_cache: anywhere_cache, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_anywhere_cache(::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest.new(parent: parent, anywhere_cache: anywhere_cache, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_update_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    anywhere_cache = {}
    update_mask = {}
    request_id = "hello world"

    update_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::AnywhereCache), request["anywhere_cache"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_anywhere_cache({ anywhere_cache: anywhere_cache, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_anywhere_cache anywhere_cache: anywhere_cache, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_anywhere_cache ::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest.new(anywhere_cache: anywhere_cache, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_anywhere_cache({ anywhere_cache: anywhere_cache, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_anywhere_cache(::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest.new(anywhere_cache: anywhere_cache, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_disable_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::AnywhereCache.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    disable_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :disable_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, disable_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.disable_anywhere_cache({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.disable_anywhere_cache name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.disable_anywhere_cache ::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.disable_anywhere_cache({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.disable_anywhere_cache(::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, disable_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_pause_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::AnywhereCache.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    pause_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pause_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pause_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pause_anywhere_cache({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pause_anywhere_cache name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pause_anywhere_cache ::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pause_anywhere_cache({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pause_anywhere_cache(::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pause_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_resume_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::AnywhereCache.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    resume_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_anywhere_cache({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_anywhere_cache name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_anywhere_cache ::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_anywhere_cache({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_anywhere_cache(::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_get_anywhere_cache
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::AnywhereCache.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    get_anywhere_cache_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_anywhere_cache, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_anywhere_cache_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_anywhere_cache({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_anywhere_cache name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_anywhere_cache ::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_anywhere_cache({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_anywhere_cache(::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_anywhere_cache_client_stub.call_rpc_count
    end
  end

  def test_list_anywhere_caches
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::ListAnywhereCachesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    request_id = "hello world"

    list_anywhere_caches_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_anywhere_caches, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_anywhere_caches_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_anywhere_caches({ parent: parent, page_size: page_size, page_token: page_token, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_anywhere_caches parent: parent, page_size: page_size, page_token: page_token, request_id: request_id do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_anywhere_caches ::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest.new(parent: parent, page_size: page_size, page_token: page_token, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_anywhere_caches({ parent: parent, page_size: page_size, page_token: page_token, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_anywhere_caches(::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest.new(parent: parent, page_size: page_size, page_token: page_token, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_anywhere_caches_client_stub.call_rpc_count
    end
  end

  def test_get_project_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_project_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_project_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_project_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_project_intelligence_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_project_intelligence_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_project_intelligence_config ::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_project_intelligence_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_project_intelligence_config(::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_project_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_update_project_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    intelligence_config = {}
    update_mask = {}
    request_id = "hello world"

    update_project_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_project_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::IntelligenceConfig), request["intelligence_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_project_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_project_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_project_intelligence_config intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_project_intelligence_config ::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_project_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_project_intelligence_config(::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_project_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_get_folder_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_folder_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_folder_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_folder_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_folder_intelligence_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_folder_intelligence_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_folder_intelligence_config ::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_folder_intelligence_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_folder_intelligence_config(::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_folder_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_update_folder_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    intelligence_config = {}
    update_mask = {}
    request_id = "hello world"

    update_folder_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_folder_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::IntelligenceConfig), request["intelligence_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_folder_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_folder_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_folder_intelligence_config intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_folder_intelligence_config ::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_folder_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_folder_intelligence_config(::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_folder_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_get_organization_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_organization_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_organization_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_organization_intelligence_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_organization_intelligence_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_organization_intelligence_config ::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_organization_intelligence_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_organization_intelligence_config(::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_organization_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_update_organization_intelligence_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Storage::Control::V2::IntelligenceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    intelligence_config = {}
    update_mask = {}
    request_id = "hello world"

    update_organization_intelligence_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_organization_intelligence_config, name
      assert_kind_of ::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Storage::Control::V2::IntelligenceConfig), request["intelligence_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_organization_intelligence_config_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_organization_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_organization_intelligence_config intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_organization_intelligence_config ::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_organization_intelligence_config({ intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_organization_intelligence_config(::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest.new(intelligence_config: intelligence_config, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_organization_intelligence_config_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Storage::Control::V2::StorageControl::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Storage::Control::V2::StorageControl::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Storage::Control::V2::StorageControl::Operations, client.operations_client
  end
end
