# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/storage/control/v2/storage_control"

class ::Google::Cloud::Storage::Control::V2::StorageControl::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_anywhere_cache_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.anywhere_cache_path project: "value0", bucket: "value1", anywhere_cache: "value2"
      assert_equal "projects/value0/buckets/value1/anywhereCaches/value2", path
    end
  end

  def test_bucket_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.bucket_path project: "value0", bucket: "value1"
      assert_equal "projects/value0/buckets/value1", path
    end
  end

  def test_folder_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.folder_path project: "value0", bucket: "value1", folder: "value2"
      assert_equal "projects/value0/buckets/value1/folders/value2", path
    end
  end

  def test_intelligence_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.intelligence_config_path folder: "value0", location: "value1"
      assert_equal "folders/value0/locations/value1/intelligenceConfig", path

      path = client.intelligence_config_path org: "value0", location: "value1"
      assert_equal "organizations/value0/locations/value1/intelligenceConfig", path

      path = client.intelligence_config_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/intelligenceConfig", path
    end
  end

  def test_managed_folder_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.managed_folder_path project: "value0", bucket: "value1", managed_folder: "value2"
      assert_equal "projects/value0/buckets/value1/managedFolders/value2", path
    end
  end

  def test_storage_layout_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.storage_layout_path project: "value0", bucket: "value1"
      assert_equal "projects/value0/buckets/value1/storageLayout", path
    end
  end
end
