# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/storage/control/v2/storage_control_pb"
require "google/cloud/storage/control/v2/storage_control/rest/service_stub"

module Google
  module Cloud
    module Storage
      module Control
        module V2
          module StorageControl
            module Rest
              ##
              # REST client for the StorageControl service.
              #
              # StorageControl service includes selected control plane operations.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "storage.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :storage_control_stub

                ##
                # Configure the StorageControl Client class.
                #
                # See {::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all StorageControl clients
                #   ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Storage", "Control", "V2"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0

                    default_config.rpcs.get_project_intelligence_config.timeout = 60.0
                    default_config.rpcs.get_project_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config.rpcs.update_project_intelligence_config.timeout = 60.0
                    default_config.rpcs.update_project_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config.rpcs.get_folder_intelligence_config.timeout = 60.0
                    default_config.rpcs.get_folder_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config.rpcs.update_folder_intelligence_config.timeout = 60.0
                    default_config.rpcs.update_folder_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config.rpcs.get_organization_intelligence_config.timeout = 60.0
                    default_config.rpcs.get_organization_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config.rpcs.update_organization_intelligence_config.timeout = 60.0
                    default_config.rpcs.update_organization_intelligence_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the StorageControl Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @storage_control_stub.universe_domain
                end

                ##
                # Create a new StorageControl REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the StorageControl client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @storage_control_stub = ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @storage_control_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @storage_control_stub.logger
                end

                # Service calls

                ##
                # Returns the Project scoped singleton IntelligenceConfig resource.
                #
                # @overload get_project_intelligence_config(request, options = nil)
                #   Pass arguments to `get_project_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_project_intelligence_config(name: nil)
                #   Pass arguments to `get_project_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the `IntelligenceConfig` resource associated with
                #     your project.
                #
                #     Format: `projects/{id}/locations/global/intelligenceConfig`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest.new
                #
                #   # Call the get_project_intelligence_config method.
                #   result = client.get_project_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def get_project_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_project_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_project_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_project_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.get_project_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the Project scoped singleton IntelligenceConfig resource.
                #
                # @overload update_project_intelligence_config(request, options = nil)
                #   Pass arguments to `update_project_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_project_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_project_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
                #     Required. The `IntelligenceConfig` resource to be updated.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. The `update_mask` that specifies the fields within the
                #     `IntelligenceConfig` resource that should be modified by this update. Only
                #     the listed fields are updated.
                #   @param request_id [::String]
                #     Optional. The ID that uniquely identifies the request, preventing duplicate
                #     processing.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest.new
                #
                #   # Call the update_project_intelligence_config method.
                #   result = client.update_project_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def update_project_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_project_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_project_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_project_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.update_project_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the Folder scoped singleton IntelligenceConfig resource.
                #
                # @overload get_folder_intelligence_config(request, options = nil)
                #   Pass arguments to `get_folder_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_folder_intelligence_config(name: nil)
                #   Pass arguments to `get_folder_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the `IntelligenceConfig` resource associated with
                #     your folder.
                #
                #     Format: `folders/{id}/locations/global/intelligenceConfig`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest.new
                #
                #   # Call the get_folder_intelligence_config method.
                #   result = client.get_folder_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def get_folder_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_folder_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_folder_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_folder_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.get_folder_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the Folder scoped singleton IntelligenceConfig resource.
                #
                # @overload update_folder_intelligence_config(request, options = nil)
                #   Pass arguments to `update_folder_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_folder_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_folder_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
                #     Required. The `IntelligenceConfig` resource to be updated.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. The `update_mask` that specifies the fields within the
                #     `IntelligenceConfig` resource that should be modified by this update. Only
                #     the listed fields are updated.
                #   @param request_id [::String]
                #     Optional. The ID that uniquely identifies the request, preventing duplicate
                #     processing.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest.new
                #
                #   # Call the update_folder_intelligence_config method.
                #   result = client.update_folder_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def update_folder_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_folder_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_folder_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_folder_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.update_folder_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the Organization scoped singleton IntelligenceConfig resource.
                #
                # @overload get_organization_intelligence_config(request, options = nil)
                #   Pass arguments to `get_organization_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_organization_intelligence_config(name: nil)
                #   Pass arguments to `get_organization_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the `IntelligenceConfig` resource associated with
                #     your organization.
                #
                #     Format: `organizations/{org_id}/locations/global/intelligenceConfig`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest.new
                #
                #   # Call the get_organization_intelligence_config method.
                #   result = client.get_organization_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def get_organization_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_organization_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_organization_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_organization_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.get_organization_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the Organization scoped singleton IntelligenceConfig resource.
                #
                # @overload update_organization_intelligence_config(request, options = nil)
                #   Pass arguments to `update_organization_intelligence_config` via a request object, either of type
                #   {::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_organization_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_organization_intelligence_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
                #     Required. The `IntelligenceConfig` resource to be updated.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. The `update_mask` that specifies the fields within the
                #     `IntelligenceConfig` resource that should be modified by this update. Only
                #     the listed fields are updated.
                #   @param request_id [::String]
                #     Optional. The ID that uniquely identifies the request, preventing duplicate
                #     processing.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/storage/control/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest.new
                #
                #   # Call the update_organization_intelligence_config method.
                #   result = client.update_organization_intelligence_config request
                #
                #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
                #   p result
                #
                def update_organization_intelligence_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_organization_intelligence_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_organization_intelligence_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_organization_intelligence_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @storage_control_stub.update_organization_intelligence_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the StorageControl REST API.
                #
                # This class represents the configuration for StorageControl REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # get_project_intelligence_config to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.get_project_intelligence_config.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.get_project_intelligence_config.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "storage.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the StorageControl API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `get_project_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_project_intelligence_config
                    ##
                    # RPC-specific configuration for `update_project_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_project_intelligence_config
                    ##
                    # RPC-specific configuration for `get_folder_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_folder_intelligence_config
                    ##
                    # RPC-specific configuration for `update_folder_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_folder_intelligence_config
                    ##
                    # RPC-specific configuration for `get_organization_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_organization_intelligence_config
                    ##
                    # RPC-specific configuration for `update_organization_intelligence_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_organization_intelligence_config

                    # @private
                    def initialize parent_rpcs = nil
                      get_project_intelligence_config_config = parent_rpcs.get_project_intelligence_config if parent_rpcs.respond_to? :get_project_intelligence_config
                      @get_project_intelligence_config = ::Gapic::Config::Method.new get_project_intelligence_config_config
                      update_project_intelligence_config_config = parent_rpcs.update_project_intelligence_config if parent_rpcs.respond_to? :update_project_intelligence_config
                      @update_project_intelligence_config = ::Gapic::Config::Method.new update_project_intelligence_config_config
                      get_folder_intelligence_config_config = parent_rpcs.get_folder_intelligence_config if parent_rpcs.respond_to? :get_folder_intelligence_config
                      @get_folder_intelligence_config = ::Gapic::Config::Method.new get_folder_intelligence_config_config
                      update_folder_intelligence_config_config = parent_rpcs.update_folder_intelligence_config if parent_rpcs.respond_to? :update_folder_intelligence_config
                      @update_folder_intelligence_config = ::Gapic::Config::Method.new update_folder_intelligence_config_config
                      get_organization_intelligence_config_config = parent_rpcs.get_organization_intelligence_config if parent_rpcs.respond_to? :get_organization_intelligence_config
                      @get_organization_intelligence_config = ::Gapic::Config::Method.new get_organization_intelligence_config_config
                      update_organization_intelligence_config_config = parent_rpcs.update_organization_intelligence_config if parent_rpcs.respond_to? :update_organization_intelligence_config
                      @update_organization_intelligence_config = ::Gapic::Config::Method.new update_organization_intelligence_config_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
