# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Storage
      module Control
        module V2
          module StorageControl
            # Path helper methods for the StorageControl API.
            module Paths
              ##
              # Create a fully-qualified AnywhereCache resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
              #
              # @param project [String]
              # @param bucket [String]
              # @param anywhere_cache [String]
              #
              # @return [::String]
              def anywhere_cache_path project:, bucket:, anywhere_cache:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "bucket cannot contain /" if bucket.to_s.include? "/"

                "projects/#{project}/buckets/#{bucket}/anywhereCaches/#{anywhere_cache}"
              end

              ##
              # Create a fully-qualified Bucket resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/buckets/{bucket}`
              #
              # @param project [String]
              # @param bucket [String]
              #
              # @return [::String]
              def bucket_path project:, bucket:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/buckets/#{bucket}"
              end

              ##
              # Create a fully-qualified Folder resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/buckets/{bucket}/folders/{folder=**}`
              #
              # @param project [String]
              # @param bucket [String]
              # @param folder [String]
              #
              # @return [::String]
              def folder_path project:, bucket:, folder:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "bucket cannot contain /" if bucket.to_s.include? "/"

                "projects/#{project}/buckets/#{bucket}/folders/#{folder}"
              end

              ##
              # Create a fully-qualified IntelligenceConfig resource string.
              #
              # @overload intelligence_config_path(folder:, location:)
              #   The resource will be in the following format:
              #
              #   `folders/{folder}/locations/{location}/intelligenceConfig`
              #
              #   @param folder [String]
              #   @param location [String]
              #
              # @overload intelligence_config_path(org:, location:)
              #   The resource will be in the following format:
              #
              #   `organizations/{org}/locations/{location}/intelligenceConfig`
              #
              #   @param org [String]
              #   @param location [String]
              #
              # @overload intelligence_config_path(project:, location:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/intelligenceConfig`
              #
              #   @param project [String]
              #   @param location [String]
              #
              # @return [::String]
              def intelligence_config_path **args
                resources = {
                  "folder:location" => (proc do |folder:, location:|
                    raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                    "folders/#{folder}/locations/#{location}/intelligenceConfig"
                  end),
                  "location:org" => (proc do |org:, location:|
                    raise ::ArgumentError, "org cannot contain /" if org.to_s.include? "/"

                    "organizations/#{org}/locations/#{location}/intelligenceConfig"
                  end),
                  "location:project" => (proc do |project:, location:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/intelligenceConfig"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified ManagedFolder resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/buckets/{bucket}/managedFolders/{managed_folder=**}`
              #
              # @param project [String]
              # @param bucket [String]
              # @param managed_folder [String]
              #
              # @return [::String]
              def managed_folder_path project:, bucket:, managed_folder:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "bucket cannot contain /" if bucket.to_s.include? "/"

                "projects/#{project}/buckets/#{bucket}/managedFolders/#{managed_folder}"
              end

              ##
              # Create a fully-qualified StorageLayout resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/buckets/{bucket}/storageLayout`
              #
              # @param project [String]
              # @param bucket [String]
              #
              # @return [::String]
              def storage_layout_path project:, bucket:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/buckets/#{bucket}/storageLayout"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
