# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/storage/control/v2/storage_control_pb"

module Google
  module Cloud
    module Storage
      module Control
        module V2
          module StorageControl
            ##
            # Client for the StorageControl service.
            #
            # StorageControl service includes selected control plane operations.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "storage.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :storage_control_stub

              ##
              # Configure the StorageControl Client class.
              #
              # See {::Google::Cloud::Storage::Control::V2::StorageControl::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all StorageControl clients
              #   ::Google::Cloud::Storage::Control::V2::StorageControl::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Storage", "Control", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.create_folder.timeout = 60.0
                  default_config.rpcs.create_folder.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_folder.timeout = 60.0
                  default_config.rpcs.get_folder.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.list_folders.timeout = 60.0
                  default_config.rpcs.list_folders.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.rename_folder.timeout = 60.0
                  default_config.rpcs.rename_folder.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_storage_layout.timeout = 60.0
                  default_config.rpcs.get_storage_layout.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_managed_folder.timeout = 60.0
                  default_config.rpcs.get_managed_folder.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.list_managed_folders.timeout = 60.0
                  default_config.rpcs.list_managed_folders.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.create_anywhere_cache.timeout = 60.0
                  default_config.rpcs.create_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.update_anywhere_cache.timeout = 60.0
                  default_config.rpcs.update_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.disable_anywhere_cache.timeout = 60.0
                  default_config.rpcs.disable_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.pause_anywhere_cache.timeout = 60.0
                  default_config.rpcs.pause_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.resume_anywhere_cache.timeout = 60.0
                  default_config.rpcs.resume_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_anywhere_cache.timeout = 60.0
                  default_config.rpcs.get_anywhere_cache.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.list_anywhere_caches.timeout = 60.0
                  default_config.rpcs.list_anywhere_caches.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_project_intelligence_config.timeout = 60.0
                  default_config.rpcs.get_project_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.update_project_intelligence_config.timeout = 60.0
                  default_config.rpcs.update_project_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_folder_intelligence_config.timeout = 60.0
                  default_config.rpcs.get_folder_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.update_folder_intelligence_config.timeout = 60.0
                  default_config.rpcs.update_folder_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.get_organization_intelligence_config.timeout = 60.0
                  default_config.rpcs.get_organization_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config.rpcs.update_organization_intelligence_config.timeout = 60.0
                  default_config.rpcs.update_organization_intelligence_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [8, 14, 4, 13, 2]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the StorageControl Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Storage::Control::V2::StorageControl::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @storage_control_stub.universe_domain
              end

              ##
              # Create a new StorageControl client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the StorageControl client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/storage/control/v2/storage_control_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @storage_control_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Storage::Control::V2::StorageControl::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @storage_control_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Storage::Control::V2::StorageControl::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @storage_control_stub.logger
              end

              # Service calls

              ##
              # Creates a new folder. This operation is only applicable to a hierarchical
              # namespace enabled bucket.
              #
              # @overload create_folder(request, options = nil)
              #   Pass arguments to `create_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::CreateFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::CreateFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_folder(parent: nil, folder: nil, folder_id: nil, recursive: nil, request_id: nil)
              #   Pass arguments to `create_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the bucket in which the folder will reside. The bucket
              #     must be a hierarchical namespace enabled bucket.
              #   @param folder [::Google::Cloud::Storage::Control::V2::Folder, ::Hash]
              #     Required. Properties of the new folder being created.
              #     The bucket and name of the folder are specified in the parent and folder_id
              #     fields, respectively. Populating those fields in `folder` will result in an
              #     error.
              #   @param folder_id [::String]
              #     Required. The full name of a folder, including all its parent folders.
              #     Folders use single '/' characters as a delimiter.
              #     The folder_id must end with a slash.
              #     For example, the folder_id of "books/biographies/" would create a new
              #     "biographies/" folder under the "books/" folder.
              #   @param recursive [::Boolean]
              #     Optional. If true, parent folder doesn't have to be present and all missing
              #     ancestor folders will be created atomically.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::Folder]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::Folder]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::CreateFolderRequest.new
              #
              #   # Call the create_folder method.
              #   result = client.create_folder request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::Folder.
              #   p result
              #
              def create_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::CreateFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :create_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes an empty folder. This operation is only applicable to a
              # hierarchical namespace enabled bucket.
              #
              # @overload delete_folder(request, options = nil)
              #   Pass arguments to `delete_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::DeleteFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::DeleteFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_folder(name: nil, if_metageneration_match: nil, if_metageneration_not_match: nil, request_id: nil)
              #   Pass arguments to `delete_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the folder.
              #     Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
              #   @param if_metageneration_match [::Integer]
              #     Makes the operation only succeed conditional on whether the folder's
              #     current metageneration matches the given value.
              #   @param if_metageneration_not_match [::Integer]
              #     Makes the operation only succeed conditional on whether the folder's
              #     current metageneration does not match the given value.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::DeleteFolderRequest.new
              #
              #   # Call the delete_folder method.
              #   result = client.delete_folder request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::DeleteFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :delete_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns metadata for the specified folder. This operation is only
              # applicable to a hierarchical namespace enabled bucket.
              #
              # @overload get_folder(request, options = nil)
              #   Pass arguments to `get_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_folder(name: nil, if_metageneration_match: nil, if_metageneration_not_match: nil, request_id: nil)
              #   Pass arguments to `get_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the folder.
              #     Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
              #   @param if_metageneration_match [::Integer]
              #     Makes the operation only succeed conditional on whether the folder's
              #     current metageneration matches the given value.
              #   @param if_metageneration_not_match [::Integer]
              #     Makes the operation only succeed conditional on whether the folder's
              #     current metageneration does not match the given value.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::Folder]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::Folder]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetFolderRequest.new
              #
              #   # Call the get_folder method.
              #   result = client.get_folder request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::Folder.
              #   p result
              #
              def get_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a list of folders. This operation is only applicable to a
              # hierarchical namespace enabled bucket.
              #
              # @overload list_folders(request, options = nil)
              #   Pass arguments to `list_folders` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::ListFoldersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::ListFoldersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_folders(parent: nil, page_size: nil, page_token: nil, prefix: nil, delimiter: nil, lexicographic_start: nil, lexicographic_end: nil, request_id: nil)
              #   Pass arguments to `list_folders` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the bucket in which to look for folders. The bucket must
              #     be a hierarchical namespace enabled bucket.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of folders to return in a single response. The
              #     service will use this parameter or 1,000 items, whichever is smaller.
              #   @param page_token [::String]
              #     Optional. A previously-returned page token representing part of the larger
              #     set of results to view.
              #   @param prefix [::String]
              #     Optional. Filter results to folders whose names begin with this prefix.
              #     If set, the value must either be an empty string or end with a '/'.
              #   @param delimiter [::String]
              #     Optional. If set, returns results in a directory-like mode. The results
              #     will only include folders that either exactly match the above prefix, or
              #     are one level below the prefix. The only supported value is '/'.
              #   @param lexicographic_start [::String]
              #     Optional. Filter results to folders whose names are lexicographically equal
              #     to or after lexicographic_start. If lexicographic_end is also set, the
              #     folders listed have names between lexicographic_start (inclusive) and
              #     lexicographic_end (exclusive).
              #   @param lexicographic_end [::String]
              #     Optional. Filter results to folders whose names are lexicographically
              #     before lexicographic_end. If lexicographic_start is also set, the folders
              #     listed have names between lexicographic_start (inclusive) and
              #     lexicographic_end (exclusive).
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::Folder>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::Folder>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::ListFoldersRequest.new
              #
              #   # Call the list_folders method.
              #   result = client.list_folders request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Storage::Control::V2::Folder.
              #     p item
              #   end
              #
              def list_folders request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::ListFoldersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_folders.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_folders.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_folders.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :list_folders, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @storage_control_stub, :list_folders, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Renames a source folder to a destination folder. This operation is only
              # applicable to a hierarchical namespace enabled bucket. During a rename, the
              # source and destination folders are locked until the long running operation
              # completes.
              #
              # @overload rename_folder(request, options = nil)
              #   Pass arguments to `rename_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::RenameFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::RenameFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload rename_folder(name: nil, destination_folder_id: nil, if_metageneration_match: nil, if_metageneration_not_match: nil, request_id: nil)
              #   Pass arguments to `rename_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the source folder being renamed.
              #     Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
              #   @param destination_folder_id [::String]
              #     Required. The destination folder ID, e.g. `foo/bar/`.
              #   @param if_metageneration_match [::Integer]
              #     Makes the operation only succeed conditional on whether the source
              #     folder's current metageneration matches the given value.
              #   @param if_metageneration_not_match [::Integer]
              #     Makes the operation only succeed conditional on whether the source
              #     folder's current metageneration does not match the given value.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::RenameFolderRequest.new
              #
              #   # Call the rename_folder method.
              #   result = client.rename_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def rename_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::RenameFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.rename_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.rename_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.rename_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :rename_folder, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the storage layout configuration for a given bucket.
              #
              # @overload get_storage_layout(request, options = nil)
              #   Pass arguments to `get_storage_layout` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_storage_layout(name: nil, prefix: nil, request_id: nil)
              #   Pass arguments to `get_storage_layout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the StorageLayout resource.
              #     Format: `projects/{project}/buckets/{bucket}/storageLayout`
              #   @param prefix [::String]
              #     An optional prefix used for permission check. It is useful when the caller
              #     only has limited permissions under a specific prefix.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::StorageLayout]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::StorageLayout]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest.new
              #
              #   # Call the get_storage_layout method.
              #   result = client.get_storage_layout request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::StorageLayout.
              #   p result
              #
              def get_storage_layout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetStorageLayoutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_storage_layout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_storage_layout.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_storage_layout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_storage_layout, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new managed folder.
              #
              # @overload create_managed_folder(request, options = nil)
              #   Pass arguments to `create_managed_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_managed_folder(parent: nil, managed_folder: nil, managed_folder_id: nil, request_id: nil)
              #   Pass arguments to `create_managed_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the bucket this managed folder belongs to.
              #   @param managed_folder [::Google::Cloud::Storage::Control::V2::ManagedFolder, ::Hash]
              #     Required. Properties of the managed folder being created.
              #     The bucket and managed folder names are specified in the `parent` and
              #     `managed_folder_id` fields. Populating these fields in `managed_folder`
              #     will result in an error.
              #   @param managed_folder_id [::String]
              #     Required. The name of the managed folder. It uses a single `/` as delimiter
              #     and leading and trailing `/` are allowed.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::ManagedFolder]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::ManagedFolder]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest.new
              #
              #   # Call the create_managed_folder method.
              #   result = client.create_managed_folder request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::ManagedFolder.
              #   p result
              #
              def create_managed_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::CreateManagedFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_managed_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_managed_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_managed_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :create_managed_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes an empty managed folder.
              #
              # @overload delete_managed_folder(request, options = nil)
              #   Pass arguments to `delete_managed_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_managed_folder(name: nil, if_metageneration_match: nil, if_metageneration_not_match: nil, allow_non_empty: nil, request_id: nil)
              #   Pass arguments to `delete_managed_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the managed folder.
              #     Format:
              #     `projects/{project}/buckets/{bucket}/managedFolders/{managedFolder}`
              #   @param if_metageneration_match [::Integer]
              #     The operation succeeds conditional on the managed folder's current
              #     metageneration matching the value here specified.
              #   @param if_metageneration_not_match [::Integer]
              #     The operation succeeds conditional on the managed folder's current
              #     metageneration NOT matching the value here specified.
              #   @param allow_non_empty [::Boolean]
              #     Allows deletion of a managed folder even if it is not empty.
              #     A managed folder is empty if it manages no child managed folders or
              #     objects. Caller must have permission for
              #     storage.managedFolders.setIamPolicy.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest.new
              #
              #   # Call the delete_managed_folder method.
              #   result = client.delete_managed_folder request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_managed_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::DeleteManagedFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_managed_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_managed_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_managed_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :delete_managed_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns metadata for the specified managed folder.
              #
              # @overload get_managed_folder(request, options = nil)
              #   Pass arguments to `get_managed_folder` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_managed_folder(name: nil, if_metageneration_match: nil, if_metageneration_not_match: nil, request_id: nil)
              #   Pass arguments to `get_managed_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the managed folder.
              #     Format:
              #     `projects/{project}/buckets/{bucket}/managedFolders/{managedFolder}`
              #   @param if_metageneration_match [::Integer]
              #     The operation succeeds conditional on the managed folder's current
              #     metageneration matching the value here specified.
              #   @param if_metageneration_not_match [::Integer]
              #     The operation succeeds conditional on the managed folder's current
              #     metageneration NOT matching the value here specified.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::ManagedFolder]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::ManagedFolder]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetManagedFolderRequest.new
              #
              #   # Call the get_managed_folder method.
              #   result = client.get_managed_folder request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::ManagedFolder.
              #   p result
              #
              def get_managed_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetManagedFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_managed_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_managed_folder.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_managed_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_managed_folder, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a list of managed folders for a given bucket.
              #
              # @overload list_managed_folders(request, options = nil)
              #   Pass arguments to `list_managed_folders` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_managed_folders(parent: nil, page_size: nil, page_token: nil, prefix: nil, request_id: nil)
              #   Pass arguments to `list_managed_folders` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the bucket this managed folder belongs to.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of managed folders to return in a single response.
              #     The service will use this parameter or 1,000 items, whichever is smaller.
              #   @param page_token [::String]
              #     Optional. A previously-returned page token representing part of the larger
              #     set of results to view.
              #   @param prefix [::String]
              #     Optional. Filter results to match managed folders with name starting with
              #     this prefix.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::ManagedFolder>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::ManagedFolder>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest.new
              #
              #   # Call the list_managed_folders method.
              #   result = client.list_managed_folders request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Storage::Control::V2::ManagedFolder.
              #     p item
              #   end
              #
              def list_managed_folders request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::ListManagedFoldersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_managed_folders.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_managed_folders.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_managed_folders.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :list_managed_folders, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @storage_control_stub, :list_managed_folders, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an Anywhere Cache instance.
              #
              # @overload create_anywhere_cache(request, options = nil)
              #   Pass arguments to `create_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_anywhere_cache(parent: nil, anywhere_cache: nil, request_id: nil)
              #   Pass arguments to `create_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The bucket to which this cache belongs.
              #     Format: `projects/{project}/buckets/{bucket}`
              #   @param anywhere_cache [::Google::Cloud::Storage::Control::V2::AnywhereCache, ::Hash]
              #     Required. Properties of the Anywhere Cache instance being created.
              #     The parent bucket name is specified in the `parent` field. Server uses the
              #     default value of `ttl` or `admission_policy` if not specified in
              #     request.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest.new
              #
              #   # Call the create_anywhere_cache method.
              #   result = client.create_anywhere_cache request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::CreateAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :create_anywhere_cache, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an Anywhere Cache instance. Mutable fields include `ttl` and
              # `admission_policy`.
              #
              # @overload update_anywhere_cache(request, options = nil)
              #   Pass arguments to `update_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_anywhere_cache(anywhere_cache: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param anywhere_cache [::Google::Cloud::Storage::Control::V2::AnywhereCache, ::Hash]
              #     Required. The Anywhere Cache instance to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. List of fields to be updated. Mutable fields of AnywhereCache
              #     include `ttl` and `admission_policy`.
              #
              #     To specify ALL fields, specify a single field with the value `*`. Note: We
              #     recommend against doing this. If a new field is introduced at a later time,
              #     an older client updating with the `*` may accidentally reset the new
              #     field's value.
              #
              #     Not specifying any fields is an error.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest.new
              #
              #   # Call the update_anywhere_cache method.
              #   result = client.update_anywhere_cache request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.anywhere_cache&.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.anywhere_cache.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :update_anywhere_cache, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Disables an Anywhere Cache instance. A disabled instance is read-only. The
              # disablement could be revoked by calling ResumeAnywhereCache. The cache
              # instance will be deleted automatically if it remains in the disabled state
              # for at least one hour.
              #
              # @overload disable_anywhere_cache(request, options = nil)
              #   Pass arguments to `disable_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload disable_anywhere_cache(name: nil, request_id: nil)
              #   Pass arguments to `disable_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name field in the request should be:
              #     `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest.new
              #
              #   # Call the disable_anywhere_cache method.
              #   result = client.disable_anywhere_cache request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::AnywhereCache.
              #   p result
              #
              def disable_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::DisableAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.disable_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.disable_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.disable_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :disable_anywhere_cache, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses an Anywhere Cache instance.
              #
              # @overload pause_anywhere_cache(request, options = nil)
              #   Pass arguments to `pause_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload pause_anywhere_cache(name: nil, request_id: nil)
              #   Pass arguments to `pause_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name field in the request should be:
              #     `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest.new
              #
              #   # Call the pause_anywhere_cache method.
              #   result = client.pause_anywhere_cache request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::AnywhereCache.
              #   p result
              #
              def pause_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::PauseAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.pause_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.pause_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.pause_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :pause_anywhere_cache, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes a disabled or paused Anywhere Cache instance.
              #
              # @overload resume_anywhere_cache(request, options = nil)
              #   Pass arguments to `resume_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload resume_anywhere_cache(name: nil, request_id: nil)
              #   Pass arguments to `resume_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name field in the request should be:
              #     `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted. This request is only
              #     idempotent if a `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest.new
              #
              #   # Call the resume_anywhere_cache method.
              #   result = client.resume_anywhere_cache request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::AnywhereCache.
              #   p result
              #
              def resume_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::ResumeAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.resume_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.resume_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.resume_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :resume_anywhere_cache, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an Anywhere Cache instance.
              #
              # @overload get_anywhere_cache(request, options = nil)
              #   Pass arguments to `get_anywhere_cache` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_anywhere_cache(name: nil, request_id: nil)
              #   Pass arguments to `get_anywhere_cache` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name field in the request should be:
              #     `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::AnywhereCache]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest.new
              #
              #   # Call the get_anywhere_cache method.
              #   result = client.get_anywhere_cache request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::AnywhereCache.
              #   p result
              #
              def get_anywhere_cache request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetAnywhereCacheRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_anywhere_cache.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.name
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_anywhere_cache.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_anywhere_cache.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_anywhere_cache, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Anywhere Cache instances for a given bucket.
              #
              # @overload list_anywhere_caches(request, options = nil)
              #   Pass arguments to `list_anywhere_caches` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_anywhere_caches(parent: nil, page_size: nil, page_token: nil, request_id: nil)
              #   Pass arguments to `list_anywhere_caches` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The bucket to which this cache belongs.
              #   @param page_size [::Integer]
              #     Maximum number of caches to return in a single response.
              #     The service will use this parameter or 1,000 items, whichever is smaller.
              #   @param page_token [::String]
              #     A previously-returned page token representing part of the larger set of
              #     results to view.
              #   @param request_id [::String]
              #     Optional. A unique identifier for this request. UUID is the recommended
              #     format, but other formats are still accepted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::AnywhereCache>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Storage::Control::V2::AnywhereCache>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest.new
              #
              #   # Call the list_anywhere_caches method.
              #   result = client.list_anywhere_caches request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Storage::Control::V2::AnywhereCache.
              #     p item
              #   end
              #
              def list_anywhere_caches request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::ListAnywhereCachesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_anywhere_caches.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent && !request.parent.empty?
                  header_params["bucket"] = request.parent
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_anywhere_caches.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_anywhere_caches.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :list_anywhere_caches, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @storage_control_stub, :list_anywhere_caches, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the Project scoped singleton IntelligenceConfig resource.
              #
              # @overload get_project_intelligence_config(request, options = nil)
              #   Pass arguments to `get_project_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_project_intelligence_config(name: nil)
              #   Pass arguments to `get_project_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `IntelligenceConfig` resource associated with
              #     your project.
              #
              #     Format: `projects/{id}/locations/global/intelligenceConfig`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest.new
              #
              #   # Call the get_project_intelligence_config method.
              #   result = client.get_project_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def get_project_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetProjectIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_project_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_project_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_project_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_project_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Project scoped singleton IntelligenceConfig resource.
              #
              # @overload update_project_intelligence_config(request, options = nil)
              #   Pass arguments to `update_project_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_project_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_project_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
              #     Required. The `IntelligenceConfig` resource to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The `update_mask` that specifies the fields within the
              #     `IntelligenceConfig` resource that should be modified by this update. Only
              #     the listed fields are updated.
              #   @param request_id [::String]
              #     Optional. The ID that uniquely identifies the request, preventing duplicate
              #     processing.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest.new
              #
              #   # Call the update_project_intelligence_config method.
              #   result = client.update_project_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def update_project_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateProjectIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_project_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.intelligence_config&.name
                  header_params["intelligence_config.name"] = request.intelligence_config.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_project_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_project_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :update_project_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the Folder scoped singleton IntelligenceConfig resource.
              #
              # @overload get_folder_intelligence_config(request, options = nil)
              #   Pass arguments to `get_folder_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_folder_intelligence_config(name: nil)
              #   Pass arguments to `get_folder_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `IntelligenceConfig` resource associated with
              #     your folder.
              #
              #     Format: `folders/{id}/locations/global/intelligenceConfig`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest.new
              #
              #   # Call the get_folder_intelligence_config method.
              #   result = client.get_folder_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def get_folder_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetFolderIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_folder_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_folder_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_folder_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_folder_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Folder scoped singleton IntelligenceConfig resource.
              #
              # @overload update_folder_intelligence_config(request, options = nil)
              #   Pass arguments to `update_folder_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_folder_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_folder_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
              #     Required. The `IntelligenceConfig` resource to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The `update_mask` that specifies the fields within the
              #     `IntelligenceConfig` resource that should be modified by this update. Only
              #     the listed fields are updated.
              #   @param request_id [::String]
              #     Optional. The ID that uniquely identifies the request, preventing duplicate
              #     processing.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest.new
              #
              #   # Call the update_folder_intelligence_config method.
              #   result = client.update_folder_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def update_folder_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateFolderIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_folder_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.intelligence_config&.name
                  header_params["intelligence_config.name"] = request.intelligence_config.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_folder_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_folder_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :update_folder_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the Organization scoped singleton IntelligenceConfig resource.
              #
              # @overload get_organization_intelligence_config(request, options = nil)
              #   Pass arguments to `get_organization_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_organization_intelligence_config(name: nil)
              #   Pass arguments to `get_organization_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `IntelligenceConfig` resource associated with
              #     your organization.
              #
              #     Format: `organizations/{org_id}/locations/global/intelligenceConfig`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest.new
              #
              #   # Call the get_organization_intelligence_config method.
              #   result = client.get_organization_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def get_organization_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::GetOrganizationIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_organization_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_organization_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_organization_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_organization_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Organization scoped singleton IntelligenceConfig resource.
              #
              # @overload update_organization_intelligence_config(request, options = nil)
              #   Pass arguments to `update_organization_intelligence_config` via a request object, either of type
              #   {::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_organization_intelligence_config(intelligence_config: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_organization_intelligence_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param intelligence_config [::Google::Cloud::Storage::Control::V2::IntelligenceConfig, ::Hash]
              #     Required. The `IntelligenceConfig` resource to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The `update_mask` that specifies the fields within the
              #     `IntelligenceConfig` resource that should be modified by this update. Only
              #     the listed fields are updated.
              #   @param request_id [::String]
              #     Optional. The ID that uniquely identifies the request, preventing duplicate
              #     processing.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Storage::Control::V2::IntelligenceConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest.new
              #
              #   # Call the update_organization_intelligence_config method.
              #   result = client.update_organization_intelligence_config request
              #
              #   # The returned object is of type Google::Cloud::Storage::Control::V2::IntelligenceConfig.
              #   p result
              #
              def update_organization_intelligence_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Storage::Control::V2::UpdateOrganizationIntelligenceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_organization_intelligence_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.intelligence_config&.name
                  header_params["intelligence_config.name"] = request.intelligence_config.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_organization_intelligence_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_organization_intelligence_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :update_organization_intelligence_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAM policy for a specified bucket.
              # The `resource` field in the request should be
              # `projects/_/buckets/{bucket}` for a bucket, or
              # `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
              # for a managed folder.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource && !request.resource.empty?
                  header_params["bucket"] = request.resource
                end
                if request.resource
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.resource
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an IAM policy for the specified bucket.
              # The `resource` field in the request should be
              # `projects/_/buckets/{bucket}` for a bucket, or
              # `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
              # for a managed folder.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource && !request.resource.empty?
                  header_params["bucket"] = request.resource
                end
                if request.resource
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?$}.match request.resource
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Tests a set of permissions on the given bucket, object, or managed folder
              # to see which, if any, are held by the caller.
              # The `resource` field in the request should be
              # `projects/_/buckets/{bucket}` for a bucket,
              # `projects/_/buckets/{bucket}/objects/{object}` for an object, or
              # `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
              # for a managed folder.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/storage/control/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Storage::Control::V2::StorageControl::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Storage::Control::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource && !request.resource.empty?
                  header_params["bucket"] = request.resource
                end
                if request.resource
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)/objects(?:/.*)?$}.match request.resource
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end
                if request.resource
                  regex_match = %r{^(?<bucket>projects/[^/]+/buckets/[^/]+)/managedFolders(?:/.*)?$}.match request.resource
                  if regex_match
                    header_params["bucket"] = regex_match["bucket".to_s]
                  end
                end

                request_params_header = URI.encode_www_form header_params
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @storage_control_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the StorageControl API.
              #
              # This class represents the configuration for StorageControl,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Storage::Control::V2::StorageControl::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_folder to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Storage::Control::V2::StorageControl::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_folder.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_folder.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Storage::Control::V2::StorageControl::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "storage.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the StorageControl API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_folder
                  ##
                  # RPC-specific configuration for `delete_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_folder
                  ##
                  # RPC-specific configuration for `get_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_folder
                  ##
                  # RPC-specific configuration for `list_folders`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_folders
                  ##
                  # RPC-specific configuration for `rename_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_folder
                  ##
                  # RPC-specific configuration for `get_storage_layout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_storage_layout
                  ##
                  # RPC-specific configuration for `create_managed_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_managed_folder
                  ##
                  # RPC-specific configuration for `delete_managed_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_managed_folder
                  ##
                  # RPC-specific configuration for `get_managed_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_managed_folder
                  ##
                  # RPC-specific configuration for `list_managed_folders`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_managed_folders
                  ##
                  # RPC-specific configuration for `create_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_anywhere_cache
                  ##
                  # RPC-specific configuration for `update_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_anywhere_cache
                  ##
                  # RPC-specific configuration for `disable_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :disable_anywhere_cache
                  ##
                  # RPC-specific configuration for `pause_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_anywhere_cache
                  ##
                  # RPC-specific configuration for `resume_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_anywhere_cache
                  ##
                  # RPC-specific configuration for `get_anywhere_cache`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_anywhere_cache
                  ##
                  # RPC-specific configuration for `list_anywhere_caches`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_anywhere_caches
                  ##
                  # RPC-specific configuration for `get_project_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_project_intelligence_config
                  ##
                  # RPC-specific configuration for `update_project_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_project_intelligence_config
                  ##
                  # RPC-specific configuration for `get_folder_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_folder_intelligence_config
                  ##
                  # RPC-specific configuration for `update_folder_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_folder_intelligence_config
                  ##
                  # RPC-specific configuration for `get_organization_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_organization_intelligence_config
                  ##
                  # RPC-specific configuration for `update_organization_intelligence_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_organization_intelligence_config
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    create_folder_config = parent_rpcs.create_folder if parent_rpcs.respond_to? :create_folder
                    @create_folder = ::Gapic::Config::Method.new create_folder_config
                    delete_folder_config = parent_rpcs.delete_folder if parent_rpcs.respond_to? :delete_folder
                    @delete_folder = ::Gapic::Config::Method.new delete_folder_config
                    get_folder_config = parent_rpcs.get_folder if parent_rpcs.respond_to? :get_folder
                    @get_folder = ::Gapic::Config::Method.new get_folder_config
                    list_folders_config = parent_rpcs.list_folders if parent_rpcs.respond_to? :list_folders
                    @list_folders = ::Gapic::Config::Method.new list_folders_config
                    rename_folder_config = parent_rpcs.rename_folder if parent_rpcs.respond_to? :rename_folder
                    @rename_folder = ::Gapic::Config::Method.new rename_folder_config
                    get_storage_layout_config = parent_rpcs.get_storage_layout if parent_rpcs.respond_to? :get_storage_layout
                    @get_storage_layout = ::Gapic::Config::Method.new get_storage_layout_config
                    create_managed_folder_config = parent_rpcs.create_managed_folder if parent_rpcs.respond_to? :create_managed_folder
                    @create_managed_folder = ::Gapic::Config::Method.new create_managed_folder_config
                    delete_managed_folder_config = parent_rpcs.delete_managed_folder if parent_rpcs.respond_to? :delete_managed_folder
                    @delete_managed_folder = ::Gapic::Config::Method.new delete_managed_folder_config
                    get_managed_folder_config = parent_rpcs.get_managed_folder if parent_rpcs.respond_to? :get_managed_folder
                    @get_managed_folder = ::Gapic::Config::Method.new get_managed_folder_config
                    list_managed_folders_config = parent_rpcs.list_managed_folders if parent_rpcs.respond_to? :list_managed_folders
                    @list_managed_folders = ::Gapic::Config::Method.new list_managed_folders_config
                    create_anywhere_cache_config = parent_rpcs.create_anywhere_cache if parent_rpcs.respond_to? :create_anywhere_cache
                    @create_anywhere_cache = ::Gapic::Config::Method.new create_anywhere_cache_config
                    update_anywhere_cache_config = parent_rpcs.update_anywhere_cache if parent_rpcs.respond_to? :update_anywhere_cache
                    @update_anywhere_cache = ::Gapic::Config::Method.new update_anywhere_cache_config
                    disable_anywhere_cache_config = parent_rpcs.disable_anywhere_cache if parent_rpcs.respond_to? :disable_anywhere_cache
                    @disable_anywhere_cache = ::Gapic::Config::Method.new disable_anywhere_cache_config
                    pause_anywhere_cache_config = parent_rpcs.pause_anywhere_cache if parent_rpcs.respond_to? :pause_anywhere_cache
                    @pause_anywhere_cache = ::Gapic::Config::Method.new pause_anywhere_cache_config
                    resume_anywhere_cache_config = parent_rpcs.resume_anywhere_cache if parent_rpcs.respond_to? :resume_anywhere_cache
                    @resume_anywhere_cache = ::Gapic::Config::Method.new resume_anywhere_cache_config
                    get_anywhere_cache_config = parent_rpcs.get_anywhere_cache if parent_rpcs.respond_to? :get_anywhere_cache
                    @get_anywhere_cache = ::Gapic::Config::Method.new get_anywhere_cache_config
                    list_anywhere_caches_config = parent_rpcs.list_anywhere_caches if parent_rpcs.respond_to? :list_anywhere_caches
                    @list_anywhere_caches = ::Gapic::Config::Method.new list_anywhere_caches_config
                    get_project_intelligence_config_config = parent_rpcs.get_project_intelligence_config if parent_rpcs.respond_to? :get_project_intelligence_config
                    @get_project_intelligence_config = ::Gapic::Config::Method.new get_project_intelligence_config_config
                    update_project_intelligence_config_config = parent_rpcs.update_project_intelligence_config if parent_rpcs.respond_to? :update_project_intelligence_config
                    @update_project_intelligence_config = ::Gapic::Config::Method.new update_project_intelligence_config_config
                    get_folder_intelligence_config_config = parent_rpcs.get_folder_intelligence_config if parent_rpcs.respond_to? :get_folder_intelligence_config
                    @get_folder_intelligence_config = ::Gapic::Config::Method.new get_folder_intelligence_config_config
                    update_folder_intelligence_config_config = parent_rpcs.update_folder_intelligence_config if parent_rpcs.respond_to? :update_folder_intelligence_config
                    @update_folder_intelligence_config = ::Gapic::Config::Method.new update_folder_intelligence_config_config
                    get_organization_intelligence_config_config = parent_rpcs.get_organization_intelligence_config if parent_rpcs.respond_to? :get_organization_intelligence_config
                    @get_organization_intelligence_config = ::Gapic::Config::Method.new get_organization_intelligence_config_config
                    update_organization_intelligence_config_config = parent_rpcs.update_organization_intelligence_config if parent_rpcs.respond_to? :update_organization_intelligence_config
                    @update_organization_intelligence_config = ::Gapic::Config::Method.new update_organization_intelligence_config_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
