# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# AUTO GENERATED BY GAPIC

require "minitest/autorun"
require "minitest/spec"

require "google/cloud/speech"

class SpeechSmokeTest < Minitest::Test
  def test_recognize
    speech_client = Google::Cloud::Speech.speech
    project = ENV["SPEECH_PROJECT"]
    recognizer = "projects/#{project}/locations/global/recognizers/_"
    config = {
      language_codes: ["en-US"],
      auto_decoding_config: {},
      model: "short"
    }
    uri = "gs://cloud-samples-data/speech/brooklyn_bridge.flac"
    response = speech_client.recognize recognizer: recognizer, config: config, uri: uri
    refute_equal 0, response.results.size
  end
end
