# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/speech/v2/cloud_speech_pb"
require "google/cloud/speech/v2/speech"

class ::Google::Cloud::Speech::V2::Speech::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_recognizer
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    recognizer = {}
    validate_only = true
    recognizer_id = "hello world"
    parent = "hello world"

    create_recognizer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_recognizer, name
      assert_kind_of ::Google::Cloud::Speech::V2::CreateRecognizerRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::Recognizer), request["recognizer"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["recognizer_id"]
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_recognizer_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_recognizer({ recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_recognizer recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_recognizer ::Google::Cloud::Speech::V2::CreateRecognizerRequest.new(recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_recognizer({ recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_recognizer(::Google::Cloud::Speech::V2::CreateRecognizerRequest.new(recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_recognizer_client_stub.call_rpc_count
    end
  end

  def test_list_recognizers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::ListRecognizersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_recognizers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_recognizers, name
      assert_kind_of ::Google::Cloud::Speech::V2::ListRecognizersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_recognizers_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_recognizers({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_recognizers parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_recognizers ::Google::Cloud::Speech::V2::ListRecognizersRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_recognizers({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_recognizers(::Google::Cloud::Speech::V2::ListRecognizersRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_recognizers_client_stub.call_rpc_count
    end
  end

  def test_get_recognizer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::Recognizer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_recognizer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_recognizer, name
      assert_kind_of ::Google::Cloud::Speech::V2::GetRecognizerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_recognizer_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_recognizer({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_recognizer name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_recognizer ::Google::Cloud::Speech::V2::GetRecognizerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_recognizer({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_recognizer(::Google::Cloud::Speech::V2::GetRecognizerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_recognizer_client_stub.call_rpc_count
    end
  end

  def test_update_recognizer
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    recognizer = {}
    update_mask = {}
    validate_only = true

    update_recognizer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_recognizer, name
      assert_kind_of ::Google::Cloud::Speech::V2::UpdateRecognizerRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::Recognizer), request["recognizer"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_recognizer_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_recognizer({ recognizer: recognizer, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_recognizer recognizer: recognizer, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_recognizer ::Google::Cloud::Speech::V2::UpdateRecognizerRequest.new(recognizer: recognizer, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_recognizer({ recognizer: recognizer, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_recognizer(::Google::Cloud::Speech::V2::UpdateRecognizerRequest.new(recognizer: recognizer, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_recognizer_client_stub.call_rpc_count
    end
  end

  def test_delete_recognizer
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_recognizer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_recognizer, name
      assert_kind_of ::Google::Cloud::Speech::V2::DeleteRecognizerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_recognizer_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_recognizer({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_recognizer name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_recognizer ::Google::Cloud::Speech::V2::DeleteRecognizerRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_recognizer({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_recognizer(::Google::Cloud::Speech::V2::DeleteRecognizerRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_recognizer_client_stub.call_rpc_count
    end
  end

  def test_undelete_recognizer
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_recognizer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_recognizer, name
      assert_kind_of ::Google::Cloud::Speech::V2::UndeleteRecognizerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_recognizer_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_recognizer({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_recognizer name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_recognizer ::Google::Cloud::Speech::V2::UndeleteRecognizerRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_recognizer({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_recognizer(::Google::Cloud::Speech::V2::UndeleteRecognizerRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_recognizer_client_stub.call_rpc_count
    end
  end

  def test_recognize
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::RecognizeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    recognizer = "hello world"
    config = {}
    config_mask = {}
    content = "hello world"

    recognize_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :recognize, name
      assert_kind_of ::Google::Cloud::Speech::V2::RecognizeRequest, request
      assert_equal "hello world", request["recognizer"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::RecognitionConfig), request["config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["config_mask"]
      assert_equal "hello world", request["content"]
      assert_equal :content, request.audio_source
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, recognize_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.recognize({ recognizer: recognizer, config: config, config_mask: config_mask, content: content }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.recognize recognizer: recognizer, config: config, config_mask: config_mask, content: content do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.recognize ::Google::Cloud::Speech::V2::RecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, content: content) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.recognize({ recognizer: recognizer, config: config, config_mask: config_mask, content: content }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.recognize(::Google::Cloud::Speech::V2::RecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, content: content), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, recognize_client_stub.call_rpc_count
    end
  end

  def test_streaming_recognize
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::StreamingRecognizeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    recognizer = "hello world"
    streaming_config = {}

    streaming_recognize_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_recognize, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, streaming_recognize_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { recognizer: recognizer, streaming_config: streaming_config }
      request_proto = ::Google::Cloud::Speech::V2::StreamingRecognizeRequest.new recognizer: recognizer, streaming_config: streaming_config
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_recognize enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Speech::V2::StreamingRecognizeResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { recognizer: recognizer, streaming_config: streaming_config }
      request_proto = ::Google::Cloud::Speech::V2::StreamingRecognizeRequest.new recognizer: recognizer, streaming_config: streaming_config
      stream_input = Gapic::StreamInput.new
      client.streaming_recognize stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Speech::V2::StreamingRecognizeResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { recognizer: recognizer, streaming_config: streaming_config }
      request_proto = ::Google::Cloud::Speech::V2::StreamingRecognizeRequest.new recognizer: recognizer, streaming_config: streaming_config
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_recognize enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Speech::V2::StreamingRecognizeResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { recognizer: recognizer, streaming_config: streaming_config }
      request_proto = ::Google::Cloud::Speech::V2::StreamingRecognizeRequest.new recognizer: recognizer, streaming_config: streaming_config
      stream_input = Gapic::StreamInput.new
      client.streaming_recognize stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Speech::V2::StreamingRecognizeResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, streaming_recognize_client_stub.call_rpc_count
      streaming_recognize_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Speech::V2::StreamingRecognizeRequest, r
          assert_equal "hello world", r["recognizer"]
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::StreamingRecognitionConfig), r["streaming_config"]
          assert_equal :streaming_config, r.streaming_request
        end
      end
    end
  end

  def test_batch_recognize
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    recognizer = "hello world"
    config = {}
    config_mask = {}
    files = [{}]
    recognition_output_config = {}
    processing_strategy = :PROCESSING_STRATEGY_UNSPECIFIED

    batch_recognize_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_recognize, name
      assert_kind_of ::Google::Cloud::Speech::V2::BatchRecognizeRequest, request
      assert_equal "hello world", request["recognizer"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::RecognitionConfig), request["config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["config_mask"]
      assert_kind_of ::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata, request["files"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::RecognitionOutputConfig), request["recognition_output_config"]
      assert_equal :PROCESSING_STRATEGY_UNSPECIFIED, request["processing_strategy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_recognize_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_recognize({ recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_recognize recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_recognize ::Google::Cloud::Speech::V2::BatchRecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_recognize({ recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_recognize(::Google::Cloud::Speech::V2::BatchRecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_recognize_client_stub.call_rpc_count
    end
  end

  def test_get_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::Config.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_config, name
      assert_kind_of ::Google::Cloud::Speech::V2::GetConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_config_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_config ::Google::Cloud::Speech::V2::GetConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_config(::Google::Cloud::Speech::V2::GetConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_config_client_stub.call_rpc_count
    end
  end

  def test_update_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::Config.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    config = {}
    update_mask = {}

    update_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_config, name
      assert_kind_of ::Google::Cloud::Speech::V2::UpdateConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::Config), request["config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_config_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_config({ config: config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_config config: config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_config ::Google::Cloud::Speech::V2::UpdateConfigRequest.new(config: config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_config({ config: config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_config(::Google::Cloud::Speech::V2::UpdateConfigRequest.new(config: config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_config_client_stub.call_rpc_count
    end
  end

  def test_create_custom_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_class = {}
    validate_only = true
    custom_class_id = "hello world"
    parent = "hello world"

    create_custom_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_class, name
      assert_kind_of ::Google::Cloud::Speech::V2::CreateCustomClassRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::CustomClass), request["custom_class"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["custom_class_id"]
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_class_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_class({ custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_class custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_class ::Google::Cloud::Speech::V2::CreateCustomClassRequest.new(custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_class({ custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_class(::Google::Cloud::Speech::V2::CreateCustomClassRequest.new(custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_class_client_stub.call_rpc_count
    end
  end

  def test_list_custom_classes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::ListCustomClassesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_custom_classes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_classes, name
      assert_kind_of ::Google::Cloud::Speech::V2::ListCustomClassesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_classes_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_classes({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_classes parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_classes ::Google::Cloud::Speech::V2::ListCustomClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_classes({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_classes(::Google::Cloud::Speech::V2::ListCustomClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_classes_client_stub.call_rpc_count
    end
  end

  def test_get_custom_class
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::CustomClass.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_class, name
      assert_kind_of ::Google::Cloud::Speech::V2::GetCustomClassRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_class_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_class({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_class name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_class ::Google::Cloud::Speech::V2::GetCustomClassRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_class({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_class(::Google::Cloud::Speech::V2::GetCustomClassRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_class_client_stub.call_rpc_count
    end
  end

  def test_update_custom_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_class = {}
    update_mask = {}
    validate_only = true

    update_custom_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_custom_class, name
      assert_kind_of ::Google::Cloud::Speech::V2::UpdateCustomClassRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::CustomClass), request["custom_class"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_custom_class_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_custom_class({ custom_class: custom_class, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_custom_class custom_class: custom_class, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_custom_class ::Google::Cloud::Speech::V2::UpdateCustomClassRequest.new(custom_class: custom_class, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_custom_class({ custom_class: custom_class, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_custom_class(::Google::Cloud::Speech::V2::UpdateCustomClassRequest.new(custom_class: custom_class, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_custom_class_client_stub.call_rpc_count
    end
  end

  def test_delete_custom_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_custom_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_custom_class, name
      assert_kind_of ::Google::Cloud::Speech::V2::DeleteCustomClassRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_custom_class_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_custom_class({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_custom_class name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_custom_class ::Google::Cloud::Speech::V2::DeleteCustomClassRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_custom_class({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_custom_class(::Google::Cloud::Speech::V2::DeleteCustomClassRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_custom_class_client_stub.call_rpc_count
    end
  end

  def test_undelete_custom_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_custom_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_custom_class, name
      assert_kind_of ::Google::Cloud::Speech::V2::UndeleteCustomClassRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_custom_class_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_custom_class({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_custom_class name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_custom_class ::Google::Cloud::Speech::V2::UndeleteCustomClassRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_custom_class({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_custom_class(::Google::Cloud::Speech::V2::UndeleteCustomClassRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_custom_class_client_stub.call_rpc_count
    end
  end

  def test_create_phrase_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    phrase_set = {}
    validate_only = true
    phrase_set_id = "hello world"
    parent = "hello world"

    create_phrase_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_phrase_set, name
      assert_kind_of ::Google::Cloud::Speech::V2::CreatePhraseSetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::PhraseSet), request["phrase_set"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["phrase_set_id"]
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_phrase_set_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_phrase_set({ phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_phrase_set phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_phrase_set ::Google::Cloud::Speech::V2::CreatePhraseSetRequest.new(phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_phrase_set({ phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_phrase_set(::Google::Cloud::Speech::V2::CreatePhraseSetRequest.new(phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_phrase_set_client_stub.call_rpc_count
    end
  end

  def test_list_phrase_sets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::ListPhraseSetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_phrase_sets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_phrase_sets, name
      assert_kind_of ::Google::Cloud::Speech::V2::ListPhraseSetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_phrase_sets_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_phrase_sets({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_phrase_sets parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_phrase_sets ::Google::Cloud::Speech::V2::ListPhraseSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_phrase_sets({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_phrase_sets(::Google::Cloud::Speech::V2::ListPhraseSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_phrase_sets_client_stub.call_rpc_count
    end
  end

  def test_get_phrase_set
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Speech::V2::PhraseSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_phrase_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_phrase_set, name
      assert_kind_of ::Google::Cloud::Speech::V2::GetPhraseSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_phrase_set_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_phrase_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_phrase_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_phrase_set ::Google::Cloud::Speech::V2::GetPhraseSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_phrase_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_phrase_set(::Google::Cloud::Speech::V2::GetPhraseSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_phrase_set_client_stub.call_rpc_count
    end
  end

  def test_update_phrase_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    phrase_set = {}
    update_mask = {}
    validate_only = true

    update_phrase_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_phrase_set, name
      assert_kind_of ::Google::Cloud::Speech::V2::UpdatePhraseSetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Speech::V2::PhraseSet), request["phrase_set"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_phrase_set_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_phrase_set({ phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_phrase_set phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_phrase_set ::Google::Cloud::Speech::V2::UpdatePhraseSetRequest.new(phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_phrase_set({ phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_phrase_set(::Google::Cloud::Speech::V2::UpdatePhraseSetRequest.new(phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_phrase_set_client_stub.call_rpc_count
    end
  end

  def test_delete_phrase_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_phrase_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_phrase_set, name
      assert_kind_of ::Google::Cloud::Speech::V2::DeletePhraseSetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_phrase_set_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_phrase_set({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_phrase_set name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_phrase_set ::Google::Cloud::Speech::V2::DeletePhraseSetRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_phrase_set({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_phrase_set(::Google::Cloud::Speech::V2::DeletePhraseSetRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_phrase_set_client_stub.call_rpc_count
    end
  end

  def test_undelete_phrase_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_phrase_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_phrase_set, name
      assert_kind_of ::Google::Cloud::Speech::V2::UndeletePhraseSetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_phrase_set_client_stub do
      # Create client
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_phrase_set({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_phrase_set name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_phrase_set ::Google::Cloud::Speech::V2::UndeletePhraseSetRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_phrase_set({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_phrase_set(::Google::Cloud::Speech::V2::UndeletePhraseSetRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_phrase_set_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Speech::V2::Speech::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Speech::V2::Speech::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Speech::V2::Speech::Operations, client.operations_client
  end
end
