# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/speech/v2/cloud_speech_pb"
require "google/cloud/speech/v2/speech/rest"


class ::Google::Cloud::Speech::V2::Speech::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_recognizer
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    recognizer = {}
    validate_only = true
    recognizer_id = "hello world"
    parent = "hello world"

    create_recognizer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_create_recognizer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_recognizer_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_recognizer({ recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_recognizer recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_recognizer ::Google::Cloud::Speech::V2::CreateRecognizerRequest.new(recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_recognizer({ recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_recognizer(::Google::Cloud::Speech::V2::CreateRecognizerRequest.new(recognizer: recognizer, validate_only: validate_only, recognizer_id: recognizer_id, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_recognizer_client_stub.call_count
      end
    end
  end

  def test_list_recognizers
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::ListRecognizersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_recognizers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_list_recognizers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_recognizers_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_recognizers({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_recognizers parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_recognizers ::Google::Cloud::Speech::V2::ListRecognizersRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_recognizers({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_recognizers(::Google::Cloud::Speech::V2::ListRecognizersRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_recognizers_client_stub.call_count
      end
    end
  end

  def test_get_recognizer
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::Recognizer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_recognizer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_get_recognizer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_recognizer_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_recognizer({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_recognizer name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_recognizer ::Google::Cloud::Speech::V2::GetRecognizerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_recognizer({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_recognizer(::Google::Cloud::Speech::V2::GetRecognizerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_recognizer_client_stub.call_count
      end
    end
  end

  def test_update_recognizer
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    recognizer = {}
    update_mask = {}
    validate_only = true

    update_recognizer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_update_recognizer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_recognizer_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_recognizer({ recognizer: recognizer, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_recognizer recognizer: recognizer, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_recognizer ::Google::Cloud::Speech::V2::UpdateRecognizerRequest.new(recognizer: recognizer, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_recognizer({ recognizer: recognizer, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_recognizer(::Google::Cloud::Speech::V2::UpdateRecognizerRequest.new(recognizer: recognizer, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_recognizer_client_stub.call_count
      end
    end
  end

  def test_delete_recognizer
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_recognizer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_delete_recognizer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_recognizer_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_recognizer({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_recognizer name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_recognizer ::Google::Cloud::Speech::V2::DeleteRecognizerRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_recognizer({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_recognizer(::Google::Cloud::Speech::V2::DeleteRecognizerRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_recognizer_client_stub.call_count
      end
    end
  end

  def test_undelete_recognizer
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_recognizer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_undelete_recognizer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_recognizer_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_recognizer({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_recognizer name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_recognizer ::Google::Cloud::Speech::V2::UndeleteRecognizerRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_recognizer({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_recognizer(::Google::Cloud::Speech::V2::UndeleteRecognizerRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_recognizer_client_stub.call_count
      end
    end
  end

  def test_recognize
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::RecognizeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    recognizer = "hello world"
    config = {}
    config_mask = {}
    content = "hello world"

    recognize_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_recognize_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, recognize_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.recognize({ recognizer: recognizer, config: config, config_mask: config_mask, content: content }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.recognize recognizer: recognizer, config: config, config_mask: config_mask, content: content do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.recognize ::Google::Cloud::Speech::V2::RecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, content: content) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.recognize({ recognizer: recognizer, config: config, config_mask: config_mask, content: content }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.recognize(::Google::Cloud::Speech::V2::RecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, content: content), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, recognize_client_stub.call_count
      end
    end
  end

  def test_batch_recognize
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    recognizer = "hello world"
    config = {}
    config_mask = {}
    files = [{}]
    recognition_output_config = {}
    processing_strategy = :PROCESSING_STRATEGY_UNSPECIFIED

    batch_recognize_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_batch_recognize_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_recognize_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_recognize({ recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_recognize recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_recognize ::Google::Cloud::Speech::V2::BatchRecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_recognize({ recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_recognize(::Google::Cloud::Speech::V2::BatchRecognizeRequest.new(recognizer: recognizer, config: config, config_mask: config_mask, files: files, recognition_output_config: recognition_output_config, processing_strategy: processing_strategy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_recognize_client_stub.call_count
      end
    end
  end

  def test_get_config
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::Config.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_get_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_config_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_config ::Google::Cloud::Speech::V2::GetConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_config(::Google::Cloud::Speech::V2::GetConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_config_client_stub.call_count
      end
    end
  end

  def test_update_config
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::Config.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    config = {}
    update_mask = {}

    update_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_update_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_config_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_config({ config: config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_config config: config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_config ::Google::Cloud::Speech::V2::UpdateConfigRequest.new(config: config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_config({ config: config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_config(::Google::Cloud::Speech::V2::UpdateConfigRequest.new(config: config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_config_client_stub.call_count
      end
    end
  end

  def test_create_custom_class
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_class = {}
    validate_only = true
    custom_class_id = "hello world"
    parent = "hello world"

    create_custom_class_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_create_custom_class_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_class_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_class({ custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_class custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_class ::Google::Cloud::Speech::V2::CreateCustomClassRequest.new(custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_class({ custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_class(::Google::Cloud::Speech::V2::CreateCustomClassRequest.new(custom_class: custom_class, validate_only: validate_only, custom_class_id: custom_class_id, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_class_client_stub.call_count
      end
    end
  end

  def test_list_custom_classes
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::ListCustomClassesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_custom_classes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_list_custom_classes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_classes_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_classes({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_classes parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_classes ::Google::Cloud::Speech::V2::ListCustomClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_classes({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_classes(::Google::Cloud::Speech::V2::ListCustomClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_classes_client_stub.call_count
      end
    end
  end

  def test_get_custom_class
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::CustomClass.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_class_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_get_custom_class_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_class_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_class({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_class name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_class ::Google::Cloud::Speech::V2::GetCustomClassRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_class({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_class(::Google::Cloud::Speech::V2::GetCustomClassRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_class_client_stub.call_count
      end
    end
  end

  def test_update_custom_class
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_class = {}
    update_mask = {}
    validate_only = true

    update_custom_class_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_update_custom_class_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_custom_class_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_custom_class({ custom_class: custom_class, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_custom_class custom_class: custom_class, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_custom_class ::Google::Cloud::Speech::V2::UpdateCustomClassRequest.new(custom_class: custom_class, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_custom_class({ custom_class: custom_class, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_custom_class(::Google::Cloud::Speech::V2::UpdateCustomClassRequest.new(custom_class: custom_class, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_custom_class_client_stub.call_count
      end
    end
  end

  def test_delete_custom_class
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_custom_class_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_delete_custom_class_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_custom_class_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_custom_class({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_custom_class name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_custom_class ::Google::Cloud::Speech::V2::DeleteCustomClassRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_custom_class({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_custom_class(::Google::Cloud::Speech::V2::DeleteCustomClassRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_custom_class_client_stub.call_count
      end
    end
  end

  def test_undelete_custom_class
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_custom_class_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_undelete_custom_class_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_custom_class_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_custom_class({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_custom_class name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_custom_class ::Google::Cloud::Speech::V2::UndeleteCustomClassRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_custom_class({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_custom_class(::Google::Cloud::Speech::V2::UndeleteCustomClassRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_custom_class_client_stub.call_count
      end
    end
  end

  def test_create_phrase_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    phrase_set = {}
    validate_only = true
    phrase_set_id = "hello world"
    parent = "hello world"

    create_phrase_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_create_phrase_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_phrase_set_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_phrase_set({ phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_phrase_set phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_phrase_set ::Google::Cloud::Speech::V2::CreatePhraseSetRequest.new(phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_phrase_set({ phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_phrase_set(::Google::Cloud::Speech::V2::CreatePhraseSetRequest.new(phrase_set: phrase_set, validate_only: validate_only, phrase_set_id: phrase_set_id, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_phrase_set_client_stub.call_count
      end
    end
  end

  def test_list_phrase_sets
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::ListPhraseSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_phrase_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_list_phrase_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_phrase_sets_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_phrase_sets({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_phrase_sets parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_phrase_sets ::Google::Cloud::Speech::V2::ListPhraseSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_phrase_sets({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_phrase_sets(::Google::Cloud::Speech::V2::ListPhraseSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_phrase_sets_client_stub.call_count
      end
    end
  end

  def test_get_phrase_set
    # Create test objects.
    client_result = ::Google::Cloud::Speech::V2::PhraseSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_phrase_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_get_phrase_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_phrase_set_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_phrase_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_phrase_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_phrase_set ::Google::Cloud::Speech::V2::GetPhraseSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_phrase_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_phrase_set(::Google::Cloud::Speech::V2::GetPhraseSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_phrase_set_client_stub.call_count
      end
    end
  end

  def test_update_phrase_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    phrase_set = {}
    update_mask = {}
    validate_only = true

    update_phrase_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_update_phrase_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_phrase_set_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_phrase_set({ phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_phrase_set phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_phrase_set ::Google::Cloud::Speech::V2::UpdatePhraseSetRequest.new(phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_phrase_set({ phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_phrase_set(::Google::Cloud::Speech::V2::UpdatePhraseSetRequest.new(phrase_set: phrase_set, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_phrase_set_client_stub.call_count
      end
    end
  end

  def test_delete_phrase_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_phrase_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_delete_phrase_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_phrase_set_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_phrase_set({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_phrase_set name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_phrase_set ::Google::Cloud::Speech::V2::DeletePhraseSetRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_phrase_set({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_phrase_set(::Google::Cloud::Speech::V2::DeletePhraseSetRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_phrase_set_client_stub.call_count
      end
    end
  end

  def test_undelete_phrase_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    undelete_phrase_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Speech::V2::Speech::Rest::ServiceStub.stub :transcode_undelete_phrase_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_phrase_set_client_stub do
        # Create client
        client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_phrase_set({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_phrase_set name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_phrase_set ::Google::Cloud::Speech::V2::UndeletePhraseSetRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_phrase_set({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_phrase_set(::Google::Cloud::Speech::V2::UndeletePhraseSetRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_phrase_set_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Speech::V2::Speech::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Speech::V2::Speech::Rest::Client::Configuration, config
  end
end
