# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Speech
      module V2
        # Represents a singular feature of a model. If the feature is `recognizer`,
        # the release_state of the feature represents the release_state of the model
        # @!attribute [rw] feature
        #   @return [::String]
        #     The name of the feature (Note: the feature can be `recognizer`)
        # @!attribute [rw] release_state
        #   @return [::String]
        #     The release state of the feature
        class ModelFeature
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the collection of features belonging to a model
        # @!attribute [rw] model_feature
        #   @return [::Array<::Google::Cloud::Speech::V2::ModelFeature>]
        #     Repeated field that contains all features of the model
        class ModelFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata about the models in a given region for a specific locale.
        # Currently this is just the features of the model
        # @!attribute [rw] model_features
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Speech::V2::ModelFeatures}]
        #     Map of the model name -> features of that model
        class ModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Speech::V2::ModelFeatures]
          class ModelFeaturesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The metadata about locales available in a given region. Currently this is
        # just the models that are available for each locale
        # @!attribute [rw] models
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Speech::V2::ModelMetadata}]
        #     Map of locale (language code) -> models
        class LanguageMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Speech::V2::ModelMetadata]
          class ModelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The access metadata for a particular region. This can be applied if the org
        # policy for the given project disallows a particular region.
        # @!attribute [rw] constraint_type
        #   @return [::Google::Cloud::Speech::V2::AccessMetadata::ConstraintType]
        #     Describes the different types of constraints that are applied.
        class AccessMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the different types of constraints that can be applied on a
          # region.
          module ConstraintType
            # Unspecified constraint applied.
            CONSTRAINT_TYPE_UNSPECIFIED = 0

            # The project's org policy disallows the given region.
            RESOURCE_LOCATIONS_ORG_POLICY_CREATE_CONSTRAINT = 1
          end
        end

        # Main metadata for the Locations API for STT V2. Currently this is just the
        # metadata about locales, models, and features
        # @!attribute [rw] languages
        #   @return [::Google::Cloud::Speech::V2::LanguageMetadata]
        #     Information about available locales, models, and features represented in
        #     the hierarchical structure of locales -> models -> features
        # @!attribute [rw] access_metadata
        #   @return [::Google::Cloud::Speech::V2::AccessMetadata]
        #     Information about access metadata for the region and given project.
        class LocationsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
