# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Speech
      module V2
        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#create_recognizer CreateRecognizer} method.
        # @!attribute [rw] recognizer
        #   @return [::Google::Cloud::Speech::V2::Recognizer]
        #     Required. The Recognizer to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the Recognizer, but do not
        #     actually create it.
        # @!attribute [rw] recognizer_id
        #   @return [::String]
        #     The ID to use for the Recognizer, which will become the final component of
        #     the Recognizer's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location where this Recognizer will be created.
        #     The expected format is `projects/{project}/locations/{location}`.
        class CreateRecognizerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was last updated.
        # @!attribute [rw] resource
        #   @return [::String]
        #     The resource path for the target of the operation.
        # @!attribute [rw] method
        #   @return [::String]
        #     The method that triggered the operation.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The [KMS key
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
        #     the content of the Operation is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [rw] kms_key_version_name
        #   @return [::String]
        #     The [KMS key version
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
        #     with which content of the Operation is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
        # @!attribute [rw] batch_recognize_request
        #   @return [::Google::Cloud::Speech::V2::BatchRecognizeRequest]
        #     The BatchRecognizeRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_recognizer_request
        #   @return [::Google::Cloud::Speech::V2::CreateRecognizerRequest]
        #     The CreateRecognizerRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `create_recognizer_request`, `batch_recognize_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update_recognizer_request
        #   @return [::Google::Cloud::Speech::V2::UpdateRecognizerRequest]
        #     The UpdateRecognizerRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `update_recognizer_request`, `batch_recognize_request`, `create_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete_recognizer_request
        #   @return [::Google::Cloud::Speech::V2::DeleteRecognizerRequest]
        #     The DeleteRecognizerRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `delete_recognizer_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] undelete_recognizer_request
        #   @return [::Google::Cloud::Speech::V2::UndeleteRecognizerRequest]
        #     The UndeleteRecognizerRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `undelete_recognizer_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_custom_class_request
        #   @return [::Google::Cloud::Speech::V2::CreateCustomClassRequest]
        #     The CreateCustomClassRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `create_custom_class_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update_custom_class_request
        #   @return [::Google::Cloud::Speech::V2::UpdateCustomClassRequest]
        #     The UpdateCustomClassRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `update_custom_class_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete_custom_class_request
        #   @return [::Google::Cloud::Speech::V2::DeleteCustomClassRequest]
        #     The DeleteCustomClassRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `delete_custom_class_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] undelete_custom_class_request
        #   @return [::Google::Cloud::Speech::V2::UndeleteCustomClassRequest]
        #     The UndeleteCustomClassRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `undelete_custom_class_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_phrase_set_request
        #   @return [::Google::Cloud::Speech::V2::CreatePhraseSetRequest]
        #     The CreatePhraseSetRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `create_phrase_set_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update_phrase_set_request
        #   @return [::Google::Cloud::Speech::V2::UpdatePhraseSetRequest]
        #     The UpdatePhraseSetRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `update_phrase_set_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete_phrase_set_request
        #   @return [::Google::Cloud::Speech::V2::DeletePhraseSetRequest]
        #     The DeletePhraseSetRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `delete_phrase_set_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `undelete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] undelete_phrase_set_request
        #   @return [::Google::Cloud::Speech::V2::UndeletePhraseSetRequest]
        #     The UndeletePhraseSetRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `undelete_phrase_set_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `update_config_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update_config_request
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Speech::V2::UpdateConfigRequest]
        #     The UpdateConfigRequest that spawned the Operation.
        #
        #     Note: The following fields are mutually exclusive: `update_config_request`, `batch_recognize_request`, `create_recognizer_request`, `update_recognizer_request`, `delete_recognizer_request`, `undelete_recognizer_request`, `create_custom_class_request`, `update_custom_class_request`, `delete_custom_class_request`, `undelete_custom_class_request`, `create_phrase_set_request`, `update_phrase_set_request`, `delete_phrase_set_request`, `undelete_phrase_set_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] progress_percent
        #   @return [::Integer]
        #     The percent progress of the Operation. Values can range from 0-100. If the
        #     value is 100, then the operation is finished.
        # @!attribute [rw] batch_recognize_metadata
        #   @return [::Google::Cloud::Speech::V2::BatchRecognizeMetadata]
        #     Metadata specific to the BatchRecognize method.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location of Recognizers to list. The expected
        #     format is `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Recognizers to return. The service may return fewer
        #     than this value. If unspecified, at most 5 Recognizers will be returned.
        #     The maximum value is 100; values above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} must match
        #     the call that provided the page token.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Whether, or not, to show resources that have been deleted.
        class ListRecognizersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} method.
        # @!attribute [rw] recognizers
        #   @return [::Array<::Google::Cloud::Speech::V2::Recognizer>]
        #     The list of requested Recognizers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::Speech::V2::ListRecognizersRequest#page_token page_token} to
        #     retrieve the next page. If this field is omitted, there are no subsequent
        #     pages. This token expires after 72 hours.
        class ListRecognizersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#get_recognizer GetRecognizer} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Recognizer to retrieve. The expected format is
        #     `projects/{project}/locations/{location}/recognizers/{recognizer}`.
        class GetRecognizerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#update_recognizer UpdateRecognizer} method.
        # @!attribute [rw] recognizer
        #   @return [::Google::Cloud::Speech::V2::Recognizer]
        #     Required. The Recognizer to update.
        #
        #     The Recognizer's `name` field is used to identify the Recognizer to update.
        #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update. If empty, all non-default valued fields are
        #     considered for update. Use `*` to update the entire Recognizer resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the updated Recognizer, but do not
        #     actually update it.
        class UpdateRecognizerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#delete_recognizer DeleteRecognizer} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Recognizer to delete.
        #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the deleted Recognizer, but do not
        #     actually delete it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the Recognizer is not found, the request will succeed
        #     and  be a no-op (no Operation is recorded in this case).
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class DeleteRecognizerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#undelete_recognizer UndeleteRecognizer}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Recognizer to undelete.
        #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the undeleted Recognizer, but do
        #     not actually undelete it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class UndeleteRecognizerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Recognizer message. Stores recognition configuration and metadata.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the Recognizer.
        #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-assigned unique identifier for the Recognizer.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-settable, human-readable name for the Recognizer. Must be 63
        #     characters or less.
        # @!attribute [rw] model
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. This field is now deprecated. Prefer the
        #     {::Google::Cloud::Speech::V2::RecognitionConfig#model `model`} field in the
        #     {::Google::Cloud::Speech::V2::RecognitionConfig `RecognitionConfig`} message.
        #
        #     Which model to use for recognition requests. Select the model best suited
        #     to your domain to get best results.
        #
        #     Guidance for choosing which model to use can be found in the [Transcription
        #     Models
        #     Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
        #     and the models supported in each region can be found in the [Table Of
        #     Supported
        #     Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
        # @!attribute [rw] language_codes
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        #     Optional. This field is now deprecated. Prefer the
        #     {::Google::Cloud::Speech::V2::RecognitionConfig#language_codes `language_codes`}
        #     field in the
        #     {::Google::Cloud::Speech::V2::RecognitionConfig `RecognitionConfig`} message.
        #
        #     The language of the supplied audio as a
        #     [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
        #
        #     Supported languages for each model are listed in the [Table of Supported
        #     Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
        #
        #     If additional languages are provided, recognition result will contain
        #     recognition in the most likely language detected. The recognition result
        #     will include the language tag of the language detected in the audio.
        #     When you create or update a Recognizer, these values are
        #     stored in normalized BCP-47 form. For example, "en-us" is stored as
        #     "en-US".
        # @!attribute [rw] default_recognition_config
        #   @return [::Google::Cloud::Speech::V2::RecognitionConfig]
        #     Default configuration to use for requests with this Recognizer.
        #     This can be overwritten by inline configuration in the
        #     {::Google::Cloud::Speech::V2::RecognizeRequest#config RecognizeRequest.config}
        #     field.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Allows users to store small amounts of arbitrary data.
        #     Both the key and the value must be 63 characters or less each.
        #     At most 100 annotations.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Speech::V2::Recognizer::State]
        #     Output only. The Recognizer lifecycle state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time this Recognizer was modified.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this Recognizer was requested for deletion.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this Recognizer will be purged.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields. This may be sent on update, undelete, and delete requests to
        #     ensure the client has an up-to-date value before proceeding.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Whether or not this Recognizer is in the process of being
        #     updated.
        # @!attribute [r] kms_key_name
        #   @return [::String]
        #     Output only. The [KMS key
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
        #     the Recognizer is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [r] kms_key_version_name
        #   @return [::String]
        #     Output only. The [KMS key version
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
        #     with which the Recognizer is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
        class Recognizer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set of states that define the lifecycle of a Recognizer.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The Recognizer is active and ready for use.
            ACTIVE = 2

            # This Recognizer has been deleted.
            DELETED = 4
          end
        end

        # Automatically detected decoding parameters.
        # Supported for the following encodings:
        #
        # * WAV_LINEAR16: 16-bit signed little-endian PCM samples in a WAV container.
        #
        # * WAV_MULAW: 8-bit companded mulaw samples in a WAV container.
        #
        # * WAV_ALAW: 8-bit companded alaw samples in a WAV container.
        #
        # * RFC4867_5_AMR: AMR frames with an rfc4867.5 header.
        #
        # * RFC4867_5_AMRWB: AMR-WB frames with an rfc4867.5 header.
        #
        # * FLAC: FLAC frames in the "native FLAC" container format.
        #
        # * MP3: MPEG audio frames with optional (ignored) ID3 metadata.
        #
        # * OGG_OPUS: Opus audio frames in an Ogg container.
        #
        # * WEBM_OPUS: Opus audio frames in a WebM container.
        #
        # * MP4_AAC: AAC audio frames in an MP4 container.
        #
        # * M4A_AAC: AAC audio frames in an M4A container.
        #
        # * MOV_AAC: AAC audio frames in an MOV container.
        class AutoDetectDecodingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Explicitly specified decoding parameters.
        # @!attribute [rw] encoding
        #   @return [::Google::Cloud::Speech::V2::ExplicitDecodingConfig::AudioEncoding]
        #     Required. Encoding of the audio data sent for recognition.
        # @!attribute [rw] sample_rate_hertz
        #   @return [::Integer]
        #     Optional. Sample rate in Hertz of the audio data sent for recognition.
        #     Valid values are: 8000-48000, and 16000 is optimal. For best results, set
        #     the sampling rate of the audio source to 16000 Hz. If that's not possible,
        #     use the native sample rate of the audio source (instead of resampling).
        #     Note that this field is marked as OPTIONAL for backward compatibility
        #     reasons. It is (and has always been) effectively REQUIRED.
        # @!attribute [rw] audio_channel_count
        #   @return [::Integer]
        #     Optional. Number of channels present in the audio data sent for
        #     recognition. Note that this field is marked as OPTIONAL for backward
        #     compatibility reasons. It is (and has always been) effectively REQUIRED.
        #
        #     The maximum allowed value is 8.
        class ExplicitDecodingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported audio data encodings.
          module AudioEncoding
            # Default value. This value is unused.
            AUDIO_ENCODING_UNSPECIFIED = 0

            # Headerless 16-bit signed little-endian PCM samples.
            LINEAR16 = 1

            # Headerless 8-bit companded mulaw samples.
            MULAW = 2

            # Headerless 8-bit companded alaw samples.
            ALAW = 3

            # AMR frames with an rfc4867.5 header.
            AMR = 4

            # AMR-WB frames with an rfc4867.5 header.
            AMR_WB = 5

            # FLAC frames in the "native FLAC" container format.
            FLAC = 6

            # MPEG audio frames with optional (ignored) ID3 metadata.
            MP3 = 7

            # Opus audio frames in an Ogg container.
            OGG_OPUS = 8

            # Opus audio frames in a WebM container.
            WEBM_OPUS = 9

            # AAC audio frames in an MP4 container.
            MP4_AAC = 10

            # AAC audio frames in an M4A container.
            M4A_AAC = 11

            # AAC audio frames in an MOV container.
            MOV_AAC = 12
          end
        end

        # Configuration to enable speaker diarization.
        # @!attribute [rw] min_speaker_count
        #   @return [::Integer]
        #     Optional. The system automatically determines the number of speakers. This
        #     value is not currently used.
        # @!attribute [rw] max_speaker_count
        #   @return [::Integer]
        #     Optional. The system automatically determines the number of speakers. This
        #     value is not currently used.
        class SpeakerDiarizationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration to enable custom prompt in chirp3.
        # @!attribute [rw] custom_prompt
        #   @return [::String]
        #     Optional. The custom instructions to override the existing instructions for
        #     chirp3.
        class CustomPromptConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Available recognition features.
        # @!attribute [rw] profanity_filter
        #   @return [::Boolean]
        #     If set to `true`, the server will attempt to filter out profanities,
        #     replacing all but the initial character in each filtered word with
        #     asterisks, for instance, "f***". If set to `false` or omitted, profanities
        #     won't be filtered out.
        # @!attribute [rw] enable_word_time_offsets
        #   @return [::Boolean]
        #     If `true`, the top result includes a list of words and the start and end
        #     time offsets (timestamps) for those words. If `false`, no word-level time
        #     offset information is returned. The default is `false`.
        # @!attribute [rw] enable_word_confidence
        #   @return [::Boolean]
        #     If `true`, the top result includes a list of words and the confidence for
        #     those words. If `false`, no word-level confidence information is returned.
        #     The default is `false`.
        # @!attribute [rw] enable_automatic_punctuation
        #   @return [::Boolean]
        #     If `true`, adds punctuation to recognition result hypotheses. This feature
        #     is only available in select languages. The default `false` value does not
        #     add punctuation to result hypotheses.
        # @!attribute [rw] enable_spoken_punctuation
        #   @return [::Boolean]
        #     The spoken punctuation behavior for the call. If `true`, replaces spoken
        #     punctuation with the corresponding symbols in the request. For example,
        #     "how are you question mark" becomes "how are you?". See
        #     https://cloud.google.com/speech-to-text/docs/spoken-punctuation for
        #     support. If `false`, spoken punctuation is not replaced.
        # @!attribute [rw] enable_spoken_emojis
        #   @return [::Boolean]
        #     The spoken emoji behavior for the call. If `true`, adds spoken emoji
        #     formatting for the request. This will replace spoken emojis with the
        #     corresponding Unicode symbols in the final transcript. If `false`, spoken
        #     emojis are not replaced.
        # @!attribute [rw] multi_channel_mode
        #   @return [::Google::Cloud::Speech::V2::RecognitionFeatures::MultiChannelMode]
        #     Mode for recognizing multi-channel audio.
        # @!attribute [rw] diarization_config
        #   @return [::Google::Cloud::Speech::V2::SpeakerDiarizationConfig]
        #     Configuration to enable speaker diarization. To enable diarization, set
        #     this field to an empty SpeakerDiarizationConfig message.
        # @!attribute [rw] max_alternatives
        #   @return [::Integer]
        #     Maximum number of recognition hypotheses to be returned.
        #     The server may return fewer than `max_alternatives`.
        #     Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
        #     one. If omitted, will return a maximum of one.
        # @!attribute [rw] custom_prompt_config
        #   @return [::Google::Cloud::Speech::V2::CustomPromptConfig]
        #     Optional. Configuration to enable custom prompt for chirp3.
        class RecognitionFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for how to recognize multi-channel audio.
          module MultiChannelMode
            # Default value for the multi-channel mode. If the audio contains
            # multiple channels, only the first channel will be transcribed; other
            # channels will be ignored.
            MULTI_CHANNEL_MODE_UNSPECIFIED = 0

            # If selected, each channel in the provided audio is transcribed
            # independently. This cannot be selected if the selected
            # {::Google::Cloud::Speech::V2::Recognizer#model model} is `latest_short`.
            SEPARATE_RECOGNITION_PER_CHANNEL = 1
          end
        end

        # Transcription normalization configuration. Use transcription normalization
        # to automatically replace parts of the transcript with phrases of your
        # choosing. For StreamingRecognize, this normalization only applies to stable
        # partial transcripts (stability > 0.8) and final transcripts.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::Speech::V2::TranscriptNormalization::Entry>]
        #     A list of replacement entries. We will perform replacement with one entry
        #     at a time. For example, the second entry in ["cat" => "dog", "mountain cat"
        #     => "mountain dog"] will never be applied because we will always process the
        #     first entry before it. At most 100 entries.
        class TranscriptNormalization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A single replacement configuration.
          # @!attribute [rw] search
          #   @return [::String]
          #     What to replace. Max length is 100 characters.
          # @!attribute [rw] replace
          #   @return [::String]
          #     What to replace with. Max length is 100 characters.
          # @!attribute [rw] case_sensitive
          #   @return [::Boolean]
          #     Whether the search is case sensitive.
          class Entry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Translation configuration. Use to translate the given audio into text for the
        # desired language.
        # @!attribute [rw] target_language
        #   @return [::String]
        #     Required. The language code to translate to.
        class TranslationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provides "hints" to the speech recognizer to favor specific words and phrases
        # in the results. PhraseSets can be specified as an inline resource, or a
        # reference to an existing PhraseSet resource.
        # @!attribute [rw] phrase_sets
        #   @return [::Array<::Google::Cloud::Speech::V2::SpeechAdaptation::AdaptationPhraseSet>]
        #     A list of inline or referenced PhraseSets.
        # @!attribute [rw] custom_classes
        #   @return [::Array<::Google::Cloud::Speech::V2::CustomClass>]
        #     A list of inline CustomClasses. Existing CustomClass resources can be
        #     referenced directly in a PhraseSet.
        class SpeechAdaptation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A biasing PhraseSet, which can be either a string referencing the name of
          # an existing PhraseSets resource, or an inline definition of a PhraseSet.
          # @!attribute [rw] phrase_set
          #   @return [::String]
          #     The name of an existing PhraseSet resource. The user must have read
          #     access to the resource and it must not be deleted.
          #
          #     Note: The following fields are mutually exclusive: `phrase_set`, `inline_phrase_set`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] inline_phrase_set
          #   @return [::Google::Cloud::Speech::V2::PhraseSet]
          #     An inline defined PhraseSet.
          #
          #     Note: The following fields are mutually exclusive: `inline_phrase_set`, `phrase_set`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AdaptationPhraseSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Denoiser config. May not be supported for all models and may
        # have no effect.
        # @!attribute [rw] denoise_audio
        #   @return [::Boolean]
        #     Denoise audio before sending to the transcription model.
        # @!attribute [rw] snr_threshold
        #   @return [::Float]
        #     Signal-to-Noise Ratio (SNR) threshold for the denoiser. Here SNR means the
        #     loudness of the speech signal. Audio with an SNR below this threshold,
        #     meaning the speech is too quiet, will be prevented from being sent to the
        #     transcription model.
        #
        #     If snr_threshold=0, no filtering will be applied.
        class DenoiserConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provides information to the Recognizer that specifies how to process the
        # recognition request.
        # @!attribute [rw] auto_decoding_config
        #   @return [::Google::Cloud::Speech::V2::AutoDetectDecodingConfig]
        #     Automatically detect decoding parameters.
        #     Preferred for supported formats.
        #
        #     Note: The following fields are mutually exclusive: `auto_decoding_config`, `explicit_decoding_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] explicit_decoding_config
        #   @return [::Google::Cloud::Speech::V2::ExplicitDecodingConfig]
        #     Explicitly specified decoding parameters.
        #     Required if using headerless PCM audio (linear16, mulaw, alaw).
        #
        #     Note: The following fields are mutually exclusive: `explicit_decoding_config`, `auto_decoding_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. Which model to use for recognition requests. Select the model
        #     best suited to your domain to get best results.
        #
        #     Guidance for choosing which model to use can be found in the [Transcription
        #     Models
        #     Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
        #     and the models supported in each region can be found in the [Table Of
        #     Supported
        #     Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
        # @!attribute [rw] language_codes
        #   @return [::Array<::String>]
        #     Optional. The language of the supplied audio as a
        #     [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
        #     Language tags are normalized to BCP-47 before they are used eg "en-us"
        #     becomes "en-US".
        #
        #     Supported languages for each model are listed in the [Table of Supported
        #     Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
        #
        #     If additional languages are provided, recognition result will contain
        #     recognition in the most likely language detected. The recognition result
        #     will include the language tag of the language detected in the audio.
        # @!attribute [rw] features
        #   @return [::Google::Cloud::Speech::V2::RecognitionFeatures]
        #     Speech recognition features to enable.
        # @!attribute [rw] adaptation
        #   @return [::Google::Cloud::Speech::V2::SpeechAdaptation]
        #     Speech adaptation context that weights recognizer predictions for specific
        #     words and phrases.
        # @!attribute [rw] transcript_normalization
        #   @return [::Google::Cloud::Speech::V2::TranscriptNormalization]
        #     Optional. Use transcription normalization to automatically replace parts of
        #     the transcript with phrases of your choosing. For StreamingRecognize, this
        #     normalization only applies to stable partial transcripts (stability > 0.8)
        #     and final transcripts.
        # @!attribute [rw] translation_config
        #   @return [::Google::Cloud::Speech::V2::TranslationConfig]
        #     Optional. Optional configuration used to automatically run translation on
        #     the given audio to the desired language for supported models.
        # @!attribute [rw] denoiser_config
        #   @return [::Google::Cloud::Speech::V2::DenoiserConfig]
        #     Optional. Optional denoiser config. May not be supported for all models
        #     and may have no effect.
        class RecognitionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#recognize Recognize} method. Either
        # `content` or `uri` must be supplied. Supplying both or neither returns
        # [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
        # limits](https://cloud.google.com/speech-to-text/quotas#content).
        # @!attribute [rw] recognizer
        #   @return [::String]
        #     Required. The name of the Recognizer to use during recognition. The
        #     expected format is
        #     `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
        #     \\{recognizer} segment may be set to `_` to use an empty implicit Recognizer.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Speech::V2::RecognitionConfig]
        #     Features and audio metadata to use for the Automatic Speech Recognition.
        #     This field in combination with the
        #     {::Google::Cloud::Speech::V2::RecognizeRequest#config_mask config_mask} field
        #     can be used to override parts of the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the Recognizer resource.
        # @!attribute [rw] config_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields in
        #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} that override the
        #     values in the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the recognizer during this recognition request. If no mask is provided,
        #     all non-default valued fields in
        #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} override the
        #     values in the recognizer for this recognition request. If a mask is
        #     provided, only the fields listed in the mask override the config in the
        #     recognizer for this recognition request. If a wildcard (`*`) is provided,
        #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} completely
        #     overrides and replaces the config in the recognizer for this recognition
        #     request.
        # @!attribute [rw] content
        #   @return [::String]
        #     The audio data bytes encoded as specified in
        #     {::Google::Cloud::Speech::V2::RecognitionConfig RecognitionConfig}. As
        #     with all bytes fields, proto buffers use a pure binary representation,
        #     whereas JSON representations use base64.
        #
        #     Note: The following fields are mutually exclusive: `content`, `uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] uri
        #   @return [::String]
        #     URI that points to a file that contains audio data bytes as specified in
        #     {::Google::Cloud::Speech::V2::RecognitionConfig RecognitionConfig}. The file
        #     must not be compressed (for example, gzip). Currently, only Google Cloud
        #     Storage URIs are supported, which must be specified in the following
        #     format: `gs://bucket_name/object_name` (other URI formats return
        #     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
        #     information, see [Request
        #     URIs](https://cloud.google.com/storage/docs/reference-uris).
        #
        #     Note: The following fields are mutually exclusive: `uri`, `content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RecognizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about the recognition request and response.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Global request identifier auto-generated by the API.
        # @!attribute [rw] total_billed_duration
        #   @return [::Google::Protobuf::Duration]
        #     When available, billed audio seconds for the corresponding request.
        # @!attribute [r] prompt
        #   @return [::String]
        #     Optional. Output only. Provides the prompt used for the recognition
        #     request.
        class RecognitionResponseMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Alternative hypotheses (a.k.a. n-best list).
        # @!attribute [rw] transcript
        #   @return [::String]
        #     Transcript text representing the words that the user spoke.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     The confidence estimate between 0.0 and 1.0. A higher number
        #     indicates an estimated greater likelihood that the recognized words are
        #     correct. This field is set only for the top alternative of a non-streaming
        #     result or, of a streaming result where
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult#is_final is_final} is
        #     set to `true`. This field is not guaranteed to be accurate and users should
        #     not rely on it to be always provided. The default of 0.0 is a sentinel
        #     value indicating `confidence` was not set.
        # @!attribute [rw] words
        #   @return [::Array<::Google::Cloud::Speech::V2::WordInfo>]
        #     A list of word-specific information for each recognized word.
        #     When the
        #     {::Google::Cloud::Speech::V2::SpeakerDiarizationConfig SpeakerDiarizationConfig}
        #     is set, you will see all the words from the beginning of the audio.
        class SpeechRecognitionAlternative
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Word-specific information for recognized words.
        # @!attribute [rw] start_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset relative to the beginning of the audio,
        #     and corresponding to the start of the spoken word.
        #     This field is only set if
        #     {::Google::Cloud::Speech::V2::RecognitionFeatures#enable_word_time_offsets enable_word_time_offsets}
        #     is `true` and only in the top hypothesis. This is an experimental feature
        #     and the accuracy of the time offset can vary.
        # @!attribute [rw] end_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset relative to the beginning of the audio,
        #     and corresponding to the end of the spoken word.
        #     This field is only set if
        #     {::Google::Cloud::Speech::V2::RecognitionFeatures#enable_word_time_offsets enable_word_time_offsets}
        #     is `true` and only in the top hypothesis. This is an experimental feature
        #     and the accuracy of the time offset can vary.
        # @!attribute [rw] word
        #   @return [::String]
        #     The word corresponding to this set of information.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     The confidence estimate between 0.0 and 1.0. A higher number
        #     indicates an estimated greater likelihood that the recognized words are
        #     correct. This field is set only for the top alternative of a non-streaming
        #     result or, of a streaming result where
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult#is_final is_final} is
        #     set to `true`. This field is not guaranteed to be accurate and users should
        #     not rely on it to be always provided. The default of 0.0 is a sentinel
        #     value indicating `confidence` was not set.
        # @!attribute [rw] speaker_label
        #   @return [::String]
        #     A distinct label is assigned for every speaker within the audio. This field
        #     specifies which one of those speakers was detected to have spoken this
        #     word. `speaker_label` is set if
        #     {::Google::Cloud::Speech::V2::SpeakerDiarizationConfig SpeakerDiarizationConfig}
        #     is given and only in the top alternative.
        class WordInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A speech recognition result corresponding to a portion of the audio.
        # @!attribute [rw] alternatives
        #   @return [::Array<::Google::Cloud::Speech::V2::SpeechRecognitionAlternative>]
        #     May contain one or more recognition hypotheses. These alternatives are
        #     ordered in terms of accuracy, with the top (first) alternative being the
        #     most probable, as ranked by the recognizer.
        # @!attribute [rw] channel_tag
        #   @return [::Integer]
        #     For multi-channel audio, this is the channel number corresponding to the
        #     recognized result for the audio from that channel.
        #     For `audio_channel_count` = `N`, its output values can range from `1` to
        #     `N`.
        # @!attribute [rw] result_end_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset of the end of this result relative to the beginning of the
        #     audio.
        # @!attribute [r] language_code
        #   @return [::String]
        #     Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
        #     language tag of the language in this result. This language code was
        #     detected to have the most likelihood of being spoken in the audio.
        class SpeechRecognitionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#recognize Recognize} method.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Speech::V2::SpeechRecognitionResult>]
        #     Sequential list of transcription results corresponding to sequential
        #     portions of audio.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::Speech::V2::RecognitionResponseMetadata]
        #     Metadata about the recognition.
        class RecognizeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Available recognition features specific to streaming recognition requests.
        # @!attribute [rw] enable_voice_activity_events
        #   @return [::Boolean]
        #     If `true`, responses with voice activity speech events will be returned as
        #     they are detected.
        # @!attribute [rw] interim_results
        #   @return [::Boolean]
        #     Whether or not to stream interim results to the client. If set to true,
        #     interim results will be streamed to the client. Otherwise, only the final
        #     response will be streamed back.
        # @!attribute [rw] voice_activity_timeout
        #   @return [::Google::Cloud::Speech::V2::StreamingRecognitionFeatures::VoiceActivityTimeout]
        #     If set, the server will automatically close the stream after the specified
        #     duration has elapsed after the last VOICE_ACTIVITY speech event has been
        #     sent. The field `voice_activity_events` must also be set to true.
        class StreamingRecognitionFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Events that a timeout can be set on for voice activity.
          # @!attribute [rw] speech_start_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Duration to timeout the stream if no speech begins. If this is set and
          #     no speech is detected in this duration at the start of the stream, the
          #     server will close the stream.
          # @!attribute [rw] speech_end_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Duration to timeout the stream after speech ends. If this is set and no
          #     speech is detected in this duration after speech was detected, the server
          #     will close the stream.
          class VoiceActivityTimeout
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Provides configuration information for the StreamingRecognize request.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Speech::V2::RecognitionConfig]
        #     Required. Features and audio metadata to use for the Automatic Speech
        #     Recognition. This field in combination with the
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionConfig#config_mask config_mask}
        #     field can be used to override parts of the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the Recognizer resource.
        # @!attribute [rw] config_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields in
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionConfig#config config} that
        #     override the values in the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the recognizer during this recognition request. If no mask is provided,
        #     all non-default valued fields in
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionConfig#config config} override
        #     the values in the Recognizer for this recognition request. If a mask is
        #     provided, only the fields listed in the mask override the config in the
        #     Recognizer for this recognition request. If a wildcard (`*`) is provided,
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionConfig#config config}
        #     completely overrides and replaces the config in the recognizer for this
        #     recognition request.
        # @!attribute [rw] streaming_features
        #   @return [::Google::Cloud::Speech::V2::StreamingRecognitionFeatures]
        #     Speech recognition features to enable specific to streaming audio
        #     recognition requests.
        class StreamingRecognitionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#streaming_recognize StreamingRecognize}
        # method. Multiple
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest StreamingRecognizeRequest}
        # messages are sent in one call.
        #
        # If the {::Google::Cloud::Speech::V2::Recognizer Recognizer} referenced by
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#recognizer recognizer}
        # contains a fully specified request configuration then the stream may only
        # contain messages with only
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#audio audio} set.
        #
        # Otherwise the first message must contain a
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#recognizer recognizer} and
        # a
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#streaming_config streaming_config}
        # message that together fully specify the request configuration and must not
        # contain {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#audio audio}. All
        # subsequent messages must only have
        # {::Google::Cloud::Speech::V2::StreamingRecognizeRequest#audio audio} set.
        # @!attribute [rw] recognizer
        #   @return [::String]
        #     Required. The name of the Recognizer to use during recognition. The
        #     expected format is
        #     `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
        #     \\{recognizer} segment may be set to `_` to use an empty implicit Recognizer.
        # @!attribute [rw] streaming_config
        #   @return [::Google::Cloud::Speech::V2::StreamingRecognitionConfig]
        #     StreamingRecognitionConfig to be used in this recognition attempt.
        #     If provided, it will override the default RecognitionConfig stored in the
        #     Recognizer.
        #
        #     Note: The following fields are mutually exclusive: `streaming_config`, `audio`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] audio
        #   @return [::String]
        #     Inline audio bytes to be Recognized.
        #     Maximum size for this field is 15 KB per request.
        #
        #     Note: The following fields are mutually exclusive: `audio`, `streaming_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class StreamingRecognizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#batch_recognize BatchRecognize}
        # method.
        # @!attribute [rw] recognizer
        #   @return [::String]
        #     Required. The name of the Recognizer to use during recognition. The
        #     expected format is
        #     `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
        #     \\{recognizer} segment may be set to `_` to use an empty implicit Recognizer.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Speech::V2::RecognitionConfig]
        #     Features and audio metadata to use for the Automatic Speech Recognition.
        #     This field in combination with the
        #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config_mask config_mask}
        #     field can be used to override parts of the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the Recognizer resource.
        # @!attribute [rw] config_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields in
        #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} that override
        #     the values in the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the recognizer during this recognition request. If no mask is provided,
        #     all given fields in
        #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} override the
        #     values in the recognizer for this recognition request. If a mask is
        #     provided, only the fields listed in the mask override the config in the
        #     recognizer for this recognition request. If a wildcard (`*`) is provided,
        #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} completely
        #     overrides and replaces the config in the recognizer for this recognition
        #     request.
        # @!attribute [rw] files
        #   @return [::Array<::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata>]
        #     Audio files with file metadata for ASR.
        #     The maximum number of files allowed to be specified is 15.
        # @!attribute [rw] recognition_output_config
        #   @return [::Google::Cloud::Speech::V2::RecognitionOutputConfig]
        #     Configuration options for where to output the transcripts of each file.
        # @!attribute [rw] processing_strategy
        #   @return [::Google::Cloud::Speech::V2::BatchRecognizeRequest::ProcessingStrategy]
        #     Processing strategy to use for this request.
        class BatchRecognizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible processing strategies for batch requests.
          module ProcessingStrategy
            # Default value for the processing strategy. The request is processed as
            # soon as its received.
            PROCESSING_STRATEGY_UNSPECIFIED = 0

            # If selected, processes the request during lower utilization periods for a
            # price discount. The request is fulfilled within 24 hours.
            DYNAMIC_BATCHING = 1
          end
        end

        # Output configurations for Cloud Storage.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The Cloud Storage URI prefix with which recognition results will be
        #     written.
        class GcsOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configurations for inline response.
        class InlineOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configurations for serialized `BatchRecognizeResults` protos.
        class NativeOutputFileFormatConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configurations for [WebVTT](https://www.w3.org/TR/webvtt1/) formatted
        # subtitle file.
        class VttOutputFileFormatConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configurations [SubRip
        # Text](https://www.matroska.org/technical/subtitles.html#srt-subtitles)
        # formatted subtitle file.
        class SrtOutputFileFormatConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the format of the results stored to `output`.
        # @!attribute [rw] native
        #   @return [::Google::Cloud::Speech::V2::NativeOutputFileFormatConfig]
        #     Configuration for the native output format. If this field is set or if no
        #     other output format field is set, then transcripts will be written to the
        #     sink in the native format.
        # @!attribute [rw] vtt
        #   @return [::Google::Cloud::Speech::V2::VttOutputFileFormatConfig]
        #     Configuration for the VTT output format. If this field is set, then
        #     transcripts will be written to the sink in the VTT format.
        # @!attribute [rw] srt
        #   @return [::Google::Cloud::Speech::V2::SrtOutputFileFormatConfig]
        #     Configuration for the SRT output format. If this field is set, then
        #     transcripts will be written to the sink in the SRT format.
        class OutputFormatConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the output(s) of recognition.
        # @!attribute [rw] gcs_output_config
        #   @return [::Google::Cloud::Speech::V2::GcsOutputConfig]
        #     If this message is populated, recognition results are written to the
        #     provided Google Cloud Storage URI.
        #
        #     Note: The following fields are mutually exclusive: `gcs_output_config`, `inline_response_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inline_response_config
        #   @return [::Google::Cloud::Speech::V2::InlineOutputConfig]
        #     If this message is populated, recognition results are provided in the
        #     {::Google::Cloud::Speech::V2::BatchRecognizeResponse BatchRecognizeResponse}
        #     message of the Operation when completed. This is only supported when
        #     calling {::Google::Cloud::Speech::V2::Speech::Client#batch_recognize BatchRecognize}
        #     with just one audio file.
        #
        #     Note: The following fields are mutually exclusive: `inline_response_config`, `gcs_output_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] output_format_config
        #   @return [::Google::Cloud::Speech::V2::OutputFormatConfig]
        #     Optional. Configuration for the format of the results stored to `output`.
        #     If unspecified transcripts will be written in the `NATIVE` format only.
        class RecognitionOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Speech::V2::Speech::Client#batch_recognize BatchRecognize} that is
        # packaged into a longrunning {::Google::Longrunning::Operation Operation}.
        # @!attribute [rw] results
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Speech::V2::BatchRecognizeFileResult}]
        #     Map from filename to the final result for that file.
        # @!attribute [rw] total_billed_duration
        #   @return [::Google::Protobuf::Duration]
        #     When available, billed audio seconds for the corresponding request.
        class BatchRecognizeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Speech::V2::BatchRecognizeFileResult]
          class ResultsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Output type for Cloud Storage of BatchRecognize transcripts. Though this
        # proto isn't returned in this API anywhere, the Cloud Storage transcripts will
        # be this proto serialized and should be parsed as such.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Speech::V2::SpeechRecognitionResult>]
        #     Sequential list of transcription results corresponding to sequential
        #     portions of audio.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::Speech::V2::RecognitionResponseMetadata]
        #     Metadata about the recognition.
        class BatchRecognizeResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Final results written to Cloud Storage.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The Cloud Storage URI to which recognition results were written.
        # @!attribute [rw] vtt_format_uri
        #   @return [::String]
        #     The Cloud Storage URI to which recognition results were written as VTT
        #     formatted captions. This is populated only when `VTT` output is requested.
        # @!attribute [rw] srt_format_uri
        #   @return [::String]
        #     The Cloud Storage URI to which recognition results were written as SRT
        #     formatted captions. This is populated only when `SRT` output is requested.
        class CloudStorageResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Final results returned inline in the recognition response.
        # @!attribute [rw] transcript
        #   @return [::Google::Cloud::Speech::V2::BatchRecognizeResults]
        #     The transcript for the audio file.
        # @!attribute [rw] vtt_captions
        #   @return [::String]
        #     The transcript for the audio file as VTT formatted captions. This is
        #     populated only when `VTT` output is requested.
        # @!attribute [rw] srt_captions
        #   @return [::String]
        #     The transcript for the audio file as SRT formatted captions. This is
        #     populated only when `SRT` output is requested.
        class InlineResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Final results for a single file.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Error if one was encountered.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::Speech::V2::RecognitionResponseMetadata]
        # @!attribute [rw] cloud_storage_result
        #   @return [::Google::Cloud::Speech::V2::CloudStorageResult]
        #     Recognition results written to Cloud Storage. This is
        #     populated only when
        #     {::Google::Cloud::Speech::V2::GcsOutputConfig GcsOutputConfig} is set in
        #     the
        #     [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_result`, `inline_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inline_result
        #   @return [::Google::Cloud::Speech::V2::InlineResult]
        #     Recognition results. This is populated only when
        #     {::Google::Cloud::Speech::V2::InlineOutputConfig InlineOutputConfig} is set in
        #     the
        #     [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
        #
        #     Note: The following fields are mutually exclusive: `inline_result`, `cloud_storage_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] uri
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. Use `cloud_storage_result.native_format_uri` instead.
        # @!attribute [rw] transcript
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Speech::V2::BatchRecognizeResults]
        #     Deprecated. Use `inline_result.transcript` instead.
        class BatchRecognizeFileResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about transcription for a single file (for example, progress
        # percent).
        # @!attribute [rw] progress_percent
        #   @return [::Integer]
        #     How much of the file has been transcribed so far.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Error if one was encountered.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The Cloud Storage URI to which recognition results will be written.
        class BatchRecognizeTranscriptionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operation metadata for
        # {::Google::Cloud::Speech::V2::Speech::Client#batch_recognize BatchRecognize}.
        # @!attribute [rw] transcription_metadata
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Speech::V2::BatchRecognizeTranscriptionMetadata}]
        #     Map from provided filename to the transcription metadata for that file.
        class BatchRecognizeMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Speech::V2::BatchRecognizeTranscriptionMetadata]
          class TranscriptionMetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata about a single file in a batch for BatchRecognize.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Cloud Storage URI for the audio file.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Speech::V2::RecognitionConfig]
        #     Features and audio metadata to use for the Automatic Speech Recognition.
        #     This field in combination with the
        #     {::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata#config_mask config_mask}
        #     field can be used to override parts of the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the Recognizer resource as well as the
        #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} at the
        #     request level.
        # @!attribute [rw] config_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields in
        #     {::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata#config config} that
        #     override the values in the
        #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
        #     of the recognizer during this recognition request. If no mask is provided,
        #     all non-default valued fields in
        #     {::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata#config config} override
        #     the values in the recognizer for this recognition request. If a mask is
        #     provided, only the fields listed in the mask override the config in the
        #     recognizer for this recognition request. If a wildcard (`*`) is provided,
        #     {::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata#config config}
        #     completely overrides and replaces the config in the recognizer for this
        #     recognition request.
        class BatchRecognizeFileMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A streaming speech recognition result corresponding to a portion of the audio
        # that is currently being processed.
        # @!attribute [rw] alternatives
        #   @return [::Array<::Google::Cloud::Speech::V2::SpeechRecognitionAlternative>]
        #     May contain one or more recognition hypotheses. These alternatives are
        #     ordered in terms of accuracy, with the top (first) alternative being the
        #     most probable, as ranked by the recognizer.
        # @!attribute [rw] is_final
        #   @return [::Boolean]
        #     If `false`, this
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult StreamingRecognitionResult}
        #     represents an interim result that may change. If `true`, this is the final
        #     time the speech service will return this particular
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult StreamingRecognitionResult},
        #     the recognizer will not return any further hypotheses for this portion of
        #     the transcript and corresponding audio.
        # @!attribute [rw] stability
        #   @return [::Float]
        #     An estimate of the likelihood that the recognizer will not change its guess
        #     about this interim result. Values range from 0.0 (completely unstable)
        #     to 1.0 (completely stable). This field is only provided for interim results
        #     ({::Google::Cloud::Speech::V2::StreamingRecognitionResult#is_final is_final}=`false`).
        #     The default of 0.0 is a sentinel value indicating `stability` was not set.
        # @!attribute [rw] result_end_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset of the end of this result relative to the beginning of the
        #     audio.
        # @!attribute [rw] channel_tag
        #   @return [::Integer]
        #     For multi-channel audio, this is the channel number corresponding to the
        #     recognized result for the audio from that channel.
        #     For
        #     `audio_channel_count` = `N`, its output values can range from `1` to `N`.
        # @!attribute [r] language_code
        #   @return [::String]
        #     Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
        #     language tag of the language in this result. This language code was
        #     detected to have the most likelihood of being spoken in the audio.
        class StreamingRecognitionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `StreamingRecognizeResponse` is the only message returned to the client by
        # `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
        # messages are streamed back to the client. If there is no recognizable
        # audio then no messages are streamed back to the client.
        #
        # Here are some examples of `StreamingRecognizeResponse`s that might
        # be returned while processing audio:
        #
        # 1. results { alternatives { transcript: "tube" } stability: 0.01 }
        #
        # 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
        #
        # 3. results { alternatives { transcript: "to be" } stability: 0.9 }
        #    results { alternatives { transcript: " or not to be" } stability: 0.01 }
        #
        # 4. results { alternatives { transcript: "to be or not to be"
        #                             confidence: 0.92 }
        #              alternatives { transcript: "to bee or not to bee" }
        #              is_final: true }
        #
        # 5. results { alternatives { transcript: " that's" } stability: 0.01 }
        #
        # 6. results { alternatives { transcript: " that is" } stability: 0.9 }
        #    results { alternatives { transcript: " the question" } stability: 0.01 }
        #
        # 7. results { alternatives { transcript: " that is the question"
        #                             confidence: 0.98 }
        #              alternatives { transcript: " that was the question" }
        #              is_final: true }
        #
        # Notes:
        #
        # - Only two of the above responses #4 and #7 contain final results; they are
        #   indicated by `is_final: true`. Concatenating these together generates the
        #   full transcript: "to be or not to be that is the question".
        #
        # - The others contain interim `results`. #3 and #6 contain two interim
        #   `results`: the first portion has a high stability and is less likely to
        #   change; the second portion has a low stability and is very likely to
        #   change. A UI designer might choose to show only high stability `results`.
        #
        # - The specific `stability` and `confidence` values shown above are only for
        #   illustrative purposes. Actual values may vary.
        #
        # - In each response, only one of these fields will be set:
        #     `error`,
        #     `speech_event_type`, or
        #     one or more (repeated) `results`.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Speech::V2::StreamingRecognitionResult>]
        #     This repeated list contains zero or more results that
        #     correspond to consecutive portions of the audio currently being processed.
        #     It contains zero or one
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult#is_final is_final}=`true`
        #     result (the newly settled portion), followed by zero or more
        #     {::Google::Cloud::Speech::V2::StreamingRecognitionResult#is_final is_final}=`false`
        #     results (the interim results).
        # @!attribute [rw] speech_event_type
        #   @return [::Google::Cloud::Speech::V2::StreamingRecognizeResponse::SpeechEventType]
        #     Indicates the type of speech event.
        # @!attribute [rw] speech_event_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset between the beginning of the audio and event emission.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::Speech::V2::RecognitionResponseMetadata]
        #     Metadata about the recognition.
        class StreamingRecognizeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates the type of speech event.
          module SpeechEventType
            # No speech event specified.
            SPEECH_EVENT_TYPE_UNSPECIFIED = 0

            # This event indicates that the server has detected the end of the user's
            # speech utterance and expects no additional speech. Therefore, the server
            # will not process additional audio and will close the gRPC bidirectional
            # stream. This event is only sent if there was a force cutoff due to
            # silence being detected early. This event is only available through the
            # `latest_short` {::Google::Cloud::Speech::V2::Recognizer#model model}.
            END_OF_SINGLE_UTTERANCE = 1

            # This event indicates that the server has detected the beginning of human
            # voice activity in the stream. This event can be returned multiple times
            # if speech starts and stops repeatedly throughout the stream. This event
            # is only sent if `voice_activity_events` is set to true.
            SPEECH_ACTIVITY_BEGIN = 2

            # This event indicates that the server has detected the end of human voice
            # activity in the stream. This event can be returned multiple times if
            # speech starts and stops repeatedly throughout the stream. This event is
            # only sent if `voice_activity_events` is set to true.
            SPEECH_ACTIVITY_END = 3
          end
        end

        # Message representing the config for the Speech-to-Text API. This includes an
        # optional [KMS key](https://cloud.google.com/kms/docs/resource-hierarchy#keys)
        # with which incoming data will be encrypted.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The name of the config resource. There is exactly
        #     one config resource per project per location. The expected format is
        #     `projects/{project}/locations/{location}/config`.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Optional. An optional [KMS key
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) that if
        #     present, will be used to encrypt Speech-to-Text resources at-rest. Updating
        #     this key will not encrypt existing resources using this key; only new
        #     resources will be encrypted using this key. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time this resource was modified.
        class Config
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#get_config GetConfig} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the config to retrieve. There is exactly one config
        #     resource per project per location. The expected format is
        #     `projects/{project}/locations/{location}/config`.
        class GetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#update_config UpdateConfig} method.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Speech::V2::Config]
        #     Required. The config to update.
        #
        #     The config's `name` field is used to identify the config to be updated.
        #     The expected format is `projects/{project}/locations/{location}/config`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CustomClass for biasing in speech recognition. Used to define a set of words
        # or phrases that represents a common concept or theme likely to appear in your
        # audio, for example a list of passenger ship names.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the CustomClass.
        #     Format:
        #     `projects/{project}/locations/{location}/customClasses/{custom_class}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-assigned unique identifier for the CustomClass.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User-settable, human-readable name for the CustomClass. Must be
        #     63 characters or less.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Speech::V2::CustomClass::ClassItem>]
        #     A collection of class items.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Speech::V2::CustomClass::State]
        #     Output only. The CustomClass lifecycle state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time this resource was modified.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this resource was requested for deletion.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this resource will be purged.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Allows users to store small amounts of arbitrary data.
        #     Both the key and the value must be 63 characters or less each.
        #     At most 100 annotations.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields. This may be sent on update, undelete, and delete requests to
        #     ensure the client has an up-to-date value before proceeding.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Whether or not this CustomClass is in the process of being
        #     updated.
        # @!attribute [r] kms_key_name
        #   @return [::String]
        #     Output only. The [KMS key
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
        #     the CustomClass is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [r] kms_key_version_name
        #   @return [::String]
        #     Output only. The [KMS key version
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
        #     with which the CustomClass is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
        class CustomClass
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An item of the class.
          # @!attribute [rw] value
          #   @return [::String]
          #     The class item's value.
          class ClassItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set of states that define the lifecycle of a CustomClass.
          module State
            # Unspecified state.  This is only used/useful for distinguishing
            # unset values.
            STATE_UNSPECIFIED = 0

            # The normal and active state.
            ACTIVE = 2

            # This CustomClass has been deleted.
            DELETED = 4
          end
        end

        # PhraseSet for biasing in speech recognition. A PhraseSet is used to provide
        # "hints" to the speech recognizer to favor specific words and phrases in the
        # results.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the PhraseSet.
        #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-assigned unique identifier for the PhraseSet.
        # @!attribute [rw] phrases
        #   @return [::Array<::Google::Cloud::Speech::V2::PhraseSet::Phrase>]
        #     A list of word and phrases.
        # @!attribute [rw] boost
        #   @return [::Float]
        #     Hint Boost. Positive value will increase the probability that a specific
        #     phrase will be recognized over other similar sounding phrases. The higher
        #     the boost, the higher the chance of false positive recognition as well.
        #     Valid `boost` values are between 0 (exclusive) and 20. We recommend using a
        #     binary search approach to finding the optimal value for your use case as
        #     well as adding phrases both with and without boost to your requests.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-settable, human-readable name for the PhraseSet. Must be 63
        #     characters or less.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Speech::V2::PhraseSet::State]
        #     Output only. The PhraseSet lifecycle state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time this resource was modified.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this resource was requested for deletion.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this resource will be purged.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Allows users to store small amounts of arbitrary data.
        #     Both the key and the value must be 63 characters or less each.
        #     At most 100 annotations.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields. This may be sent on update, undelete, and delete requests to
        #     ensure the client has an up-to-date value before proceeding.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Whether or not this PhraseSet is in the process of being
        #     updated.
        # @!attribute [r] kms_key_name
        #   @return [::String]
        #     Output only. The [KMS key
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
        #     the PhraseSet is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [r] kms_key_version_name
        #   @return [::String]
        #     Output only. The [KMS key version
        #     name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
        #     with which the PhraseSet is encrypted. The expected format is
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
        class PhraseSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A Phrase contains words and phrase "hints" so that the speech recognition
          # is more likely to recognize them. This can be used to improve the accuracy
          # for specific words and phrases, for example, if specific commands are
          # typically spoken by the user. This can also be used to add additional words
          # to the vocabulary of the recognizer.
          #
          # List items can also include CustomClass references containing groups of
          # words that represent common concepts that occur in natural language.
          # @!attribute [rw] value
          #   @return [::String]
          #     The phrase itself.
          # @!attribute [rw] boost
          #   @return [::Float]
          #     Hint Boost. Overrides the boost set at the phrase set level.
          #     Positive value will increase the probability that a specific phrase will
          #     be recognized over other similar sounding phrases. The higher the boost,
          #     the higher the chance of false positive recognition as well. Negative
          #     boost values would correspond to anti-biasing. Anti-biasing is not
          #     enabled, so negative boost values will return an error. Boost values must
          #     be between 0 and 20. Any values outside that range will return an error.
          #     We recommend using a binary search approach to finding the optimal value
          #     for your use case as well as adding phrases both with and without boost
          #     to your requests.
          class Phrase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set of states that define the lifecycle of a PhraseSet.
          module State
            # Unspecified state.  This is only used/useful for distinguishing
            # unset values.
            STATE_UNSPECIFIED = 0

            # The normal and active state.
            ACTIVE = 2

            # This PhraseSet has been deleted.
            DELETED = 4
          end
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#create_custom_class CreateCustomClass} method.
        # @!attribute [rw] custom_class
        #   @return [::Google::Cloud::Speech::V2::CustomClass]
        #     Required. The CustomClass to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the CustomClass, but do not
        #     actually create it.
        # @!attribute [rw] custom_class_id
        #   @return [::String]
        #     The ID to use for the CustomClass, which will become the final component of
        #     the CustomClass's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location where this CustomClass will be created.
        #     The expected format is `projects/{project}/locations/{location}`.
        class CreateCustomClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location of CustomClass resources to list. The
        #     expected format is `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of results per requests. A valid page_size ranges from 0 to 100
        #     inclusive. If the page_size is zero or unspecified, a page size of 5 will
        #     be chosen. If the page size exceeds 100, it will be coerced down to 100.
        #     Note that a call might return fewer results than the requested page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} must
        #     match the call that provided the page token.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Whether, or not, to show resources that have been deleted.
        class ListCustomClassesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} method.
        # @!attribute [rw] custom_classes
        #   @return [::Array<::Google::Cloud::Speech::V2::CustomClass>]
        #     The list of requested CustomClasses.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::Speech::V2::ListCustomClassesRequest#page_token page_token} to
        #     retrieve the next page. If this field is omitted, there are no subsequent
        #     pages. This token expires after 72 hours.
        class ListCustomClassesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#get_custom_class GetCustomClass} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomClass to retrieve. The expected format is
        #     `projects/{project}/locations/{location}/customClasses/{custom_class}`.
        class GetCustomClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#update_custom_class UpdateCustomClass} method.
        # @!attribute [rw] custom_class
        #   @return [::Google::Cloud::Speech::V2::CustomClass]
        #     Required. The CustomClass to update.
        #
        #     The CustomClass's `name` field is used to identify the CustomClass to
        #     update. Format:
        #     `projects/{project}/locations/{location}/customClasses/{custom_class}`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If empty, all fields are considered for
        #     update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the updated CustomClass, but do
        #     not actually update it.
        class UpdateCustomClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#delete_custom_class DeleteCustomClass} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomClass to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the deleted CustomClass, but do
        #     not actually delete it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the CustomClass is not found, the request will succeed
        #     and  be a no-op (no Operation is recorded in this case).
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class DeleteCustomClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#undelete_custom_class UndeleteCustomClass}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomClass to undelete.
        #     Format:
        #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the undeleted CustomClass, but do
        #     not actually undelete it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class UndeleteCustomClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#create_phrase_set CreatePhraseSet} method.
        # @!attribute [rw] phrase_set
        #   @return [::Google::Cloud::Speech::V2::PhraseSet]
        #     Required. The PhraseSet to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the PhraseSet, but do not
        #     actually create it.
        # @!attribute [rw] phrase_set_id
        #   @return [::String]
        #     The ID to use for the PhraseSet, which will become the final component of
        #     the PhraseSet's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location where this PhraseSet will be created.
        #     The expected format is `projects/{project}/locations/{location}`.
        class CreatePhraseSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location of PhraseSet resources to list. The
        #     expected format is `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of PhraseSets to return. The service may return fewer
        #     than this value. If unspecified, at most 5 PhraseSets will be returned.
        #     The maximum value is 100; values above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} must match
        #     the call that provided the page token.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Whether, or not, to show resources that have been deleted.
        class ListPhraseSetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} method.
        # @!attribute [rw] phrase_sets
        #   @return [::Array<::Google::Cloud::Speech::V2::PhraseSet>]
        #     The list of requested PhraseSets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::Speech::V2::ListPhraseSetsRequest#page_token page_token} to
        #     retrieve the next page. If this field is omitted, there are no subsequent
        #     pages. This token expires after 72 hours.
        class ListPhraseSetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#get_phrase_set GetPhraseSet} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the PhraseSet to retrieve. The expected format is
        #     `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
        class GetPhraseSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#update_phrase_set UpdatePhraseSet} method.
        # @!attribute [rw] phrase_set
        #   @return [::Google::Cloud::Speech::V2::PhraseSet]
        #     Required. The PhraseSet to update.
        #
        #     The PhraseSet's `name` field is used to identify the PhraseSet to update.
        #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update. If empty, all non-default valued fields are
        #     considered for update. Use `*` to update the entire PhraseSet resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the updated PhraseSet, but do not
        #     actually update it.
        class UpdatePhraseSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#delete_phrase_set DeletePhraseSet} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the PhraseSet to delete.
        #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the deleted PhraseSet, but do not
        #     actually delete it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the PhraseSet is not found, the request will succeed
        #     and  be a no-op (no Operation is recorded in this case).
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class DeletePhraseSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::Speech::V2::Speech::Client#undelete_phrase_set UndeletePhraseSet}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the PhraseSet to undelete.
        #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the undeleted PhraseSet, but do
        #     not actually undelete it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields. This may be sent on update, undelete, and delete requests to ensure
        #     the client has an up-to-date value before proceeding.
        class UndeletePhraseSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
