# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/speech/v2/cloud_speech_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Speech
      module V2
        module Speech
          ##
          # Client for the Speech service.
          #
          # Enables speech transcription and resource management.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "speech.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :speech_stub

            ##
            # Configure the Speech Client class.
            #
            # See {::Google::Cloud::Speech::V2::Speech::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Speech clients
            #   ::Google::Cloud::Speech::V2::Speech::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Speech", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 5000.0
                default_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Speech Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Speech::V2::Speech::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @speech_stub.universe_domain
            end

            ##
            # Create a new Speech client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Speech client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/speech/v2/cloud_speech_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @speech_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Speech::V2::Speech::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @speech_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @speech_stub.endpoint
                config.universe_domain = @speech_stub.universe_domain
                config.logger = @speech_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Speech::V2::Speech::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @speech_stub.logger
            end

            # Service calls

            ##
            # Creates a {::Google::Cloud::Speech::V2::Recognizer Recognizer}.
            #
            # @overload create_recognizer(request, options = nil)
            #   Pass arguments to `create_recognizer` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::CreateRecognizerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::CreateRecognizerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_recognizer(recognizer: nil, validate_only: nil, recognizer_id: nil, parent: nil)
            #   Pass arguments to `create_recognizer` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param recognizer [::Google::Cloud::Speech::V2::Recognizer, ::Hash]
            #     Required. The Recognizer to create.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the Recognizer, but do not
            #     actually create it.
            #   @param recognizer_id [::String]
            #     The ID to use for the Recognizer, which will become the final component of
            #     the Recognizer's resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are /[a-z][0-9]-/.
            #   @param parent [::String]
            #     Required. The project and location where this Recognizer will be created.
            #     The expected format is `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::CreateRecognizerRequest.new
            #
            #   # Call the create_recognizer method.
            #   result = client.create_recognizer request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_recognizer request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::CreateRecognizerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_recognizer.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_recognizer.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_recognizer.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :create_recognizer, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Recognizers.
            #
            # @overload list_recognizers(request, options = nil)
            #   Pass arguments to `list_recognizers` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::ListRecognizersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::ListRecognizersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_recognizers(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
            #   Pass arguments to `list_recognizers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location of Recognizers to list. The expected
            #     format is `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     The maximum number of Recognizers to return. The service may return fewer
            #     than this value. If unspecified, at most 5 Recognizers will be returned.
            #     The maximum value is 100; values above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_recognizers ListRecognizers} must match
            #     the call that provided the page token.
            #   @param show_deleted [::Boolean]
            #     Whether, or not, to show resources that have been deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::Recognizer>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::Recognizer>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::ListRecognizersRequest.new
            #
            #   # Call the list_recognizers method.
            #   result = client.list_recognizers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Speech::V2::Recognizer.
            #     p item
            #   end
            #
            def list_recognizers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::ListRecognizersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_recognizers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_recognizers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_recognizers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :list_recognizers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @speech_stub, :list_recognizers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested
            # {::Google::Cloud::Speech::V2::Recognizer Recognizer}. Fails with
            # [NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested Recognizer doesn't
            # exist.
            #
            # @overload get_recognizer(request, options = nil)
            #   Pass arguments to `get_recognizer` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::GetRecognizerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::GetRecognizerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_recognizer(name: nil)
            #   Pass arguments to `get_recognizer` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Recognizer to retrieve. The expected format is
            #     `projects/{project}/locations/{location}/recognizers/{recognizer}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::Recognizer]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::Recognizer]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::GetRecognizerRequest.new
            #
            #   # Call the get_recognizer method.
            #   result = client.get_recognizer request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::Recognizer.
            #   p result
            #
            def get_recognizer request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::GetRecognizerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_recognizer.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_recognizer.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_recognizer.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :get_recognizer, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the {::Google::Cloud::Speech::V2::Recognizer Recognizer}.
            #
            # @overload update_recognizer(request, options = nil)
            #   Pass arguments to `update_recognizer` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UpdateRecognizerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UpdateRecognizerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_recognizer(recognizer: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_recognizer` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param recognizer [::Google::Cloud::Speech::V2::Recognizer, ::Hash]
            #     Required. The Recognizer to update.
            #
            #     The Recognizer's `name` field is used to identify the Recognizer to update.
            #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update. If empty, all non-default valued fields are
            #     considered for update. Use `*` to update the entire Recognizer resource.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the updated Recognizer, but do not
            #     actually update it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UpdateRecognizerRequest.new
            #
            #   # Call the update_recognizer method.
            #   result = client.update_recognizer request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_recognizer request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UpdateRecognizerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_recognizer.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.recognizer&.name
                header_params["recognizer.name"] = request.recognizer.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_recognizer.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_recognizer.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :update_recognizer, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the {::Google::Cloud::Speech::V2::Recognizer Recognizer}.
            #
            # @overload delete_recognizer(request, options = nil)
            #   Pass arguments to `delete_recognizer` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::DeleteRecognizerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::DeleteRecognizerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_recognizer(name: nil, validate_only: nil, allow_missing: nil, etag: nil)
            #   Pass arguments to `delete_recognizer` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Recognizer to delete.
            #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the deleted Recognizer, but do not
            #     actually delete it.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the Recognizer is not found, the request will succeed
            #     and  be a no-op (no Operation is recorded in this case).
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::DeleteRecognizerRequest.new
            #
            #   # Call the delete_recognizer method.
            #   result = client.delete_recognizer request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_recognizer request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::DeleteRecognizerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_recognizer.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_recognizer.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_recognizer.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :delete_recognizer, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeletes the {::Google::Cloud::Speech::V2::Recognizer Recognizer}.
            #
            # @overload undelete_recognizer(request, options = nil)
            #   Pass arguments to `undelete_recognizer` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UndeleteRecognizerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UndeleteRecognizerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_recognizer(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `undelete_recognizer` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Recognizer to undelete.
            #     Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the undeleted Recognizer, but do
            #     not actually undelete it.
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UndeleteRecognizerRequest.new
            #
            #   # Call the undelete_recognizer method.
            #   result = client.undelete_recognizer request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undelete_recognizer request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UndeleteRecognizerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_recognizer.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_recognizer.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_recognizer.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :undelete_recognizer, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Performs synchronous Speech recognition: receive results after all audio
            # has been sent and processed.
            #
            # @overload recognize(request, options = nil)
            #   Pass arguments to `recognize` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::RecognizeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::RecognizeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload recognize(recognizer: nil, config: nil, config_mask: nil, content: nil, uri: nil)
            #   Pass arguments to `recognize` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param recognizer [::String]
            #     Required. The name of the Recognizer to use during recognition. The
            #     expected format is
            #     `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
            #     \\{recognizer} segment may be set to `_` to use an empty implicit Recognizer.
            #   @param config [::Google::Cloud::Speech::V2::RecognitionConfig, ::Hash]
            #     Features and audio metadata to use for the Automatic Speech Recognition.
            #     This field in combination with the
            #     {::Google::Cloud::Speech::V2::RecognizeRequest#config_mask config_mask} field
            #     can be used to override parts of the
            #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
            #     of the Recognizer resource.
            #   @param config_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields in
            #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} that override the
            #     values in the
            #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
            #     of the recognizer during this recognition request. If no mask is provided,
            #     all non-default valued fields in
            #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} override the
            #     values in the recognizer for this recognition request. If a mask is
            #     provided, only the fields listed in the mask override the config in the
            #     recognizer for this recognition request. If a wildcard (`*`) is provided,
            #     {::Google::Cloud::Speech::V2::RecognizeRequest#config config} completely
            #     overrides and replaces the config in the recognizer for this recognition
            #     request.
            #   @param content [::String]
            #     The audio data bytes encoded as specified in
            #     {::Google::Cloud::Speech::V2::RecognitionConfig RecognitionConfig}. As
            #     with all bytes fields, proto buffers use a pure binary representation,
            #     whereas JSON representations use base64.
            #
            #     Note: The following parameters are mutually exclusive: `content`, `uri`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param uri [::String]
            #     URI that points to a file that contains audio data bytes as specified in
            #     {::Google::Cloud::Speech::V2::RecognitionConfig RecognitionConfig}. The file
            #     must not be compressed (for example, gzip). Currently, only Google Cloud
            #     Storage URIs are supported, which must be specified in the following
            #     format: `gs://bucket_name/object_name` (other URI formats return
            #     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
            #     information, see [Request
            #     URIs](https://cloud.google.com/storage/docs/reference-uris).
            #
            #     Note: The following parameters are mutually exclusive: `uri`, `content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::RecognizeResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::RecognizeResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::RecognizeRequest.new
            #
            #   # Call the recognize method.
            #   result = client.recognize request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::RecognizeResponse.
            #   p result
            #
            def recognize request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::RecognizeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.recognize.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.recognizer
                header_params["recognizer"] = request.recognizer
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.recognize.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.recognize.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :recognize, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Performs bidirectional streaming speech recognition: receive results while
            # sending audio. This method is only available via the gRPC API (not REST).
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::Speech::V2::StreamingRecognizeRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::Speech::V2::StreamingRecognizeRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Speech::V2::StreamingRecognizeResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Speech::V2::StreamingRecognizeResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the streaming_recognize method to start streaming.
            #   output = client.streaming_recognize input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::Speech::V2::StreamingRecognizeRequest.new
            #   input << Google::Cloud::Speech::V2::StreamingRecognizeRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Speech::V2::StreamingRecognizeResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def streaming_recognize request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::Speech::V2::StreamingRecognizeRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.streaming_recognize.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.streaming_recognize.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.streaming_recognize.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :streaming_recognize, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Performs batch asynchronous speech recognition: send a request with N
            # audio files and receive a long running operation that can be polled to see
            # when the transcriptions are finished.
            #
            # @overload batch_recognize(request, options = nil)
            #   Pass arguments to `batch_recognize` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::BatchRecognizeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::BatchRecognizeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_recognize(recognizer: nil, config: nil, config_mask: nil, files: nil, recognition_output_config: nil, processing_strategy: nil)
            #   Pass arguments to `batch_recognize` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param recognizer [::String]
            #     Required. The name of the Recognizer to use during recognition. The
            #     expected format is
            #     `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
            #     \\{recognizer} segment may be set to `_` to use an empty implicit Recognizer.
            #   @param config [::Google::Cloud::Speech::V2::RecognitionConfig, ::Hash]
            #     Features and audio metadata to use for the Automatic Speech Recognition.
            #     This field in combination with the
            #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config_mask config_mask}
            #     field can be used to override parts of the
            #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
            #     of the Recognizer resource.
            #   @param config_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields in
            #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} that override
            #     the values in the
            #     {::Google::Cloud::Speech::V2::Recognizer#default_recognition_config default_recognition_config}
            #     of the recognizer during this recognition request. If no mask is provided,
            #     all given fields in
            #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} override the
            #     values in the recognizer for this recognition request. If a mask is
            #     provided, only the fields listed in the mask override the config in the
            #     recognizer for this recognition request. If a wildcard (`*`) is provided,
            #     {::Google::Cloud::Speech::V2::BatchRecognizeRequest#config config} completely
            #     overrides and replaces the config in the recognizer for this recognition
            #     request.
            #   @param files [::Array<::Google::Cloud::Speech::V2::BatchRecognizeFileMetadata, ::Hash>]
            #     Audio files with file metadata for ASR.
            #     The maximum number of files allowed to be specified is 15.
            #   @param recognition_output_config [::Google::Cloud::Speech::V2::RecognitionOutputConfig, ::Hash]
            #     Configuration options for where to output the transcripts of each file.
            #   @param processing_strategy [::Google::Cloud::Speech::V2::BatchRecognizeRequest::ProcessingStrategy]
            #     Processing strategy to use for this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::BatchRecognizeRequest.new
            #
            #   # Call the batch_recognize method.
            #   result = client.batch_recognize request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_recognize request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::BatchRecognizeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_recognize.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.recognizer
                header_params["recognizer"] = request.recognizer
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_recognize.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_recognize.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :batch_recognize, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested {::Google::Cloud::Speech::V2::Config Config}.
            #
            # @overload get_config(request, options = nil)
            #   Pass arguments to `get_config` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::GetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::GetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_config(name: nil)
            #   Pass arguments to `get_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the config to retrieve. There is exactly one config
            #     resource per project per location. The expected format is
            #     `projects/{project}/locations/{location}/config`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::Config]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::Config]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::GetConfigRequest.new
            #
            #   # Call the get_config method.
            #   result = client.get_config request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::Config.
            #   p result
            #
            def get_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::GetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :get_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the {::Google::Cloud::Speech::V2::Config Config}.
            #
            # @overload update_config(request, options = nil)
            #   Pass arguments to `update_config` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UpdateConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UpdateConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_config(config: nil, update_mask: nil)
            #   Pass arguments to `update_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param config [::Google::Cloud::Speech::V2::Config, ::Hash]
            #     Required. The config to update.
            #
            #     The config's `name` field is used to identify the config to be updated.
            #     The expected format is `projects/{project}/locations/{location}/config`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::Config]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::Config]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UpdateConfigRequest.new
            #
            #   # Call the update_config method.
            #   result = client.update_config request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::Config.
            #   p result
            #
            def update_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UpdateConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.config&.name
                header_params["config.name"] = request.config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :update_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::Speech::V2::CustomClass CustomClass}.
            #
            # @overload create_custom_class(request, options = nil)
            #   Pass arguments to `create_custom_class` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::CreateCustomClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::CreateCustomClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_custom_class(custom_class: nil, validate_only: nil, custom_class_id: nil, parent: nil)
            #   Pass arguments to `create_custom_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param custom_class [::Google::Cloud::Speech::V2::CustomClass, ::Hash]
            #     Required. The CustomClass to create.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the CustomClass, but do not
            #     actually create it.
            #   @param custom_class_id [::String]
            #     The ID to use for the CustomClass, which will become the final component of
            #     the CustomClass's resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are /[a-z][0-9]-/.
            #   @param parent [::String]
            #     Required. The project and location where this CustomClass will be created.
            #     The expected format is `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::CreateCustomClassRequest.new
            #
            #   # Call the create_custom_class method.
            #   result = client.create_custom_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_custom_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::CreateCustomClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_custom_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_custom_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_custom_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :create_custom_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CustomClasses.
            #
            # @overload list_custom_classes(request, options = nil)
            #   Pass arguments to `list_custom_classes` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::ListCustomClassesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::ListCustomClassesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_custom_classes(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
            #   Pass arguments to `list_custom_classes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location of CustomClass resources to list. The
            #     expected format is `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Number of results per requests. A valid page_size ranges from 0 to 100
            #     inclusive. If the page_size is zero or unspecified, a page size of 5 will
            #     be chosen. If the page size exceeds 100, it will be coerced down to 100.
            #     Note that a call might return fewer results than the requested page size.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_custom_classes ListCustomClasses} must
            #     match the call that provided the page token.
            #   @param show_deleted [::Boolean]
            #     Whether, or not, to show resources that have been deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::CustomClass>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::CustomClass>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::ListCustomClassesRequest.new
            #
            #   # Call the list_custom_classes method.
            #   result = client.list_custom_classes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Speech::V2::CustomClass.
            #     p item
            #   end
            #
            def list_custom_classes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::ListCustomClassesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_custom_classes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_custom_classes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_custom_classes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :list_custom_classes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @speech_stub, :list_custom_classes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested
            # {::Google::Cloud::Speech::V2::CustomClass CustomClass}.
            #
            # @overload get_custom_class(request, options = nil)
            #   Pass arguments to `get_custom_class` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::GetCustomClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::GetCustomClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_custom_class(name: nil)
            #   Pass arguments to `get_custom_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomClass to retrieve. The expected format is
            #     `projects/{project}/locations/{location}/customClasses/{custom_class}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::CustomClass]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::CustomClass]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::GetCustomClassRequest.new
            #
            #   # Call the get_custom_class method.
            #   result = client.get_custom_class request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::CustomClass.
            #   p result
            #
            def get_custom_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::GetCustomClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_custom_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_custom_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_custom_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :get_custom_class, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the {::Google::Cloud::Speech::V2::CustomClass CustomClass}.
            #
            # @overload update_custom_class(request, options = nil)
            #   Pass arguments to `update_custom_class` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UpdateCustomClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UpdateCustomClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_custom_class(custom_class: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_custom_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param custom_class [::Google::Cloud::Speech::V2::CustomClass, ::Hash]
            #     Required. The CustomClass to update.
            #
            #     The CustomClass's `name` field is used to identify the CustomClass to
            #     update. Format:
            #     `projects/{project}/locations/{location}/customClasses/{custom_class}`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated. If empty, all fields are considered for
            #     update.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the updated CustomClass, but do
            #     not actually update it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UpdateCustomClassRequest.new
            #
            #   # Call the update_custom_class method.
            #   result = client.update_custom_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_custom_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UpdateCustomClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_custom_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.custom_class&.name
                header_params["custom_class.name"] = request.custom_class.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_custom_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_custom_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :update_custom_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the {::Google::Cloud::Speech::V2::CustomClass CustomClass}.
            #
            # @overload delete_custom_class(request, options = nil)
            #   Pass arguments to `delete_custom_class` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::DeleteCustomClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::DeleteCustomClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_custom_class(name: nil, validate_only: nil, allow_missing: nil, etag: nil)
            #   Pass arguments to `delete_custom_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomClass to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the deleted CustomClass, but do
            #     not actually delete it.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the CustomClass is not found, the request will succeed
            #     and  be a no-op (no Operation is recorded in this case).
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::DeleteCustomClassRequest.new
            #
            #   # Call the delete_custom_class method.
            #   result = client.delete_custom_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_custom_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::DeleteCustomClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_custom_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_custom_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_custom_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :delete_custom_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeletes the {::Google::Cloud::Speech::V2::CustomClass CustomClass}.
            #
            # @overload undelete_custom_class(request, options = nil)
            #   Pass arguments to `undelete_custom_class` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UndeleteCustomClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UndeleteCustomClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_custom_class(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `undelete_custom_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomClass to undelete.
            #     Format:
            #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the undeleted CustomClass, but do
            #     not actually undelete it.
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UndeleteCustomClassRequest.new
            #
            #   # Call the undelete_custom_class method.
            #   result = client.undelete_custom_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undelete_custom_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UndeleteCustomClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_custom_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_custom_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_custom_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :undelete_custom_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::Speech::V2::PhraseSet PhraseSet}.
            #
            # @overload create_phrase_set(request, options = nil)
            #   Pass arguments to `create_phrase_set` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::CreatePhraseSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::CreatePhraseSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_phrase_set(phrase_set: nil, validate_only: nil, phrase_set_id: nil, parent: nil)
            #   Pass arguments to `create_phrase_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param phrase_set [::Google::Cloud::Speech::V2::PhraseSet, ::Hash]
            #     Required. The PhraseSet to create.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the PhraseSet, but do not
            #     actually create it.
            #   @param phrase_set_id [::String]
            #     The ID to use for the PhraseSet, which will become the final component of
            #     the PhraseSet's resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are /[a-z][0-9]-/.
            #   @param parent [::String]
            #     Required. The project and location where this PhraseSet will be created.
            #     The expected format is `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::CreatePhraseSetRequest.new
            #
            #   # Call the create_phrase_set method.
            #   result = client.create_phrase_set request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_phrase_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::CreatePhraseSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_phrase_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_phrase_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_phrase_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :create_phrase_set, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists PhraseSets.
            #
            # @overload list_phrase_sets(request, options = nil)
            #   Pass arguments to `list_phrase_sets` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::ListPhraseSetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::ListPhraseSetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_phrase_sets(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
            #   Pass arguments to `list_phrase_sets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location of PhraseSet resources to list. The
            #     expected format is `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     The maximum number of PhraseSets to return. The service may return fewer
            #     than this value. If unspecified, at most 5 PhraseSets will be returned.
            #     The maximum value is 100; values above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::Speech::V2::Speech::Client#list_phrase_sets ListPhraseSets} must match
            #     the call that provided the page token.
            #   @param show_deleted [::Boolean]
            #     Whether, or not, to show resources that have been deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::PhraseSet>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Speech::V2::PhraseSet>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::ListPhraseSetsRequest.new
            #
            #   # Call the list_phrase_sets method.
            #   result = client.list_phrase_sets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Speech::V2::PhraseSet.
            #     p item
            #   end
            #
            def list_phrase_sets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::ListPhraseSetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_phrase_sets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_phrase_sets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_phrase_sets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :list_phrase_sets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @speech_stub, :list_phrase_sets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested
            # {::Google::Cloud::Speech::V2::PhraseSet PhraseSet}.
            #
            # @overload get_phrase_set(request, options = nil)
            #   Pass arguments to `get_phrase_set` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::GetPhraseSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::GetPhraseSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_phrase_set(name: nil)
            #   Pass arguments to `get_phrase_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PhraseSet to retrieve. The expected format is
            #     `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Speech::V2::PhraseSet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Speech::V2::PhraseSet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::GetPhraseSetRequest.new
            #
            #   # Call the get_phrase_set method.
            #   result = client.get_phrase_set request
            #
            #   # The returned object is of type Google::Cloud::Speech::V2::PhraseSet.
            #   p result
            #
            def get_phrase_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::GetPhraseSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_phrase_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_phrase_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_phrase_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :get_phrase_set, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the {::Google::Cloud::Speech::V2::PhraseSet PhraseSet}.
            #
            # @overload update_phrase_set(request, options = nil)
            #   Pass arguments to `update_phrase_set` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UpdatePhraseSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UpdatePhraseSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_phrase_set(phrase_set: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_phrase_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param phrase_set [::Google::Cloud::Speech::V2::PhraseSet, ::Hash]
            #     Required. The PhraseSet to update.
            #
            #     The PhraseSet's `name` field is used to identify the PhraseSet to update.
            #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update. If empty, all non-default valued fields are
            #     considered for update. Use `*` to update the entire PhraseSet resource.
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the updated PhraseSet, but do not
            #     actually update it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UpdatePhraseSetRequest.new
            #
            #   # Call the update_phrase_set method.
            #   result = client.update_phrase_set request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_phrase_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UpdatePhraseSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_phrase_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.phrase_set&.name
                header_params["phrase_set.name"] = request.phrase_set.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_phrase_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_phrase_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :update_phrase_set, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the {::Google::Cloud::Speech::V2::PhraseSet PhraseSet}.
            #
            # @overload delete_phrase_set(request, options = nil)
            #   Pass arguments to `delete_phrase_set` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::DeletePhraseSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::DeletePhraseSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_phrase_set(name: nil, validate_only: nil, allow_missing: nil, etag: nil)
            #   Pass arguments to `delete_phrase_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PhraseSet to delete.
            #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the deleted PhraseSet, but do not
            #     actually delete it.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the PhraseSet is not found, the request will succeed
            #     and  be a no-op (no Operation is recorded in this case).
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::DeletePhraseSetRequest.new
            #
            #   # Call the delete_phrase_set method.
            #   result = client.delete_phrase_set request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_phrase_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::DeletePhraseSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_phrase_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_phrase_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_phrase_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :delete_phrase_set, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeletes the {::Google::Cloud::Speech::V2::PhraseSet PhraseSet}.
            #
            # @overload undelete_phrase_set(request, options = nil)
            #   Pass arguments to `undelete_phrase_set` via a request object, either of type
            #   {::Google::Cloud::Speech::V2::UndeletePhraseSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Speech::V2::UndeletePhraseSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_phrase_set(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `undelete_phrase_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PhraseSet to undelete.
            #     Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
            #   @param validate_only [::Boolean]
            #     If set, validate the request and preview the undeleted PhraseSet, but do
            #     not actually undelete it.
            #   @param etag [::String]
            #     This checksum is computed by the server based on the value of other
            #     fields. This may be sent on update, undelete, and delete requests to ensure
            #     the client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/speech/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Speech::V2::Speech::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Speech::V2::UndeletePhraseSetRequest.new
            #
            #   # Call the undelete_phrase_set method.
            #   result = client.undelete_phrase_set request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undelete_phrase_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V2::UndeletePhraseSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_phrase_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Speech::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_phrase_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_phrase_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @speech_stub.call_rpc :undelete_phrase_set, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Speech API.
            #
            # This class represents the configuration for Speech,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Speech::V2::Speech::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_recognizer to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Speech::V2::Speech::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_recognizer.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_recognizer.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Speech::V2::Speech::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "speech.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Speech API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_recognizer`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_recognizer
                ##
                # RPC-specific configuration for `list_recognizers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_recognizers
                ##
                # RPC-specific configuration for `get_recognizer`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_recognizer
                ##
                # RPC-specific configuration for `update_recognizer`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_recognizer
                ##
                # RPC-specific configuration for `delete_recognizer`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_recognizer
                ##
                # RPC-specific configuration for `undelete_recognizer`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_recognizer
                ##
                # RPC-specific configuration for `recognize`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :recognize
                ##
                # RPC-specific configuration for `streaming_recognize`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :streaming_recognize
                ##
                # RPC-specific configuration for `batch_recognize`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_recognize
                ##
                # RPC-specific configuration for `get_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_config
                ##
                # RPC-specific configuration for `update_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_config
                ##
                # RPC-specific configuration for `create_custom_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_custom_class
                ##
                # RPC-specific configuration for `list_custom_classes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_custom_classes
                ##
                # RPC-specific configuration for `get_custom_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_custom_class
                ##
                # RPC-specific configuration for `update_custom_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_custom_class
                ##
                # RPC-specific configuration for `delete_custom_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_custom_class
                ##
                # RPC-specific configuration for `undelete_custom_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_custom_class
                ##
                # RPC-specific configuration for `create_phrase_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_phrase_set
                ##
                # RPC-specific configuration for `list_phrase_sets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_phrase_sets
                ##
                # RPC-specific configuration for `get_phrase_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_phrase_set
                ##
                # RPC-specific configuration for `update_phrase_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_phrase_set
                ##
                # RPC-specific configuration for `delete_phrase_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_phrase_set
                ##
                # RPC-specific configuration for `undelete_phrase_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_phrase_set

                # @private
                def initialize parent_rpcs = nil
                  create_recognizer_config = parent_rpcs.create_recognizer if parent_rpcs.respond_to? :create_recognizer
                  @create_recognizer = ::Gapic::Config::Method.new create_recognizer_config
                  list_recognizers_config = parent_rpcs.list_recognizers if parent_rpcs.respond_to? :list_recognizers
                  @list_recognizers = ::Gapic::Config::Method.new list_recognizers_config
                  get_recognizer_config = parent_rpcs.get_recognizer if parent_rpcs.respond_to? :get_recognizer
                  @get_recognizer = ::Gapic::Config::Method.new get_recognizer_config
                  update_recognizer_config = parent_rpcs.update_recognizer if parent_rpcs.respond_to? :update_recognizer
                  @update_recognizer = ::Gapic::Config::Method.new update_recognizer_config
                  delete_recognizer_config = parent_rpcs.delete_recognizer if parent_rpcs.respond_to? :delete_recognizer
                  @delete_recognizer = ::Gapic::Config::Method.new delete_recognizer_config
                  undelete_recognizer_config = parent_rpcs.undelete_recognizer if parent_rpcs.respond_to? :undelete_recognizer
                  @undelete_recognizer = ::Gapic::Config::Method.new undelete_recognizer_config
                  recognize_config = parent_rpcs.recognize if parent_rpcs.respond_to? :recognize
                  @recognize = ::Gapic::Config::Method.new recognize_config
                  streaming_recognize_config = parent_rpcs.streaming_recognize if parent_rpcs.respond_to? :streaming_recognize
                  @streaming_recognize = ::Gapic::Config::Method.new streaming_recognize_config
                  batch_recognize_config = parent_rpcs.batch_recognize if parent_rpcs.respond_to? :batch_recognize
                  @batch_recognize = ::Gapic::Config::Method.new batch_recognize_config
                  get_config_config = parent_rpcs.get_config if parent_rpcs.respond_to? :get_config
                  @get_config = ::Gapic::Config::Method.new get_config_config
                  update_config_config = parent_rpcs.update_config if parent_rpcs.respond_to? :update_config
                  @update_config = ::Gapic::Config::Method.new update_config_config
                  create_custom_class_config = parent_rpcs.create_custom_class if parent_rpcs.respond_to? :create_custom_class
                  @create_custom_class = ::Gapic::Config::Method.new create_custom_class_config
                  list_custom_classes_config = parent_rpcs.list_custom_classes if parent_rpcs.respond_to? :list_custom_classes
                  @list_custom_classes = ::Gapic::Config::Method.new list_custom_classes_config
                  get_custom_class_config = parent_rpcs.get_custom_class if parent_rpcs.respond_to? :get_custom_class
                  @get_custom_class = ::Gapic::Config::Method.new get_custom_class_config
                  update_custom_class_config = parent_rpcs.update_custom_class if parent_rpcs.respond_to? :update_custom_class
                  @update_custom_class = ::Gapic::Config::Method.new update_custom_class_config
                  delete_custom_class_config = parent_rpcs.delete_custom_class if parent_rpcs.respond_to? :delete_custom_class
                  @delete_custom_class = ::Gapic::Config::Method.new delete_custom_class_config
                  undelete_custom_class_config = parent_rpcs.undelete_custom_class if parent_rpcs.respond_to? :undelete_custom_class
                  @undelete_custom_class = ::Gapic::Config::Method.new undelete_custom_class_config
                  create_phrase_set_config = parent_rpcs.create_phrase_set if parent_rpcs.respond_to? :create_phrase_set
                  @create_phrase_set = ::Gapic::Config::Method.new create_phrase_set_config
                  list_phrase_sets_config = parent_rpcs.list_phrase_sets if parent_rpcs.respond_to? :list_phrase_sets
                  @list_phrase_sets = ::Gapic::Config::Method.new list_phrase_sets_config
                  get_phrase_set_config = parent_rpcs.get_phrase_set if parent_rpcs.respond_to? :get_phrase_set
                  @get_phrase_set = ::Gapic::Config::Method.new get_phrase_set_config
                  update_phrase_set_config = parent_rpcs.update_phrase_set if parent_rpcs.respond_to? :update_phrase_set
                  @update_phrase_set = ::Gapic::Config::Method.new update_phrase_set_config
                  delete_phrase_set_config = parent_rpcs.delete_phrase_set if parent_rpcs.respond_to? :delete_phrase_set
                  @delete_phrase_set = ::Gapic::Config::Method.new delete_phrase_set_config
                  undelete_phrase_set_config = parent_rpcs.undelete_phrase_set if parent_rpcs.respond_to? :undelete_phrase_set
                  @undelete_phrase_set = ::Gapic::Config::Method.new undelete_phrase_set_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
