# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/speech/v1p1beta1/cloud_speech_adaptation_pb"
require "google/cloud/speech/v1p1beta1/adaptation/rest/service_stub"

module Google
  module Cloud
    module Speech
      module V1p1beta1
        module Adaptation
          module Rest
            ##
            # REST client for the Adaptation service.
            #
            # Service that implements Google Cloud Speech Adaptation API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "speech.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :adaptation_stub

              ##
              # Configure the Adaptation Client class.
              #
              # See {::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Adaptation clients
              #   ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Speech", "V1p1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Adaptation Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @adaptation_stub.universe_domain
              end

              ##
              # Create a new Adaptation REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Adaptation client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @adaptation_stub = ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @adaptation_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @adaptation_stub.logger
              end

              # Service calls

              ##
              # Create a set of phrase hints. Each item in the set can be a single word or
              # a multi-word phrase. The items in the PhraseSet are favored by the
              # recognition model when you send a call that includes the PhraseSet.
              #
              # @overload create_phrase_set(request, options = nil)
              #   Pass arguments to `create_phrase_set` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::CreatePhraseSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::CreatePhraseSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_phrase_set(parent: nil, phrase_set_id: nil, phrase_set: nil)
              #   Pass arguments to `create_phrase_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this phrase set will be created.
              #     Format:
              #
              #     `projects/{project}/locations/{location}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param phrase_set_id [::String]
              #     Required. The ID to use for the phrase set, which will become the final
              #     component of the phrase set's resource name.
              #
              #     This value should restrict to letters, numbers, and hyphens, with the first
              #     character a letter, the last a letter or a number, and be 4-63 characters.
              #   @param phrase_set [::Google::Cloud::Speech::V1p1beta1::PhraseSet, ::Hash]
              #     Required. The phrase set to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::CreatePhraseSetRequest.new
              #
              #   # Call the create_phrase_set method.
              #   result = client.create_phrase_set request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::PhraseSet.
              #   p result
              #
              def create_phrase_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::CreatePhraseSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_phrase_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_phrase_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_phrase_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.create_phrase_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a phrase set.
              #
              # @overload get_phrase_set(request, options = nil)
              #   Pass arguments to `get_phrase_set` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::GetPhraseSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::GetPhraseSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_phrase_set(name: nil)
              #   Pass arguments to `get_phrase_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the phrase set to retrieve. Format:
              #
              #     `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::GetPhraseSetRequest.new
              #
              #   # Call the get_phrase_set method.
              #   result = client.get_phrase_set request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::PhraseSet.
              #   p result
              #
              def get_phrase_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::GetPhraseSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_phrase_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_phrase_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_phrase_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.get_phrase_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List phrase sets.
              #
              # @overload list_phrase_set(request, options = nil)
              #   Pass arguments to `list_phrase_set` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::ListPhraseSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::ListPhraseSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_phrase_set(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_phrase_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of phrase set. Format:
              #
              #     `projects/{project}/locations/{location}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param page_size [::Integer]
              #     The maximum number of phrase sets to return. The service may return
              #     fewer than this value. If unspecified, at most 50 phrase sets will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListPhraseSet` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListPhraseSet` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Speech::V1p1beta1::PhraseSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Speech::V1p1beta1::PhraseSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::ListPhraseSetRequest.new
              #
              #   # Call the list_phrase_set method.
              #   result = client.list_phrase_set request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Speech::V1p1beta1::PhraseSet.
              #     p item
              #   end
              #
              def list_phrase_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::ListPhraseSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_phrase_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_phrase_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_phrase_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.list_phrase_set request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @adaptation_stub, :list_phrase_set, "phrase_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a phrase set.
              #
              # @overload update_phrase_set(request, options = nil)
              #   Pass arguments to `update_phrase_set` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::UpdatePhraseSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::UpdatePhraseSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_phrase_set(phrase_set: nil, update_mask: nil)
              #   Pass arguments to `update_phrase_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param phrase_set [::Google::Cloud::Speech::V1p1beta1::PhraseSet, ::Hash]
              #     Required. The phrase set to update.
              #
              #     The phrase set's `name` field is used to identify the set to be
              #     updated. Format:
              #
              #     `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::PhraseSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::UpdatePhraseSetRequest.new
              #
              #   # Call the update_phrase_set method.
              #   result = client.update_phrase_set request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::PhraseSet.
              #   p result
              #
              def update_phrase_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::UpdatePhraseSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_phrase_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_phrase_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_phrase_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.update_phrase_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a phrase set.
              #
              # @overload delete_phrase_set(request, options = nil)
              #   Pass arguments to `delete_phrase_set` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::DeletePhraseSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::DeletePhraseSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_phrase_set(name: nil)
              #   Pass arguments to `delete_phrase_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the phrase set to delete. Format:
              #
              #     `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::DeletePhraseSetRequest.new
              #
              #   # Call the delete_phrase_set method.
              #   result = client.delete_phrase_set request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_phrase_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::DeletePhraseSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_phrase_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_phrase_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_phrase_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.delete_phrase_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a custom class.
              #
              # @overload create_custom_class(request, options = nil)
              #   Pass arguments to `create_custom_class` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::CreateCustomClassRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::CreateCustomClassRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_custom_class(parent: nil, custom_class_id: nil, custom_class: nil)
              #   Pass arguments to `create_custom_class` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this custom class will be created.
              #     Format:
              #
              #     `projects/{project}/locations/{location}/customClasses`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param custom_class_id [::String]
              #     Required. The ID to use for the custom class, which will become the final
              #     component of the custom class' resource name.
              #
              #     This value should restrict to letters, numbers, and hyphens, with the first
              #     character a letter, the last a letter or a number, and be 4-63 characters.
              #   @param custom_class [::Google::Cloud::Speech::V1p1beta1::CustomClass, ::Hash]
              #     Required. The custom class to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::CreateCustomClassRequest.new
              #
              #   # Call the create_custom_class method.
              #   result = client.create_custom_class request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::CustomClass.
              #   p result
              #
              def create_custom_class request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::CreateCustomClassRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_custom_class.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_custom_class.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_custom_class.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.create_custom_class request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a custom class.
              #
              # @overload get_custom_class(request, options = nil)
              #   Pass arguments to `get_custom_class` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::GetCustomClassRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::GetCustomClassRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_custom_class(name: nil)
              #   Pass arguments to `get_custom_class` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the custom class to retrieve. Format:
              #
              #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::GetCustomClassRequest.new
              #
              #   # Call the get_custom_class method.
              #   result = client.get_custom_class request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::CustomClass.
              #   p result
              #
              def get_custom_class request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::GetCustomClassRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_custom_class.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_custom_class.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_custom_class.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.get_custom_class request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List custom classes.
              #
              # @overload list_custom_classes(request, options = nil)
              #   Pass arguments to `list_custom_classes` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::ListCustomClassesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::ListCustomClassesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_custom_classes(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_custom_classes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of custom classes. Format:
              #
              #     `projects/{project}/locations/{location}/customClasses`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param page_size [::Integer]
              #     The maximum number of custom classes to return. The service may return
              #     fewer than this value. If unspecified, at most 50 custom classes will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListCustomClass` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCustomClass` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Speech::V1p1beta1::CustomClass>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Speech::V1p1beta1::CustomClass>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::ListCustomClassesRequest.new
              #
              #   # Call the list_custom_classes method.
              #   result = client.list_custom_classes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Speech::V1p1beta1::CustomClass.
              #     p item
              #   end
              #
              def list_custom_classes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::ListCustomClassesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_custom_classes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_custom_classes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_custom_classes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.list_custom_classes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @adaptation_stub, :list_custom_classes, "custom_classes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a custom class.
              #
              # @overload update_custom_class(request, options = nil)
              #   Pass arguments to `update_custom_class` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::UpdateCustomClassRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::UpdateCustomClassRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_custom_class(custom_class: nil, update_mask: nil)
              #   Pass arguments to `update_custom_class` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param custom_class [::Google::Cloud::Speech::V1p1beta1::CustomClass, ::Hash]
              #     Required. The custom class to update.
              #
              #     The custom class's `name` field is used to identify the custom class to be
              #     updated. Format:
              #
              #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Speech::V1p1beta1::CustomClass]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::UpdateCustomClassRequest.new
              #
              #   # Call the update_custom_class method.
              #   result = client.update_custom_class request
              #
              #   # The returned object is of type Google::Cloud::Speech::V1p1beta1::CustomClass.
              #   p result
              #
              def update_custom_class request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::UpdateCustomClassRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_custom_class.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_custom_class.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_custom_class.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.update_custom_class request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a custom class.
              #
              # @overload delete_custom_class(request, options = nil)
              #   Pass arguments to `delete_custom_class` via a request object, either of type
              #   {::Google::Cloud::Speech::V1p1beta1::DeleteCustomClassRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Speech::V1p1beta1::DeleteCustomClassRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_custom_class(name: nil)
              #   Pass arguments to `delete_custom_class` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the custom class to delete. Format:
              #
              #     `projects/{project}/locations/{location}/customClasses/{custom_class}`
              #
              #     Speech-to-Text supports three locations: `global`, `us` (US North America),
              #     and `eu` (Europe). If you are calling the `speech.googleapis.com`
              #     endpoint, use the `global` location. To specify a region, use a
              #     [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
              #     with matching `us` or `eu` location value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/speech/v1p1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Speech::V1p1beta1::DeleteCustomClassRequest.new
              #
              #   # Call the delete_custom_class method.
              #   result = client.delete_custom_class request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_custom_class request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Speech::V1p1beta1::DeleteCustomClassRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_custom_class.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Speech::V1p1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_custom_class.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_custom_class.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @adaptation_stub.delete_custom_class request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Adaptation REST API.
              #
              # This class represents the configuration for Adaptation REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_phrase_set to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_phrase_set.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Speech::V1p1beta1::Adaptation::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_phrase_set.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "speech.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Adaptation API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_phrase_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_phrase_set
                  ##
                  # RPC-specific configuration for `get_phrase_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_phrase_set
                  ##
                  # RPC-specific configuration for `list_phrase_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_phrase_set
                  ##
                  # RPC-specific configuration for `update_phrase_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_phrase_set
                  ##
                  # RPC-specific configuration for `delete_phrase_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_phrase_set
                  ##
                  # RPC-specific configuration for `create_custom_class`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_custom_class
                  ##
                  # RPC-specific configuration for `get_custom_class`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_custom_class
                  ##
                  # RPC-specific configuration for `list_custom_classes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_custom_classes
                  ##
                  # RPC-specific configuration for `update_custom_class`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_custom_class
                  ##
                  # RPC-specific configuration for `delete_custom_class`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_custom_class

                  # @private
                  def initialize parent_rpcs = nil
                    create_phrase_set_config = parent_rpcs.create_phrase_set if parent_rpcs.respond_to? :create_phrase_set
                    @create_phrase_set = ::Gapic::Config::Method.new create_phrase_set_config
                    get_phrase_set_config = parent_rpcs.get_phrase_set if parent_rpcs.respond_to? :get_phrase_set
                    @get_phrase_set = ::Gapic::Config::Method.new get_phrase_set_config
                    list_phrase_set_config = parent_rpcs.list_phrase_set if parent_rpcs.respond_to? :list_phrase_set
                    @list_phrase_set = ::Gapic::Config::Method.new list_phrase_set_config
                    update_phrase_set_config = parent_rpcs.update_phrase_set if parent_rpcs.respond_to? :update_phrase_set
                    @update_phrase_set = ::Gapic::Config::Method.new update_phrase_set_config
                    delete_phrase_set_config = parent_rpcs.delete_phrase_set if parent_rpcs.respond_to? :delete_phrase_set
                    @delete_phrase_set = ::Gapic::Config::Method.new delete_phrase_set_config
                    create_custom_class_config = parent_rpcs.create_custom_class if parent_rpcs.respond_to? :create_custom_class
                    @create_custom_class = ::Gapic::Config::Method.new create_custom_class_config
                    get_custom_class_config = parent_rpcs.get_custom_class if parent_rpcs.respond_to? :get_custom_class
                    @get_custom_class = ::Gapic::Config::Method.new get_custom_class_config
                    list_custom_classes_config = parent_rpcs.list_custom_classes if parent_rpcs.respond_to? :list_custom_classes
                    @list_custom_classes = ::Gapic::Config::Method.new list_custom_classes_config
                    update_custom_class_config = parent_rpcs.update_custom_class if parent_rpcs.respond_to? :update_custom_class
                    @update_custom_class = ::Gapic::Config::Method.new update_custom_class_config
                    delete_custom_class_config = parent_rpcs.delete_custom_class if parent_rpcs.respond_to? :delete_custom_class
                    @delete_custom_class = ::Gapic::Config::Method.new delete_custom_class_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
