# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/speech/v1/version"

require "google/cloud/speech/v1/adaptation/credentials"
require "google/cloud/speech/v1/adaptation/paths"
require "google/cloud/speech/v1/adaptation/client"
require "google/cloud/speech/v1/adaptation/rest"

module Google
  module Cloud
    module Speech
      module V1
        ##
        # Service that implements Google Cloud Speech Adaptation API.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/speech/v1/adaptation"
        #     client = ::Google::Cloud::Speech::V1::Adaptation::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/speech/v1/adaptation/rest"
        #     client = ::Google::Cloud::Speech::V1::Adaptation::Rest::Client.new
        #
        module Adaptation
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "adaptation", "helpers.rb"
require "google/cloud/speech/v1/adaptation/helpers" if ::File.file? helper_path
