# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/spanner/v1/spanner_pb"
require "google/cloud/spanner/v1/spanner"

class ::Google::Cloud::Spanner::V1::Spanner::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::Session.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    session = {}

    create_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_session, name
      assert_kind_of ::Google::Cloud::Spanner::V1::CreateSessionRequest, request
      assert_equal "hello world", request["database"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::Session), request["session"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_session_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_session({ database: database, session: session }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_session database: database, session: session do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_session ::Google::Cloud::Spanner::V1::CreateSessionRequest.new(database: database, session: session) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_session({ database: database, session: session }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_session(::Google::Cloud::Spanner::V1::CreateSessionRequest.new(database: database, session: session), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_session_client_stub.call_rpc_count
    end
  end

  def test_batch_create_sessions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::BatchCreateSessionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    session_template = {}
    session_count = 42

    batch_create_sessions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_sessions, name
      assert_kind_of ::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest, request
      assert_equal "hello world", request["database"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::Session), request["session_template"]
      assert_equal 42, request["session_count"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_sessions_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_sessions({ database: database, session_template: session_template, session_count: session_count }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_sessions database: database, session_template: session_template, session_count: session_count do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_sessions ::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest.new(database: database, session_template: session_template, session_count: session_count) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_sessions({ database: database, session_template: session_template, session_count: session_count }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_sessions(::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest.new(database: database, session_template: session_template, session_count: session_count), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_sessions_client_stub.call_rpc_count
    end
  end

  def test_get_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::Session.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_session, name
      assert_kind_of ::Google::Cloud::Spanner::V1::GetSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_session_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_session ::Google::Cloud::Spanner::V1::GetSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_session(::Google::Cloud::Spanner::V1::GetSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_session_client_stub.call_rpc_count
    end
  end

  def test_list_sessions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::ListSessionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_sessions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sessions, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ListSessionsRequest, request
      assert_equal "hello world", request["database"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sessions_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sessions({ database: database, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sessions database: database, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sessions ::Google::Cloud::Spanner::V1::ListSessionsRequest.new(database: database, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sessions({ database: database, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sessions(::Google::Cloud::Spanner::V1::ListSessionsRequest.new(database: database, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sessions_client_stub.call_rpc_count
    end
  end

  def test_delete_session
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_session, name
      assert_kind_of ::Google::Cloud::Spanner::V1::DeleteSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_session_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_session ::Google::Cloud::Spanner::V1::DeleteSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_session(::Google::Cloud::Spanner::V1::DeleteSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_session_client_stub.call_rpc_count
    end
  end

  def test_execute_sql
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::ResultSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction = {}
    sql = "hello world"
    params = {}
    param_types = {}
    resume_token = "hello world"
    query_mode = :NORMAL
    partition_token = "hello world"
    seqno = 42
    query_options = {}
    request_options = {}
    directed_read_options = {}
    data_boost_enabled = true
    last_statement = true
    routing_hint = {}

    execute_sql_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :execute_sql, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ExecuteSqlRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["sql"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["params"]
      assert_equal({}, request["param_types"].to_h)
      assert_equal "hello world", request["resume_token"]
      assert_equal :NORMAL, request["query_mode"]
      assert_equal "hello world", request["partition_token"]
      assert_equal 42, request["seqno"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryOptions), request["query_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::DirectedReadOptions), request["directed_read_options"]
      assert_equal true, request["data_boost_enabled"]
      assert_equal true, request["last_statement"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RoutingHint), request["routing_hint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_sql_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_sql({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_sql session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_sql ::Google::Cloud::Spanner::V1::ExecuteSqlRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_sql({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_sql(::Google::Cloud::Spanner::V1::ExecuteSqlRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_sql_client_stub.call_rpc_count
    end
  end

  def test_execute_streaming_sql
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::PartialResultSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    session = "hello world"
    transaction = {}
    sql = "hello world"
    params = {}
    param_types = {}
    resume_token = "hello world"
    query_mode = :NORMAL
    partition_token = "hello world"
    seqno = 42
    query_options = {}
    request_options = {}
    directed_read_options = {}
    data_boost_enabled = true
    last_statement = true
    routing_hint = {}

    execute_streaming_sql_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :execute_streaming_sql, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ExecuteSqlRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["sql"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["params"]
      assert_equal({}, request["param_types"].to_h)
      assert_equal "hello world", request["resume_token"]
      assert_equal :NORMAL, request["query_mode"]
      assert_equal "hello world", request["partition_token"]
      assert_equal 42, request["seqno"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryOptions), request["query_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::DirectedReadOptions), request["directed_read_options"]
      assert_equal true, request["data_boost_enabled"]
      assert_equal true, request["last_statement"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RoutingHint), request["routing_hint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_streaming_sql_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_streaming_sql({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_streaming_sql session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_streaming_sql ::Google::Cloud::Spanner::V1::ExecuteSqlRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_streaming_sql({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_streaming_sql(::Google::Cloud::Spanner::V1::ExecuteSqlRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, resume_token: resume_token, query_mode: query_mode, partition_token: partition_token, seqno: seqno, query_options: query_options, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, last_statement: last_statement, routing_hint: routing_hint), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_streaming_sql_client_stub.call_rpc_count
    end
  end

  def test_execute_batch_dml
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::ExecuteBatchDmlResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction = {}
    statements = [{}]
    seqno = 42
    request_options = {}
    last_statements = true

    execute_batch_dml_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :execute_batch_dml, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_kind_of ::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest::Statement, request["statements"].first
      assert_equal 42, request["seqno"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal true, request["last_statements"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_batch_dml_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_batch_dml({ session: session, transaction: transaction, statements: statements, seqno: seqno, request_options: request_options, last_statements: last_statements }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_batch_dml session: session, transaction: transaction, statements: statements, seqno: seqno, request_options: request_options, last_statements: last_statements do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_batch_dml ::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest.new(session: session, transaction: transaction, statements: statements, seqno: seqno, request_options: request_options, last_statements: last_statements) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_batch_dml({ session: session, transaction: transaction, statements: statements, seqno: seqno, request_options: request_options, last_statements: last_statements }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_batch_dml(::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest.new(session: session, transaction: transaction, statements: statements, seqno: seqno, request_options: request_options, last_statements: last_statements), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_batch_dml_client_stub.call_rpc_count
    end
  end

  def test_read
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::ResultSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction = {}
    table = "hello world"
    index = "hello world"
    columns = ["hello world"]
    key_set = {}
    limit = 42
    resume_token = "hello world"
    partition_token = "hello world"
    request_options = {}
    directed_read_options = {}
    data_boost_enabled = true
    order_by = :ORDER_BY_UNSPECIFIED
    lock_hint = :LOCK_HINT_UNSPECIFIED
    routing_hint = {}

    read_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ReadRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["table"]
      assert_equal "hello world", request["index"]
      assert_equal ["hello world"], request["columns"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::KeySet), request["key_set"]
      assert_equal 42, request["limit"]
      assert_equal "hello world", request["resume_token"]
      assert_equal "hello world", request["partition_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::DirectedReadOptions), request["directed_read_options"]
      assert_equal true, request["data_boost_enabled"]
      assert_equal :ORDER_BY_UNSPECIFIED, request["order_by"]
      assert_equal :LOCK_HINT_UNSPECIFIED, request["lock_hint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RoutingHint), request["routing_hint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read ::Google::Cloud::Spanner::V1::ReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read(::Google::Cloud::Spanner::V1::ReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_client_stub.call_rpc_count
    end
  end

  def test_streaming_read
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::PartialResultSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    session = "hello world"
    transaction = {}
    table = "hello world"
    index = "hello world"
    columns = ["hello world"]
    key_set = {}
    limit = 42
    resume_token = "hello world"
    partition_token = "hello world"
    request_options = {}
    directed_read_options = {}
    data_boost_enabled = true
    order_by = :ORDER_BY_UNSPECIFIED
    lock_hint = :LOCK_HINT_UNSPECIFIED
    routing_hint = {}

    streaming_read_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_read, name
      assert_kind_of ::Google::Cloud::Spanner::V1::ReadRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["table"]
      assert_equal "hello world", request["index"]
      assert_equal ["hello world"], request["columns"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::KeySet), request["key_set"]
      assert_equal 42, request["limit"]
      assert_equal "hello world", request["resume_token"]
      assert_equal "hello world", request["partition_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::DirectedReadOptions), request["directed_read_options"]
      assert_equal true, request["data_boost_enabled"]
      assert_equal :ORDER_BY_UNSPECIFIED, request["order_by"]
      assert_equal :LOCK_HINT_UNSPECIFIED, request["lock_hint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RoutingHint), request["routing_hint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, streaming_read_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.streaming_read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.streaming_read session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.streaming_read ::Google::Cloud::Spanner::V1::ReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.streaming_read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.streaming_read(::Google::Cloud::Spanner::V1::ReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, limit: limit, resume_token: resume_token, partition_token: partition_token, request_options: request_options, directed_read_options: directed_read_options, data_boost_enabled: data_boost_enabled, order_by: order_by, lock_hint: lock_hint, routing_hint: routing_hint), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::PartialResultSet, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, streaming_read_client_stub.call_rpc_count
    end
  end

  def test_begin_transaction
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::Transaction.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    options = {}
    request_options = {}
    mutation_key = {}

    begin_transaction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :begin_transaction, name
      assert_kind_of ::Google::Cloud::Spanner::V1::BeginTransactionRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionOptions), request["options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::Mutation), request["mutation_key"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, begin_transaction_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.begin_transaction({ session: session, options: options, request_options: request_options, mutation_key: mutation_key }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.begin_transaction session: session, options: options, request_options: request_options, mutation_key: mutation_key do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.begin_transaction ::Google::Cloud::Spanner::V1::BeginTransactionRequest.new(session: session, options: options, request_options: request_options, mutation_key: mutation_key) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.begin_transaction({ session: session, options: options, request_options: request_options, mutation_key: mutation_key }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.begin_transaction(::Google::Cloud::Spanner::V1::BeginTransactionRequest.new(session: session, options: options, request_options: request_options, mutation_key: mutation_key), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, begin_transaction_client_stub.call_rpc_count
    end
  end

  def test_commit
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::CommitResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction_id = "hello world"
    mutations = [{}]
    return_commit_stats = true
    max_commit_delay = {}
    request_options = {}
    precommit_token = {}

    commit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit, name
      assert_kind_of ::Google::Cloud::Spanner::V1::CommitRequest, request
      assert_equal "hello world", request["session"]
      assert_equal "hello world", request["transaction_id"]
      assert_equal :transaction_id, request.transaction
      assert_kind_of ::Google::Cloud::Spanner::V1::Mutation, request["mutations"].first
      assert_equal true, request["return_commit_stats"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["max_commit_delay"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::MultiplexedSessionPrecommitToken), request["precommit_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit({ session: session, transaction_id: transaction_id, mutations: mutations, return_commit_stats: return_commit_stats, max_commit_delay: max_commit_delay, request_options: request_options, precommit_token: precommit_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit session: session, transaction_id: transaction_id, mutations: mutations, return_commit_stats: return_commit_stats, max_commit_delay: max_commit_delay, request_options: request_options, precommit_token: precommit_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit ::Google::Cloud::Spanner::V1::CommitRequest.new(session: session, transaction_id: transaction_id, mutations: mutations, return_commit_stats: return_commit_stats, max_commit_delay: max_commit_delay, request_options: request_options, precommit_token: precommit_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit({ session: session, transaction_id: transaction_id, mutations: mutations, return_commit_stats: return_commit_stats, max_commit_delay: max_commit_delay, request_options: request_options, precommit_token: precommit_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit(::Google::Cloud::Spanner::V1::CommitRequest.new(session: session, transaction_id: transaction_id, mutations: mutations, return_commit_stats: return_commit_stats, max_commit_delay: max_commit_delay, request_options: request_options, precommit_token: precommit_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_client_stub.call_rpc_count
    end
  end

  def test_rollback
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction_id = "hello world"

    rollback_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback, name
      assert_kind_of ::Google::Cloud::Spanner::V1::RollbackRequest, request
      assert_equal "hello world", request["session"]
      assert_equal "hello world", request["transaction_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback({ session: session, transaction_id: transaction_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback session: session, transaction_id: transaction_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback ::Google::Cloud::Spanner::V1::RollbackRequest.new(session: session, transaction_id: transaction_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback({ session: session, transaction_id: transaction_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback(::Google::Cloud::Spanner::V1::RollbackRequest.new(session: session, transaction_id: transaction_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_client_stub.call_rpc_count
    end
  end

  def test_partition_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::PartitionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction = {}
    sql = "hello world"
    params = {}
    param_types = {}
    partition_options = {}

    partition_query_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :partition_query, name
      assert_kind_of ::Google::Cloud::Spanner::V1::PartitionQueryRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["sql"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["params"]
      assert_equal({}, request["param_types"].to_h)
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::PartitionOptions), request["partition_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, partition_query_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.partition_query({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, partition_options: partition_options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.partition_query session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, partition_options: partition_options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.partition_query ::Google::Cloud::Spanner::V1::PartitionQueryRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, partition_options: partition_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.partition_query({ session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, partition_options: partition_options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.partition_query(::Google::Cloud::Spanner::V1::PartitionQueryRequest.new(session: session, transaction: transaction, sql: sql, params: params, param_types: param_types, partition_options: partition_options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, partition_query_client_stub.call_rpc_count
    end
  end

  def test_partition_read
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::PartitionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    session = "hello world"
    transaction = {}
    table = "hello world"
    index = "hello world"
    columns = ["hello world"]
    key_set = {}
    partition_options = {}

    partition_read_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :partition_read, name
      assert_kind_of ::Google::Cloud::Spanner::V1::PartitionReadRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::TransactionSelector), request["transaction"]
      assert_equal "hello world", request["table"]
      assert_equal "hello world", request["index"]
      assert_equal ["hello world"], request["columns"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::KeySet), request["key_set"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::PartitionOptions), request["partition_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, partition_read_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.partition_read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, partition_options: partition_options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.partition_read session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, partition_options: partition_options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.partition_read ::Google::Cloud::Spanner::V1::PartitionReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, partition_options: partition_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.partition_read({ session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, partition_options: partition_options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.partition_read(::Google::Cloud::Spanner::V1::PartitionReadRequest.new(session: session, transaction: transaction, table: table, index: index, columns: columns, key_set: key_set, partition_options: partition_options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, partition_read_client_stub.call_rpc_count
    end
  end

  def test_batch_write
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Spanner::V1::BatchWriteResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    session = "hello world"
    request_options = {}
    mutation_groups = [{}]
    exclude_txn_from_change_streams = true

    batch_write_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :batch_write, name
      assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteRequest, request
      assert_equal "hello world", request["session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Spanner::V1::RequestOptions), request["request_options"]
      assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteRequest::MutationGroup, request["mutation_groups"].first
      assert_equal true, request["exclude_txn_from_change_streams"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_write_client_stub do
      # Create client
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_write({ session: session, request_options: request_options, mutation_groups: mutation_groups, exclude_txn_from_change_streams: exclude_txn_from_change_streams }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_write session: session, request_options: request_options, mutation_groups: mutation_groups, exclude_txn_from_change_streams: exclude_txn_from_change_streams do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_write ::Google::Cloud::Spanner::V1::BatchWriteRequest.new(session: session, request_options: request_options, mutation_groups: mutation_groups, exclude_txn_from_change_streams: exclude_txn_from_change_streams) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_write({ session: session, request_options: request_options, mutation_groups: mutation_groups, exclude_txn_from_change_streams: exclude_txn_from_change_streams }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_write(::Google::Cloud::Spanner::V1::BatchWriteRequest.new(session: session, request_options: request_options, mutation_groups: mutation_groups, exclude_txn_from_change_streams: exclude_txn_from_change_streams), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Spanner::V1::BatchWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_write_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Spanner::V1::Spanner::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Spanner::V1::Spanner::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
