# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#create_session CreateSession}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database in which the new session is created.
        # @!attribute [rw] session
        #   @return [::Google::Cloud::Spanner::V1::Session]
        #     Required. The session to create.
        class CreateSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Spanner::V1::Spanner::Client#batch_create_sessions BatchCreateSessions}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database in which the new sessions are created.
        # @!attribute [rw] session_template
        #   @return [::Google::Cloud::Spanner::V1::Session]
        #     Parameters to apply to each created session.
        # @!attribute [rw] session_count
        #   @return [::Integer]
        #     Required. The number of sessions to be created in this batch call. At least
        #     one session is created. The API can return fewer than the requested number
        #     of sessions. If a specific number of sessions are desired, the client can
        #     make additional calls to `BatchCreateSessions` (adjusting
        #     {::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest#session_count session_count}
        #     as necessary).
        class BatchCreateSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Spanner::V1::Spanner::Client#batch_create_sessions BatchCreateSessions}.
        # @!attribute [rw] session
        #   @return [::Array<::Google::Cloud::Spanner::V1::Session>]
        #     The freshly created sessions.
        class BatchCreateSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A session in the Cloud Spanner API.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the session. This is always system-assigned.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels for the session.
        #
        #      * Label keys must be between 1 and 63 characters long and must conform to
        #        the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
        #      * Label values must be between 0 and 63 characters long and must conform
        #        to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
        #      * No more than 64 labels can be associated with a given session.
        #
        #     See https://goo.gl/xmQnxf for more information on and examples of labels.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the session is created.
        # @!attribute [r] approximate_last_use_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The approximate timestamp when the session is last used. It's
        #     typically earlier than the actual last use time.
        # @!attribute [rw] creator_role
        #   @return [::String]
        #     The database role which created this session.
        # @!attribute [rw] multiplexed
        #   @return [::Boolean]
        #     Optional. If `true`, specifies a multiplexed session. Use a multiplexed
        #     session for multiple, concurrent operations including any combination of
        #     read-only and read-write transactions. Use
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#create_session `sessions.create`} to create
        #     multiplexed sessions. Don't use
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#batch_create_sessions BatchCreateSessions} to
        #     create a multiplexed session. You can't delete or list multiplexed
        #     sessions.
        class Session
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#get_session GetSession}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the session to retrieve.
        class GetSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#list_sessions ListSessions}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database in which to list sessions.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of sessions to be returned in the response. If 0 or less, defaults
        #     to the server's maximum allowed page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     If non-empty, `page_token` should contain a
        #     {::Google::Cloud::Spanner::V1::ListSessionsResponse#next_page_token next_page_token}
        #     from a previous
        #     {::Google::Cloud::Spanner::V1::ListSessionsResponse ListSessionsResponse}.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression for filtering the results of the request. Filter rules are
        #     case insensitive. The fields eligible for filtering are:
        #
        #       * `labels.key` where key is the name of a label
        #
        #     Some examples of using filters are:
        #
        #       * `labels.env:*` --> The session has the label "env".
        #       * `labels.env:dev` --> The session has the label "env" and the value of
        #                            the label contains the string "dev".
        class ListSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for {::Google::Cloud::Spanner::V1::Spanner::Client#list_sessions ListSessions}.
        # @!attribute [rw] sessions
        #   @return [::Array<::Google::Cloud::Spanner::V1::Session>]
        #     The list of requested sessions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     `next_page_token` can be sent in a subsequent
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#list_sessions ListSessions} call to fetch more
        #     of the matching sessions.
        class ListSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#delete_session DeleteSession}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the session to delete.
        class DeleteSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Common request options for various APIs.
        # @!attribute [rw] priority
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions::Priority]
        #     Priority for the request.
        # @!attribute [rw] request_tag
        #   @return [::String]
        #     A per-request tag which can be applied to queries or reads, used for
        #     statistics collection.
        #     Both `request_tag` and `transaction_tag` can be specified for a read or
        #     query that belongs to a transaction.
        #     This field is ignored for requests where it's not applicable (for example,
        #     `CommitRequest`).
        #     Legal characters for `request_tag` values are all printable characters
        #     (ASCII 32 - 126) and the length of a request_tag is limited to 50
        #     characters. Values that exceed this limit are truncated.
        #     Any leading underscore (_) characters are removed from the string.
        # @!attribute [rw] transaction_tag
        #   @return [::String]
        #     A tag used for statistics collection about this transaction.
        #     Both `request_tag` and `transaction_tag` can be specified for a read or
        #     query that belongs to a transaction.
        #     The value of transaction_tag should be the same for all requests belonging
        #     to the same transaction.
        #     If this request doesn't belong to any transaction, `transaction_tag` is
        #     ignored.
        #     Legal characters for `transaction_tag` values are all printable characters
        #     (ASCII 32 - 126) and the length of a `transaction_tag` is limited to 50
        #     characters. Values that exceed this limit are truncated.
        #     Any leading underscore (_) characters are removed from the string.
        # @!attribute [rw] client_context
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions::ClientContext]
        #     Optional. Optional context that may be needed for some requests.
        class RequestOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Container for various pieces of client-owned context attached to a request.
          # @!attribute [rw] secure_context
          #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
          #     Optional. Map of parameter name to value for this request. These values
          #     will be returned by any SECURE_CONTEXT() calls invoked by this request
          #     (e.g., by queries against Parameterized Secure Views).
          class ClientContext
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            class SecureContextEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The relative priority for requests. Note that priority isn't applicable
          # for {::Google::Cloud::Spanner::V1::Spanner::Client#begin_transaction BeginTransaction}.
          #
          # The priority acts as a hint to the Cloud Spanner scheduler and doesn't
          # guarantee priority or order of execution. For example:
          #
          # * Some parts of a write operation always execute at `PRIORITY_HIGH`,
          #   regardless of the specified priority. This can cause you to see an
          #   increase in high priority workload even when executing a low priority
          #   request. This can also potentially cause a priority inversion where a
          #   lower priority request is fulfilled ahead of a higher priority
          #   request.
          # * If a transaction contains multiple operations with different priorities,
          #   Cloud Spanner doesn't guarantee to process the higher priority
          #   operations first. There might be other constraints to satisfy, such as
          #   the order of operations.
          module Priority
            # `PRIORITY_UNSPECIFIED` is equivalent to `PRIORITY_HIGH`.
            PRIORITY_UNSPECIFIED = 0

            # This specifies that the request is low priority.
            PRIORITY_LOW = 1

            # This specifies that the request is medium priority.
            PRIORITY_MEDIUM = 2

            # This specifies that the request is high priority.
            PRIORITY_HIGH = 3
          end
        end

        # The `DirectedReadOptions` can be used to indicate which replicas or regions
        # should be used for non-transactional reads or queries.
        #
        # `DirectedReadOptions` can only be specified for a read-only transaction,
        # otherwise the API returns an `INVALID_ARGUMENT` error.
        # @!attribute [rw] include_replicas
        #   @return [::Google::Cloud::Spanner::V1::DirectedReadOptions::IncludeReplicas]
        #     `Include_replicas` indicates the order of replicas (as they appear in
        #     this list) to process the request. If `auto_failover_disabled` is set to
        #     `true` and all replicas are exhausted without finding a healthy replica,
        #     Spanner waits for a replica in the list to become available, requests
        #     might fail due to `DEADLINE_EXCEEDED` errors.
        #
        #     Note: The following fields are mutually exclusive: `include_replicas`, `exclude_replicas`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclude_replicas
        #   @return [::Google::Cloud::Spanner::V1::DirectedReadOptions::ExcludeReplicas]
        #     `Exclude_replicas` indicates that specified replicas should be excluded
        #     from serving requests. Spanner doesn't route requests to the replicas
        #     in this list.
        #
        #     Note: The following fields are mutually exclusive: `exclude_replicas`, `include_replicas`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DirectedReadOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The directed read replica selector.
          # Callers must provide one or more of the following fields for replica
          # selection:
          #
          #   * `location` - The location must be one of the regions within the
          #      multi-region configuration of your database.
          #   * `type` - The type of the replica.
          #
          # Some examples of using replica_selectors are:
          #
          #   * `location:us-east1` --> The "us-east1" replica(s) of any available type
          #                             is used to process the request.
          #   * `type:READ_ONLY`    --> The "READ_ONLY" type replica(s) in the nearest
          #                             available location are used to process the
          #                             request.
          #   * `location:us-east1 type:READ_ONLY` --> The "READ_ONLY" type replica(s)
          #                          in location "us-east1" is used to process
          #                          the request.
          # @!attribute [rw] location
          #   @return [::String]
          #     The location or region of the serving requests, for example, "us-east1".
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Spanner::V1::DirectedReadOptions::ReplicaSelection::Type]
          #     The type of replica.
          class ReplicaSelection
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Indicates the type of replica.
            module Type
              # Not specified.
              TYPE_UNSPECIFIED = 0

              # Read-write replicas support both reads and writes.
              READ_WRITE = 1

              # Read-only replicas only support reads (not writes).
              READ_ONLY = 2
            end
          end

          # An `IncludeReplicas` contains a repeated set of `ReplicaSelection` which
          # indicates the order in which replicas should be considered.
          # @!attribute [rw] replica_selections
          #   @return [::Array<::Google::Cloud::Spanner::V1::DirectedReadOptions::ReplicaSelection>]
          #     The directed read replica selector.
          # @!attribute [rw] auto_failover_disabled
          #   @return [::Boolean]
          #     If `true`, Spanner doesn't route requests to a replica outside the
          #     <`include_replicas` list when all of the specified replicas are
          #     unavailable or unhealthy. Default value is `false`.
          class IncludeReplicas
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An ExcludeReplicas contains a repeated set of ReplicaSelection that should
          # be excluded from serving requests.
          # @!attribute [rw] replica_selections
          #   @return [::Array<::Google::Cloud::Spanner::V1::DirectedReadOptions::ReplicaSelection>]
          #     The directed read replica selector.
          class ExcludeReplicas
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql} and
        # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_streaming_sql ExecuteStreamingSql}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the SQL query should be performed.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionSelector]
        #     The transaction to use.
        #
        #     For queries, if none is provided, the default is a temporary read-only
        #     transaction with strong concurrency.
        #
        #     Standard DML statements require a read-write transaction. To protect
        #     against replays, single-use transactions are not supported. The caller
        #     must either supply an existing transaction ID or begin a new transaction.
        #
        #     Partitioned DML requires an existing Partitioned DML transaction ID.
        # @!attribute [rw] sql
        #   @return [::String]
        #     Required. The SQL string.
        # @!attribute [rw] params
        #   @return [::Google::Protobuf::Struct]
        #     Parameter names and values that bind to placeholders in the SQL string.
        #
        #     A parameter placeholder consists of the `@` character followed by the
        #     parameter name (for example, `@firstName`). Parameter names must conform
        #     to the naming requirements of identifiers as specified at
        #     https://cloud.google.com/spanner/docs/lexical#identifiers.
        #
        #     Parameters can appear anywhere that a literal value is expected. The same
        #     parameter name can be used more than once, for example:
        #
        #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
        #
        #     It's an error to execute a SQL statement with unbound parameters.
        # @!attribute [rw] param_types
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Spanner::V1::Type}]
        #     It isn't always possible for Cloud Spanner to infer the right SQL type
        #     from a JSON value. For example, values of type `BYTES` and values
        #     of type `STRING` both appear in
        #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#params params} as JSON strings.
        #
        #     In these cases, you can use `param_types` to specify the exact
        #     SQL type for some or all of the SQL statement parameters. See the
        #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
        #     about SQL types.
        # @!attribute [rw] resume_token
        #   @return [::String]
        #     If this request is resuming a previously interrupted SQL statement
        #     execution, `resume_token` should be copied from the last
        #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
        #     interruption. Doing this enables the new SQL statement execution to resume
        #     where the last one left off. The rest of the request parameters must
        #     exactly match the request that yielded this token.
        # @!attribute [rw] query_mode
        #   @return [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode]
        #     Used to control the amount of debugging information returned in
        #     {::Google::Cloud::Spanner::V1::ResultSetStats ResultSetStats}. If
        #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#partition_token partition_token} is
        #     set, {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#query_mode query_mode} can only
        #     be set to
        #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode::NORMAL QueryMode.NORMAL}.
        # @!attribute [rw] partition_token
        #   @return [::String]
        #     If present, results are restricted to the specified partition
        #     previously created using `PartitionQuery`. There must be an exact
        #     match for the values of fields common to this message and the
        #     `PartitionQueryRequest` message used to create this `partition_token`.
        # @!attribute [rw] seqno
        #   @return [::Integer]
        #     A per-transaction sequence number used to identify this request. This field
        #     makes each request idempotent such that if the request is received multiple
        #     times, at most one succeeds.
        #
        #     The sequence number must be monotonically increasing within the
        #     transaction. If a request arrives for the first time with an out-of-order
        #     sequence number, the transaction can be aborted. Replays of previously
        #     handled requests yield the same response as the first execution.
        #
        #     Required for DML statements. Ignored for queries.
        # @!attribute [rw] query_options
        #   @return [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryOptions]
        #     Query optimizer configuration to use for the given query.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        # @!attribute [rw] directed_read_options
        #   @return [::Google::Cloud::Spanner::V1::DirectedReadOptions]
        #     Directed read options for this request.
        # @!attribute [rw] data_boost_enabled
        #   @return [::Boolean]
        #     If this is for a partitioned query and this field is set to `true`, the
        #     request is executed with Spanner Data Boost independent compute resources.
        #
        #     If the field is set to `true` but the request doesn't set
        #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
        # @!attribute [rw] last_statement
        #   @return [::Boolean]
        #     Optional. If set to `true`, this statement marks the end of the
        #     transaction. After this statement executes, you must commit or abort the
        #     transaction. Attempts to execute any other requests against this
        #     transaction (including reads and queries) are rejected.
        #
        #     For DML statements, setting this option might cause some error reporting to
        #     be deferred until commit time (for example, validation of unique
        #     constraints). Given this, successful execution of a DML statement shouldn't
        #     be assumed until a subsequent `Commit` call completes successfully.
        # @!attribute [rw] routing_hint
        #   @return [::Google::Cloud::Spanner::V1::RoutingHint]
        #     Optional. If present, it makes the Spanner requests location-aware.
        #
        #     It gives the server hints that can be used to route the request
        #     to an appropriate server, potentially significantly decreasing latency and
        #     improving throughput. To achieve improved performance, most fields must be
        #     filled in with accurate values.
        class ExecuteSqlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Query optimizer configuration.
          # @!attribute [rw] optimizer_version
          #   @return [::String]
          #     An option to control the selection of optimizer version.
          #
          #     This parameter allows individual queries to pick different query
          #     optimizer versions.
          #
          #     Specifying `latest` as a value instructs Cloud Spanner to use the
          #     latest supported query optimizer version. If not specified, Cloud Spanner
          #     uses the optimizer version set at the database level options. Any other
          #     positive integer (from the list of supported optimizer versions)
          #     overrides the default optimizer version for query execution.
          #
          #     The list of supported optimizer versions can be queried from
          #     `SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS`.
          #
          #     Executing a SQL statement with an invalid optimizer version fails with
          #     an `INVALID_ARGUMENT` error.
          #
          #     See
          #     https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
          #     for more information on managing the query optimizer.
          #
          #     The `optimizer_version` statement hint has precedence over this setting.
          # @!attribute [rw] optimizer_statistics_package
          #   @return [::String]
          #     An option to control the selection of optimizer statistics package.
          #
          #     This parameter allows individual queries to use a different query
          #     optimizer statistics package.
          #
          #     Specifying `latest` as a value instructs Cloud Spanner to use the latest
          #     generated statistics package. If not specified, Cloud Spanner uses
          #     the statistics package set at the database level options, or the latest
          #     package if the database option isn't set.
          #
          #     The statistics package requested by the query has to be exempt from
          #     garbage collection. This can be achieved with the following DDL
          #     statement:
          #
          #     ```sql
          #     ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
          #     ```
          #
          #     The list of available statistics packages can be queried from
          #     `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
          #
          #     Executing a SQL statement with an invalid optimizer statistics package
          #     or with a statistics package that allows garbage collection fails with
          #     an `INVALID_ARGUMENT` error.
          class QueryOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Spanner::V1::Type]
          class ParamTypesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Mode in which the statement must be processed.
          module QueryMode
            # The default mode. Only the statement results are returned.
            NORMAL = 0

            # This mode returns only the query plan, without any results or
            # execution statistics information.
            PLAN = 1

            # This mode returns the query plan, overall execution statistics,
            # operator level execution statistics along with the results. This has a
            # performance overhead compared to the other modes. It isn't recommended
            # to use this mode for production traffic.
            PROFILE = 2

            # This mode returns the overall (but not operator-level) execution
            # statistics along with the results.
            WITH_STATS = 3

            # This mode returns the query plan, overall (but not operator-level)
            # execution statistics along with the results.
            WITH_PLAN_AND_STATS = 4
          end
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#execute_batch_dml ExecuteBatchDml}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the DML statements should be performed.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionSelector]
        #     Required. The transaction to use. Must be a read-write transaction.
        #
        #     To protect against replays, single-use transactions are not supported. The
        #     caller must either supply an existing transaction ID or begin a new
        #     transaction.
        # @!attribute [rw] statements
        #   @return [::Array<::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest::Statement>]
        #     Required. The list of statements to execute in this batch. Statements are
        #     executed serially, such that the effects of statement `i` are visible to
        #     statement `i+1`. Each statement must be a DML statement. Execution stops at
        #     the first failed statement; the remaining statements are not executed.
        #
        #     Callers must provide at least one statement.
        # @!attribute [rw] seqno
        #   @return [::Integer]
        #     Required. A per-transaction sequence number used to identify this request.
        #     This field makes each request idempotent such that if the request is
        #     received multiple times, at most one succeeds.
        #
        #     The sequence number must be monotonically increasing within the
        #     transaction. If a request arrives for the first time with an out-of-order
        #     sequence number, the transaction might be aborted. Replays of previously
        #     handled requests yield the same response as the first execution.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        # @!attribute [rw] last_statements
        #   @return [::Boolean]
        #     Optional. If set to `true`, this request marks the end of the transaction.
        #     After these statements execute, you must commit or abort the transaction.
        #     Attempts to execute any other requests against this transaction
        #     (including reads and queries) are rejected.
        #
        #     Setting this option might cause some error reporting to be deferred until
        #     commit time (for example, validation of unique constraints). Given this,
        #     successful execution of statements shouldn't be assumed until a subsequent
        #     `Commit` call completes successfully.
        class ExecuteBatchDmlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A single DML statement.
          # @!attribute [rw] sql
          #   @return [::String]
          #     Required. The DML string.
          # @!attribute [rw] params
          #   @return [::Google::Protobuf::Struct]
          #     Parameter names and values that bind to placeholders in the DML string.
          #
          #     A parameter placeholder consists of the `@` character followed by the
          #     parameter name (for example, `@firstName`). Parameter names can contain
          #     letters, numbers, and underscores.
          #
          #     Parameters can appear anywhere that a literal value is expected. The
          #     same parameter name can be used more than once, for example:
          #
          #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
          #
          #     It's an error to execute a SQL statement with unbound parameters.
          # @!attribute [rw] param_types
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Spanner::V1::Type}]
          #     It isn't always possible for Cloud Spanner to infer the right SQL type
          #     from a JSON value. For example, values of type `BYTES` and values
          #     of type `STRING` both appear in
          #     {::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest::Statement#params params} as
          #     JSON strings.
          #
          #     In these cases, `param_types` can be used to specify the exact
          #     SQL type for some or all of the SQL statement parameters. See the
          #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
          #     about SQL types.
          class Statement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Spanner::V1::Type]
            class ParamTypesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The response for
        # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_batch_dml ExecuteBatchDml}. Contains a list
        # of {::Google::Cloud::Spanner::V1::ResultSet ResultSet} messages, one for each DML
        # statement that has successfully executed, in the same order as the statements
        # in the request. If a statement fails, the status in the response body
        # identifies the cause of the failure.
        #
        # To check for DML statements that failed, use the following approach:
        #
        # 1. Check the status in the response message. The
        # [google.rpc.Code][google.rpc.Code] enum
        #    value `OK` indicates that all statements were executed successfully.
        # 2. If the status was not `OK`, check the number of result sets in the
        #    response. If the response contains `N`
        #    {::Google::Cloud::Spanner::V1::ResultSet ResultSet} messages, then statement `N+1` in
        #    the request failed.
        #
        # Example 1:
        #
        # * Request: 5 DML statements, all executed successfully.
        # * Response: 5 {::Google::Cloud::Spanner::V1::ResultSet ResultSet} messages, with the
        # status `OK`.
        #
        # Example 2:
        #
        # * Request: 5 DML statements. The third statement has a syntax error.
        # * Response: 2 {::Google::Cloud::Spanner::V1::ResultSet ResultSet} messages, and a syntax
        # error (`INVALID_ARGUMENT`)
        #   status. The number of {::Google::Cloud::Spanner::V1::ResultSet ResultSet} messages
        #   indicates that the third statement failed, and the fourth and fifth
        #   statements were not executed.
        # @!attribute [rw] result_sets
        #   @return [::Array<::Google::Cloud::Spanner::V1::ResultSet>]
        #     One {::Google::Cloud::Spanner::V1::ResultSet ResultSet} for each statement in the
        #     request that ran successfully, in the same order as the statements in the
        #     request. Each {::Google::Cloud::Spanner::V1::ResultSet ResultSet} does not contain any
        #     rows. The {::Google::Cloud::Spanner::V1::ResultSetStats ResultSetStats} in each
        #     {::Google::Cloud::Spanner::V1::ResultSet ResultSet} contain the number of rows
        #     modified by the statement.
        #
        #     Only the first {::Google::Cloud::Spanner::V1::ResultSet ResultSet} in the response
        #     contains valid {::Google::Cloud::Spanner::V1::ResultSetMetadata ResultSetMetadata}.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     If all DML statements are executed successfully, the status is `OK`.
        #     Otherwise, the error status of the first failed statement.
        # @!attribute [rw] precommit_token
        #   @return [::Google::Cloud::Spanner::V1::MultiplexedSessionPrecommitToken]
        #     Optional. A precommit token is included if the read-write transaction
        #     is on a multiplexed session. Pass the precommit token with the highest
        #     sequence number from this transaction attempt should be passed to the
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit} request for this transaction.
        class ExecuteBatchDmlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for a `PartitionQueryRequest` and `PartitionReadRequest`.
        # @!attribute [rw] partition_size_bytes
        #   @return [::Integer]
        #     **Note:** This hint is currently ignored by `PartitionQuery` and
        #     `PartitionRead` requests.
        #
        #     The desired data size for each partition generated. The default for this
        #     option is currently 1 GiB. This is only a hint. The actual size of each
        #     partition can be smaller or larger than this size request.
        # @!attribute [rw] max_partitions
        #   @return [::Integer]
        #     **Note:** This hint is currently ignored by `PartitionQuery` and
        #     `PartitionRead` requests.
        #
        #     The desired maximum number of partitions to return. For example, this
        #     might be set to the number of workers available. The default for this
        #     option is currently 10,000. The maximum value is currently 200,000. This
        #     is only a hint. The actual number of partitions returned can be smaller or
        #     larger than this maximum count request.
        class PartitionOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#partition_query PartitionQuery}
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session used to create the partitions.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionSelector]
        #     Read-only snapshot transactions are supported, read and write and
        #     single-use transactions are not.
        # @!attribute [rw] sql
        #   @return [::String]
        #     Required. The query request to generate partitions for. The request fails
        #     if the query isn't root partitionable. For a query to be root
        #     partitionable, it needs to satisfy a few conditions. For example, if the
        #     query execution plan contains a distributed union operator, then it must be
        #     the first operator in the plan. For more information about other
        #     conditions, see [Read data in
        #     parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
        #
        #     The query request must not contain DML commands, such as `INSERT`,
        #     `UPDATE`, or `DELETE`. Use
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#execute_streaming_sql `ExecuteStreamingSql`} with
        #     a `PartitionedDml` transaction for large, partition-friendly DML
        #     operations.
        # @!attribute [rw] params
        #   @return [::Google::Protobuf::Struct]
        #     Parameter names and values that bind to placeholders in the SQL string.
        #
        #     A parameter placeholder consists of the `@` character followed by the
        #     parameter name (for example, `@firstName`). Parameter names can contain
        #     letters, numbers, and underscores.
        #
        #     Parameters can appear anywhere that a literal value is expected. The same
        #     parameter name can be used more than once, for example:
        #
        #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
        #
        #     It's an error to execute a SQL statement with unbound parameters.
        # @!attribute [rw] param_types
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Spanner::V1::Type}]
        #     It isn't always possible for Cloud Spanner to infer the right SQL type
        #     from a JSON value. For example, values of type `BYTES` and values
        #     of type `STRING` both appear in
        #     {::Google::Cloud::Spanner::V1::PartitionQueryRequest#params params} as JSON strings.
        #
        #     In these cases, `param_types` can be used to specify the exact
        #     SQL type for some or all of the SQL query parameters. See the
        #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
        #     about SQL types.
        # @!attribute [rw] partition_options
        #   @return [::Google::Cloud::Spanner::V1::PartitionOptions]
        #     Additional options that affect how many partitions are created.
        class PartitionQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Spanner::V1::Type]
          class ParamTypesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#partition_read PartitionRead}
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session used to create the partitions.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionSelector]
        #     Read only snapshot transactions are supported, read/write and single use
        #     transactions are not.
        # @!attribute [rw] table
        #   @return [::String]
        #     Required. The name of the table in the database to be read.
        # @!attribute [rw] index
        #   @return [::String]
        #     If non-empty, the name of an index on
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table}. This index is used
        #     instead of the table primary key when interpreting
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set} and sorting
        #     result rows. See {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set}
        #     for further information.
        # @!attribute [rw] columns
        #   @return [::Array<::String>]
        #     The columns of {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table} to be
        #     returned for each row matching this request.
        # @!attribute [rw] key_set
        #   @return [::Google::Cloud::Spanner::V1::KeySet]
        #     Required. `key_set` identifies the rows to be yielded. `key_set` names the
        #     primary keys of the rows in
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table} to be yielded, unless
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index} is present. If
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index} is present, then
        #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set} instead names
        #     index keys in {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index}.
        #
        #     It isn't an error for the `key_set` to name rows that don't
        #     exist in the database. Read yields nothing for nonexistent rows.
        # @!attribute [rw] partition_options
        #   @return [::Google::Cloud::Spanner::V1::PartitionOptions]
        #     Additional options that affect how many partitions are created.
        class PartitionReadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information returned for each partition returned in a
        # PartitionResponse.
        # @!attribute [rw] partition_token
        #   @return [::String]
        #     This token can be passed to `Read`, `StreamingRead`, `ExecuteSql`, or
        #     `ExecuteStreamingSql` requests to restrict the results to those identified
        #     by this partition token.
        class Partition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for {::Google::Cloud::Spanner::V1::Spanner::Client#partition_query PartitionQuery}
        # or {::Google::Cloud::Spanner::V1::Spanner::Client#partition_read PartitionRead}
        # @!attribute [rw] partitions
        #   @return [::Array<::Google::Cloud::Spanner::V1::Partition>]
        #     Partitions created by this request.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::Transaction]
        #     Transaction created by this request.
        class PartitionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#read Read} and
        # {::Google::Cloud::Spanner::V1::Spanner::Client#streaming_read StreamingRead}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the read should be performed.
        # @!attribute [rw] transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionSelector]
        #     The transaction to use. If none is provided, the default is a
        #     temporary read-only transaction with strong concurrency.
        # @!attribute [rw] table
        #   @return [::String]
        #     Required. The name of the table in the database to be read.
        # @!attribute [rw] index
        #   @return [::String]
        #     If non-empty, the name of an index on
        #     {::Google::Cloud::Spanner::V1::ReadRequest#table table}. This index is used instead of
        #     the table primary key when interpreting
        #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} and sorting result rows.
        #     See {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} for further
        #     information.
        # @!attribute [rw] columns
        #   @return [::Array<::String>]
        #     Required. The columns of {::Google::Cloud::Spanner::V1::ReadRequest#table table} to be
        #     returned for each row matching this request.
        # @!attribute [rw] key_set
        #   @return [::Google::Cloud::Spanner::V1::KeySet]
        #     Required. `key_set` identifies the rows to be yielded. `key_set` names the
        #     primary keys of the rows in {::Google::Cloud::Spanner::V1::ReadRequest#table table} to
        #     be yielded, unless {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present.
        #     If {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present, then
        #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} instead names index keys
        #     in {::Google::Cloud::Spanner::V1::ReadRequest#index index}.
        #
        #     If the {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token}
        #     field is empty, rows are yielded in table primary key order (if
        #     {::Google::Cloud::Spanner::V1::ReadRequest#index index} is empty) or index key order
        #     (if {::Google::Cloud::Spanner::V1::ReadRequest#index index} is non-empty). If the
        #     {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token} field
        #     isn't empty, rows are yielded in an unspecified order.
        #
        #     It isn't an error for the `key_set` to name rows that don't
        #     exist in the database. Read yields nothing for nonexistent rows.
        # @!attribute [rw] limit
        #   @return [::Integer]
        #     If greater than zero, only the first `limit` rows are yielded. If `limit`
        #     is zero, the default is no limit. A limit can't be specified if
        #     `partition_token` is set.
        # @!attribute [rw] resume_token
        #   @return [::String]
        #     If this request is resuming a previously interrupted read,
        #     `resume_token` should be copied from the last
        #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
        #     interruption. Doing this enables the new read to resume where the last read
        #     left off. The rest of the request parameters must exactly match the request
        #     that yielded this token.
        # @!attribute [rw] partition_token
        #   @return [::String]
        #     If present, results are restricted to the specified partition
        #     previously created using `PartitionRead`. There must be an exact
        #     match for the values of fields common to this message and the
        #     PartitionReadRequest message used to create this partition_token.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        # @!attribute [rw] directed_read_options
        #   @return [::Google::Cloud::Spanner::V1::DirectedReadOptions]
        #     Directed read options for this request.
        # @!attribute [rw] data_boost_enabled
        #   @return [::Boolean]
        #     If this is for a partitioned read and this field is set to `true`, the
        #     request is executed with Spanner Data Boost independent compute resources.
        #
        #     If the field is set to `true` but the request doesn't set
        #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
        # @!attribute [rw] order_by
        #   @return [::Google::Cloud::Spanner::V1::ReadRequest::OrderBy]
        #     Optional. Order for the returned rows.
        #
        #     By default, Spanner returns result rows in primary key order except for
        #     PartitionRead requests. For applications that don't require rows to be
        #     returned in primary key (`ORDER_BY_PRIMARY_KEY`) order, setting
        #     `ORDER_BY_NO_ORDER` option allows Spanner to optimize row retrieval,
        #     resulting in lower latencies in certain cases (for example, bulk point
        #     lookups).
        # @!attribute [rw] lock_hint
        #   @return [::Google::Cloud::Spanner::V1::ReadRequest::LockHint]
        #     Optional. Lock Hint for the request, it can only be used with read-write
        #     transactions.
        # @!attribute [rw] routing_hint
        #   @return [::Google::Cloud::Spanner::V1::RoutingHint]
        #     Optional. If present, it makes the Spanner requests location-aware.
        #
        #     It gives the server hints that can be used to route the request
        #     to an appropriate server, potentially significantly decreasing latency and
        #     improving throughput. To achieve improved performance, most fields must be
        #     filled in with accurate values.
        class ReadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An option to control the order in which rows are returned from a read.
          module OrderBy
            # Default value.
            #
            # `ORDER_BY_UNSPECIFIED` is equivalent to `ORDER_BY_PRIMARY_KEY`.
            ORDER_BY_UNSPECIFIED = 0

            # Read rows are returned in primary key order.
            #
            # In the event that this option is used in conjunction with the
            # `partition_token` field, the API returns an `INVALID_ARGUMENT` error.
            ORDER_BY_PRIMARY_KEY = 1

            # Read rows are returned in any order.
            ORDER_BY_NO_ORDER = 2
          end

          # A lock hint mechanism for reads done within a transaction.
          module LockHint
            # Default value.
            #
            # `LOCK_HINT_UNSPECIFIED` is equivalent to `LOCK_HINT_SHARED`.
            LOCK_HINT_UNSPECIFIED = 0

            # Acquire shared locks.
            #
            # By default when you perform a read as part of a read-write transaction,
            # Spanner acquires shared read locks, which allows other reads to still
            # access the data until your transaction is ready to commit. When your
            # transaction is committing and writes are being applied, the transaction
            # attempts to upgrade to an exclusive lock for any data you are writing.
            # For more information about locks, see [Lock
            # modes](https://cloud.google.com/spanner/docs/introspection/lock-statistics#explain-lock-modes).
            LOCK_HINT_SHARED = 1

            # Acquire exclusive locks.
            #
            # Requesting exclusive locks is beneficial if you observe high write
            # contention, which means you notice that multiple transactions are
            # concurrently trying to read and write to the same data, resulting in a
            # large number of aborts. This problem occurs when two transactions
            # initially acquire shared locks and then both try to upgrade to exclusive
            # locks at the same time. In this situation both transactions are waiting
            # for the other to give up their lock, resulting in a deadlocked situation.
            # Spanner is able to detect this occurring and force one of the
            # transactions to abort. However, this is a slow and expensive operation
            # and results in lower performance. In this case it makes sense to acquire
            # exclusive locks at the start of the transaction because then when
            # multiple transactions try to act on the same data, they automatically get
            # serialized. Each transaction waits its turn to acquire the lock and
            # avoids getting into deadlock situations.
            #
            # Because the exclusive lock hint is just a hint, it shouldn't be
            # considered equivalent to a mutex. In other words, you shouldn't use
            # Spanner exclusive locks as a mutual exclusion mechanism for the execution
            # of code outside of Spanner.
            #
            # **Note:** Request exclusive locks judiciously because they block others
            # from reading that data for the entire transaction, rather than just when
            # the writes are being performed. Unless you observe high write contention,
            # you should use the default of shared read locks so you don't prematurely
            # block other clients from reading the data that you're writing to.
            LOCK_HINT_EXCLUSIVE = 2
          end
        end

        # The request for
        # {::Google::Cloud::Spanner::V1::Spanner::Client#begin_transaction BeginTransaction}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the transaction runs.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::Spanner::V1::TransactionOptions]
        #     Required. Options for the new transaction.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        #     Priority is ignored for this request. Setting the priority in this
        #     `request_options` struct doesn't do anything. To set the priority for a
        #     transaction, set it on the reads and writes that are part of this
        #     transaction instead.
        # @!attribute [rw] mutation_key
        #   @return [::Google::Cloud::Spanner::V1::Mutation]
        #     Optional. Required for read-write transactions on a multiplexed session
        #     that commit mutations but don't perform any reads or queries. You must
        #     randomly select one of the mutations from the mutation set and send it as a
        #     part of this request.
        class BeginTransactionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the transaction to be committed is running.
        # @!attribute [rw] transaction_id
        #   @return [::String]
        #     Commit a previously-started transaction.
        #
        #     Note: The following fields are mutually exclusive: `transaction_id`, `single_use_transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] single_use_transaction
        #   @return [::Google::Cloud::Spanner::V1::TransactionOptions]
        #     Execute mutations in a temporary transaction. Note that unlike
        #     commit of a previously-started transaction, commit with a
        #     temporary transaction is non-idempotent. That is, if the
        #     `CommitRequest` is sent to Cloud Spanner more than once (for
        #     instance, due to retries in the application, or in the
        #     transport library), it's possible that the mutations are
        #     executed more than once. If this is undesirable, use
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#begin_transaction BeginTransaction} and
        #     {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit} instead.
        #
        #     Note: The following fields are mutually exclusive: `single_use_transaction`, `transaction_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mutations
        #   @return [::Array<::Google::Cloud::Spanner::V1::Mutation>]
        #     The mutations to be executed when this transaction commits. All
        #     mutations are applied atomically, in the order they appear in
        #     this list.
        # @!attribute [rw] return_commit_stats
        #   @return [::Boolean]
        #     If `true`, then statistics related to the transaction is included in
        #     the {::Google::Cloud::Spanner::V1::CommitResponse#commit_stats CommitResponse}.
        #     Default value is `false`.
        # @!attribute [rw] max_commit_delay
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The amount of latency this request is configured to incur in
        #     order to improve throughput. If this field isn't set, Spanner assumes
        #     requests are relatively latency sensitive and automatically determines an
        #     appropriate delay time. You can specify a commit delay value between 0 and
        #     500 ms.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        # @!attribute [rw] precommit_token
        #   @return [::Google::Cloud::Spanner::V1::MultiplexedSessionPrecommitToken]
        #     Optional. If the read-write transaction was executed on a multiplexed
        #     session, then you must include the precommit token with the highest
        #     sequence number received in this transaction attempt. Failing to do so
        #     results in a `FailedPrecondition` error.
        class CommitRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#rollback Rollback}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the transaction to roll back is running.
        # @!attribute [rw] transaction_id
        #   @return [::String]
        #     Required. The transaction to roll back.
        class RollbackRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Spanner::V1::Spanner::Client#batch_write BatchWrite}.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The session in which the batch request is to be run.
        # @!attribute [rw] request_options
        #   @return [::Google::Cloud::Spanner::V1::RequestOptions]
        #     Common options for this request.
        # @!attribute [rw] mutation_groups
        #   @return [::Array<::Google::Cloud::Spanner::V1::BatchWriteRequest::MutationGroup>]
        #     Required. The groups of mutations to be applied.
        # @!attribute [rw] exclude_txn_from_change_streams
        #   @return [::Boolean]
        #     Optional. If you don't set the `exclude_txn_from_change_streams` option or
        #     if it's set to `false`, then any change streams monitoring columns modified
        #     by transactions will capture the updates made within that transaction.
        class BatchWriteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A group of mutations to be committed together. Related mutations should be
          # placed in a group. For example, two mutations inserting rows with the same
          # primary key prefix in both parent and child tables are related.
          # @!attribute [rw] mutations
          #   @return [::Array<::Google::Cloud::Spanner::V1::Mutation>]
          #     Required. The mutations in this group.
          class MutationGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The result of applying a batch of mutations.
        # @!attribute [rw] indexes
        #   @return [::Array<::Integer>]
        #     The mutation groups applied in this batch. The values index into the
        #     `mutation_groups` field in the corresponding `BatchWriteRequest`.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     An `OK` status indicates success. Any other status indicates a failure.
        # @!attribute [rw] commit_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     The commit timestamp of the transaction that applied this batch.
        #     Present if `status` is `OK`, absent otherwise.
        class BatchWriteResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
