# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        # Node information for nodes appearing in a
        # {::Google::Cloud::Spanner::V1::QueryPlan#plan_nodes QueryPlan.plan_nodes}.
        # @!attribute [rw] index
        #   @return [::Integer]
        #     The `PlanNode`'s index in [node
        #     list][google.spanner.v1.QueryPlan.plan_nodes].
        # @!attribute [rw] kind
        #   @return [::Google::Cloud::Spanner::V1::PlanNode::Kind]
        #     Used to determine the type of node. May be needed for visualizing
        #     different kinds of nodes differently. For example, If the node is a
        #     {::Google::Cloud::Spanner::V1::PlanNode::Kind::SCALAR SCALAR} node, it will have a
        #     condensed representation which can be used to directly embed a description
        #     of the node in its parent.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name for the node.
        # @!attribute [rw] child_links
        #   @return [::Array<::Google::Cloud::Spanner::V1::PlanNode::ChildLink>]
        #     List of child node `index`es and their relationship to this parent.
        # @!attribute [rw] short_representation
        #   @return [::Google::Cloud::Spanner::V1::PlanNode::ShortRepresentation]
        #     Condensed representation for
        #     {::Google::Cloud::Spanner::V1::PlanNode::Kind::SCALAR SCALAR} nodes.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Struct]
        #     Attributes relevant to the node contained in a group of key-value pairs.
        #     For example, a Parameter Reference node could have the following
        #     information in its metadata:
        #
        #         {
        #           "parameter_reference": "param1",
        #           "parameter_type": "array"
        #         }
        # @!attribute [rw] execution_stats
        #   @return [::Google::Protobuf::Struct]
        #     The execution statistics associated with the node, contained in a group of
        #     key-value pairs. Only present if the plan was returned as a result of a
        #     profile query. For example, number of executions, number of rows/time per
        #     execution etc.
        class PlanNode
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata associated with a parent-child relationship appearing in a
          # {::Google::Cloud::Spanner::V1::PlanNode PlanNode}.
          # @!attribute [rw] child_index
          #   @return [::Integer]
          #     The node to which the link points.
          # @!attribute [rw] type
          #   @return [::String]
          #     The type of the link. For example, in Hash Joins this could be used to
          #     distinguish between the build child and the probe child, or in the case
          #     of the child being an output variable, to represent the tag associated
          #     with the output variable.
          # @!attribute [rw] variable
          #   @return [::String]
          #     Only present if the child node is
          #     {::Google::Cloud::Spanner::V1::PlanNode::Kind::SCALAR SCALAR} and corresponds to an
          #     output variable of the parent node. The field carries the name of the
          #     output variable. For example, a `TableScan` operator that reads rows from
          #     a table will have child links to the `SCALAR` nodes representing the
          #     output variables created for each column that is read by the operator.
          #     The corresponding `variable` fields will be set to the variable names
          #     assigned to the columns.
          class ChildLink
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Condensed representation of a node and its subtree. Only present for
          # `SCALAR` [PlanNode(s)][google.spanner.v1.PlanNode].
          # @!attribute [rw] description
          #   @return [::String]
          #     A string representation of the expression subtree rooted at this node.
          # @!attribute [rw] subqueries
          #   @return [::Google::Protobuf::Map{::String => ::Integer}]
          #     A mapping of (subquery variable name) -> (subquery node id) for cases
          #     where the `description` string of this node references a `SCALAR`
          #     subquery contained in the expression subtree rooted at this node. The
          #     referenced `SCALAR` subquery may not necessarily be a direct child of
          #     this node.
          class ShortRepresentation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Integer]
            class SubqueriesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The kind of {::Google::Cloud::Spanner::V1::PlanNode PlanNode}. Distinguishes between
          # the two different kinds of nodes that can appear in a query plan.
          module Kind
            # Not specified.
            KIND_UNSPECIFIED = 0

            # Denotes a Relational operator node in the expression tree. Relational
            # operators represent iterative processing of rows during query execution.
            # For example, a `TableScan` operation that reads rows from a table.
            RELATIONAL = 1

            # Denotes a Scalar node in the expression tree. Scalar nodes represent
            # non-iterable entities in the query plan. For example, constants or
            # arithmetic operators appearing inside predicate expressions or references
            # to column names.
            SCALAR = 2
          end
        end

        # Output of query advisor analysis.
        # @!attribute [rw] index_advice
        #   @return [::Array<::Google::Cloud::Spanner::V1::QueryAdvisorResult::IndexAdvice>]
        #     Optional. Index Recommendation for a query. This is an optional field and
        #     the recommendation will only be available when the recommendation
        #     guarantees significant improvement in query performance.
        class QueryAdvisorResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Recommendation to add new indexes to run queries more efficiently.
          # @!attribute [rw] ddl
          #   @return [::Array<::String>]
          #     Optional. DDL statements to add new indexes that will improve the query.
          # @!attribute [rw] improvement_factor
          #   @return [::Float]
          #     Optional. Estimated latency improvement factor. For example if the query
          #     currently takes 500 ms to run and the estimated latency with new indexes
          #     is 100 ms this field will be 5.
          class IndexAdvice
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains an ordered list of nodes appearing in the query plan.
        # @!attribute [rw] plan_nodes
        #   @return [::Array<::Google::Cloud::Spanner::V1::PlanNode>]
        #     The nodes in the query plan. Plan nodes are returned in pre-order starting
        #     with the plan root. Each {::Google::Cloud::Spanner::V1::PlanNode PlanNode}'s `id`
        #     corresponds to its index in `plan_nodes`.
        # @!attribute [rw] query_advice
        #   @return [::Google::Cloud::Spanner::V1::QueryAdvisorResult]
        #     Optional. The advise/recommendations for a query. Currently this field will
        #     be serving index recommendations for a query.
        class QueryPlan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
