# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        # A modification to one or more Cloud Spanner rows.  Mutations can be
        # applied to a Cloud Spanner database by sending them in a
        # {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit} call.
        # @!attribute [rw] insert
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Write]
        #     Insert new rows in a table. If any of the rows already exist,
        #     the write or transaction fails with error `ALREADY_EXISTS`.
        #
        #     Note: The following fields are mutually exclusive: `insert`, `update`, `insert_or_update`, `replace`, `delete`, `send`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Write]
        #     Update existing rows in a table. If any of the rows does not
        #     already exist, the transaction fails with error `NOT_FOUND`.
        #
        #     Note: The following fields are mutually exclusive: `update`, `insert`, `insert_or_update`, `replace`, `delete`, `send`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] insert_or_update
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Write]
        #     Like {::Google::Cloud::Spanner::V1::Mutation#insert insert}, except that if the row
        #     already exists, then its column values are overwritten with the ones
        #     provided. Any column values not explicitly written are preserved.
        #
        #     When using
        #     {::Google::Cloud::Spanner::V1::Mutation#insert_or_update insert_or_update}, just as
        #     when using {::Google::Cloud::Spanner::V1::Mutation#insert insert}, all `NOT NULL`
        #     columns in the table must be given a value. This holds true even when the
        #     row already exists and will therefore actually be updated.
        #
        #     Note: The following fields are mutually exclusive: `insert_or_update`, `insert`, `update`, `replace`, `delete`, `send`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] replace
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Write]
        #     Like {::Google::Cloud::Spanner::V1::Mutation#insert insert}, except that if the row
        #     already exists, it is deleted, and the column values provided are
        #     inserted instead. Unlike
        #     {::Google::Cloud::Spanner::V1::Mutation#insert_or_update insert_or_update}, this
        #     means any values not explicitly written become `NULL`.
        #
        #     In an interleaved table, if you create the child table with the
        #     `ON DELETE CASCADE` annotation, then replacing a parent row
        #     also deletes the child rows. Otherwise, you must delete the
        #     child rows before you replace the parent row.
        #
        #     Note: The following fields are mutually exclusive: `replace`, `insert`, `update`, `insert_or_update`, `delete`, `send`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Delete]
        #     Delete rows from a table. Succeeds whether or not the named
        #     rows were present.
        #
        #     Note: The following fields are mutually exclusive: `delete`, `insert`, `update`, `insert_or_update`, `replace`, `send`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] send
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Send]
        #     Send a message to a queue.
        #
        #     Note: The following fields are mutually exclusive: `send`, `insert`, `update`, `insert_or_update`, `replace`, `delete`, `ack`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ack
        #   @return [::Google::Cloud::Spanner::V1::Mutation::Ack]
        #     Ack a message from a queue.
        #
        #     Note: The following fields are mutually exclusive: `ack`, `insert`, `update`, `insert_or_update`, `replace`, `delete`, `send`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Mutation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Arguments to {::Google::Cloud::Spanner::V1::Mutation#insert insert},
          # {::Google::Cloud::Spanner::V1::Mutation#update update},
          # {::Google::Cloud::Spanner::V1::Mutation#insert_or_update insert_or_update}, and
          # {::Google::Cloud::Spanner::V1::Mutation#replace replace} operations.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table whose rows will be written.
          # @!attribute [rw] columns
          #   @return [::Array<::String>]
          #     The names of the columns in
          #     {::Google::Cloud::Spanner::V1::Mutation::Write#table table} to be written.
          #
          #     The list of columns must contain enough columns to allow
          #     Cloud Spanner to derive values for all primary key columns in the
          #     row(s) to be modified.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Protobuf::ListValue>]
          #     The values to be written. `values` can contain more than one
          #     list of values. If it does, then multiple rows are written, one
          #     for each entry in `values`. Each list in `values` must have
          #     exactly as many entries as there are entries in
          #     {::Google::Cloud::Spanner::V1::Mutation::Write#columns columns} above. Sending
          #     multiple lists is equivalent to sending multiple `Mutation`s, each
          #     containing one `values` entry and repeating
          #     {::Google::Cloud::Spanner::V1::Mutation::Write#table table} and
          #     {::Google::Cloud::Spanner::V1::Mutation::Write#columns columns}. Individual values in
          #     each list are encoded as described {::Google::Cloud::Spanner::V1::TypeCode here}.
          class Write
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Arguments to {::Google::Cloud::Spanner::V1::Mutation#delete delete} operations.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table whose rows will be deleted.
          # @!attribute [rw] key_set
          #   @return [::Google::Cloud::Spanner::V1::KeySet]
          #     Required. The primary keys of the rows within
          #     {::Google::Cloud::Spanner::V1::Mutation::Delete#table table} to delete.  The primary
          #     keys must be specified in the order in which they appear in the `PRIMARY
          #     KEY()` clause of the table's equivalent DDL statement (the DDL statement
          #     used to create the table). Delete is idempotent. The transaction will
          #     succeed even if some or all rows do not exist.
          class Delete
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Arguments to {::Google::Cloud::Spanner::V1::Mutation#send send} operations.
          # @!attribute [rw] queue
          #   @return [::String]
          #     Required. The queue to which the message will be sent.
          # @!attribute [rw] key
          #   @return [::Google::Protobuf::ListValue]
          #     Required. The primary key of the message to be sent.
          # @!attribute [rw] deliver_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which Spanner will begin attempting to deliver the message.
          #     If `deliver_time` is not set, Spanner will deliver the message
          #     immediately. If `deliver_time` is in the past, Spanner will replace it
          #     with a value closer to the current time.
          # @!attribute [rw] payload
          #   @return [::Google::Protobuf::Value]
          #     The payload of the message.
          class Send
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Arguments to {::Google::Cloud::Spanner::V1::Mutation#ack ack} operations.
          # @!attribute [rw] queue
          #   @return [::String]
          #     Required. The queue where the message to be acked is stored.
          # @!attribute [rw] key
          #   @return [::Google::Protobuf::ListValue]
          #     Required. The primary key of the message to be acked.
          # @!attribute [rw] ignore_not_found
          #   @return [::Boolean]
          #     By default, an attempt to ack a message that does not exist will fail
          #     with a `NOT_FOUND` error. With `ignore_not_found` set to true, the ack
          #     will succeed even if the message does not exist. This is useful for
          #     unconditionally acking a message, even if it is missing or has already
          #     been acked.
          class Ack
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
