# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        # The response for {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit}.
        # @!attribute [rw] commit_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     The Cloud Spanner timestamp at which the transaction committed.
        # @!attribute [rw] commit_stats
        #   @return [::Google::Cloud::Spanner::V1::CommitResponse::CommitStats]
        #     The statistics about this `Commit`. Not returned by default.
        #     For more information, see
        #     {::Google::Cloud::Spanner::V1::CommitRequest#return_commit_stats CommitRequest.return_commit_stats}.
        # @!attribute [rw] precommit_token
        #   @return [::Google::Cloud::Spanner::V1::MultiplexedSessionPrecommitToken]
        #     If specified, transaction has not committed yet.
        #     You must retry the commit with the new precommit token.
        # @!attribute [rw] snapshot_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     If `TransactionOptions.isolation_level` is set to
        #     `IsolationLevel.REPEATABLE_READ`, then the snapshot timestamp is the
        #     timestamp at which all reads in the transaction ran. This timestamp is
        #     never returned.
        class CommitResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Additional statistics about a commit.
          # @!attribute [rw] mutation_count
          #   @return [::Integer]
          #     The total number of mutations for the transaction. Knowing the
          #     `mutation_count` value can help you maximize the number of mutations
          #     in a transaction and minimize the number of API round trips. You can
          #     also monitor this value to prevent transactions from exceeding the system
          #     [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
          #     If the number of mutations exceeds the limit, the server returns
          #     [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
          class CommitStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
